/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetOptionalREALNull is the corresponding interface of BACnetOptionalREALNull
type BACnetOptionalREALNull interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetOptionalREAL
	// GetNullValue returns NullValue (property field)
	GetNullValue() BACnetApplicationTagNull
	// IsBACnetOptionalREALNull is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetOptionalREALNull()
	// CreateBuilder creates a BACnetOptionalREALNullBuilder
	CreateBACnetOptionalREALNullBuilder() BACnetOptionalREALNullBuilder
}

// _BACnetOptionalREALNull is the data-structure of this message
type _BACnetOptionalREALNull struct {
	BACnetOptionalREALContract
	NullValue BACnetApplicationTagNull
}

var _ BACnetOptionalREALNull = (*_BACnetOptionalREALNull)(nil)
var _ BACnetOptionalREALRequirements = (*_BACnetOptionalREALNull)(nil)

// NewBACnetOptionalREALNull factory function for _BACnetOptionalREALNull
func NewBACnetOptionalREALNull(peekedTagHeader BACnetTagHeader, nullValue BACnetApplicationTagNull) *_BACnetOptionalREALNull {
	if nullValue == nil {
		panic("nullValue of type BACnetApplicationTagNull for BACnetOptionalREALNull must not be nil")
	}
	_result := &_BACnetOptionalREALNull{
		BACnetOptionalREALContract: NewBACnetOptionalREAL(peekedTagHeader),
		NullValue:                  nullValue,
	}
	_result.BACnetOptionalREALContract.(*_BACnetOptionalREAL)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetOptionalREALNullBuilder is a builder for BACnetOptionalREALNull
type BACnetOptionalREALNullBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(nullValue BACnetApplicationTagNull) BACnetOptionalREALNullBuilder
	// WithNullValue adds NullValue (property field)
	WithNullValue(BACnetApplicationTagNull) BACnetOptionalREALNullBuilder
	// WithNullValueBuilder adds NullValue (property field) which is build by the builder
	WithNullValueBuilder(func(BACnetApplicationTagNullBuilder) BACnetApplicationTagNullBuilder) BACnetOptionalREALNullBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetOptionalREALBuilder
	// Build builds the BACnetOptionalREALNull or returns an error if something is wrong
	Build() (BACnetOptionalREALNull, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetOptionalREALNull
}

// NewBACnetOptionalREALNullBuilder() creates a BACnetOptionalREALNullBuilder
func NewBACnetOptionalREALNullBuilder() BACnetOptionalREALNullBuilder {
	return &_BACnetOptionalREALNullBuilder{_BACnetOptionalREALNull: new(_BACnetOptionalREALNull)}
}

type _BACnetOptionalREALNullBuilder struct {
	*_BACnetOptionalREALNull

	parentBuilder *_BACnetOptionalREALBuilder

	collectedErr []error
}

var _ (BACnetOptionalREALNullBuilder) = (*_BACnetOptionalREALNullBuilder)(nil)

func (b *_BACnetOptionalREALNullBuilder) setParent(contract BACnetOptionalREALContract) {
	b.BACnetOptionalREALContract = contract
	contract.(*_BACnetOptionalREAL)._SubType = b._BACnetOptionalREALNull
}

func (b *_BACnetOptionalREALNullBuilder) WithMandatoryFields(nullValue BACnetApplicationTagNull) BACnetOptionalREALNullBuilder {
	return b.WithNullValue(nullValue)
}

func (b *_BACnetOptionalREALNullBuilder) WithNullValue(nullValue BACnetApplicationTagNull) BACnetOptionalREALNullBuilder {
	b.NullValue = nullValue
	return b
}

func (b *_BACnetOptionalREALNullBuilder) WithNullValueBuilder(builderSupplier func(BACnetApplicationTagNullBuilder) BACnetApplicationTagNullBuilder) BACnetOptionalREALNullBuilder {
	builder := builderSupplier(b.NullValue.CreateBACnetApplicationTagNullBuilder())
	var err error
	b.NullValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagNullBuilder failed"))
	}
	return b
}

func (b *_BACnetOptionalREALNullBuilder) Build() (BACnetOptionalREALNull, error) {
	if b.NullValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'nullValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetOptionalREALNull.deepCopy(), nil
}

func (b *_BACnetOptionalREALNullBuilder) MustBuild() BACnetOptionalREALNull {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetOptionalREALNullBuilder) Done() BACnetOptionalREALBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetOptionalREALBuilder().(*_BACnetOptionalREALBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetOptionalREALNullBuilder) buildForBACnetOptionalREAL() (BACnetOptionalREAL, error) {
	return b.Build()
}

func (b *_BACnetOptionalREALNullBuilder) DeepCopy() any {
	_copy := b.CreateBACnetOptionalREALNullBuilder().(*_BACnetOptionalREALNullBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetOptionalREALNullBuilder creates a BACnetOptionalREALNullBuilder
func (b *_BACnetOptionalREALNull) CreateBACnetOptionalREALNullBuilder() BACnetOptionalREALNullBuilder {
	if b == nil {
		return NewBACnetOptionalREALNullBuilder()
	}
	return &_BACnetOptionalREALNullBuilder{_BACnetOptionalREALNull: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetOptionalREALNull) GetParent() BACnetOptionalREALContract {
	return m.BACnetOptionalREALContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetOptionalREALNull) GetNullValue() BACnetApplicationTagNull {
	return m.NullValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetOptionalREALNull(structType any) BACnetOptionalREALNull {
	if casted, ok := structType.(BACnetOptionalREALNull); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetOptionalREALNull); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetOptionalREALNull) GetTypeName() string {
	return "BACnetOptionalREALNull"
}

func (m *_BACnetOptionalREALNull) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetOptionalREALContract.(*_BACnetOptionalREAL).getLengthInBits(ctx))

	// Simple field (nullValue)
	lengthInBits += m.NullValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetOptionalREALNull) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetOptionalREALNull) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetOptionalREAL) (__bACnetOptionalREALNull BACnetOptionalREALNull, err error) {
	m.BACnetOptionalREALContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetOptionalREALNull"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetOptionalREALNull")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	nullValue, err := ReadSimpleField[BACnetApplicationTagNull](ctx, "nullValue", ReadComplex[BACnetApplicationTagNull](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagNull](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'nullValue' field"))
	}
	m.NullValue = nullValue

	if closeErr := readBuffer.CloseContext("BACnetOptionalREALNull"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetOptionalREALNull")
	}

	return m, nil
}

func (m *_BACnetOptionalREALNull) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetOptionalREALNull) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetOptionalREALNull"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetOptionalREALNull")
		}

		if err := WriteSimpleField[BACnetApplicationTagNull](ctx, "nullValue", m.GetNullValue(), WriteComplex[BACnetApplicationTagNull](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'nullValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetOptionalREALNull"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetOptionalREALNull")
		}
		return nil
	}
	return m.BACnetOptionalREALContract.(*_BACnetOptionalREAL).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetOptionalREALNull) IsBACnetOptionalREALNull() {}

func (m *_BACnetOptionalREALNull) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetOptionalREALNull) deepCopy() *_BACnetOptionalREALNull {
	if m == nil {
		return nil
	}
	_BACnetOptionalREALNullCopy := &_BACnetOptionalREALNull{
		m.BACnetOptionalREALContract.(*_BACnetOptionalREAL).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagNull](m.NullValue),
	}
	_BACnetOptionalREALNullCopy.BACnetOptionalREALContract.(*_BACnetOptionalREAL)._SubType = m
	return _BACnetOptionalREALNullCopy
}

func (m *_BACnetOptionalREALNull) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
