/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPriorityValueUnsigned is the corresponding interface of BACnetPriorityValueUnsigned
type BACnetPriorityValueUnsigned interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPriorityValue
	// GetUnsignedValue returns UnsignedValue (property field)
	GetUnsignedValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetPriorityValueUnsigned is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPriorityValueUnsigned()
	// CreateBuilder creates a BACnetPriorityValueUnsignedBuilder
	CreateBACnetPriorityValueUnsignedBuilder() BACnetPriorityValueUnsignedBuilder
}

// _BACnetPriorityValueUnsigned is the data-structure of this message
type _BACnetPriorityValueUnsigned struct {
	BACnetPriorityValueContract
	UnsignedValue BACnetApplicationTagUnsignedInteger
}

var _ BACnetPriorityValueUnsigned = (*_BACnetPriorityValueUnsigned)(nil)
var _ BACnetPriorityValueRequirements = (*_BACnetPriorityValueUnsigned)(nil)

// NewBACnetPriorityValueUnsigned factory function for _BACnetPriorityValueUnsigned
func NewBACnetPriorityValueUnsigned(peekedTagHeader BACnetTagHeader, unsignedValue BACnetApplicationTagUnsignedInteger, objectTypeArgument BACnetObjectType) *_BACnetPriorityValueUnsigned {
	if unsignedValue == nil {
		panic("unsignedValue of type BACnetApplicationTagUnsignedInteger for BACnetPriorityValueUnsigned must not be nil")
	}
	_result := &_BACnetPriorityValueUnsigned{
		BACnetPriorityValueContract: NewBACnetPriorityValue(peekedTagHeader, objectTypeArgument),
		UnsignedValue:               unsignedValue,
	}
	_result.BACnetPriorityValueContract.(*_BACnetPriorityValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPriorityValueUnsignedBuilder is a builder for BACnetPriorityValueUnsigned
type BACnetPriorityValueUnsignedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(unsignedValue BACnetApplicationTagUnsignedInteger) BACnetPriorityValueUnsignedBuilder
	// WithUnsignedValue adds UnsignedValue (property field)
	WithUnsignedValue(BACnetApplicationTagUnsignedInteger) BACnetPriorityValueUnsignedBuilder
	// WithUnsignedValueBuilder adds UnsignedValue (property field) which is build by the builder
	WithUnsignedValueBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetPriorityValueUnsignedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPriorityValueBuilder
	// Build builds the BACnetPriorityValueUnsigned or returns an error if something is wrong
	Build() (BACnetPriorityValueUnsigned, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPriorityValueUnsigned
}

// NewBACnetPriorityValueUnsignedBuilder() creates a BACnetPriorityValueUnsignedBuilder
func NewBACnetPriorityValueUnsignedBuilder() BACnetPriorityValueUnsignedBuilder {
	return &_BACnetPriorityValueUnsignedBuilder{_BACnetPriorityValueUnsigned: new(_BACnetPriorityValueUnsigned)}
}

type _BACnetPriorityValueUnsignedBuilder struct {
	*_BACnetPriorityValueUnsigned

	parentBuilder *_BACnetPriorityValueBuilder

	collectedErr []error
}

var _ (BACnetPriorityValueUnsignedBuilder) = (*_BACnetPriorityValueUnsignedBuilder)(nil)

func (b *_BACnetPriorityValueUnsignedBuilder) setParent(contract BACnetPriorityValueContract) {
	b.BACnetPriorityValueContract = contract
	contract.(*_BACnetPriorityValue)._SubType = b._BACnetPriorityValueUnsigned
}

func (b *_BACnetPriorityValueUnsignedBuilder) WithMandatoryFields(unsignedValue BACnetApplicationTagUnsignedInteger) BACnetPriorityValueUnsignedBuilder {
	return b.WithUnsignedValue(unsignedValue)
}

func (b *_BACnetPriorityValueUnsignedBuilder) WithUnsignedValue(unsignedValue BACnetApplicationTagUnsignedInteger) BACnetPriorityValueUnsignedBuilder {
	b.UnsignedValue = unsignedValue
	return b
}

func (b *_BACnetPriorityValueUnsignedBuilder) WithUnsignedValueBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetPriorityValueUnsignedBuilder {
	builder := builderSupplier(b.UnsignedValue.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.UnsignedValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetPriorityValueUnsignedBuilder) Build() (BACnetPriorityValueUnsigned, error) {
	if b.UnsignedValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'unsignedValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPriorityValueUnsigned.deepCopy(), nil
}

func (b *_BACnetPriorityValueUnsignedBuilder) MustBuild() BACnetPriorityValueUnsigned {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPriorityValueUnsignedBuilder) Done() BACnetPriorityValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPriorityValueBuilder().(*_BACnetPriorityValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPriorityValueUnsignedBuilder) buildForBACnetPriorityValue() (BACnetPriorityValue, error) {
	return b.Build()
}

func (b *_BACnetPriorityValueUnsignedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPriorityValueUnsignedBuilder().(*_BACnetPriorityValueUnsignedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPriorityValueUnsignedBuilder creates a BACnetPriorityValueUnsignedBuilder
func (b *_BACnetPriorityValueUnsigned) CreateBACnetPriorityValueUnsignedBuilder() BACnetPriorityValueUnsignedBuilder {
	if b == nil {
		return NewBACnetPriorityValueUnsignedBuilder()
	}
	return &_BACnetPriorityValueUnsignedBuilder{_BACnetPriorityValueUnsigned: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPriorityValueUnsigned) GetParent() BACnetPriorityValueContract {
	return m.BACnetPriorityValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPriorityValueUnsigned) GetUnsignedValue() BACnetApplicationTagUnsignedInteger {
	return m.UnsignedValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPriorityValueUnsigned(structType any) BACnetPriorityValueUnsigned {
	if casted, ok := structType.(BACnetPriorityValueUnsigned); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPriorityValueUnsigned); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPriorityValueUnsigned) GetTypeName() string {
	return "BACnetPriorityValueUnsigned"
}

func (m *_BACnetPriorityValueUnsigned) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPriorityValueContract.(*_BACnetPriorityValue).getLengthInBits(ctx))

	// Simple field (unsignedValue)
	lengthInBits += m.UnsignedValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPriorityValueUnsigned) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPriorityValueUnsigned) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPriorityValue, objectTypeArgument BACnetObjectType) (__bACnetPriorityValueUnsigned BACnetPriorityValueUnsigned, err error) {
	m.BACnetPriorityValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPriorityValueUnsigned"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPriorityValueUnsigned")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	unsignedValue, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "unsignedValue", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'unsignedValue' field"))
	}
	m.UnsignedValue = unsignedValue

	if closeErr := readBuffer.CloseContext("BACnetPriorityValueUnsigned"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPriorityValueUnsigned")
	}

	return m, nil
}

func (m *_BACnetPriorityValueUnsigned) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPriorityValueUnsigned) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPriorityValueUnsigned"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPriorityValueUnsigned")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "unsignedValue", m.GetUnsignedValue(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'unsignedValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPriorityValueUnsigned"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPriorityValueUnsigned")
		}
		return nil
	}
	return m.BACnetPriorityValueContract.(*_BACnetPriorityValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPriorityValueUnsigned) IsBACnetPriorityValueUnsigned() {}

func (m *_BACnetPriorityValueUnsigned) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPriorityValueUnsigned) deepCopy() *_BACnetPriorityValueUnsigned {
	if m == nil {
		return nil
	}
	_BACnetPriorityValueUnsignedCopy := &_BACnetPriorityValueUnsigned{
		m.BACnetPriorityValueContract.(*_BACnetPriorityValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.UnsignedValue),
	}
	_BACnetPriorityValueUnsignedCopy.BACnetPriorityValueContract.(*_BACnetPriorityValue)._SubType = m
	return _BACnetPriorityValueUnsignedCopy
}

func (m *_BACnetPriorityValueUnsigned) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
