/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetServiceAckReadRange is the corresponding interface of BACnetServiceAckReadRange
type BACnetServiceAckReadRange interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetServiceAck
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetContextTagObjectIdentifier
	// GetPropertyIdentifier returns PropertyIdentifier (property field)
	GetPropertyIdentifier() BACnetPropertyIdentifierTagged
	// GetPropertyArrayIndex returns PropertyArrayIndex (property field)
	GetPropertyArrayIndex() BACnetContextTagUnsignedInteger
	// GetResultFlags returns ResultFlags (property field)
	GetResultFlags() BACnetResultFlagsTagged
	// GetItemCount returns ItemCount (property field)
	GetItemCount() BACnetContextTagUnsignedInteger
	// GetItemData returns ItemData (property field)
	GetItemData() BACnetConstructedData
	// GetFirstSequenceNumber returns FirstSequenceNumber (property field)
	GetFirstSequenceNumber() BACnetContextTagUnsignedInteger
	// IsBACnetServiceAckReadRange is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetServiceAckReadRange()
	// CreateBuilder creates a BACnetServiceAckReadRangeBuilder
	CreateBACnetServiceAckReadRangeBuilder() BACnetServiceAckReadRangeBuilder
}

// _BACnetServiceAckReadRange is the data-structure of this message
type _BACnetServiceAckReadRange struct {
	BACnetServiceAckContract
	ObjectIdentifier    BACnetContextTagObjectIdentifier
	PropertyIdentifier  BACnetPropertyIdentifierTagged
	PropertyArrayIndex  BACnetContextTagUnsignedInteger
	ResultFlags         BACnetResultFlagsTagged
	ItemCount           BACnetContextTagUnsignedInteger
	ItemData            BACnetConstructedData
	FirstSequenceNumber BACnetContextTagUnsignedInteger
}

var _ BACnetServiceAckReadRange = (*_BACnetServiceAckReadRange)(nil)
var _ BACnetServiceAckRequirements = (*_BACnetServiceAckReadRange)(nil)

// NewBACnetServiceAckReadRange factory function for _BACnetServiceAckReadRange
func NewBACnetServiceAckReadRange(objectIdentifier BACnetContextTagObjectIdentifier, propertyIdentifier BACnetPropertyIdentifierTagged, propertyArrayIndex BACnetContextTagUnsignedInteger, resultFlags BACnetResultFlagsTagged, itemCount BACnetContextTagUnsignedInteger, itemData BACnetConstructedData, firstSequenceNumber BACnetContextTagUnsignedInteger, serviceAckLength uint32) *_BACnetServiceAckReadRange {
	if objectIdentifier == nil {
		panic("objectIdentifier of type BACnetContextTagObjectIdentifier for BACnetServiceAckReadRange must not be nil")
	}
	if propertyIdentifier == nil {
		panic("propertyIdentifier of type BACnetPropertyIdentifierTagged for BACnetServiceAckReadRange must not be nil")
	}
	if resultFlags == nil {
		panic("resultFlags of type BACnetResultFlagsTagged for BACnetServiceAckReadRange must not be nil")
	}
	if itemCount == nil {
		panic("itemCount of type BACnetContextTagUnsignedInteger for BACnetServiceAckReadRange must not be nil")
	}
	_result := &_BACnetServiceAckReadRange{
		BACnetServiceAckContract: NewBACnetServiceAck(serviceAckLength),
		ObjectIdentifier:         objectIdentifier,
		PropertyIdentifier:       propertyIdentifier,
		PropertyArrayIndex:       propertyArrayIndex,
		ResultFlags:              resultFlags,
		ItemCount:                itemCount,
		ItemData:                 itemData,
		FirstSequenceNumber:      firstSequenceNumber,
	}
	_result.BACnetServiceAckContract.(*_BACnetServiceAck)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetServiceAckReadRangeBuilder is a builder for BACnetServiceAckReadRange
type BACnetServiceAckReadRangeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier, propertyIdentifier BACnetPropertyIdentifierTagged, resultFlags BACnetResultFlagsTagged, itemCount BACnetContextTagUnsignedInteger) BACnetServiceAckReadRangeBuilder
	// WithObjectIdentifier adds ObjectIdentifier (property field)
	WithObjectIdentifier(BACnetContextTagObjectIdentifier) BACnetServiceAckReadRangeBuilder
	// WithObjectIdentifierBuilder adds ObjectIdentifier (property field) which is build by the builder
	WithObjectIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetServiceAckReadRangeBuilder
	// WithPropertyIdentifier adds PropertyIdentifier (property field)
	WithPropertyIdentifier(BACnetPropertyIdentifierTagged) BACnetServiceAckReadRangeBuilder
	// WithPropertyIdentifierBuilder adds PropertyIdentifier (property field) which is build by the builder
	WithPropertyIdentifierBuilder(func(BACnetPropertyIdentifierTaggedBuilder) BACnetPropertyIdentifierTaggedBuilder) BACnetServiceAckReadRangeBuilder
	// WithPropertyArrayIndex adds PropertyArrayIndex (property field)
	WithOptionalPropertyArrayIndex(BACnetContextTagUnsignedInteger) BACnetServiceAckReadRangeBuilder
	// WithOptionalPropertyArrayIndexBuilder adds PropertyArrayIndex (property field) which is build by the builder
	WithOptionalPropertyArrayIndexBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetServiceAckReadRangeBuilder
	// WithResultFlags adds ResultFlags (property field)
	WithResultFlags(BACnetResultFlagsTagged) BACnetServiceAckReadRangeBuilder
	// WithResultFlagsBuilder adds ResultFlags (property field) which is build by the builder
	WithResultFlagsBuilder(func(BACnetResultFlagsTaggedBuilder) BACnetResultFlagsTaggedBuilder) BACnetServiceAckReadRangeBuilder
	// WithItemCount adds ItemCount (property field)
	WithItemCount(BACnetContextTagUnsignedInteger) BACnetServiceAckReadRangeBuilder
	// WithItemCountBuilder adds ItemCount (property field) which is build by the builder
	WithItemCountBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetServiceAckReadRangeBuilder
	// WithItemData adds ItemData (property field)
	WithOptionalItemData(BACnetConstructedData) BACnetServiceAckReadRangeBuilder
	// WithOptionalItemDataBuilder adds ItemData (property field) which is build by the builder
	WithOptionalItemDataBuilder(func(BACnetConstructedDataBuilder) BACnetConstructedDataBuilder) BACnetServiceAckReadRangeBuilder
	// WithFirstSequenceNumber adds FirstSequenceNumber (property field)
	WithOptionalFirstSequenceNumber(BACnetContextTagUnsignedInteger) BACnetServiceAckReadRangeBuilder
	// WithOptionalFirstSequenceNumberBuilder adds FirstSequenceNumber (property field) which is build by the builder
	WithOptionalFirstSequenceNumberBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetServiceAckReadRangeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetServiceAckBuilder
	// Build builds the BACnetServiceAckReadRange or returns an error if something is wrong
	Build() (BACnetServiceAckReadRange, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetServiceAckReadRange
}

// NewBACnetServiceAckReadRangeBuilder() creates a BACnetServiceAckReadRangeBuilder
func NewBACnetServiceAckReadRangeBuilder() BACnetServiceAckReadRangeBuilder {
	return &_BACnetServiceAckReadRangeBuilder{_BACnetServiceAckReadRange: new(_BACnetServiceAckReadRange)}
}

type _BACnetServiceAckReadRangeBuilder struct {
	*_BACnetServiceAckReadRange

	parentBuilder *_BACnetServiceAckBuilder

	collectedErr []error
}

var _ (BACnetServiceAckReadRangeBuilder) = (*_BACnetServiceAckReadRangeBuilder)(nil)

func (b *_BACnetServiceAckReadRangeBuilder) setParent(contract BACnetServiceAckContract) {
	b.BACnetServiceAckContract = contract
	contract.(*_BACnetServiceAck)._SubType = b._BACnetServiceAckReadRange
}

func (b *_BACnetServiceAckReadRangeBuilder) WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier, propertyIdentifier BACnetPropertyIdentifierTagged, resultFlags BACnetResultFlagsTagged, itemCount BACnetContextTagUnsignedInteger) BACnetServiceAckReadRangeBuilder {
	return b.WithObjectIdentifier(objectIdentifier).WithPropertyIdentifier(propertyIdentifier).WithResultFlags(resultFlags).WithItemCount(itemCount)
}

func (b *_BACnetServiceAckReadRangeBuilder) WithObjectIdentifier(objectIdentifier BACnetContextTagObjectIdentifier) BACnetServiceAckReadRangeBuilder {
	b.ObjectIdentifier = objectIdentifier
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithObjectIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetServiceAckReadRangeBuilder {
	builder := builderSupplier(b.ObjectIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.ObjectIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithPropertyIdentifier(propertyIdentifier BACnetPropertyIdentifierTagged) BACnetServiceAckReadRangeBuilder {
	b.PropertyIdentifier = propertyIdentifier
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithPropertyIdentifierBuilder(builderSupplier func(BACnetPropertyIdentifierTaggedBuilder) BACnetPropertyIdentifierTaggedBuilder) BACnetServiceAckReadRangeBuilder {
	builder := builderSupplier(b.PropertyIdentifier.CreateBACnetPropertyIdentifierTaggedBuilder())
	var err error
	b.PropertyIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetPropertyIdentifierTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithOptionalPropertyArrayIndex(propertyArrayIndex BACnetContextTagUnsignedInteger) BACnetServiceAckReadRangeBuilder {
	b.PropertyArrayIndex = propertyArrayIndex
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithOptionalPropertyArrayIndexBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetServiceAckReadRangeBuilder {
	builder := builderSupplier(b.PropertyArrayIndex.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.PropertyArrayIndex, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithResultFlags(resultFlags BACnetResultFlagsTagged) BACnetServiceAckReadRangeBuilder {
	b.ResultFlags = resultFlags
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithResultFlagsBuilder(builderSupplier func(BACnetResultFlagsTaggedBuilder) BACnetResultFlagsTaggedBuilder) BACnetServiceAckReadRangeBuilder {
	builder := builderSupplier(b.ResultFlags.CreateBACnetResultFlagsTaggedBuilder())
	var err error
	b.ResultFlags, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetResultFlagsTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithItemCount(itemCount BACnetContextTagUnsignedInteger) BACnetServiceAckReadRangeBuilder {
	b.ItemCount = itemCount
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithItemCountBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetServiceAckReadRangeBuilder {
	builder := builderSupplier(b.ItemCount.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.ItemCount, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithOptionalItemData(itemData BACnetConstructedData) BACnetServiceAckReadRangeBuilder {
	b.ItemData = itemData
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithOptionalItemDataBuilder(builderSupplier func(BACnetConstructedDataBuilder) BACnetConstructedDataBuilder) BACnetServiceAckReadRangeBuilder {
	builder := builderSupplier(b.ItemData.CreateBACnetConstructedDataBuilder())
	var err error
	b.ItemData, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetConstructedDataBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithOptionalFirstSequenceNumber(firstSequenceNumber BACnetContextTagUnsignedInteger) BACnetServiceAckReadRangeBuilder {
	b.FirstSequenceNumber = firstSequenceNumber
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) WithOptionalFirstSequenceNumberBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetServiceAckReadRangeBuilder {
	builder := builderSupplier(b.FirstSequenceNumber.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.FirstSequenceNumber, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckReadRangeBuilder) Build() (BACnetServiceAckReadRange, error) {
	if b.ObjectIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'objectIdentifier' not set"))
	}
	if b.PropertyIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'propertyIdentifier' not set"))
	}
	if b.ResultFlags == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'resultFlags' not set"))
	}
	if b.ItemCount == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'itemCount' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetServiceAckReadRange.deepCopy(), nil
}

func (b *_BACnetServiceAckReadRangeBuilder) MustBuild() BACnetServiceAckReadRange {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetServiceAckReadRangeBuilder) Done() BACnetServiceAckBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetServiceAckBuilder().(*_BACnetServiceAckBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetServiceAckReadRangeBuilder) buildForBACnetServiceAck() (BACnetServiceAck, error) {
	return b.Build()
}

func (b *_BACnetServiceAckReadRangeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetServiceAckReadRangeBuilder().(*_BACnetServiceAckReadRangeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetServiceAckReadRangeBuilder creates a BACnetServiceAckReadRangeBuilder
func (b *_BACnetServiceAckReadRange) CreateBACnetServiceAckReadRangeBuilder() BACnetServiceAckReadRangeBuilder {
	if b == nil {
		return NewBACnetServiceAckReadRangeBuilder()
	}
	return &_BACnetServiceAckReadRangeBuilder{_BACnetServiceAckReadRange: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetServiceAckReadRange) GetServiceChoice() BACnetConfirmedServiceChoice {
	return BACnetConfirmedServiceChoice_READ_RANGE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetServiceAckReadRange) GetParent() BACnetServiceAckContract {
	return m.BACnetServiceAckContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetServiceAckReadRange) GetObjectIdentifier() BACnetContextTagObjectIdentifier {
	return m.ObjectIdentifier
}

func (m *_BACnetServiceAckReadRange) GetPropertyIdentifier() BACnetPropertyIdentifierTagged {
	return m.PropertyIdentifier
}

func (m *_BACnetServiceAckReadRange) GetPropertyArrayIndex() BACnetContextTagUnsignedInteger {
	return m.PropertyArrayIndex
}

func (m *_BACnetServiceAckReadRange) GetResultFlags() BACnetResultFlagsTagged {
	return m.ResultFlags
}

func (m *_BACnetServiceAckReadRange) GetItemCount() BACnetContextTagUnsignedInteger {
	return m.ItemCount
}

func (m *_BACnetServiceAckReadRange) GetItemData() BACnetConstructedData {
	return m.ItemData
}

func (m *_BACnetServiceAckReadRange) GetFirstSequenceNumber() BACnetContextTagUnsignedInteger {
	return m.FirstSequenceNumber
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetServiceAckReadRange(structType any) BACnetServiceAckReadRange {
	if casted, ok := structType.(BACnetServiceAckReadRange); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetServiceAckReadRange); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetServiceAckReadRange) GetTypeName() string {
	return "BACnetServiceAckReadRange"
}

func (m *_BACnetServiceAckReadRange) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetServiceAckContract.(*_BACnetServiceAck).getLengthInBits(ctx))

	// Simple field (objectIdentifier)
	lengthInBits += m.ObjectIdentifier.GetLengthInBits(ctx)

	// Simple field (propertyIdentifier)
	lengthInBits += m.PropertyIdentifier.GetLengthInBits(ctx)

	// Optional Field (propertyArrayIndex)
	if m.PropertyArrayIndex != nil {
		lengthInBits += m.PropertyArrayIndex.GetLengthInBits(ctx)
	}

	// Simple field (resultFlags)
	lengthInBits += m.ResultFlags.GetLengthInBits(ctx)

	// Simple field (itemCount)
	lengthInBits += m.ItemCount.GetLengthInBits(ctx)

	// Optional Field (itemData)
	if m.ItemData != nil {
		lengthInBits += m.ItemData.GetLengthInBits(ctx)
	}

	// Optional Field (firstSequenceNumber)
	if m.FirstSequenceNumber != nil {
		lengthInBits += m.FirstSequenceNumber.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_BACnetServiceAckReadRange) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetServiceAckReadRange) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetServiceAck, serviceAckLength uint32) (__bACnetServiceAckReadRange BACnetServiceAckReadRange, err error) {
	m.BACnetServiceAckContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetServiceAckReadRange"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetServiceAckReadRange")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIdentifier' field"))
	}
	m.ObjectIdentifier = objectIdentifier

	propertyIdentifier, err := ReadSimpleField[BACnetPropertyIdentifierTagged](ctx, "propertyIdentifier", ReadComplex[BACnetPropertyIdentifierTagged](BACnetPropertyIdentifierTaggedParseWithBufferProducer((uint8)(uint8(1)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'propertyIdentifier' field"))
	}
	m.PropertyIdentifier = propertyIdentifier

	var propertyArrayIndex BACnetContextTagUnsignedInteger
	_propertyArrayIndex, err := ReadOptionalField[BACnetContextTagUnsignedInteger](ctx, "propertyArrayIndex", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(2)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'propertyArrayIndex' field"))
	}
	if _propertyArrayIndex != nil {
		propertyArrayIndex = *_propertyArrayIndex
		m.PropertyArrayIndex = propertyArrayIndex
	}

	resultFlags, err := ReadSimpleField[BACnetResultFlagsTagged](ctx, "resultFlags", ReadComplex[BACnetResultFlagsTagged](BACnetResultFlagsTaggedParseWithBufferProducer((uint8)(uint8(3)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'resultFlags' field"))
	}
	m.ResultFlags = resultFlags

	itemCount, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "itemCount", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(4)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'itemCount' field"))
	}
	m.ItemCount = itemCount

	var itemData BACnetConstructedData
	_itemData, err := ReadOptionalField[BACnetConstructedData](ctx, "itemData", ReadComplex[BACnetConstructedData](BACnetConstructedDataParseWithBufferProducer[BACnetConstructedData]((uint8)(uint8(5)), (BACnetObjectType)(objectIdentifier.GetObjectType()), (BACnetPropertyIdentifier)(propertyIdentifier.GetValue()), (BACnetTagPayloadUnsignedInteger)((CastBACnetTagPayloadUnsignedInteger(utils.InlineIf(bool((propertyArrayIndex) != (nil)), func() any { return CastBACnetTagPayloadUnsignedInteger((propertyArrayIndex).GetPayload()) }, func() any { return CastBACnetTagPayloadUnsignedInteger(nil) }))))), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'itemData' field"))
	}
	if _itemData != nil {
		itemData = *_itemData
		m.ItemData = itemData
	}

	var firstSequenceNumber BACnetContextTagUnsignedInteger
	_firstSequenceNumber, err := ReadOptionalField[BACnetContextTagUnsignedInteger](ctx, "firstSequenceNumber", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(6)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'firstSequenceNumber' field"))
	}
	if _firstSequenceNumber != nil {
		firstSequenceNumber = *_firstSequenceNumber
		m.FirstSequenceNumber = firstSequenceNumber
	}

	if closeErr := readBuffer.CloseContext("BACnetServiceAckReadRange"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetServiceAckReadRange")
	}

	return m, nil
}

func (m *_BACnetServiceAckReadRange) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetServiceAckReadRange) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetServiceAckReadRange"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetServiceAckReadRange")
		}

		if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", m.GetObjectIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'objectIdentifier' field")
		}

		if err := WriteSimpleField[BACnetPropertyIdentifierTagged](ctx, "propertyIdentifier", m.GetPropertyIdentifier(), WriteComplex[BACnetPropertyIdentifierTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'propertyIdentifier' field")
		}

		if err := WriteOptionalField[BACnetContextTagUnsignedInteger](ctx, "propertyArrayIndex", GetRef(m.GetPropertyArrayIndex()), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'propertyArrayIndex' field")
		}

		if err := WriteSimpleField[BACnetResultFlagsTagged](ctx, "resultFlags", m.GetResultFlags(), WriteComplex[BACnetResultFlagsTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'resultFlags' field")
		}

		if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "itemCount", m.GetItemCount(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'itemCount' field")
		}

		if err := WriteOptionalField[BACnetConstructedData](ctx, "itemData", GetRef(m.GetItemData()), WriteComplex[BACnetConstructedData](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'itemData' field")
		}

		if err := WriteOptionalField[BACnetContextTagUnsignedInteger](ctx, "firstSequenceNumber", GetRef(m.GetFirstSequenceNumber()), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'firstSequenceNumber' field")
		}

		if popErr := writeBuffer.PopContext("BACnetServiceAckReadRange"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetServiceAckReadRange")
		}
		return nil
	}
	return m.BACnetServiceAckContract.(*_BACnetServiceAck).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetServiceAckReadRange) IsBACnetServiceAckReadRange() {}

func (m *_BACnetServiceAckReadRange) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetServiceAckReadRange) deepCopy() *_BACnetServiceAckReadRange {
	if m == nil {
		return nil
	}
	_BACnetServiceAckReadRangeCopy := &_BACnetServiceAckReadRange{
		m.BACnetServiceAckContract.(*_BACnetServiceAck).deepCopy(),
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.ObjectIdentifier),
		utils.DeepCopy[BACnetPropertyIdentifierTagged](m.PropertyIdentifier),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.PropertyArrayIndex),
		utils.DeepCopy[BACnetResultFlagsTagged](m.ResultFlags),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.ItemCount),
		utils.DeepCopy[BACnetConstructedData](m.ItemData),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.FirstSequenceNumber),
	}
	_BACnetServiceAckReadRangeCopy.BACnetServiceAckContract.(*_BACnetServiceAck)._SubType = m
	return _BACnetServiceAckReadRangeCopy
}

func (m *_BACnetServiceAckReadRange) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
