/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetShedStateTagged is the corresponding interface of BACnetShedStateTagged
type BACnetShedStateTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetShedState
	// IsBACnetShedStateTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetShedStateTagged()
	// CreateBuilder creates a BACnetShedStateTaggedBuilder
	CreateBACnetShedStateTaggedBuilder() BACnetShedStateTaggedBuilder
}

// _BACnetShedStateTagged is the data-structure of this message
type _BACnetShedStateTagged struct {
	Header BACnetTagHeader
	Value  BACnetShedState

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetShedStateTagged = (*_BACnetShedStateTagged)(nil)

// NewBACnetShedStateTagged factory function for _BACnetShedStateTagged
func NewBACnetShedStateTagged(header BACnetTagHeader, value BACnetShedState, tagNumber uint8, tagClass TagClass) *_BACnetShedStateTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetShedStateTagged must not be nil")
	}
	return &_BACnetShedStateTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetShedStateTaggedBuilder is a builder for BACnetShedStateTagged
type BACnetShedStateTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetShedState) BACnetShedStateTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetShedStateTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetShedStateTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetShedState) BACnetShedStateTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetShedStateTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetShedStateTaggedBuilder
	// Build builds the BACnetShedStateTagged or returns an error if something is wrong
	Build() (BACnetShedStateTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetShedStateTagged
}

// NewBACnetShedStateTaggedBuilder() creates a BACnetShedStateTaggedBuilder
func NewBACnetShedStateTaggedBuilder() BACnetShedStateTaggedBuilder {
	return &_BACnetShedStateTaggedBuilder{_BACnetShedStateTagged: new(_BACnetShedStateTagged)}
}

type _BACnetShedStateTaggedBuilder struct {
	*_BACnetShedStateTagged

	collectedErr []error
}

var _ (BACnetShedStateTaggedBuilder) = (*_BACnetShedStateTaggedBuilder)(nil)

func (b *_BACnetShedStateTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetShedState) BACnetShedStateTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetShedStateTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetShedStateTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetShedStateTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetShedStateTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetShedStateTaggedBuilder) WithValue(value BACnetShedState) BACnetShedStateTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetShedStateTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetShedStateTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetShedStateTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetShedStateTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetShedStateTaggedBuilder) Build() (BACnetShedStateTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetShedStateTagged.deepCopy(), nil
}

func (b *_BACnetShedStateTaggedBuilder) MustBuild() BACnetShedStateTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetShedStateTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetShedStateTaggedBuilder().(*_BACnetShedStateTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetShedStateTaggedBuilder creates a BACnetShedStateTaggedBuilder
func (b *_BACnetShedStateTagged) CreateBACnetShedStateTaggedBuilder() BACnetShedStateTaggedBuilder {
	if b == nil {
		return NewBACnetShedStateTaggedBuilder()
	}
	return &_BACnetShedStateTaggedBuilder{_BACnetShedStateTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetShedStateTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetShedStateTagged) GetValue() BACnetShedState {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetShedStateTagged(structType any) BACnetShedStateTagged {
	if casted, ok := structType.(BACnetShedStateTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetShedStateTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetShedStateTagged) GetTypeName() string {
	return "BACnetShedStateTagged"
}

func (m *_BACnetShedStateTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetShedStateTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetShedStateTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetShedStateTagged, error) {
	return BACnetShedStateTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetShedStateTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetShedStateTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetShedStateTagged, error) {
		return BACnetShedStateTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetShedStateTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetShedStateTagged, error) {
	v, err := (&_BACnetShedStateTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetShedStateTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetShedStateTagged BACnetShedStateTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetShedStateTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetShedStateTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetShedState](ctx, "value", readBuffer, EnsureType[BACnetShedState](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetShedState_SHED_INACTIVE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetShedStateTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetShedStateTagged")
	}

	return m, nil
}

func (m *_BACnetShedStateTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetShedStateTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetShedStateTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetShedStateTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetShedState](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetShedStateTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetShedStateTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetShedStateTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetShedStateTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetShedStateTagged) IsBACnetShedStateTagged() {}

func (m *_BACnetShedStateTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetShedStateTagged) deepCopy() *_BACnetShedStateTagged {
	if m == nil {
		return nil
	}
	_BACnetShedStateTaggedCopy := &_BACnetShedStateTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetShedStateTaggedCopy
}

func (m *_BACnetShedStateTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
