/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetUnconfirmedServiceRequestWhoIs is the corresponding interface of BACnetUnconfirmedServiceRequestWhoIs
type BACnetUnconfirmedServiceRequestWhoIs interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetUnconfirmedServiceRequest
	// GetDeviceInstanceRangeLowLimit returns DeviceInstanceRangeLowLimit (property field)
	GetDeviceInstanceRangeLowLimit() BACnetContextTagUnsignedInteger
	// GetDeviceInstanceRangeHighLimit returns DeviceInstanceRangeHighLimit (property field)
	GetDeviceInstanceRangeHighLimit() BACnetContextTagUnsignedInteger
	// IsBACnetUnconfirmedServiceRequestWhoIs is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetUnconfirmedServiceRequestWhoIs()
	// CreateBuilder creates a BACnetUnconfirmedServiceRequestWhoIsBuilder
	CreateBACnetUnconfirmedServiceRequestWhoIsBuilder() BACnetUnconfirmedServiceRequestWhoIsBuilder
}

// _BACnetUnconfirmedServiceRequestWhoIs is the data-structure of this message
type _BACnetUnconfirmedServiceRequestWhoIs struct {
	BACnetUnconfirmedServiceRequestContract
	DeviceInstanceRangeLowLimit  BACnetContextTagUnsignedInteger
	DeviceInstanceRangeHighLimit BACnetContextTagUnsignedInteger
}

var _ BACnetUnconfirmedServiceRequestWhoIs = (*_BACnetUnconfirmedServiceRequestWhoIs)(nil)
var _ BACnetUnconfirmedServiceRequestRequirements = (*_BACnetUnconfirmedServiceRequestWhoIs)(nil)

// NewBACnetUnconfirmedServiceRequestWhoIs factory function for _BACnetUnconfirmedServiceRequestWhoIs
func NewBACnetUnconfirmedServiceRequestWhoIs(deviceInstanceRangeLowLimit BACnetContextTagUnsignedInteger, deviceInstanceRangeHighLimit BACnetContextTagUnsignedInteger, serviceRequestLength uint16) *_BACnetUnconfirmedServiceRequestWhoIs {
	_result := &_BACnetUnconfirmedServiceRequestWhoIs{
		BACnetUnconfirmedServiceRequestContract: NewBACnetUnconfirmedServiceRequest(serviceRequestLength),
		DeviceInstanceRangeLowLimit:             deviceInstanceRangeLowLimit,
		DeviceInstanceRangeHighLimit:            deviceInstanceRangeHighLimit,
	}
	_result.BACnetUnconfirmedServiceRequestContract.(*_BACnetUnconfirmedServiceRequest)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetUnconfirmedServiceRequestWhoIsBuilder is a builder for BACnetUnconfirmedServiceRequestWhoIs
type BACnetUnconfirmedServiceRequestWhoIsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetUnconfirmedServiceRequestWhoIsBuilder
	// WithDeviceInstanceRangeLowLimit adds DeviceInstanceRangeLowLimit (property field)
	WithOptionalDeviceInstanceRangeLowLimit(BACnetContextTagUnsignedInteger) BACnetUnconfirmedServiceRequestWhoIsBuilder
	// WithOptionalDeviceInstanceRangeLowLimitBuilder adds DeviceInstanceRangeLowLimit (property field) which is build by the builder
	WithOptionalDeviceInstanceRangeLowLimitBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetUnconfirmedServiceRequestWhoIsBuilder
	// WithDeviceInstanceRangeHighLimit adds DeviceInstanceRangeHighLimit (property field)
	WithOptionalDeviceInstanceRangeHighLimit(BACnetContextTagUnsignedInteger) BACnetUnconfirmedServiceRequestWhoIsBuilder
	// WithOptionalDeviceInstanceRangeHighLimitBuilder adds DeviceInstanceRangeHighLimit (property field) which is build by the builder
	WithOptionalDeviceInstanceRangeHighLimitBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetUnconfirmedServiceRequestWhoIsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetUnconfirmedServiceRequestBuilder
	// Build builds the BACnetUnconfirmedServiceRequestWhoIs or returns an error if something is wrong
	Build() (BACnetUnconfirmedServiceRequestWhoIs, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetUnconfirmedServiceRequestWhoIs
}

// NewBACnetUnconfirmedServiceRequestWhoIsBuilder() creates a BACnetUnconfirmedServiceRequestWhoIsBuilder
func NewBACnetUnconfirmedServiceRequestWhoIsBuilder() BACnetUnconfirmedServiceRequestWhoIsBuilder {
	return &_BACnetUnconfirmedServiceRequestWhoIsBuilder{_BACnetUnconfirmedServiceRequestWhoIs: new(_BACnetUnconfirmedServiceRequestWhoIs)}
}

type _BACnetUnconfirmedServiceRequestWhoIsBuilder struct {
	*_BACnetUnconfirmedServiceRequestWhoIs

	parentBuilder *_BACnetUnconfirmedServiceRequestBuilder

	collectedErr []error
}

var _ (BACnetUnconfirmedServiceRequestWhoIsBuilder) = (*_BACnetUnconfirmedServiceRequestWhoIsBuilder)(nil)

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) setParent(contract BACnetUnconfirmedServiceRequestContract) {
	b.BACnetUnconfirmedServiceRequestContract = contract
	contract.(*_BACnetUnconfirmedServiceRequest)._SubType = b._BACnetUnconfirmedServiceRequestWhoIs
}

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) WithMandatoryFields() BACnetUnconfirmedServiceRequestWhoIsBuilder {
	return b
}

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) WithOptionalDeviceInstanceRangeLowLimit(deviceInstanceRangeLowLimit BACnetContextTagUnsignedInteger) BACnetUnconfirmedServiceRequestWhoIsBuilder {
	b.DeviceInstanceRangeLowLimit = deviceInstanceRangeLowLimit
	return b
}

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) WithOptionalDeviceInstanceRangeLowLimitBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetUnconfirmedServiceRequestWhoIsBuilder {
	builder := builderSupplier(b.DeviceInstanceRangeLowLimit.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.DeviceInstanceRangeLowLimit, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) WithOptionalDeviceInstanceRangeHighLimit(deviceInstanceRangeHighLimit BACnetContextTagUnsignedInteger) BACnetUnconfirmedServiceRequestWhoIsBuilder {
	b.DeviceInstanceRangeHighLimit = deviceInstanceRangeHighLimit
	return b
}

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) WithOptionalDeviceInstanceRangeHighLimitBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetUnconfirmedServiceRequestWhoIsBuilder {
	builder := builderSupplier(b.DeviceInstanceRangeHighLimit.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.DeviceInstanceRangeHighLimit, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) Build() (BACnetUnconfirmedServiceRequestWhoIs, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetUnconfirmedServiceRequestWhoIs.deepCopy(), nil
}

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) MustBuild() BACnetUnconfirmedServiceRequestWhoIs {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) Done() BACnetUnconfirmedServiceRequestBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetUnconfirmedServiceRequestBuilder().(*_BACnetUnconfirmedServiceRequestBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) buildForBACnetUnconfirmedServiceRequest() (BACnetUnconfirmedServiceRequest, error) {
	return b.Build()
}

func (b *_BACnetUnconfirmedServiceRequestWhoIsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetUnconfirmedServiceRequestWhoIsBuilder().(*_BACnetUnconfirmedServiceRequestWhoIsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetUnconfirmedServiceRequestWhoIsBuilder creates a BACnetUnconfirmedServiceRequestWhoIsBuilder
func (b *_BACnetUnconfirmedServiceRequestWhoIs) CreateBACnetUnconfirmedServiceRequestWhoIsBuilder() BACnetUnconfirmedServiceRequestWhoIsBuilder {
	if b == nil {
		return NewBACnetUnconfirmedServiceRequestWhoIsBuilder()
	}
	return &_BACnetUnconfirmedServiceRequestWhoIsBuilder{_BACnetUnconfirmedServiceRequestWhoIs: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetUnconfirmedServiceRequestWhoIs) GetServiceChoice() BACnetUnconfirmedServiceChoice {
	return BACnetUnconfirmedServiceChoice_WHO_IS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetUnconfirmedServiceRequestWhoIs) GetParent() BACnetUnconfirmedServiceRequestContract {
	return m.BACnetUnconfirmedServiceRequestContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetUnconfirmedServiceRequestWhoIs) GetDeviceInstanceRangeLowLimit() BACnetContextTagUnsignedInteger {
	return m.DeviceInstanceRangeLowLimit
}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) GetDeviceInstanceRangeHighLimit() BACnetContextTagUnsignedInteger {
	return m.DeviceInstanceRangeHighLimit
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetUnconfirmedServiceRequestWhoIs(structType any) BACnetUnconfirmedServiceRequestWhoIs {
	if casted, ok := structType.(BACnetUnconfirmedServiceRequestWhoIs); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetUnconfirmedServiceRequestWhoIs); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) GetTypeName() string {
	return "BACnetUnconfirmedServiceRequestWhoIs"
}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetUnconfirmedServiceRequestContract.(*_BACnetUnconfirmedServiceRequest).getLengthInBits(ctx))

	// Optional Field (deviceInstanceRangeLowLimit)
	if m.DeviceInstanceRangeLowLimit != nil {
		lengthInBits += m.DeviceInstanceRangeLowLimit.GetLengthInBits(ctx)
	}

	// Optional Field (deviceInstanceRangeHighLimit)
	if m.DeviceInstanceRangeHighLimit != nil {
		lengthInBits += m.DeviceInstanceRangeHighLimit.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetUnconfirmedServiceRequest, serviceRequestLength uint16) (__bACnetUnconfirmedServiceRequestWhoIs BACnetUnconfirmedServiceRequestWhoIs, err error) {
	m.BACnetUnconfirmedServiceRequestContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetUnconfirmedServiceRequestWhoIs"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetUnconfirmedServiceRequestWhoIs")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var deviceInstanceRangeLowLimit BACnetContextTagUnsignedInteger
	_deviceInstanceRangeLowLimit, err := ReadOptionalField[BACnetContextTagUnsignedInteger](ctx, "deviceInstanceRangeLowLimit", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deviceInstanceRangeLowLimit' field"))
	}
	if _deviceInstanceRangeLowLimit != nil {
		deviceInstanceRangeLowLimit = *_deviceInstanceRangeLowLimit
		m.DeviceInstanceRangeLowLimit = deviceInstanceRangeLowLimit
	}

	var deviceInstanceRangeHighLimit BACnetContextTagUnsignedInteger
	_deviceInstanceRangeHighLimit, err := ReadOptionalField[BACnetContextTagUnsignedInteger](ctx, "deviceInstanceRangeHighLimit", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(1)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer), bool((deviceInstanceRangeLowLimit) != (nil)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deviceInstanceRangeHighLimit' field"))
	}
	if _deviceInstanceRangeHighLimit != nil {
		deviceInstanceRangeHighLimit = *_deviceInstanceRangeHighLimit
		m.DeviceInstanceRangeHighLimit = deviceInstanceRangeHighLimit
	}

	if closeErr := readBuffer.CloseContext("BACnetUnconfirmedServiceRequestWhoIs"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetUnconfirmedServiceRequestWhoIs")
	}

	return m, nil
}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetUnconfirmedServiceRequestWhoIs"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetUnconfirmedServiceRequestWhoIs")
		}

		if err := WriteOptionalField[BACnetContextTagUnsignedInteger](ctx, "deviceInstanceRangeLowLimit", GetRef(m.GetDeviceInstanceRangeLowLimit()), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'deviceInstanceRangeLowLimit' field")
		}

		if err := WriteOptionalField[BACnetContextTagUnsignedInteger](ctx, "deviceInstanceRangeHighLimit", GetRef(m.GetDeviceInstanceRangeHighLimit()), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'deviceInstanceRangeHighLimit' field")
		}

		if popErr := writeBuffer.PopContext("BACnetUnconfirmedServiceRequestWhoIs"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetUnconfirmedServiceRequestWhoIs")
		}
		return nil
	}
	return m.BACnetUnconfirmedServiceRequestContract.(*_BACnetUnconfirmedServiceRequest).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) IsBACnetUnconfirmedServiceRequestWhoIs() {}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) deepCopy() *_BACnetUnconfirmedServiceRequestWhoIs {
	if m == nil {
		return nil
	}
	_BACnetUnconfirmedServiceRequestWhoIsCopy := &_BACnetUnconfirmedServiceRequestWhoIs{
		m.BACnetUnconfirmedServiceRequestContract.(*_BACnetUnconfirmedServiceRequest).deepCopy(),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.DeviceInstanceRangeLowLimit),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.DeviceInstanceRangeHighLimit),
	}
	_BACnetUnconfirmedServiceRequestWhoIsCopy.BACnetUnconfirmedServiceRequestContract.(*_BACnetUnconfirmedServiceRequest)._SubType = m
	return _BACnetUnconfirmedServiceRequestWhoIsCopy
}

func (m *_BACnetUnconfirmedServiceRequestWhoIs) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
