/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetWriteStatusTagged is the corresponding interface of BACnetWriteStatusTagged
type BACnetWriteStatusTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetWriteStatus
	// IsBACnetWriteStatusTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetWriteStatusTagged()
	// CreateBuilder creates a BACnetWriteStatusTaggedBuilder
	CreateBACnetWriteStatusTaggedBuilder() BACnetWriteStatusTaggedBuilder
}

// _BACnetWriteStatusTagged is the data-structure of this message
type _BACnetWriteStatusTagged struct {
	Header BACnetTagHeader
	Value  BACnetWriteStatus

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetWriteStatusTagged = (*_BACnetWriteStatusTagged)(nil)

// NewBACnetWriteStatusTagged factory function for _BACnetWriteStatusTagged
func NewBACnetWriteStatusTagged(header BACnetTagHeader, value BACnetWriteStatus, tagNumber uint8, tagClass TagClass) *_BACnetWriteStatusTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetWriteStatusTagged must not be nil")
	}
	return &_BACnetWriteStatusTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetWriteStatusTaggedBuilder is a builder for BACnetWriteStatusTagged
type BACnetWriteStatusTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetWriteStatus) BACnetWriteStatusTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetWriteStatusTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetWriteStatusTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetWriteStatus) BACnetWriteStatusTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetWriteStatusTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetWriteStatusTaggedBuilder
	// Build builds the BACnetWriteStatusTagged or returns an error if something is wrong
	Build() (BACnetWriteStatusTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetWriteStatusTagged
}

// NewBACnetWriteStatusTaggedBuilder() creates a BACnetWriteStatusTaggedBuilder
func NewBACnetWriteStatusTaggedBuilder() BACnetWriteStatusTaggedBuilder {
	return &_BACnetWriteStatusTaggedBuilder{_BACnetWriteStatusTagged: new(_BACnetWriteStatusTagged)}
}

type _BACnetWriteStatusTaggedBuilder struct {
	*_BACnetWriteStatusTagged

	collectedErr []error
}

var _ (BACnetWriteStatusTaggedBuilder) = (*_BACnetWriteStatusTaggedBuilder)(nil)

func (b *_BACnetWriteStatusTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetWriteStatus) BACnetWriteStatusTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetWriteStatusTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetWriteStatusTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetWriteStatusTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetWriteStatusTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetWriteStatusTaggedBuilder) WithValue(value BACnetWriteStatus) BACnetWriteStatusTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetWriteStatusTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetWriteStatusTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetWriteStatusTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetWriteStatusTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetWriteStatusTaggedBuilder) Build() (BACnetWriteStatusTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetWriteStatusTagged.deepCopy(), nil
}

func (b *_BACnetWriteStatusTaggedBuilder) MustBuild() BACnetWriteStatusTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetWriteStatusTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetWriteStatusTaggedBuilder().(*_BACnetWriteStatusTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetWriteStatusTaggedBuilder creates a BACnetWriteStatusTaggedBuilder
func (b *_BACnetWriteStatusTagged) CreateBACnetWriteStatusTaggedBuilder() BACnetWriteStatusTaggedBuilder {
	if b == nil {
		return NewBACnetWriteStatusTaggedBuilder()
	}
	return &_BACnetWriteStatusTaggedBuilder{_BACnetWriteStatusTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetWriteStatusTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetWriteStatusTagged) GetValue() BACnetWriteStatus {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetWriteStatusTagged(structType any) BACnetWriteStatusTagged {
	if casted, ok := structType.(BACnetWriteStatusTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetWriteStatusTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetWriteStatusTagged) GetTypeName() string {
	return "BACnetWriteStatusTagged"
}

func (m *_BACnetWriteStatusTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetWriteStatusTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetWriteStatusTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetWriteStatusTagged, error) {
	return BACnetWriteStatusTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetWriteStatusTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetWriteStatusTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetWriteStatusTagged, error) {
		return BACnetWriteStatusTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetWriteStatusTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetWriteStatusTagged, error) {
	v, err := (&_BACnetWriteStatusTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetWriteStatusTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetWriteStatusTagged BACnetWriteStatusTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetWriteStatusTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetWriteStatusTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetWriteStatus](ctx, "value", readBuffer, EnsureType[BACnetWriteStatus](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetWriteStatus_IDLE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetWriteStatusTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetWriteStatusTagged")
	}

	return m, nil
}

func (m *_BACnetWriteStatusTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetWriteStatusTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetWriteStatusTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetWriteStatusTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetWriteStatus](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetWriteStatusTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetWriteStatusTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetWriteStatusTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetWriteStatusTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetWriteStatusTagged) IsBACnetWriteStatusTagged() {}

func (m *_BACnetWriteStatusTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetWriteStatusTagged) deepCopy() *_BACnetWriteStatusTagged {
	if m == nil {
		return nil
	}
	_BACnetWriteStatusTaggedCopy := &_BACnetWriteStatusTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetWriteStatusTaggedCopy
}

func (m *_BACnetWriteStatusTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
