/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CBusPointToMultiPointCommandStatus is the corresponding interface of CBusPointToMultiPointCommandStatus
type CBusPointToMultiPointCommandStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CBusPointToMultiPointCommand
	// GetStatusRequest returns StatusRequest (property field)
	GetStatusRequest() StatusRequest
	// IsCBusPointToMultiPointCommandStatus is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCBusPointToMultiPointCommandStatus()
	// CreateBuilder creates a CBusPointToMultiPointCommandStatusBuilder
	CreateCBusPointToMultiPointCommandStatusBuilder() CBusPointToMultiPointCommandStatusBuilder
}

// _CBusPointToMultiPointCommandStatus is the data-structure of this message
type _CBusPointToMultiPointCommandStatus struct {
	CBusPointToMultiPointCommandContract
	StatusRequest StatusRequest
	// Reserved Fields
	reservedField0 *byte
	reservedField1 *byte
}

var _ CBusPointToMultiPointCommandStatus = (*_CBusPointToMultiPointCommandStatus)(nil)
var _ CBusPointToMultiPointCommandRequirements = (*_CBusPointToMultiPointCommandStatus)(nil)

// NewCBusPointToMultiPointCommandStatus factory function for _CBusPointToMultiPointCommandStatus
func NewCBusPointToMultiPointCommandStatus(peekedApplication byte, statusRequest StatusRequest, cBusOptions CBusOptions) *_CBusPointToMultiPointCommandStatus {
	if statusRequest == nil {
		panic("statusRequest of type StatusRequest for CBusPointToMultiPointCommandStatus must not be nil")
	}
	_result := &_CBusPointToMultiPointCommandStatus{
		CBusPointToMultiPointCommandContract: NewCBusPointToMultiPointCommand(peekedApplication, cBusOptions),
		StatusRequest:                        statusRequest,
	}
	_result.CBusPointToMultiPointCommandContract.(*_CBusPointToMultiPointCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CBusPointToMultiPointCommandStatusBuilder is a builder for CBusPointToMultiPointCommandStatus
type CBusPointToMultiPointCommandStatusBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(statusRequest StatusRequest) CBusPointToMultiPointCommandStatusBuilder
	// WithStatusRequest adds StatusRequest (property field)
	WithStatusRequest(StatusRequest) CBusPointToMultiPointCommandStatusBuilder
	// WithStatusRequestBuilder adds StatusRequest (property field) which is build by the builder
	WithStatusRequestBuilder(func(StatusRequestBuilder) StatusRequestBuilder) CBusPointToMultiPointCommandStatusBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CBusPointToMultiPointCommandBuilder
	// Build builds the CBusPointToMultiPointCommandStatus or returns an error if something is wrong
	Build() (CBusPointToMultiPointCommandStatus, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CBusPointToMultiPointCommandStatus
}

// NewCBusPointToMultiPointCommandStatusBuilder() creates a CBusPointToMultiPointCommandStatusBuilder
func NewCBusPointToMultiPointCommandStatusBuilder() CBusPointToMultiPointCommandStatusBuilder {
	return &_CBusPointToMultiPointCommandStatusBuilder{_CBusPointToMultiPointCommandStatus: new(_CBusPointToMultiPointCommandStatus)}
}

type _CBusPointToMultiPointCommandStatusBuilder struct {
	*_CBusPointToMultiPointCommandStatus

	parentBuilder *_CBusPointToMultiPointCommandBuilder

	collectedErr []error
}

var _ (CBusPointToMultiPointCommandStatusBuilder) = (*_CBusPointToMultiPointCommandStatusBuilder)(nil)

func (b *_CBusPointToMultiPointCommandStatusBuilder) setParent(contract CBusPointToMultiPointCommandContract) {
	b.CBusPointToMultiPointCommandContract = contract
	contract.(*_CBusPointToMultiPointCommand)._SubType = b._CBusPointToMultiPointCommandStatus
}

func (b *_CBusPointToMultiPointCommandStatusBuilder) WithMandatoryFields(statusRequest StatusRequest) CBusPointToMultiPointCommandStatusBuilder {
	return b.WithStatusRequest(statusRequest)
}

func (b *_CBusPointToMultiPointCommandStatusBuilder) WithStatusRequest(statusRequest StatusRequest) CBusPointToMultiPointCommandStatusBuilder {
	b.StatusRequest = statusRequest
	return b
}

func (b *_CBusPointToMultiPointCommandStatusBuilder) WithStatusRequestBuilder(builderSupplier func(StatusRequestBuilder) StatusRequestBuilder) CBusPointToMultiPointCommandStatusBuilder {
	builder := builderSupplier(b.StatusRequest.CreateStatusRequestBuilder())
	var err error
	b.StatusRequest, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "StatusRequestBuilder failed"))
	}
	return b
}

func (b *_CBusPointToMultiPointCommandStatusBuilder) Build() (CBusPointToMultiPointCommandStatus, error) {
	if b.StatusRequest == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'statusRequest' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._CBusPointToMultiPointCommandStatus.deepCopy(), nil
}

func (b *_CBusPointToMultiPointCommandStatusBuilder) MustBuild() CBusPointToMultiPointCommandStatus {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CBusPointToMultiPointCommandStatusBuilder) Done() CBusPointToMultiPointCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCBusPointToMultiPointCommandBuilder().(*_CBusPointToMultiPointCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_CBusPointToMultiPointCommandStatusBuilder) buildForCBusPointToMultiPointCommand() (CBusPointToMultiPointCommand, error) {
	return b.Build()
}

func (b *_CBusPointToMultiPointCommandStatusBuilder) DeepCopy() any {
	_copy := b.CreateCBusPointToMultiPointCommandStatusBuilder().(*_CBusPointToMultiPointCommandStatusBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCBusPointToMultiPointCommandStatusBuilder creates a CBusPointToMultiPointCommandStatusBuilder
func (b *_CBusPointToMultiPointCommandStatus) CreateCBusPointToMultiPointCommandStatusBuilder() CBusPointToMultiPointCommandStatusBuilder {
	if b == nil {
		return NewCBusPointToMultiPointCommandStatusBuilder()
	}
	return &_CBusPointToMultiPointCommandStatusBuilder{_CBusPointToMultiPointCommandStatus: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CBusPointToMultiPointCommandStatus) GetParent() CBusPointToMultiPointCommandContract {
	return m.CBusPointToMultiPointCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CBusPointToMultiPointCommandStatus) GetStatusRequest() StatusRequest {
	return m.StatusRequest
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCBusPointToMultiPointCommandStatus(structType any) CBusPointToMultiPointCommandStatus {
	if casted, ok := structType.(CBusPointToMultiPointCommandStatus); ok {
		return casted
	}
	if casted, ok := structType.(*CBusPointToMultiPointCommandStatus); ok {
		return *casted
	}
	return nil
}

func (m *_CBusPointToMultiPointCommandStatus) GetTypeName() string {
	return "CBusPointToMultiPointCommandStatus"
}

func (m *_CBusPointToMultiPointCommandStatus) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CBusPointToMultiPointCommandContract.(*_CBusPointToMultiPointCommand).getLengthInBits(ctx))

	// Reserved Field (reserved)
	lengthInBits += 8

	// Reserved Field (reserved)
	lengthInBits += 8

	// Simple field (statusRequest)
	lengthInBits += m.StatusRequest.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_CBusPointToMultiPointCommandStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CBusPointToMultiPointCommandStatus) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CBusPointToMultiPointCommand, cBusOptions CBusOptions) (__cBusPointToMultiPointCommandStatus CBusPointToMultiPointCommandStatus, err error) {
	m.CBusPointToMultiPointCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CBusPointToMultiPointCommandStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CBusPointToMultiPointCommandStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadByte(readBuffer, 8), byte(0xFF))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	reservedField1, err := ReadReservedField(ctx, "reserved", ReadByte(readBuffer, 8), byte(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField1 = reservedField1

	statusRequest, err := ReadSimpleField[StatusRequest](ctx, "statusRequest", ReadComplex[StatusRequest](StatusRequestParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'statusRequest' field"))
	}
	m.StatusRequest = statusRequest

	if closeErr := readBuffer.CloseContext("CBusPointToMultiPointCommandStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CBusPointToMultiPointCommandStatus")
	}

	return m, nil
}

func (m *_CBusPointToMultiPointCommandStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CBusPointToMultiPointCommandStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CBusPointToMultiPointCommandStatus"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CBusPointToMultiPointCommandStatus")
		}

		if err := WriteReservedField[byte](ctx, "reserved", byte(0xFF), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteReservedField[byte](ctx, "reserved", byte(0x00), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 2")
		}

		if err := WriteSimpleField[StatusRequest](ctx, "statusRequest", m.GetStatusRequest(), WriteComplex[StatusRequest](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'statusRequest' field")
		}

		if popErr := writeBuffer.PopContext("CBusPointToMultiPointCommandStatus"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CBusPointToMultiPointCommandStatus")
		}
		return nil
	}
	return m.CBusPointToMultiPointCommandContract.(*_CBusPointToMultiPointCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CBusPointToMultiPointCommandStatus) IsCBusPointToMultiPointCommandStatus() {}

func (m *_CBusPointToMultiPointCommandStatus) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CBusPointToMultiPointCommandStatus) deepCopy() *_CBusPointToMultiPointCommandStatus {
	if m == nil {
		return nil
	}
	_CBusPointToMultiPointCommandStatusCopy := &_CBusPointToMultiPointCommandStatus{
		m.CBusPointToMultiPointCommandContract.(*_CBusPointToMultiPointCommand).deepCopy(),
		utils.DeepCopy[StatusRequest](m.StatusRequest),
		m.reservedField0,
		m.reservedField1,
	}
	_CBusPointToMultiPointCommandStatusCopy.CBusPointToMultiPointCommandContract.(*_CBusPointToMultiPointCommand)._SubType = m
	return _CBusPointToMultiPointCommandStatusCopy
}

func (m *_CBusPointToMultiPointCommandStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
