/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MediaTransportControlDataSetCategory is the corresponding interface of MediaTransportControlDataSetCategory
type MediaTransportControlDataSetCategory interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	MediaTransportControlData
	// GetCategoryNumber returns CategoryNumber (property field)
	GetCategoryNumber() uint8
	// IsMediaTransportControlDataSetCategory is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMediaTransportControlDataSetCategory()
	// CreateBuilder creates a MediaTransportControlDataSetCategoryBuilder
	CreateMediaTransportControlDataSetCategoryBuilder() MediaTransportControlDataSetCategoryBuilder
}

// _MediaTransportControlDataSetCategory is the data-structure of this message
type _MediaTransportControlDataSetCategory struct {
	MediaTransportControlDataContract
	CategoryNumber uint8
}

var _ MediaTransportControlDataSetCategory = (*_MediaTransportControlDataSetCategory)(nil)
var _ MediaTransportControlDataRequirements = (*_MediaTransportControlDataSetCategory)(nil)

// NewMediaTransportControlDataSetCategory factory function for _MediaTransportControlDataSetCategory
func NewMediaTransportControlDataSetCategory(commandTypeContainer MediaTransportControlCommandTypeContainer, mediaLinkGroup byte, categoryNumber uint8) *_MediaTransportControlDataSetCategory {
	_result := &_MediaTransportControlDataSetCategory{
		MediaTransportControlDataContract: NewMediaTransportControlData(commandTypeContainer, mediaLinkGroup),
		CategoryNumber:                    categoryNumber,
	}
	_result.MediaTransportControlDataContract.(*_MediaTransportControlData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MediaTransportControlDataSetCategoryBuilder is a builder for MediaTransportControlDataSetCategory
type MediaTransportControlDataSetCategoryBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(categoryNumber uint8) MediaTransportControlDataSetCategoryBuilder
	// WithCategoryNumber adds CategoryNumber (property field)
	WithCategoryNumber(uint8) MediaTransportControlDataSetCategoryBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() MediaTransportControlDataBuilder
	// Build builds the MediaTransportControlDataSetCategory or returns an error if something is wrong
	Build() (MediaTransportControlDataSetCategory, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MediaTransportControlDataSetCategory
}

// NewMediaTransportControlDataSetCategoryBuilder() creates a MediaTransportControlDataSetCategoryBuilder
func NewMediaTransportControlDataSetCategoryBuilder() MediaTransportControlDataSetCategoryBuilder {
	return &_MediaTransportControlDataSetCategoryBuilder{_MediaTransportControlDataSetCategory: new(_MediaTransportControlDataSetCategory)}
}

type _MediaTransportControlDataSetCategoryBuilder struct {
	*_MediaTransportControlDataSetCategory

	parentBuilder *_MediaTransportControlDataBuilder

	collectedErr []error
}

var _ (MediaTransportControlDataSetCategoryBuilder) = (*_MediaTransportControlDataSetCategoryBuilder)(nil)

func (b *_MediaTransportControlDataSetCategoryBuilder) setParent(contract MediaTransportControlDataContract) {
	b.MediaTransportControlDataContract = contract
	contract.(*_MediaTransportControlData)._SubType = b._MediaTransportControlDataSetCategory
}

func (b *_MediaTransportControlDataSetCategoryBuilder) WithMandatoryFields(categoryNumber uint8) MediaTransportControlDataSetCategoryBuilder {
	return b.WithCategoryNumber(categoryNumber)
}

func (b *_MediaTransportControlDataSetCategoryBuilder) WithCategoryNumber(categoryNumber uint8) MediaTransportControlDataSetCategoryBuilder {
	b.CategoryNumber = categoryNumber
	return b
}

func (b *_MediaTransportControlDataSetCategoryBuilder) Build() (MediaTransportControlDataSetCategory, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._MediaTransportControlDataSetCategory.deepCopy(), nil
}

func (b *_MediaTransportControlDataSetCategoryBuilder) MustBuild() MediaTransportControlDataSetCategory {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MediaTransportControlDataSetCategoryBuilder) Done() MediaTransportControlDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewMediaTransportControlDataBuilder().(*_MediaTransportControlDataBuilder)
	}
	return b.parentBuilder
}

func (b *_MediaTransportControlDataSetCategoryBuilder) buildForMediaTransportControlData() (MediaTransportControlData, error) {
	return b.Build()
}

func (b *_MediaTransportControlDataSetCategoryBuilder) DeepCopy() any {
	_copy := b.CreateMediaTransportControlDataSetCategoryBuilder().(*_MediaTransportControlDataSetCategoryBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateMediaTransportControlDataSetCategoryBuilder creates a MediaTransportControlDataSetCategoryBuilder
func (b *_MediaTransportControlDataSetCategory) CreateMediaTransportControlDataSetCategoryBuilder() MediaTransportControlDataSetCategoryBuilder {
	if b == nil {
		return NewMediaTransportControlDataSetCategoryBuilder()
	}
	return &_MediaTransportControlDataSetCategoryBuilder{_MediaTransportControlDataSetCategory: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MediaTransportControlDataSetCategory) GetParent() MediaTransportControlDataContract {
	return m.MediaTransportControlDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MediaTransportControlDataSetCategory) GetCategoryNumber() uint8 {
	return m.CategoryNumber
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMediaTransportControlDataSetCategory(structType any) MediaTransportControlDataSetCategory {
	if casted, ok := structType.(MediaTransportControlDataSetCategory); ok {
		return casted
	}
	if casted, ok := structType.(*MediaTransportControlDataSetCategory); ok {
		return *casted
	}
	return nil
}

func (m *_MediaTransportControlDataSetCategory) GetTypeName() string {
	return "MediaTransportControlDataSetCategory"
}

func (m *_MediaTransportControlDataSetCategory) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.MediaTransportControlDataContract.(*_MediaTransportControlData).getLengthInBits(ctx))

	// Simple field (categoryNumber)
	lengthInBits += 8

	return lengthInBits
}

func (m *_MediaTransportControlDataSetCategory) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_MediaTransportControlDataSetCategory) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_MediaTransportControlData) (__mediaTransportControlDataSetCategory MediaTransportControlDataSetCategory, err error) {
	m.MediaTransportControlDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MediaTransportControlDataSetCategory"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MediaTransportControlDataSetCategory")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	categoryNumber, err := ReadSimpleField(ctx, "categoryNumber", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'categoryNumber' field"))
	}
	m.CategoryNumber = categoryNumber

	if closeErr := readBuffer.CloseContext("MediaTransportControlDataSetCategory"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MediaTransportControlDataSetCategory")
	}

	return m, nil
}

func (m *_MediaTransportControlDataSetCategory) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_MediaTransportControlDataSetCategory) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MediaTransportControlDataSetCategory"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MediaTransportControlDataSetCategory")
		}

		if err := WriteSimpleField[uint8](ctx, "categoryNumber", m.GetCategoryNumber(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'categoryNumber' field")
		}

		if popErr := writeBuffer.PopContext("MediaTransportControlDataSetCategory"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MediaTransportControlDataSetCategory")
		}
		return nil
	}
	return m.MediaTransportControlDataContract.(*_MediaTransportControlData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_MediaTransportControlDataSetCategory) IsMediaTransportControlDataSetCategory() {}

func (m *_MediaTransportControlDataSetCategory) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MediaTransportControlDataSetCategory) deepCopy() *_MediaTransportControlDataSetCategory {
	if m == nil {
		return nil
	}
	_MediaTransportControlDataSetCategoryCopy := &_MediaTransportControlDataSetCategory{
		m.MediaTransportControlDataContract.(*_MediaTransportControlData).deepCopy(),
		m.CategoryNumber,
	}
	_MediaTransportControlDataSetCategoryCopy.MediaTransportControlDataContract.(*_MediaTransportControlData)._SubType = m
	return _MediaTransportControlDataSetCategoryCopy
}

func (m *_MediaTransportControlDataSetCategory) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
