/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataFireAlarmRaised is the corresponding interface of SecurityDataFireAlarmRaised
type SecurityDataFireAlarmRaised interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataFireAlarmRaised is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataFireAlarmRaised()
	// CreateBuilder creates a SecurityDataFireAlarmRaisedBuilder
	CreateSecurityDataFireAlarmRaisedBuilder() SecurityDataFireAlarmRaisedBuilder
}

// _SecurityDataFireAlarmRaised is the data-structure of this message
type _SecurityDataFireAlarmRaised struct {
	SecurityDataContract
}

var _ SecurityDataFireAlarmRaised = (*_SecurityDataFireAlarmRaised)(nil)
var _ SecurityDataRequirements = (*_SecurityDataFireAlarmRaised)(nil)

// NewSecurityDataFireAlarmRaised factory function for _SecurityDataFireAlarmRaised
func NewSecurityDataFireAlarmRaised(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataFireAlarmRaised {
	_result := &_SecurityDataFireAlarmRaised{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataFireAlarmRaisedBuilder is a builder for SecurityDataFireAlarmRaised
type SecurityDataFireAlarmRaisedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataFireAlarmRaisedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataFireAlarmRaised or returns an error if something is wrong
	Build() (SecurityDataFireAlarmRaised, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataFireAlarmRaised
}

// NewSecurityDataFireAlarmRaisedBuilder() creates a SecurityDataFireAlarmRaisedBuilder
func NewSecurityDataFireAlarmRaisedBuilder() SecurityDataFireAlarmRaisedBuilder {
	return &_SecurityDataFireAlarmRaisedBuilder{_SecurityDataFireAlarmRaised: new(_SecurityDataFireAlarmRaised)}
}

type _SecurityDataFireAlarmRaisedBuilder struct {
	*_SecurityDataFireAlarmRaised

	parentBuilder *_SecurityDataBuilder

	collectedErr []error
}

var _ (SecurityDataFireAlarmRaisedBuilder) = (*_SecurityDataFireAlarmRaisedBuilder)(nil)

func (b *_SecurityDataFireAlarmRaisedBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataFireAlarmRaised
}

func (b *_SecurityDataFireAlarmRaisedBuilder) WithMandatoryFields() SecurityDataFireAlarmRaisedBuilder {
	return b
}

func (b *_SecurityDataFireAlarmRaisedBuilder) Build() (SecurityDataFireAlarmRaised, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SecurityDataFireAlarmRaised.deepCopy(), nil
}

func (b *_SecurityDataFireAlarmRaisedBuilder) MustBuild() SecurityDataFireAlarmRaised {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataFireAlarmRaisedBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataFireAlarmRaisedBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataFireAlarmRaisedBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataFireAlarmRaisedBuilder().(*_SecurityDataFireAlarmRaisedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSecurityDataFireAlarmRaisedBuilder creates a SecurityDataFireAlarmRaisedBuilder
func (b *_SecurityDataFireAlarmRaised) CreateSecurityDataFireAlarmRaisedBuilder() SecurityDataFireAlarmRaisedBuilder {
	if b == nil {
		return NewSecurityDataFireAlarmRaisedBuilder()
	}
	return &_SecurityDataFireAlarmRaisedBuilder{_SecurityDataFireAlarmRaised: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataFireAlarmRaised) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataFireAlarmRaised(structType any) SecurityDataFireAlarmRaised {
	if casted, ok := structType.(SecurityDataFireAlarmRaised); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataFireAlarmRaised); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataFireAlarmRaised) GetTypeName() string {
	return "SecurityDataFireAlarmRaised"
}

func (m *_SecurityDataFireAlarmRaised) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataFireAlarmRaised) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataFireAlarmRaised) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataFireAlarmRaised SecurityDataFireAlarmRaised, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataFireAlarmRaised"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataFireAlarmRaised")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataFireAlarmRaised"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataFireAlarmRaised")
	}

	return m, nil
}

func (m *_SecurityDataFireAlarmRaised) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataFireAlarmRaised) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataFireAlarmRaised"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataFireAlarmRaised")
		}

		if popErr := writeBuffer.PopContext("SecurityDataFireAlarmRaised"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataFireAlarmRaised")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataFireAlarmRaised) IsSecurityDataFireAlarmRaised() {}

func (m *_SecurityDataFireAlarmRaised) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataFireAlarmRaised) deepCopy() *_SecurityDataFireAlarmRaised {
	if m == nil {
		return nil
	}
	_SecurityDataFireAlarmRaisedCopy := &_SecurityDataFireAlarmRaised{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataFireAlarmRaisedCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataFireAlarmRaisedCopy
}

func (m *_SecurityDataFireAlarmRaised) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
