/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TelephonyDataLineOffHook is the corresponding interface of TelephonyDataLineOffHook
type TelephonyDataLineOffHook interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	TelephonyData
	// GetReason returns Reason (property field)
	GetReason() LineOffHookReason
	// GetNumber returns Number (property field)
	GetNumber() string
	// IsTelephonyDataLineOffHook is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTelephonyDataLineOffHook()
	// CreateBuilder creates a TelephonyDataLineOffHookBuilder
	CreateTelephonyDataLineOffHookBuilder() TelephonyDataLineOffHookBuilder
}

// _TelephonyDataLineOffHook is the data-structure of this message
type _TelephonyDataLineOffHook struct {
	TelephonyDataContract
	Reason LineOffHookReason
	Number string
}

var _ TelephonyDataLineOffHook = (*_TelephonyDataLineOffHook)(nil)
var _ TelephonyDataRequirements = (*_TelephonyDataLineOffHook)(nil)

// NewTelephonyDataLineOffHook factory function for _TelephonyDataLineOffHook
func NewTelephonyDataLineOffHook(commandTypeContainer TelephonyCommandTypeContainer, argument byte, reason LineOffHookReason, number string) *_TelephonyDataLineOffHook {
	_result := &_TelephonyDataLineOffHook{
		TelephonyDataContract: NewTelephonyData(commandTypeContainer, argument),
		Reason:                reason,
		Number:                number,
	}
	_result.TelephonyDataContract.(*_TelephonyData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TelephonyDataLineOffHookBuilder is a builder for TelephonyDataLineOffHook
type TelephonyDataLineOffHookBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(reason LineOffHookReason, number string) TelephonyDataLineOffHookBuilder
	// WithReason adds Reason (property field)
	WithReason(LineOffHookReason) TelephonyDataLineOffHookBuilder
	// WithNumber adds Number (property field)
	WithNumber(string) TelephonyDataLineOffHookBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() TelephonyDataBuilder
	// Build builds the TelephonyDataLineOffHook or returns an error if something is wrong
	Build() (TelephonyDataLineOffHook, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TelephonyDataLineOffHook
}

// NewTelephonyDataLineOffHookBuilder() creates a TelephonyDataLineOffHookBuilder
func NewTelephonyDataLineOffHookBuilder() TelephonyDataLineOffHookBuilder {
	return &_TelephonyDataLineOffHookBuilder{_TelephonyDataLineOffHook: new(_TelephonyDataLineOffHook)}
}

type _TelephonyDataLineOffHookBuilder struct {
	*_TelephonyDataLineOffHook

	parentBuilder *_TelephonyDataBuilder

	collectedErr []error
}

var _ (TelephonyDataLineOffHookBuilder) = (*_TelephonyDataLineOffHookBuilder)(nil)

func (b *_TelephonyDataLineOffHookBuilder) setParent(contract TelephonyDataContract) {
	b.TelephonyDataContract = contract
	contract.(*_TelephonyData)._SubType = b._TelephonyDataLineOffHook
}

func (b *_TelephonyDataLineOffHookBuilder) WithMandatoryFields(reason LineOffHookReason, number string) TelephonyDataLineOffHookBuilder {
	return b.WithReason(reason).WithNumber(number)
}

func (b *_TelephonyDataLineOffHookBuilder) WithReason(reason LineOffHookReason) TelephonyDataLineOffHookBuilder {
	b.Reason = reason
	return b
}

func (b *_TelephonyDataLineOffHookBuilder) WithNumber(number string) TelephonyDataLineOffHookBuilder {
	b.Number = number
	return b
}

func (b *_TelephonyDataLineOffHookBuilder) Build() (TelephonyDataLineOffHook, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._TelephonyDataLineOffHook.deepCopy(), nil
}

func (b *_TelephonyDataLineOffHookBuilder) MustBuild() TelephonyDataLineOffHook {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TelephonyDataLineOffHookBuilder) Done() TelephonyDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewTelephonyDataBuilder().(*_TelephonyDataBuilder)
	}
	return b.parentBuilder
}

func (b *_TelephonyDataLineOffHookBuilder) buildForTelephonyData() (TelephonyData, error) {
	return b.Build()
}

func (b *_TelephonyDataLineOffHookBuilder) DeepCopy() any {
	_copy := b.CreateTelephonyDataLineOffHookBuilder().(*_TelephonyDataLineOffHookBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateTelephonyDataLineOffHookBuilder creates a TelephonyDataLineOffHookBuilder
func (b *_TelephonyDataLineOffHook) CreateTelephonyDataLineOffHookBuilder() TelephonyDataLineOffHookBuilder {
	if b == nil {
		return NewTelephonyDataLineOffHookBuilder()
	}
	return &_TelephonyDataLineOffHookBuilder{_TelephonyDataLineOffHook: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TelephonyDataLineOffHook) GetParent() TelephonyDataContract {
	return m.TelephonyDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_TelephonyDataLineOffHook) GetReason() LineOffHookReason {
	return m.Reason
}

func (m *_TelephonyDataLineOffHook) GetNumber() string {
	return m.Number
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastTelephonyDataLineOffHook(structType any) TelephonyDataLineOffHook {
	if casted, ok := structType.(TelephonyDataLineOffHook); ok {
		return casted
	}
	if casted, ok := structType.(*TelephonyDataLineOffHook); ok {
		return *casted
	}
	return nil
}

func (m *_TelephonyDataLineOffHook) GetTypeName() string {
	return "TelephonyDataLineOffHook"
}

func (m *_TelephonyDataLineOffHook) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.TelephonyDataContract.(*_TelephonyData).getLengthInBits(ctx))

	// Simple field (reason)
	lengthInBits += 8

	// Simple field (number)
	lengthInBits += uint16(int32((int32(m.GetCommandTypeContainer().NumBytes()) - int32(int32(2)))) * int32(int32(8)))

	return lengthInBits
}

func (m *_TelephonyDataLineOffHook) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_TelephonyDataLineOffHook) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_TelephonyData, commandTypeContainer TelephonyCommandTypeContainer) (__telephonyDataLineOffHook TelephonyDataLineOffHook, err error) {
	m.TelephonyDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TelephonyDataLineOffHook"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TelephonyDataLineOffHook")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reason, err := ReadEnumField[LineOffHookReason](ctx, "reason", "LineOffHookReason", ReadEnum(LineOffHookReasonByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'reason' field"))
	}
	m.Reason = reason

	number, err := ReadSimpleField(ctx, "number", ReadString(readBuffer, uint32(int32((int32(commandTypeContainer.NumBytes())-int32(int32(2))))*int32(int32(8)))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'number' field"))
	}
	m.Number = number

	if closeErr := readBuffer.CloseContext("TelephonyDataLineOffHook"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TelephonyDataLineOffHook")
	}

	return m, nil
}

func (m *_TelephonyDataLineOffHook) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TelephonyDataLineOffHook) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TelephonyDataLineOffHook"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TelephonyDataLineOffHook")
		}

		if err := WriteSimpleEnumField[LineOffHookReason](ctx, "reason", "LineOffHookReason", m.GetReason(), WriteEnum[LineOffHookReason, uint8](LineOffHookReason.GetValue, LineOffHookReason.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
			return errors.Wrap(err, "Error serializing 'reason' field")
		}

		if err := WriteSimpleField[string](ctx, "number", m.GetNumber(), WriteString(writeBuffer, int32(int32((int32(m.GetCommandTypeContainer().NumBytes())-int32(int32(2))))*int32(int32(8))))); err != nil {
			return errors.Wrap(err, "Error serializing 'number' field")
		}

		if popErr := writeBuffer.PopContext("TelephonyDataLineOffHook"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TelephonyDataLineOffHook")
		}
		return nil
	}
	return m.TelephonyDataContract.(*_TelephonyData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TelephonyDataLineOffHook) IsTelephonyDataLineOffHook() {}

func (m *_TelephonyDataLineOffHook) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TelephonyDataLineOffHook) deepCopy() *_TelephonyDataLineOffHook {
	if m == nil {
		return nil
	}
	_TelephonyDataLineOffHookCopy := &_TelephonyDataLineOffHook{
		m.TelephonyDataContract.(*_TelephonyData).deepCopy(),
		m.Reason,
		m.Number,
	}
	_TelephonyDataLineOffHookCopy.TelephonyDataContract.(*_TelephonyData)._SubType = m
	return _TelephonyDataLineOffHookCopy
}

func (m *_TelephonyDataLineOffHook) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
