/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"

	"github.com/pkg/errors"

	. "github.com/apache/plc4x/plc4go/protocols/eip/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

type EipParserHelper struct {
}

func (m EipParserHelper) Parse(typeName string, arguments []string, io utils.ReadBuffer) (any, error) {
	switch typeName {
	case "PathSegment":
		return PathSegmentParseWithBuffer[PathSegment](context.Background(), io)
	case "EipConstants":
		return EipConstantsParseWithBuffer(context.Background(), io)
	case "TransportType":
		return TransportTypeParseWithBuffer(context.Background(), io)
	case "PortSegmentType":
		return PortSegmentTypeParseWithBuffer[PortSegmentType](context.Background(), io)
	case "NetworkConnectionParameters":
		return NetworkConnectionParametersParseWithBuffer(context.Background(), io)
	case "TypeId":
		return TypeIdParseWithBuffer[TypeId](context.Background(), io)
	case "InstanceSegment":
		return InstanceSegmentParseWithBuffer(context.Background(), io)
	case "CIPData":
		packetLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return CIPDataParseWithBuffer(context.Background(), io, packetLength)
	case "ClassSegment":
		return ClassSegmentParseWithBuffer(context.Background(), io)
	case "EipPacket":
		response, err := utils.StrToBool(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return EipPacketParseWithBuffer[EipPacket](context.Background(), io, response)
	case "CIPAttributes":
		packetLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return CIPAttributesParseWithBuffer(context.Background(), io, packetLength)
	case "CipService":
		connected, err := utils.StrToBool(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		serviceLen, err := utils.StrToUint16(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return CipServiceParseWithBuffer[CipService](context.Background(), io, connected, serviceLen)
	case "CommandSpecificDataItem":
		return CommandSpecificDataItemParseWithBuffer[CommandSpecificDataItem](context.Background(), io)
	case "Services":
		servicesLen, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return ServicesParseWithBuffer(context.Background(), io, servicesLen)
	case "LogicalSegmentType":
		return LogicalSegmentTypeParseWithBuffer[LogicalSegmentType](context.Background(), io)
	case "DataSegmentType":
		return DataSegmentTypeParseWithBuffer[DataSegmentType](context.Background(), io)
	case "CIPDataConnected":
		return CIPDataConnectedParseWithBuffer(context.Background(), io)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
