/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataIndividualAddressRead is the corresponding interface of ApduDataIndividualAddressRead
type ApduDataIndividualAddressRead interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduData
	// IsApduDataIndividualAddressRead is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataIndividualAddressRead()
	// CreateBuilder creates a ApduDataIndividualAddressReadBuilder
	CreateApduDataIndividualAddressReadBuilder() ApduDataIndividualAddressReadBuilder
}

// _ApduDataIndividualAddressRead is the data-structure of this message
type _ApduDataIndividualAddressRead struct {
	ApduDataContract
}

var _ ApduDataIndividualAddressRead = (*_ApduDataIndividualAddressRead)(nil)
var _ ApduDataRequirements = (*_ApduDataIndividualAddressRead)(nil)

// NewApduDataIndividualAddressRead factory function for _ApduDataIndividualAddressRead
func NewApduDataIndividualAddressRead(dataLength uint8) *_ApduDataIndividualAddressRead {
	_result := &_ApduDataIndividualAddressRead{
		ApduDataContract: NewApduData(dataLength),
	}
	_result.ApduDataContract.(*_ApduData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataIndividualAddressReadBuilder is a builder for ApduDataIndividualAddressRead
type ApduDataIndividualAddressReadBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataIndividualAddressReadBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataBuilder
	// Build builds the ApduDataIndividualAddressRead or returns an error if something is wrong
	Build() (ApduDataIndividualAddressRead, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataIndividualAddressRead
}

// NewApduDataIndividualAddressReadBuilder() creates a ApduDataIndividualAddressReadBuilder
func NewApduDataIndividualAddressReadBuilder() ApduDataIndividualAddressReadBuilder {
	return &_ApduDataIndividualAddressReadBuilder{_ApduDataIndividualAddressRead: new(_ApduDataIndividualAddressRead)}
}

type _ApduDataIndividualAddressReadBuilder struct {
	*_ApduDataIndividualAddressRead

	parentBuilder *_ApduDataBuilder

	collectedErr []error
}

var _ (ApduDataIndividualAddressReadBuilder) = (*_ApduDataIndividualAddressReadBuilder)(nil)

func (b *_ApduDataIndividualAddressReadBuilder) setParent(contract ApduDataContract) {
	b.ApduDataContract = contract
	contract.(*_ApduData)._SubType = b._ApduDataIndividualAddressRead
}

func (b *_ApduDataIndividualAddressReadBuilder) WithMandatoryFields() ApduDataIndividualAddressReadBuilder {
	return b
}

func (b *_ApduDataIndividualAddressReadBuilder) Build() (ApduDataIndividualAddressRead, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApduDataIndividualAddressRead.deepCopy(), nil
}

func (b *_ApduDataIndividualAddressReadBuilder) MustBuild() ApduDataIndividualAddressRead {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataIndividualAddressReadBuilder) Done() ApduDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataBuilder().(*_ApduDataBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataIndividualAddressReadBuilder) buildForApduData() (ApduData, error) {
	return b.Build()
}

func (b *_ApduDataIndividualAddressReadBuilder) DeepCopy() any {
	_copy := b.CreateApduDataIndividualAddressReadBuilder().(*_ApduDataIndividualAddressReadBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApduDataIndividualAddressReadBuilder creates a ApduDataIndividualAddressReadBuilder
func (b *_ApduDataIndividualAddressRead) CreateApduDataIndividualAddressReadBuilder() ApduDataIndividualAddressReadBuilder {
	if b == nil {
		return NewApduDataIndividualAddressReadBuilder()
	}
	return &_ApduDataIndividualAddressReadBuilder{_ApduDataIndividualAddressRead: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataIndividualAddressRead) GetApciType() uint8 {
	return 0x4
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataIndividualAddressRead) GetParent() ApduDataContract {
	return m.ApduDataContract
}

// Deprecated: use the interface for direct cast
func CastApduDataIndividualAddressRead(structType any) ApduDataIndividualAddressRead {
	if casted, ok := structType.(ApduDataIndividualAddressRead); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataIndividualAddressRead); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataIndividualAddressRead) GetTypeName() string {
	return "ApduDataIndividualAddressRead"
}

func (m *_ApduDataIndividualAddressRead) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataContract.(*_ApduData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataIndividualAddressRead) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataIndividualAddressRead) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduData, dataLength uint8) (__apduDataIndividualAddressRead ApduDataIndividualAddressRead, err error) {
	m.ApduDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataIndividualAddressRead"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataIndividualAddressRead")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataIndividualAddressRead"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataIndividualAddressRead")
	}

	return m, nil
}

func (m *_ApduDataIndividualAddressRead) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataIndividualAddressRead) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataIndividualAddressRead"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataIndividualAddressRead")
		}

		if popErr := writeBuffer.PopContext("ApduDataIndividualAddressRead"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataIndividualAddressRead")
		}
		return nil
	}
	return m.ApduDataContract.(*_ApduData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataIndividualAddressRead) IsApduDataIndividualAddressRead() {}

func (m *_ApduDataIndividualAddressRead) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataIndividualAddressRead) deepCopy() *_ApduDataIndividualAddressRead {
	if m == nil {
		return nil
	}
	_ApduDataIndividualAddressReadCopy := &_ApduDataIndividualAddressRead{
		m.ApduDataContract.(*_ApduData).deepCopy(),
	}
	_ApduDataIndividualAddressReadCopy.ApduDataContract.(*_ApduData)._SubType = m
	return _ApduDataIndividualAddressReadCopy
}

func (m *_ApduDataIndividualAddressRead) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
