/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LPollDataCon is the corresponding interface of LPollDataCon
type LPollDataCon interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CEMI
	// IsLPollDataCon is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLPollDataCon()
	// CreateBuilder creates a LPollDataConBuilder
	CreateLPollDataConBuilder() LPollDataConBuilder
}

// _LPollDataCon is the data-structure of this message
type _LPollDataCon struct {
	CEMIContract
}

var _ LPollDataCon = (*_LPollDataCon)(nil)
var _ CEMIRequirements = (*_LPollDataCon)(nil)

// NewLPollDataCon factory function for _LPollDataCon
func NewLPollDataCon(size uint16) *_LPollDataCon {
	_result := &_LPollDataCon{
		CEMIContract: NewCEMI(size),
	}
	_result.CEMIContract.(*_CEMI)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LPollDataConBuilder is a builder for LPollDataCon
type LPollDataConBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() LPollDataConBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CEMIBuilder
	// Build builds the LPollDataCon or returns an error if something is wrong
	Build() (LPollDataCon, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LPollDataCon
}

// NewLPollDataConBuilder() creates a LPollDataConBuilder
func NewLPollDataConBuilder() LPollDataConBuilder {
	return &_LPollDataConBuilder{_LPollDataCon: new(_LPollDataCon)}
}

type _LPollDataConBuilder struct {
	*_LPollDataCon

	parentBuilder *_CEMIBuilder

	collectedErr []error
}

var _ (LPollDataConBuilder) = (*_LPollDataConBuilder)(nil)

func (b *_LPollDataConBuilder) setParent(contract CEMIContract) {
	b.CEMIContract = contract
	contract.(*_CEMI)._SubType = b._LPollDataCon
}

func (b *_LPollDataConBuilder) WithMandatoryFields() LPollDataConBuilder {
	return b
}

func (b *_LPollDataConBuilder) Build() (LPollDataCon, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._LPollDataCon.deepCopy(), nil
}

func (b *_LPollDataConBuilder) MustBuild() LPollDataCon {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LPollDataConBuilder) Done() CEMIBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCEMIBuilder().(*_CEMIBuilder)
	}
	return b.parentBuilder
}

func (b *_LPollDataConBuilder) buildForCEMI() (CEMI, error) {
	return b.Build()
}

func (b *_LPollDataConBuilder) DeepCopy() any {
	_copy := b.CreateLPollDataConBuilder().(*_LPollDataConBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateLPollDataConBuilder creates a LPollDataConBuilder
func (b *_LPollDataCon) CreateLPollDataConBuilder() LPollDataConBuilder {
	if b == nil {
		return NewLPollDataConBuilder()
	}
	return &_LPollDataConBuilder{_LPollDataCon: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_LPollDataCon) GetMessageCode() uint8 {
	return 0x25
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LPollDataCon) GetParent() CEMIContract {
	return m.CEMIContract
}

// Deprecated: use the interface for direct cast
func CastLPollDataCon(structType any) LPollDataCon {
	if casted, ok := structType.(LPollDataCon); ok {
		return casted
	}
	if casted, ok := structType.(*LPollDataCon); ok {
		return *casted
	}
	return nil
}

func (m *_LPollDataCon) GetTypeName() string {
	return "LPollDataCon"
}

func (m *_LPollDataCon) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CEMIContract.(*_CEMI).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_LPollDataCon) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_LPollDataCon) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CEMI, size uint16) (__lPollDataCon LPollDataCon, err error) {
	m.CEMIContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LPollDataCon"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LPollDataCon")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("LPollDataCon"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LPollDataCon")
	}

	return m, nil
}

func (m *_LPollDataCon) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LPollDataCon) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LPollDataCon"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LPollDataCon")
		}

		if popErr := writeBuffer.PopContext("LPollDataCon"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LPollDataCon")
		}
		return nil
	}
	return m.CEMIContract.(*_CEMI).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LPollDataCon) IsLPollDataCon() {}

func (m *_LPollDataCon) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LPollDataCon) deepCopy() *_LPollDataCon {
	if m == nil {
		return nil
	}
	_LPollDataConCopy := &_LPollDataCon{
		m.CEMIContract.(*_CEMI).deepCopy(),
	}
	_LPollDataConCopy.CEMIContract.(*_CEMI)._SubType = m
	return _LPollDataConCopy
}

func (m *_LPollDataCon) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
