/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// JsonDataSetWriterMessageDataType is the corresponding interface of JsonDataSetWriterMessageDataType
type JsonDataSetWriterMessageDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetDataSetMessageContentMask returns DataSetMessageContentMask (property field)
	GetDataSetMessageContentMask() JsonDataSetMessageContentMask
	// IsJsonDataSetWriterMessageDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsJsonDataSetWriterMessageDataType()
	// CreateBuilder creates a JsonDataSetWriterMessageDataTypeBuilder
	CreateJsonDataSetWriterMessageDataTypeBuilder() JsonDataSetWriterMessageDataTypeBuilder
}

// _JsonDataSetWriterMessageDataType is the data-structure of this message
type _JsonDataSetWriterMessageDataType struct {
	ExtensionObjectDefinitionContract
	DataSetMessageContentMask JsonDataSetMessageContentMask
}

var _ JsonDataSetWriterMessageDataType = (*_JsonDataSetWriterMessageDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_JsonDataSetWriterMessageDataType)(nil)

// NewJsonDataSetWriterMessageDataType factory function for _JsonDataSetWriterMessageDataType
func NewJsonDataSetWriterMessageDataType(dataSetMessageContentMask JsonDataSetMessageContentMask) *_JsonDataSetWriterMessageDataType {
	_result := &_JsonDataSetWriterMessageDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		DataSetMessageContentMask:         dataSetMessageContentMask,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// JsonDataSetWriterMessageDataTypeBuilder is a builder for JsonDataSetWriterMessageDataType
type JsonDataSetWriterMessageDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dataSetMessageContentMask JsonDataSetMessageContentMask) JsonDataSetWriterMessageDataTypeBuilder
	// WithDataSetMessageContentMask adds DataSetMessageContentMask (property field)
	WithDataSetMessageContentMask(JsonDataSetMessageContentMask) JsonDataSetWriterMessageDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the JsonDataSetWriterMessageDataType or returns an error if something is wrong
	Build() (JsonDataSetWriterMessageDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() JsonDataSetWriterMessageDataType
}

// NewJsonDataSetWriterMessageDataTypeBuilder() creates a JsonDataSetWriterMessageDataTypeBuilder
func NewJsonDataSetWriterMessageDataTypeBuilder() JsonDataSetWriterMessageDataTypeBuilder {
	return &_JsonDataSetWriterMessageDataTypeBuilder{_JsonDataSetWriterMessageDataType: new(_JsonDataSetWriterMessageDataType)}
}

type _JsonDataSetWriterMessageDataTypeBuilder struct {
	*_JsonDataSetWriterMessageDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (JsonDataSetWriterMessageDataTypeBuilder) = (*_JsonDataSetWriterMessageDataTypeBuilder)(nil)

func (b *_JsonDataSetWriterMessageDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._JsonDataSetWriterMessageDataType
}

func (b *_JsonDataSetWriterMessageDataTypeBuilder) WithMandatoryFields(dataSetMessageContentMask JsonDataSetMessageContentMask) JsonDataSetWriterMessageDataTypeBuilder {
	return b.WithDataSetMessageContentMask(dataSetMessageContentMask)
}

func (b *_JsonDataSetWriterMessageDataTypeBuilder) WithDataSetMessageContentMask(dataSetMessageContentMask JsonDataSetMessageContentMask) JsonDataSetWriterMessageDataTypeBuilder {
	b.DataSetMessageContentMask = dataSetMessageContentMask
	return b
}

func (b *_JsonDataSetWriterMessageDataTypeBuilder) Build() (JsonDataSetWriterMessageDataType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._JsonDataSetWriterMessageDataType.deepCopy(), nil
}

func (b *_JsonDataSetWriterMessageDataTypeBuilder) MustBuild() JsonDataSetWriterMessageDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_JsonDataSetWriterMessageDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_JsonDataSetWriterMessageDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_JsonDataSetWriterMessageDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateJsonDataSetWriterMessageDataTypeBuilder().(*_JsonDataSetWriterMessageDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateJsonDataSetWriterMessageDataTypeBuilder creates a JsonDataSetWriterMessageDataTypeBuilder
func (b *_JsonDataSetWriterMessageDataType) CreateJsonDataSetWriterMessageDataTypeBuilder() JsonDataSetWriterMessageDataTypeBuilder {
	if b == nil {
		return NewJsonDataSetWriterMessageDataTypeBuilder()
	}
	return &_JsonDataSetWriterMessageDataTypeBuilder{_JsonDataSetWriterMessageDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_JsonDataSetWriterMessageDataType) GetExtensionId() int32 {
	return int32(15666)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_JsonDataSetWriterMessageDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_JsonDataSetWriterMessageDataType) GetDataSetMessageContentMask() JsonDataSetMessageContentMask {
	return m.DataSetMessageContentMask
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastJsonDataSetWriterMessageDataType(structType any) JsonDataSetWriterMessageDataType {
	if casted, ok := structType.(JsonDataSetWriterMessageDataType); ok {
		return casted
	}
	if casted, ok := structType.(*JsonDataSetWriterMessageDataType); ok {
		return *casted
	}
	return nil
}

func (m *_JsonDataSetWriterMessageDataType) GetTypeName() string {
	return "JsonDataSetWriterMessageDataType"
}

func (m *_JsonDataSetWriterMessageDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (dataSetMessageContentMask)
	lengthInBits += 32

	return lengthInBits
}

func (m *_JsonDataSetWriterMessageDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_JsonDataSetWriterMessageDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__jsonDataSetWriterMessageDataType JsonDataSetWriterMessageDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("JsonDataSetWriterMessageDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for JsonDataSetWriterMessageDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dataSetMessageContentMask, err := ReadEnumField[JsonDataSetMessageContentMask](ctx, "dataSetMessageContentMask", "JsonDataSetMessageContentMask", ReadEnum(JsonDataSetMessageContentMaskByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetMessageContentMask' field"))
	}
	m.DataSetMessageContentMask = dataSetMessageContentMask

	if closeErr := readBuffer.CloseContext("JsonDataSetWriterMessageDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for JsonDataSetWriterMessageDataType")
	}

	return m, nil
}

func (m *_JsonDataSetWriterMessageDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_JsonDataSetWriterMessageDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("JsonDataSetWriterMessageDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for JsonDataSetWriterMessageDataType")
		}

		if err := WriteSimpleEnumField[JsonDataSetMessageContentMask](ctx, "dataSetMessageContentMask", "JsonDataSetMessageContentMask", m.GetDataSetMessageContentMask(), WriteEnum[JsonDataSetMessageContentMask, uint32](JsonDataSetMessageContentMask.GetValue, JsonDataSetMessageContentMask.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetMessageContentMask' field")
		}

		if popErr := writeBuffer.PopContext("JsonDataSetWriterMessageDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for JsonDataSetWriterMessageDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_JsonDataSetWriterMessageDataType) IsJsonDataSetWriterMessageDataType() {}

func (m *_JsonDataSetWriterMessageDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_JsonDataSetWriterMessageDataType) deepCopy() *_JsonDataSetWriterMessageDataType {
	if m == nil {
		return nil
	}
	_JsonDataSetWriterMessageDataTypeCopy := &_JsonDataSetWriterMessageDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.DataSetMessageContentMask,
	}
	_JsonDataSetWriterMessageDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _JsonDataSetWriterMessageDataTypeCopy
}

func (m *_JsonDataSetWriterMessageDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
