/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LogRecord is the corresponding interface of LogRecord
type LogRecord interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetEventTime returns EventTime (property field)
	GetEventTime() int64
	// GetSeverity returns Severity (property field)
	GetSeverity() uint16
	// GetEventType returns EventType (property field)
	GetEventType() NodeId
	// GetSourceNode returns SourceNode (property field)
	GetSourceNode() NodeId
	// GetSourceName returns SourceName (property field)
	GetSourceName() PascalString
	// GetMessage returns Message (property field)
	GetMessage() LocalizedText
	// GetTraceContext returns TraceContext (property field)
	GetTraceContext() TraceContextDataType
	// GetAdditionalData returns AdditionalData (property field)
	GetAdditionalData() []NameValuePair
	// IsLogRecord is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLogRecord()
	// CreateBuilder creates a LogRecordBuilder
	CreateLogRecordBuilder() LogRecordBuilder
}

// _LogRecord is the data-structure of this message
type _LogRecord struct {
	ExtensionObjectDefinitionContract
	EventTime      int64
	Severity       uint16
	EventType      NodeId
	SourceNode     NodeId
	SourceName     PascalString
	Message        LocalizedText
	TraceContext   TraceContextDataType
	AdditionalData []NameValuePair
}

var _ LogRecord = (*_LogRecord)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_LogRecord)(nil)

// NewLogRecord factory function for _LogRecord
func NewLogRecord(eventTime int64, severity uint16, eventType NodeId, sourceNode NodeId, sourceName PascalString, message LocalizedText, traceContext TraceContextDataType, additionalData []NameValuePair) *_LogRecord {
	if eventType == nil {
		panic("eventType of type NodeId for LogRecord must not be nil")
	}
	if sourceNode == nil {
		panic("sourceNode of type NodeId for LogRecord must not be nil")
	}
	if sourceName == nil {
		panic("sourceName of type PascalString for LogRecord must not be nil")
	}
	if message == nil {
		panic("message of type LocalizedText for LogRecord must not be nil")
	}
	if traceContext == nil {
		panic("traceContext of type TraceContextDataType for LogRecord must not be nil")
	}
	_result := &_LogRecord{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		EventTime:                         eventTime,
		Severity:                          severity,
		EventType:                         eventType,
		SourceNode:                        sourceNode,
		SourceName:                        sourceName,
		Message:                           message,
		TraceContext:                      traceContext,
		AdditionalData:                    additionalData,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LogRecordBuilder is a builder for LogRecord
type LogRecordBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(eventTime int64, severity uint16, eventType NodeId, sourceNode NodeId, sourceName PascalString, message LocalizedText, traceContext TraceContextDataType, additionalData []NameValuePair) LogRecordBuilder
	// WithEventTime adds EventTime (property field)
	WithEventTime(int64) LogRecordBuilder
	// WithSeverity adds Severity (property field)
	WithSeverity(uint16) LogRecordBuilder
	// WithEventType adds EventType (property field)
	WithEventType(NodeId) LogRecordBuilder
	// WithEventTypeBuilder adds EventType (property field) which is build by the builder
	WithEventTypeBuilder(func(NodeIdBuilder) NodeIdBuilder) LogRecordBuilder
	// WithSourceNode adds SourceNode (property field)
	WithSourceNode(NodeId) LogRecordBuilder
	// WithSourceNodeBuilder adds SourceNode (property field) which is build by the builder
	WithSourceNodeBuilder(func(NodeIdBuilder) NodeIdBuilder) LogRecordBuilder
	// WithSourceName adds SourceName (property field)
	WithSourceName(PascalString) LogRecordBuilder
	// WithSourceNameBuilder adds SourceName (property field) which is build by the builder
	WithSourceNameBuilder(func(PascalStringBuilder) PascalStringBuilder) LogRecordBuilder
	// WithMessage adds Message (property field)
	WithMessage(LocalizedText) LogRecordBuilder
	// WithMessageBuilder adds Message (property field) which is build by the builder
	WithMessageBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) LogRecordBuilder
	// WithTraceContext adds TraceContext (property field)
	WithTraceContext(TraceContextDataType) LogRecordBuilder
	// WithTraceContextBuilder adds TraceContext (property field) which is build by the builder
	WithTraceContextBuilder(func(TraceContextDataTypeBuilder) TraceContextDataTypeBuilder) LogRecordBuilder
	// WithAdditionalData adds AdditionalData (property field)
	WithAdditionalData(...NameValuePair) LogRecordBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the LogRecord or returns an error if something is wrong
	Build() (LogRecord, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LogRecord
}

// NewLogRecordBuilder() creates a LogRecordBuilder
func NewLogRecordBuilder() LogRecordBuilder {
	return &_LogRecordBuilder{_LogRecord: new(_LogRecord)}
}

type _LogRecordBuilder struct {
	*_LogRecord

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (LogRecordBuilder) = (*_LogRecordBuilder)(nil)

func (b *_LogRecordBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._LogRecord
}

func (b *_LogRecordBuilder) WithMandatoryFields(eventTime int64, severity uint16, eventType NodeId, sourceNode NodeId, sourceName PascalString, message LocalizedText, traceContext TraceContextDataType, additionalData []NameValuePair) LogRecordBuilder {
	return b.WithEventTime(eventTime).WithSeverity(severity).WithEventType(eventType).WithSourceNode(sourceNode).WithSourceName(sourceName).WithMessage(message).WithTraceContext(traceContext).WithAdditionalData(additionalData...)
}

func (b *_LogRecordBuilder) WithEventTime(eventTime int64) LogRecordBuilder {
	b.EventTime = eventTime
	return b
}

func (b *_LogRecordBuilder) WithSeverity(severity uint16) LogRecordBuilder {
	b.Severity = severity
	return b
}

func (b *_LogRecordBuilder) WithEventType(eventType NodeId) LogRecordBuilder {
	b.EventType = eventType
	return b
}

func (b *_LogRecordBuilder) WithEventTypeBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) LogRecordBuilder {
	builder := builderSupplier(b.EventType.CreateNodeIdBuilder())
	var err error
	b.EventType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_LogRecordBuilder) WithSourceNode(sourceNode NodeId) LogRecordBuilder {
	b.SourceNode = sourceNode
	return b
}

func (b *_LogRecordBuilder) WithSourceNodeBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) LogRecordBuilder {
	builder := builderSupplier(b.SourceNode.CreateNodeIdBuilder())
	var err error
	b.SourceNode, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_LogRecordBuilder) WithSourceName(sourceName PascalString) LogRecordBuilder {
	b.SourceName = sourceName
	return b
}

func (b *_LogRecordBuilder) WithSourceNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) LogRecordBuilder {
	builder := builderSupplier(b.SourceName.CreatePascalStringBuilder())
	var err error
	b.SourceName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_LogRecordBuilder) WithMessage(message LocalizedText) LogRecordBuilder {
	b.Message = message
	return b
}

func (b *_LogRecordBuilder) WithMessageBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) LogRecordBuilder {
	builder := builderSupplier(b.Message.CreateLocalizedTextBuilder())
	var err error
	b.Message, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_LogRecordBuilder) WithTraceContext(traceContext TraceContextDataType) LogRecordBuilder {
	b.TraceContext = traceContext
	return b
}

func (b *_LogRecordBuilder) WithTraceContextBuilder(builderSupplier func(TraceContextDataTypeBuilder) TraceContextDataTypeBuilder) LogRecordBuilder {
	builder := builderSupplier(b.TraceContext.CreateTraceContextDataTypeBuilder())
	var err error
	b.TraceContext, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "TraceContextDataTypeBuilder failed"))
	}
	return b
}

func (b *_LogRecordBuilder) WithAdditionalData(additionalData ...NameValuePair) LogRecordBuilder {
	b.AdditionalData = additionalData
	return b
}

func (b *_LogRecordBuilder) Build() (LogRecord, error) {
	if b.EventType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'eventType' not set"))
	}
	if b.SourceNode == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'sourceNode' not set"))
	}
	if b.SourceName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'sourceName' not set"))
	}
	if b.Message == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'message' not set"))
	}
	if b.TraceContext == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'traceContext' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._LogRecord.deepCopy(), nil
}

func (b *_LogRecordBuilder) MustBuild() LogRecord {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LogRecordBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_LogRecordBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_LogRecordBuilder) DeepCopy() any {
	_copy := b.CreateLogRecordBuilder().(*_LogRecordBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateLogRecordBuilder creates a LogRecordBuilder
func (b *_LogRecord) CreateLogRecordBuilder() LogRecordBuilder {
	if b == nil {
		return NewLogRecordBuilder()
	}
	return &_LogRecordBuilder{_LogRecord: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_LogRecord) GetExtensionId() int32 {
	return int32(19363)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LogRecord) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LogRecord) GetEventTime() int64 {
	return m.EventTime
}

func (m *_LogRecord) GetSeverity() uint16 {
	return m.Severity
}

func (m *_LogRecord) GetEventType() NodeId {
	return m.EventType
}

func (m *_LogRecord) GetSourceNode() NodeId {
	return m.SourceNode
}

func (m *_LogRecord) GetSourceName() PascalString {
	return m.SourceName
}

func (m *_LogRecord) GetMessage() LocalizedText {
	return m.Message
}

func (m *_LogRecord) GetTraceContext() TraceContextDataType {
	return m.TraceContext
}

func (m *_LogRecord) GetAdditionalData() []NameValuePair {
	return m.AdditionalData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastLogRecord(structType any) LogRecord {
	if casted, ok := structType.(LogRecord); ok {
		return casted
	}
	if casted, ok := structType.(*LogRecord); ok {
		return *casted
	}
	return nil
}

func (m *_LogRecord) GetTypeName() string {
	return "LogRecord"
}

func (m *_LogRecord) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (eventTime)
	lengthInBits += 64

	// Simple field (severity)
	lengthInBits += 16

	// Simple field (eventType)
	lengthInBits += m.EventType.GetLengthInBits(ctx)

	// Simple field (sourceNode)
	lengthInBits += m.SourceNode.GetLengthInBits(ctx)

	// Simple field (sourceName)
	lengthInBits += m.SourceName.GetLengthInBits(ctx)

	// Simple field (message)
	lengthInBits += m.Message.GetLengthInBits(ctx)

	// Simple field (traceContext)
	lengthInBits += m.TraceContext.GetLengthInBits(ctx)

	// Implicit Field (noOfAdditionalData)
	lengthInBits += 32

	// Array field
	if len(m.AdditionalData) > 0 {
		for _curItem, element := range m.AdditionalData {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.AdditionalData), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_LogRecord) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_LogRecord) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__logRecord LogRecord, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LogRecord"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LogRecord")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	eventTime, err := ReadSimpleField(ctx, "eventTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventTime' field"))
	}
	m.EventTime = eventTime

	severity, err := ReadSimpleField(ctx, "severity", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'severity' field"))
	}
	m.Severity = severity

	eventType, err := ReadSimpleField[NodeId](ctx, "eventType", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventType' field"))
	}
	m.EventType = eventType

	sourceNode, err := ReadSimpleField[NodeId](ctx, "sourceNode", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sourceNode' field"))
	}
	m.SourceNode = sourceNode

	sourceName, err := ReadSimpleField[PascalString](ctx, "sourceName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sourceName' field"))
	}
	m.SourceName = sourceName

	message, err := ReadSimpleField[LocalizedText](ctx, "message", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'message' field"))
	}
	m.Message = message

	traceContext, err := ReadSimpleField[TraceContextDataType](ctx, "traceContext", ReadComplex[TraceContextDataType](ExtensionObjectDefinitionParseWithBufferProducer[TraceContextDataType]((int32)(int32(19749))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'traceContext' field"))
	}
	m.TraceContext = traceContext

	noOfAdditionalData, err := ReadImplicitField[int32](ctx, "noOfAdditionalData", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfAdditionalData' field"))
	}
	_ = noOfAdditionalData

	additionalData, err := ReadCountArrayField[NameValuePair](ctx, "additionalData", ReadComplex[NameValuePair](ExtensionObjectDefinitionParseWithBufferProducer[NameValuePair]((int32)(int32(19750))), readBuffer), uint64(noOfAdditionalData))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'additionalData' field"))
	}
	m.AdditionalData = additionalData

	if closeErr := readBuffer.CloseContext("LogRecord"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LogRecord")
	}

	return m, nil
}

func (m *_LogRecord) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LogRecord) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LogRecord"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LogRecord")
		}

		if err := WriteSimpleField[int64](ctx, "eventTime", m.GetEventTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'eventTime' field")
		}

		if err := WriteSimpleField[uint16](ctx, "severity", m.GetSeverity(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'severity' field")
		}

		if err := WriteSimpleField[NodeId](ctx, "eventType", m.GetEventType(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'eventType' field")
		}

		if err := WriteSimpleField[NodeId](ctx, "sourceNode", m.GetSourceNode(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'sourceNode' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "sourceName", m.GetSourceName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'sourceName' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "message", m.GetMessage(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'message' field")
		}

		if err := WriteSimpleField[TraceContextDataType](ctx, "traceContext", m.GetTraceContext(), WriteComplex[TraceContextDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'traceContext' field")
		}
		noOfAdditionalData := int32(utils.InlineIf(bool((m.GetAdditionalData()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetAdditionalData()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfAdditionalData", noOfAdditionalData, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfAdditionalData' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "additionalData", m.GetAdditionalData(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'additionalData' field")
		}

		if popErr := writeBuffer.PopContext("LogRecord"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LogRecord")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LogRecord) IsLogRecord() {}

func (m *_LogRecord) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LogRecord) deepCopy() *_LogRecord {
	if m == nil {
		return nil
	}
	_LogRecordCopy := &_LogRecord{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.EventTime,
		m.Severity,
		utils.DeepCopy[NodeId](m.EventType),
		utils.DeepCopy[NodeId](m.SourceNode),
		utils.DeepCopy[PascalString](m.SourceName),
		utils.DeepCopy[LocalizedText](m.Message),
		utils.DeepCopy[TraceContextDataType](m.TraceContext),
		utils.DeepCopySlice[NameValuePair, NameValuePair](m.AdditionalData),
	}
	_LogRecordCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _LogRecordCopy
}

func (m *_LogRecord) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
