/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ManAddrIfSubtype is an enum
type ManAddrIfSubtype uint32

type IManAddrIfSubtype interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	ManAddrIfSubtype_manAddrIfSubtypeNone             ManAddrIfSubtype = 0
	ManAddrIfSubtype_manAddrIfSubtypeUnknown          ManAddrIfSubtype = 1
	ManAddrIfSubtype_manAddrIfSubtypePortRef          ManAddrIfSubtype = 2
	ManAddrIfSubtype_manAddrIfSubtypeSystemPortNumber ManAddrIfSubtype = 3
)

var ManAddrIfSubtypeValues []ManAddrIfSubtype

func init() {
	_ = errors.New
	ManAddrIfSubtypeValues = []ManAddrIfSubtype{
		ManAddrIfSubtype_manAddrIfSubtypeNone,
		ManAddrIfSubtype_manAddrIfSubtypeUnknown,
		ManAddrIfSubtype_manAddrIfSubtypePortRef,
		ManAddrIfSubtype_manAddrIfSubtypeSystemPortNumber,
	}
}

func ManAddrIfSubtypeByValue(value uint32) (enum ManAddrIfSubtype, ok bool) {
	switch value {
	case 0:
		return ManAddrIfSubtype_manAddrIfSubtypeNone, true
	case 1:
		return ManAddrIfSubtype_manAddrIfSubtypeUnknown, true
	case 2:
		return ManAddrIfSubtype_manAddrIfSubtypePortRef, true
	case 3:
		return ManAddrIfSubtype_manAddrIfSubtypeSystemPortNumber, true
	}
	return 0, false
}

func ManAddrIfSubtypeByName(value string) (enum ManAddrIfSubtype, ok bool) {
	switch value {
	case "manAddrIfSubtypeNone":
		return ManAddrIfSubtype_manAddrIfSubtypeNone, true
	case "manAddrIfSubtypeUnknown":
		return ManAddrIfSubtype_manAddrIfSubtypeUnknown, true
	case "manAddrIfSubtypePortRef":
		return ManAddrIfSubtype_manAddrIfSubtypePortRef, true
	case "manAddrIfSubtypeSystemPortNumber":
		return ManAddrIfSubtype_manAddrIfSubtypeSystemPortNumber, true
	}
	return 0, false
}

func ManAddrIfSubtypeKnows(value uint32) bool {
	for _, typeValue := range ManAddrIfSubtypeValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastManAddrIfSubtype(structType any) ManAddrIfSubtype {
	castFunc := func(typ any) ManAddrIfSubtype {
		if sManAddrIfSubtype, ok := typ.(ManAddrIfSubtype); ok {
			return sManAddrIfSubtype
		}
		return 0
	}
	return castFunc(structType)
}

func (m ManAddrIfSubtype) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m ManAddrIfSubtype) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ManAddrIfSubtypeParse(ctx context.Context, theBytes []byte) (ManAddrIfSubtype, error) {
	return ManAddrIfSubtypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ManAddrIfSubtypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ManAddrIfSubtype, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("ManAddrIfSubtype", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading ManAddrIfSubtype")
	}
	if enum, ok := ManAddrIfSubtypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for ManAddrIfSubtype")
		return ManAddrIfSubtype(val), nil
	} else {
		return enum, nil
	}
}

func (e ManAddrIfSubtype) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e ManAddrIfSubtype) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint32("ManAddrIfSubtype", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e ManAddrIfSubtype) GetValue() uint32 {
	return uint32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e ManAddrIfSubtype) PLC4XEnumName() string {
	switch e {
	case ManAddrIfSubtype_manAddrIfSubtypeNone:
		return "manAddrIfSubtypeNone"
	case ManAddrIfSubtype_manAddrIfSubtypeUnknown:
		return "manAddrIfSubtypeUnknown"
	case ManAddrIfSubtype_manAddrIfSubtypePortRef:
		return "manAddrIfSubtypePortRef"
	case ManAddrIfSubtype_manAddrIfSubtypeSystemPortNumber:
		return "manAddrIfSubtypeSystemPortNumber"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e ManAddrIfSubtype) String() string {
	return e.PLC4XEnumName()
}
