/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableHistorical is an enum
type OpcuaNodeIdServicesVariableHistorical int32

type IOpcuaNodeIdServicesVariableHistorical interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_Stepped                                       OpcuaNodeIdServicesVariableHistorical = 2323
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_Definition                                    OpcuaNodeIdServicesVariableHistorical = 2324
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxTimeInterval                               OpcuaNodeIdServicesVariableHistorical = 2325
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MinTimeInterval                               OpcuaNodeIdServicesVariableHistorical = 2326
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ExceptionDeviation                            OpcuaNodeIdServicesVariableHistorical = 2327
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ExceptionDeviationFormat                      OpcuaNodeIdServicesVariableHistorical = 2328
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad    OpcuaNodeIdServicesVariableHistorical = 11168
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad         OpcuaNodeIdServicesVariableHistorical = 11169
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood        OpcuaNodeIdServicesVariableHistorical = 11170
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation OpcuaNodeIdServicesVariableHistorical = 11171
	OpcuaNodeIdServicesVariableHistorical_HistoricalEventFilter                                                         OpcuaNodeIdServicesVariableHistorical = 11215
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_StartOfArchive                                OpcuaNodeIdServicesVariableHistorical = 11499
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_StartOfOnlineArchive                          OpcuaNodeIdServicesVariableHistorical = 11500
	OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_SortByEventFields                            OpcuaNodeIdServicesVariableHistorical = 18644
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ServerTimestampSupported                      OpcuaNodeIdServicesVariableHistorical = 19092
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxTimeStoredValues                           OpcuaNodeIdServicesVariableHistorical = 32619
	OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxCountStoredValues                          OpcuaNodeIdServicesVariableHistorical = 32620
	OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_StartOfArchive                               OpcuaNodeIdServicesVariableHistorical = 32623
	OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_StartOfOnlineArchive                         OpcuaNodeIdServicesVariableHistorical = 32624
	OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_Server                                      OpcuaNodeIdServicesVariableHistorical = 32626
	OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_EndpointUrl                                 OpcuaNodeIdServicesVariableHistorical = 32627
	OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_SecurityMode                                OpcuaNodeIdServicesVariableHistorical = 32628
	OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_SecurityPolicyUri                           OpcuaNodeIdServicesVariableHistorical = 32629
	OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_IdentityTokenPolicy                         OpcuaNodeIdServicesVariableHistorical = 32630
	OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_TransportProfileUri                         OpcuaNodeIdServicesVariableHistorical = 32631
	OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_HistoricalEventFilter                       OpcuaNodeIdServicesVariableHistorical = 32632
)

var OpcuaNodeIdServicesVariableHistoricalValues []OpcuaNodeIdServicesVariableHistorical

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableHistoricalValues = []OpcuaNodeIdServicesVariableHistorical{
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_Stepped,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_Definition,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxTimeInterval,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MinTimeInterval,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ExceptionDeviation,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ExceptionDeviationFormat,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation,
		OpcuaNodeIdServicesVariableHistorical_HistoricalEventFilter,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_StartOfArchive,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_StartOfOnlineArchive,
		OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_SortByEventFields,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ServerTimestampSupported,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxTimeStoredValues,
		OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxCountStoredValues,
		OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_StartOfArchive,
		OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_StartOfOnlineArchive,
		OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_Server,
		OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_EndpointUrl,
		OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_SecurityMode,
		OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_SecurityPolicyUri,
		OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_IdentityTokenPolicy,
		OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_TransportProfileUri,
		OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_HistoricalEventFilter,
	}
}

func OpcuaNodeIdServicesVariableHistoricalByValue(value int32) (enum OpcuaNodeIdServicesVariableHistorical, ok bool) {
	switch value {
	case 11168:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad, true
	case 11169:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad, true
	case 11170:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood, true
	case 11171:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation, true
	case 11215:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalEventFilter, true
	case 11499:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_StartOfArchive, true
	case 11500:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_StartOfOnlineArchive, true
	case 18644:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_SortByEventFields, true
	case 19092:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ServerTimestampSupported, true
	case 2323:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_Stepped, true
	case 2324:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_Definition, true
	case 2325:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxTimeInterval, true
	case 2326:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MinTimeInterval, true
	case 2327:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ExceptionDeviation, true
	case 2328:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ExceptionDeviationFormat, true
	case 32619:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxTimeStoredValues, true
	case 32620:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxCountStoredValues, true
	case 32623:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_StartOfArchive, true
	case 32624:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_StartOfOnlineArchive, true
	case 32626:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_Server, true
	case 32627:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_EndpointUrl, true
	case 32628:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_SecurityMode, true
	case 32629:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_SecurityPolicyUri, true
	case 32630:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_IdentityTokenPolicy, true
	case 32631:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_TransportProfileUri, true
	case 32632:
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_HistoricalEventFilter, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableHistoricalByName(value string) (enum OpcuaNodeIdServicesVariableHistorical, ok bool) {
	switch value {
	case "HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad, true
	case "HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad, true
	case "HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood, true
	case "HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation, true
	case "HistoricalEventFilter":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalEventFilter, true
	case "HistoricalDataConfigurationType_StartOfArchive":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_StartOfArchive, true
	case "HistoricalDataConfigurationType_StartOfOnlineArchive":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_StartOfOnlineArchive, true
	case "HistoricalEventConfigurationType_SortByEventFields":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_SortByEventFields, true
	case "HistoricalDataConfigurationType_ServerTimestampSupported":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ServerTimestampSupported, true
	case "HistoricalDataConfigurationType_Stepped":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_Stepped, true
	case "HistoricalDataConfigurationType_Definition":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_Definition, true
	case "HistoricalDataConfigurationType_MaxTimeInterval":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxTimeInterval, true
	case "HistoricalDataConfigurationType_MinTimeInterval":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MinTimeInterval, true
	case "HistoricalDataConfigurationType_ExceptionDeviation":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ExceptionDeviation, true
	case "HistoricalDataConfigurationType_ExceptionDeviationFormat":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ExceptionDeviationFormat, true
	case "HistoricalDataConfigurationType_MaxTimeStoredValues":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxTimeStoredValues, true
	case "HistoricalDataConfigurationType_MaxCountStoredValues":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxCountStoredValues, true
	case "HistoricalEventConfigurationType_StartOfArchive":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_StartOfArchive, true
	case "HistoricalEventConfigurationType_StartOfOnlineArchive":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_StartOfOnlineArchive, true
	case "HistoricalExternalEventSourceType_Server":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_Server, true
	case "HistoricalExternalEventSourceType_EndpointUrl":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_EndpointUrl, true
	case "HistoricalExternalEventSourceType_SecurityMode":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_SecurityMode, true
	case "HistoricalExternalEventSourceType_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_SecurityPolicyUri, true
	case "HistoricalExternalEventSourceType_IdentityTokenPolicy":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_IdentityTokenPolicy, true
	case "HistoricalExternalEventSourceType_TransportProfileUri":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_TransportProfileUri, true
	case "HistoricalExternalEventSourceType_HistoricalEventFilter":
		return OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_HistoricalEventFilter, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableHistoricalKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableHistoricalValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableHistorical(structType any) OpcuaNodeIdServicesVariableHistorical {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableHistorical {
		if sOpcuaNodeIdServicesVariableHistorical, ok := typ.(OpcuaNodeIdServicesVariableHistorical); ok {
			return sOpcuaNodeIdServicesVariableHistorical
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableHistorical) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableHistorical) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableHistoricalParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableHistorical, error) {
	return OpcuaNodeIdServicesVariableHistoricalParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableHistoricalParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableHistorical, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableHistorical", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableHistorical")
	}
	if enum, ok := OpcuaNodeIdServicesVariableHistoricalByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableHistorical")
		return OpcuaNodeIdServicesVariableHistorical(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableHistorical) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableHistorical) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableHistorical", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableHistorical) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableHistorical) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad:
		return "HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad:
		return "HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood:
		return "HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation:
		return "HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalEventFilter:
		return "HistoricalEventFilter"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_StartOfArchive:
		return "HistoricalDataConfigurationType_StartOfArchive"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_StartOfOnlineArchive:
		return "HistoricalDataConfigurationType_StartOfOnlineArchive"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_SortByEventFields:
		return "HistoricalEventConfigurationType_SortByEventFields"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ServerTimestampSupported:
		return "HistoricalDataConfigurationType_ServerTimestampSupported"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_Stepped:
		return "HistoricalDataConfigurationType_Stepped"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_Definition:
		return "HistoricalDataConfigurationType_Definition"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxTimeInterval:
		return "HistoricalDataConfigurationType_MaxTimeInterval"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MinTimeInterval:
		return "HistoricalDataConfigurationType_MinTimeInterval"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ExceptionDeviation:
		return "HistoricalDataConfigurationType_ExceptionDeviation"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_ExceptionDeviationFormat:
		return "HistoricalDataConfigurationType_ExceptionDeviationFormat"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxTimeStoredValues:
		return "HistoricalDataConfigurationType_MaxTimeStoredValues"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalDataConfigurationType_MaxCountStoredValues:
		return "HistoricalDataConfigurationType_MaxCountStoredValues"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_StartOfArchive:
		return "HistoricalEventConfigurationType_StartOfArchive"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalEventConfigurationType_StartOfOnlineArchive:
		return "HistoricalEventConfigurationType_StartOfOnlineArchive"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_Server:
		return "HistoricalExternalEventSourceType_Server"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_EndpointUrl:
		return "HistoricalExternalEventSourceType_EndpointUrl"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_SecurityMode:
		return "HistoricalExternalEventSourceType_SecurityMode"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_SecurityPolicyUri:
		return "HistoricalExternalEventSourceType_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_IdentityTokenPolicy:
		return "HistoricalExternalEventSourceType_IdentityTokenPolicy"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_TransportProfileUri:
		return "HistoricalExternalEventSourceType_TransportProfileUri"
	case OpcuaNodeIdServicesVariableHistorical_HistoricalExternalEventSourceType_HistoricalEventFilter:
		return "HistoricalExternalEventSourceType_HistoricalEventFilter"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableHistorical) String() string {
	return e.PLC4XEnumName()
}
