/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// S7ParameterReadVarResponse is the corresponding interface of S7ParameterReadVarResponse
type S7ParameterReadVarResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	S7Parameter
	// GetNumItems returns NumItems (property field)
	GetNumItems() uint8
	// IsS7ParameterReadVarResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7ParameterReadVarResponse()
	// CreateBuilder creates a S7ParameterReadVarResponseBuilder
	CreateS7ParameterReadVarResponseBuilder() S7ParameterReadVarResponseBuilder
}

// _S7ParameterReadVarResponse is the data-structure of this message
type _S7ParameterReadVarResponse struct {
	S7ParameterContract
	NumItems uint8
}

var _ S7ParameterReadVarResponse = (*_S7ParameterReadVarResponse)(nil)
var _ S7ParameterRequirements = (*_S7ParameterReadVarResponse)(nil)

// NewS7ParameterReadVarResponse factory function for _S7ParameterReadVarResponse
func NewS7ParameterReadVarResponse(numItems uint8) *_S7ParameterReadVarResponse {
	_result := &_S7ParameterReadVarResponse{
		S7ParameterContract: NewS7Parameter(),
		NumItems:            numItems,
	}
	_result.S7ParameterContract.(*_S7Parameter)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// S7ParameterReadVarResponseBuilder is a builder for S7ParameterReadVarResponse
type S7ParameterReadVarResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(numItems uint8) S7ParameterReadVarResponseBuilder
	// WithNumItems adds NumItems (property field)
	WithNumItems(uint8) S7ParameterReadVarResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() S7ParameterBuilder
	// Build builds the S7ParameterReadVarResponse or returns an error if something is wrong
	Build() (S7ParameterReadVarResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() S7ParameterReadVarResponse
}

// NewS7ParameterReadVarResponseBuilder() creates a S7ParameterReadVarResponseBuilder
func NewS7ParameterReadVarResponseBuilder() S7ParameterReadVarResponseBuilder {
	return &_S7ParameterReadVarResponseBuilder{_S7ParameterReadVarResponse: new(_S7ParameterReadVarResponse)}
}

type _S7ParameterReadVarResponseBuilder struct {
	*_S7ParameterReadVarResponse

	parentBuilder *_S7ParameterBuilder

	collectedErr []error
}

var _ (S7ParameterReadVarResponseBuilder) = (*_S7ParameterReadVarResponseBuilder)(nil)

func (b *_S7ParameterReadVarResponseBuilder) setParent(contract S7ParameterContract) {
	b.S7ParameterContract = contract
	contract.(*_S7Parameter)._SubType = b._S7ParameterReadVarResponse
}

func (b *_S7ParameterReadVarResponseBuilder) WithMandatoryFields(numItems uint8) S7ParameterReadVarResponseBuilder {
	return b.WithNumItems(numItems)
}

func (b *_S7ParameterReadVarResponseBuilder) WithNumItems(numItems uint8) S7ParameterReadVarResponseBuilder {
	b.NumItems = numItems
	return b
}

func (b *_S7ParameterReadVarResponseBuilder) Build() (S7ParameterReadVarResponse, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._S7ParameterReadVarResponse.deepCopy(), nil
}

func (b *_S7ParameterReadVarResponseBuilder) MustBuild() S7ParameterReadVarResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7ParameterReadVarResponseBuilder) Done() S7ParameterBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewS7ParameterBuilder().(*_S7ParameterBuilder)
	}
	return b.parentBuilder
}

func (b *_S7ParameterReadVarResponseBuilder) buildForS7Parameter() (S7Parameter, error) {
	return b.Build()
}

func (b *_S7ParameterReadVarResponseBuilder) DeepCopy() any {
	_copy := b.CreateS7ParameterReadVarResponseBuilder().(*_S7ParameterReadVarResponseBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateS7ParameterReadVarResponseBuilder creates a S7ParameterReadVarResponseBuilder
func (b *_S7ParameterReadVarResponse) CreateS7ParameterReadVarResponseBuilder() S7ParameterReadVarResponseBuilder {
	if b == nil {
		return NewS7ParameterReadVarResponseBuilder()
	}
	return &_S7ParameterReadVarResponseBuilder{_S7ParameterReadVarResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_S7ParameterReadVarResponse) GetParameterType() uint8 {
	return 0x04
}

func (m *_S7ParameterReadVarResponse) GetMessageType() uint8 {
	return 0x03
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_S7ParameterReadVarResponse) GetParent() S7ParameterContract {
	return m.S7ParameterContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_S7ParameterReadVarResponse) GetNumItems() uint8 {
	return m.NumItems
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastS7ParameterReadVarResponse(structType any) S7ParameterReadVarResponse {
	if casted, ok := structType.(S7ParameterReadVarResponse); ok {
		return casted
	}
	if casted, ok := structType.(*S7ParameterReadVarResponse); ok {
		return *casted
	}
	return nil
}

func (m *_S7ParameterReadVarResponse) GetTypeName() string {
	return "S7ParameterReadVarResponse"
}

func (m *_S7ParameterReadVarResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.S7ParameterContract.(*_S7Parameter).getLengthInBits(ctx))

	// Simple field (numItems)
	lengthInBits += 8

	return lengthInBits
}

func (m *_S7ParameterReadVarResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_S7ParameterReadVarResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_S7Parameter, messageType uint8) (__s7ParameterReadVarResponse S7ParameterReadVarResponse, err error) {
	m.S7ParameterContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("S7ParameterReadVarResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7ParameterReadVarResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	numItems, err := ReadSimpleField(ctx, "numItems", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numItems' field"))
	}
	m.NumItems = numItems

	if closeErr := readBuffer.CloseContext("S7ParameterReadVarResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7ParameterReadVarResponse")
	}

	return m, nil
}

func (m *_S7ParameterReadVarResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_S7ParameterReadVarResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7ParameterReadVarResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for S7ParameterReadVarResponse")
		}

		if err := WriteSimpleField[uint8](ctx, "numItems", m.GetNumItems(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'numItems' field")
		}

		if popErr := writeBuffer.PopContext("S7ParameterReadVarResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for S7ParameterReadVarResponse")
		}
		return nil
	}
	return m.S7ParameterContract.(*_S7Parameter).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_S7ParameterReadVarResponse) IsS7ParameterReadVarResponse() {}

func (m *_S7ParameterReadVarResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_S7ParameterReadVarResponse) deepCopy() *_S7ParameterReadVarResponse {
	if m == nil {
		return nil
	}
	_S7ParameterReadVarResponseCopy := &_S7ParameterReadVarResponse{
		m.S7ParameterContract.(*_S7Parameter).deepCopy(),
		m.NumItems,
	}
	_S7ParameterReadVarResponseCopy.S7ParameterContract.(*_S7Parameter)._SubType = m
	return _S7ParameterReadVarResponseCopy
}

func (m *_S7ParameterReadVarResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
