/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetAssignedAccessRights implements Message {

  // Properties.
  protected final BACnetDeviceObjectReferenceEnclosed assignedAccessRights;
  protected final BACnetContextTagBoolean enable;

  public BACnetAssignedAccessRights(
      BACnetDeviceObjectReferenceEnclosed assignedAccessRights, BACnetContextTagBoolean enable) {
    super();
    this.assignedAccessRights = assignedAccessRights;
    this.enable = enable;
  }

  public BACnetDeviceObjectReferenceEnclosed getAssignedAccessRights() {
    return assignedAccessRights;
  }

  public BACnetContextTagBoolean getEnable() {
    return enable;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetAssignedAccessRights");

    // Simple Field (assignedAccessRights)
    writeSimpleField("assignedAccessRights", assignedAccessRights, writeComplex(writeBuffer));

    // Simple Field (enable)
    writeSimpleField("enable", enable, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetAssignedAccessRights");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetAssignedAccessRights _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (assignedAccessRights)
    lengthInBits += assignedAccessRights.getLengthInBits();

    // Simple field (enable)
    lengthInBits += enable.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetAssignedAccessRights staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetAssignedAccessRights");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetDeviceObjectReferenceEnclosed assignedAccessRights =
        readSimpleField(
            "assignedAccessRights",
            readComplex(
                () -> BACnetDeviceObjectReferenceEnclosed.staticParse(readBuffer, (short) (0)),
                readBuffer));

    BACnetContextTagBoolean enable =
        readSimpleField(
            "enable",
            readComplex(
                () ->
                    (BACnetContextTagBoolean)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (1), (BACnetDataType) (BACnetDataType.BOOLEAN)),
                readBuffer));

    readBuffer.closeContext("BACnetAssignedAccessRights");
    // Create the instance
    BACnetAssignedAccessRights _bACnetAssignedAccessRights;
    _bACnetAssignedAccessRights = new BACnetAssignedAccessRights(assignedAccessRights, enable);
    return _bACnetAssignedAccessRights;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetAssignedAccessRights)) {
      return false;
    }
    BACnetAssignedAccessRights that = (BACnetAssignedAccessRights) o;
    return (getAssignedAccessRights() == that.getAssignedAccessRights())
        && (getEnable() == that.getEnable())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getAssignedAccessRights(), getEnable());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
