/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class Error implements Message {

  // Properties.
  protected final ErrorClassTagged errorClass;
  protected final ErrorCodeTagged errorCode;

  public Error(ErrorClassTagged errorClass, ErrorCodeTagged errorCode) {
    super();
    this.errorClass = errorClass;
    this.errorCode = errorCode;
  }

  public ErrorClassTagged getErrorClass() {
    return errorClass;
  }

  public ErrorCodeTagged getErrorCode() {
    return errorCode;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("Error");

    // Simple Field (errorClass)
    writeSimpleField("errorClass", errorClass, writeComplex(writeBuffer));

    // Simple Field (errorCode)
    writeSimpleField("errorCode", errorCode, writeComplex(writeBuffer));

    writeBuffer.popContext("Error");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    Error _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (errorClass)
    lengthInBits += errorClass.getLengthInBits();

    // Simple field (errorCode)
    lengthInBits += errorCode.getLengthInBits();

    return lengthInBits;
  }

  public static Error staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("Error");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ErrorClassTagged errorClass =
        readSimpleField(
            "errorClass",
            readComplex(
                () ->
                    ErrorClassTagged.staticParse(
                        readBuffer, (short) (0), (TagClass) (TagClass.APPLICATION_TAGS)),
                readBuffer));

    ErrorCodeTagged errorCode =
        readSimpleField(
            "errorCode",
            readComplex(
                () ->
                    ErrorCodeTagged.staticParse(
                        readBuffer, (short) (0), (TagClass) (TagClass.APPLICATION_TAGS)),
                readBuffer));

    readBuffer.closeContext("Error");
    // Create the instance
    Error _error;
    _error = new Error(errorClass, errorCode);
    return _error;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Error)) {
      return false;
    }
    Error that = (Error) o;
    return (getErrorClass() == that.getErrorClass())
        && (getErrorCode() == that.getErrorCode())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getErrorClass(), getErrorCode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
