/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SecurityArmCode implements Message {

  // Properties.
  protected final short code;

  public SecurityArmCode(short code) {
    super();
    this.code = code;
  }

  public short getCode() {
    return code;
  }

  public boolean getIsDisarmed() {
    return (boolean) ((getCode()) == (0x00));
  }

  public boolean getIsFullyArmed() {
    return (boolean) ((getCode()) == (0x01));
  }

  public boolean getIsPartiallyArmed() {
    return (boolean) ((getCode()) == (0x02));
  }

  public boolean getIsArmSubtype() {
    return (boolean) (((getCode()) >= (0x03)) && ((getCode()) <= (0x7F)));
  }

  public boolean getIsReserved() {
    return (boolean) ((getCode()) > (0x7F));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SecurityArmCode");

    // Simple Field (code)
    writeSimpleField("code", code, writeUnsignedShort(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isDisarmed = getIsDisarmed();
    writeBuffer.writeVirtual("isDisarmed", isDisarmed);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isFullyArmed = getIsFullyArmed();
    writeBuffer.writeVirtual("isFullyArmed", isFullyArmed);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isPartiallyArmed = getIsPartiallyArmed();
    writeBuffer.writeVirtual("isPartiallyArmed", isPartiallyArmed);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isArmSubtype = getIsArmSubtype();
    writeBuffer.writeVirtual("isArmSubtype", isArmSubtype);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isReserved = getIsReserved();
    writeBuffer.writeVirtual("isReserved", isReserved);

    writeBuffer.popContext("SecurityArmCode");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SecurityArmCode _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (code)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static SecurityArmCode staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("SecurityArmCode");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short code = readSimpleField("code", readUnsignedShort(readBuffer, 8));
    boolean isDisarmed = readVirtualField("isDisarmed", boolean.class, (code) == (0x00));
    boolean isFullyArmed = readVirtualField("isFullyArmed", boolean.class, (code) == (0x01));
    boolean isPartiallyArmed =
        readVirtualField("isPartiallyArmed", boolean.class, (code) == (0x02));
    boolean isArmSubtype =
        readVirtualField("isArmSubtype", boolean.class, ((code) >= (0x03)) && ((code) <= (0x7F)));
    boolean isReserved = readVirtualField("isReserved", boolean.class, (code) > (0x7F));

    readBuffer.closeContext("SecurityArmCode");
    // Create the instance
    SecurityArmCode _securityArmCode;
    _securityArmCode = new SecurityArmCode(code);
    return _securityArmCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SecurityArmCode)) {
      return false;
    }
    SecurityArmCode that = (SecurityArmCode) o;
    return (getCode() == that.getCode()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getCode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
