/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TelephonyDataRecallLastNumber extends TelephonyData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte recallLastNumberType;
  protected final String number;

  public TelephonyDataRecallLastNumber(
      TelephonyCommandTypeContainer commandTypeContainer,
      byte argument,
      byte recallLastNumberType,
      String number) {
    super(commandTypeContainer, argument);
    this.recallLastNumberType = recallLastNumberType;
    this.number = number;
  }

  public byte getRecallLastNumberType() {
    return recallLastNumberType;
  }

  public String getNumber() {
    return number;
  }

  public boolean getIsNumberOfLastOutgoingCall() {
    return (boolean) ((getRecallLastNumberType()) == (0x01));
  }

  public boolean getIsNumberOfLastIncomingCall() {
    return (boolean) ((getRecallLastNumberType()) == (0x02));
  }

  @Override
  protected void serializeTelephonyDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TelephonyDataRecallLastNumber");

    // Simple Field (recallLastNumberType)
    writeSimpleField("recallLastNumberType", recallLastNumberType, writeByte(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isNumberOfLastOutgoingCall = getIsNumberOfLastOutgoingCall();
    writeBuffer.writeVirtual("isNumberOfLastOutgoingCall", isNumberOfLastOutgoingCall);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isNumberOfLastIncomingCall = getIsNumberOfLastIncomingCall();
    writeBuffer.writeVirtual("isNumberOfLastIncomingCall", isNumberOfLastIncomingCall);

    // Simple Field (number)
    writeSimpleField(
        "number",
        number,
        writeString(writeBuffer, (((commandTypeContainer.getNumBytes()) - (2))) * (8)));

    writeBuffer.popContext("TelephonyDataRecallLastNumber");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TelephonyDataRecallLastNumber _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (recallLastNumberType)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // Simple field (number)
    lengthInBits += (((commandTypeContainer.getNumBytes()) - (2))) * (8);

    return lengthInBits;
  }

  public static TelephonyDataBuilder staticParseTelephonyDataBuilder(
      ReadBuffer readBuffer, TelephonyCommandTypeContainer commandTypeContainer)
      throws ParseException {
    readBuffer.pullContext("TelephonyDataRecallLastNumber");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte recallLastNumberType = readSimpleField("recallLastNumberType", readByte(readBuffer, 8));
    boolean isNumberOfLastOutgoingCall =
        readVirtualField(
            "isNumberOfLastOutgoingCall", boolean.class, (recallLastNumberType) == (0x01));
    boolean isNumberOfLastIncomingCall =
        readVirtualField(
            "isNumberOfLastIncomingCall", boolean.class, (recallLastNumberType) == (0x02));

    String number =
        readSimpleField(
            "number", readString(readBuffer, (((commandTypeContainer.getNumBytes()) - (2))) * (8)));

    readBuffer.closeContext("TelephonyDataRecallLastNumber");
    // Create the instance
    return new TelephonyDataRecallLastNumberBuilderImpl(recallLastNumberType, number);
  }

  public static class TelephonyDataRecallLastNumberBuilderImpl
      implements TelephonyData.TelephonyDataBuilder {
    private final byte recallLastNumberType;
    private final String number;

    public TelephonyDataRecallLastNumberBuilderImpl(byte recallLastNumberType, String number) {
      this.recallLastNumberType = recallLastNumberType;
      this.number = number;
    }

    public TelephonyDataRecallLastNumber build(
        TelephonyCommandTypeContainer commandTypeContainer, byte argument) {
      TelephonyDataRecallLastNumber telephonyDataRecallLastNumber =
          new TelephonyDataRecallLastNumber(
              commandTypeContainer, argument, recallLastNumberType, number);
      return telephonyDataRecallLastNumber;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TelephonyDataRecallLastNumber)) {
      return false;
    }
    TelephonyDataRecallLastNumber that = (TelephonyDataRecallLastNumber) o;
    return (getRecallLastNumberType() == that.getRecallLastNumberType())
        && (getNumber() == that.getNumber())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getRecallLastNumberType(), getNumber());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
