/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CipConnectedRequest extends CipService implements Message {

  // Accessors for discriminator values.
  public Byte getService() {
    return (byte) 0x52;
  }

  public Boolean getResponse() {
    return (boolean) false;
  }

  public Boolean getConnected() {
    return (boolean) true;
  }

  // Properties.
  protected final byte[] pathSegments;

  public CipConnectedRequest(byte[] pathSegments) {
    super();
    this.pathSegments = pathSegments;
  }

  public byte[] getPathSegments() {
    return pathSegments;
  }

  @Override
  protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CipConnectedRequest");

    // Implicit Field (requestPathSize) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    short requestPathSize = (short) ((COUNT(getPathSegments())) / (2));
    writeImplicitField("requestPathSize", requestPathSize, writeUnsignedShort(writeBuffer, 8));

    // Array Field (pathSegments)
    writeByteArrayField("pathSegments", pathSegments, writeByteArray(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField("reserved", (int) 0x0001, writeUnsignedInt(writeBuffer, 16));

    // Reserved Field (reserved)
    writeReservedField("reserved", (long) 0x00000000, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("CipConnectedRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CipConnectedRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (requestPathSize)
    lengthInBits += 8;

    // Array field
    if (pathSegments != null) {
      lengthInBits += 8 * pathSegments.length;
    }

    // Reserved Field (reserved)
    lengthInBits += 16;

    // Reserved Field (reserved)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static CipServiceBuilder staticParseCipServiceBuilder(
      ReadBuffer readBuffer, Boolean connected, Integer serviceLen) throws ParseException {
    readBuffer.pullContext("CipConnectedRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short requestPathSize = readImplicitField("requestPathSize", readUnsignedShort(readBuffer, 8));

    byte[] pathSegments =
        readBuffer.readByteArray("pathSegments", Math.toIntExact((requestPathSize) * (2)));

    Integer reservedField0 =
        readReservedField("reserved", readUnsignedInt(readBuffer, 16), (int) 0x0001);

    Long reservedField1 =
        readReservedField("reserved", readUnsignedLong(readBuffer, 32), (long) 0x00000000);

    readBuffer.closeContext("CipConnectedRequest");
    // Create the instance
    return new CipConnectedRequestBuilderImpl(pathSegments);
  }

  public static class CipConnectedRequestBuilderImpl implements CipService.CipServiceBuilder {
    private final byte[] pathSegments;

    public CipConnectedRequestBuilderImpl(byte[] pathSegments) {
      this.pathSegments = pathSegments;
    }

    public CipConnectedRequest build() {
      CipConnectedRequest cipConnectedRequest = new CipConnectedRequest(pathSegments);
      return cipConnectedRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CipConnectedRequest)) {
      return false;
    }
    CipConnectedRequest that = (CipConnectedRequest) o;
    return (getPathSegments() == that.getPathSegments()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPathSegments());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
