/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class MultipleServiceRequest extends CipService implements Message {

  // Accessors for discriminator values.
  public Byte getService() {
    return (byte) 0x0A;
  }

  public Boolean getResponse() {
    return (boolean) false;
  }

  public Boolean getConnected() {
    return false;
  }

  // Constant values.
  public static final Short REQUESTPATHSIZE = 0x02;
  public static final Long REQUESTPATH = 0x01240220L;

  // Properties.
  protected final Services data;

  public MultipleServiceRequest(Services data) {
    super();
    this.data = data;
  }

  public Services getData() {
    return data;
  }

  public short getRequestPathSize() {
    return REQUESTPATHSIZE;
  }

  public long getRequestPath() {
    return REQUESTPATH;
  }

  @Override
  protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("MultipleServiceRequest");

    // Const Field (requestPathSize)
    writeConstField("requestPathSize", REQUESTPATHSIZE, writeUnsignedShort(writeBuffer, 8));

    // Const Field (requestPath)
    writeConstField("requestPath", REQUESTPATH, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (data)
    writeSimpleField("data", data, writeComplex(writeBuffer));

    writeBuffer.popContext("MultipleServiceRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    MultipleServiceRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (requestPathSize)
    lengthInBits += 8;

    // Const Field (requestPath)
    lengthInBits += 32;

    // Simple field (data)
    lengthInBits += data.getLengthInBits();

    return lengthInBits;
  }

  public static CipServiceBuilder staticParseCipServiceBuilder(
      ReadBuffer readBuffer, Boolean connected, Integer serviceLen) throws ParseException {
    readBuffer.pullContext("MultipleServiceRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short requestPathSize =
        readConstField(
            "requestPathSize",
            readUnsignedShort(readBuffer, 8),
            MultipleServiceRequest.REQUESTPATHSIZE);

    long requestPath =
        readConstField(
            "requestPath", readUnsignedLong(readBuffer, 32), MultipleServiceRequest.REQUESTPATH);

    Services data =
        readSimpleField(
            "data",
            readComplex(
                () -> Services.staticParse(readBuffer, (int) ((serviceLen) - (6))), readBuffer));

    readBuffer.closeContext("MultipleServiceRequest");
    // Create the instance
    return new MultipleServiceRequestBuilderImpl(data);
  }

  public static class MultipleServiceRequestBuilderImpl implements CipService.CipServiceBuilder {
    private final Services data;

    public MultipleServiceRequestBuilderImpl(Services data) {
      this.data = data;
    }

    public MultipleServiceRequest build() {
      MultipleServiceRequest multipleServiceRequest = new MultipleServiceRequest(data);
      return multipleServiceRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MultipleServiceRequest)) {
      return false;
    }
    MultipleServiceRequest that = (MultipleServiceRequest) o;
    return (getData() == that.getData()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
