/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BuildInfo extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 340;
  }

  // Properties.
  protected final PascalString productUri;
  protected final PascalString manufacturerName;
  protected final PascalString productName;
  protected final PascalString softwareVersion;
  protected final PascalString buildNumber;
  protected final long buildDate;

  public BuildInfo(
      PascalString productUri,
      PascalString manufacturerName,
      PascalString productName,
      PascalString softwareVersion,
      PascalString buildNumber,
      long buildDate) {
    super();
    this.productUri = productUri;
    this.manufacturerName = manufacturerName;
    this.productName = productName;
    this.softwareVersion = softwareVersion;
    this.buildNumber = buildNumber;
    this.buildDate = buildDate;
  }

  public PascalString getProductUri() {
    return productUri;
  }

  public PascalString getManufacturerName() {
    return manufacturerName;
  }

  public PascalString getProductName() {
    return productName;
  }

  public PascalString getSoftwareVersion() {
    return softwareVersion;
  }

  public PascalString getBuildNumber() {
    return buildNumber;
  }

  public long getBuildDate() {
    return buildDate;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BuildInfo");

    // Simple Field (productUri)
    writeSimpleField("productUri", productUri, writeComplex(writeBuffer));

    // Simple Field (manufacturerName)
    writeSimpleField("manufacturerName", manufacturerName, writeComplex(writeBuffer));

    // Simple Field (productName)
    writeSimpleField("productName", productName, writeComplex(writeBuffer));

    // Simple Field (softwareVersion)
    writeSimpleField("softwareVersion", softwareVersion, writeComplex(writeBuffer));

    // Simple Field (buildNumber)
    writeSimpleField("buildNumber", buildNumber, writeComplex(writeBuffer));

    // Simple Field (buildDate)
    writeSimpleField("buildDate", buildDate, writeSignedLong(writeBuffer, 64));

    writeBuffer.popContext("BuildInfo");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BuildInfo _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (productUri)
    lengthInBits += productUri.getLengthInBits();

    // Simple field (manufacturerName)
    lengthInBits += manufacturerName.getLengthInBits();

    // Simple field (productName)
    lengthInBits += productName.getLengthInBits();

    // Simple field (softwareVersion)
    lengthInBits += softwareVersion.getLengthInBits();

    // Simple field (buildNumber)
    lengthInBits += buildNumber.getLengthInBits();

    // Simple field (buildDate)
    lengthInBits += 64;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("BuildInfo");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString productUri =
        readSimpleField(
            "productUri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString manufacturerName =
        readSimpleField(
            "manufacturerName",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString productName =
        readSimpleField(
            "productName", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString softwareVersion =
        readSimpleField(
            "softwareVersion", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString buildNumber =
        readSimpleField(
            "buildNumber", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    long buildDate = readSimpleField("buildDate", readSignedLong(readBuffer, 64));

    readBuffer.closeContext("BuildInfo");
    // Create the instance
    return new BuildInfoBuilderImpl(
        productUri, manufacturerName, productName, softwareVersion, buildNumber, buildDate);
  }

  public static class BuildInfoBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString productUri;
    private final PascalString manufacturerName;
    private final PascalString productName;
    private final PascalString softwareVersion;
    private final PascalString buildNumber;
    private final long buildDate;

    public BuildInfoBuilderImpl(
        PascalString productUri,
        PascalString manufacturerName,
        PascalString productName,
        PascalString softwareVersion,
        PascalString buildNumber,
        long buildDate) {
      this.productUri = productUri;
      this.manufacturerName = manufacturerName;
      this.productName = productName;
      this.softwareVersion = softwareVersion;
      this.buildNumber = buildNumber;
      this.buildDate = buildDate;
    }

    public BuildInfo build() {
      BuildInfo buildInfo =
          new BuildInfo(
              productUri, manufacturerName, productName, softwareVersion, buildNumber, buildDate);
      return buildInfo;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BuildInfo)) {
      return false;
    }
    BuildInfo that = (BuildInfo) o;
    return (getProductUri() == that.getProductUri())
        && (getManufacturerName() == that.getManufacturerName())
        && (getProductName() == that.getProductName())
        && (getSoftwareVersion() == that.getSoftwareVersion())
        && (getBuildNumber() == that.getBuildNumber())
        && (getBuildDate() == that.getBuildDate())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getProductUri(),
        getManufacturerName(),
        getProductName(),
        getSoftwareVersion(),
        getBuildNumber(),
        getBuildDate());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
