/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class JsonApplicationDescriptionMessage extends ExtensionObjectDefinition
    implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19316;
  }

  // Properties.
  protected final PascalString messageId;
  protected final PascalString messageType;
  protected final PascalString publisherId;
  protected final long timestamp;
  protected final ApplicationDescription description;
  protected final List<PascalString> serverCapabilities;

  public JsonApplicationDescriptionMessage(
      PascalString messageId,
      PascalString messageType,
      PascalString publisherId,
      long timestamp,
      ApplicationDescription description,
      List<PascalString> serverCapabilities) {
    super();
    this.messageId = messageId;
    this.messageType = messageType;
    this.publisherId = publisherId;
    this.timestamp = timestamp;
    this.description = description;
    this.serverCapabilities = serverCapabilities;
  }

  public PascalString getMessageId() {
    return messageId;
  }

  public PascalString getMessageType() {
    return messageType;
  }

  public PascalString getPublisherId() {
    return publisherId;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public ApplicationDescription getDescription() {
    return description;
  }

  public List<PascalString> getServerCapabilities() {
    return serverCapabilities;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("JsonApplicationDescriptionMessage");

    // Simple Field (messageId)
    writeSimpleField("messageId", messageId, writeComplex(writeBuffer));

    // Simple Field (messageType)
    writeSimpleField("messageType", messageType, writeComplex(writeBuffer));

    // Simple Field (publisherId)
    writeSimpleField("publisherId", publisherId, writeComplex(writeBuffer));

    // Simple Field (timestamp)
    writeSimpleField("timestamp", timestamp, writeSignedLong(writeBuffer, 64));

    // Simple Field (description)
    writeSimpleField("description", description, writeComplex(writeBuffer));

    // Implicit Field (noOfServerCapabilities) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfServerCapabilities =
        (int) ((((getServerCapabilities()) == (null)) ? -(1) : COUNT(getServerCapabilities())));
    writeImplicitField(
        "noOfServerCapabilities", noOfServerCapabilities, writeSignedInt(writeBuffer, 32));

    // Array Field (serverCapabilities)
    writeComplexTypeArrayField("serverCapabilities", serverCapabilities, writeBuffer);

    writeBuffer.popContext("JsonApplicationDescriptionMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    JsonApplicationDescriptionMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (messageId)
    lengthInBits += messageId.getLengthInBits();

    // Simple field (messageType)
    lengthInBits += messageType.getLengthInBits();

    // Simple field (publisherId)
    lengthInBits += publisherId.getLengthInBits();

    // Simple field (timestamp)
    lengthInBits += 64;

    // Simple field (description)
    lengthInBits += description.getLengthInBits();

    // Implicit Field (noOfServerCapabilities)
    lengthInBits += 32;

    // Array field
    if (serverCapabilities != null) {
      int i = 0;
      for (PascalString element : serverCapabilities) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= serverCapabilities.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("JsonApplicationDescriptionMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString messageId =
        readSimpleField(
            "messageId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString messageType =
        readSimpleField(
            "messageType", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString publisherId =
        readSimpleField(
            "publisherId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    long timestamp = readSimpleField("timestamp", readSignedLong(readBuffer, 64));

    ApplicationDescription description =
        readSimpleField(
            "description",
            readComplex(
                () ->
                    (ApplicationDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (310)),
                readBuffer));

    int noOfServerCapabilities =
        readImplicitField("noOfServerCapabilities", readSignedInt(readBuffer, 32));

    List<PascalString> serverCapabilities =
        readCountArrayField(
            "serverCapabilities",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfServerCapabilities);

    readBuffer.closeContext("JsonApplicationDescriptionMessage");
    // Create the instance
    return new JsonApplicationDescriptionMessageBuilderImpl(
        messageId, messageType, publisherId, timestamp, description, serverCapabilities);
  }

  public static class JsonApplicationDescriptionMessageBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString messageId;
    private final PascalString messageType;
    private final PascalString publisherId;
    private final long timestamp;
    private final ApplicationDescription description;
    private final List<PascalString> serverCapabilities;

    public JsonApplicationDescriptionMessageBuilderImpl(
        PascalString messageId,
        PascalString messageType,
        PascalString publisherId,
        long timestamp,
        ApplicationDescription description,
        List<PascalString> serverCapabilities) {
      this.messageId = messageId;
      this.messageType = messageType;
      this.publisherId = publisherId;
      this.timestamp = timestamp;
      this.description = description;
      this.serverCapabilities = serverCapabilities;
    }

    public JsonApplicationDescriptionMessage build() {
      JsonApplicationDescriptionMessage jsonApplicationDescriptionMessage =
          new JsonApplicationDescriptionMessage(
              messageId, messageType, publisherId, timestamp, description, serverCapabilities);
      return jsonApplicationDescriptionMessage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof JsonApplicationDescriptionMessage)) {
      return false;
    }
    JsonApplicationDescriptionMessage that = (JsonApplicationDescriptionMessage) o;
    return (getMessageId() == that.getMessageId())
        && (getMessageType() == that.getMessageType())
        && (getPublisherId() == that.getPublisherId())
        && (getTimestamp() == that.getTimestamp())
        && (getDescription() == that.getDescription())
        && (getServerCapabilities() == that.getServerCapabilities())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getMessageId(),
        getMessageType(),
        getPublisherId(),
        getTimestamp(),
        getDescription(),
        getServerCapabilities());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
