/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PublishRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 826;
  }

  // Properties.
  protected final RequestHeader requestHeader;
  protected final List<SubscriptionAcknowledgement> subscriptionAcknowledgements;

  public PublishRequest(
      RequestHeader requestHeader, List<SubscriptionAcknowledgement> subscriptionAcknowledgements) {
    super();
    this.requestHeader = requestHeader;
    this.subscriptionAcknowledgements = subscriptionAcknowledgements;
  }

  public RequestHeader getRequestHeader() {
    return requestHeader;
  }

  public List<SubscriptionAcknowledgement> getSubscriptionAcknowledgements() {
    return subscriptionAcknowledgements;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PublishRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, writeComplex(writeBuffer));

    // Implicit Field (noOfSubscriptionAcknowledgements) (Used for parsing, but its value is not
    // stored as it's implicitly given by the objects content)
    int noOfSubscriptionAcknowledgements =
        (int)
            ((((getSubscriptionAcknowledgements()) == (null))
                ? -(1)
                : COUNT(getSubscriptionAcknowledgements())));
    writeImplicitField(
        "noOfSubscriptionAcknowledgements",
        noOfSubscriptionAcknowledgements,
        writeSignedInt(writeBuffer, 32));

    // Array Field (subscriptionAcknowledgements)
    writeComplexTypeArrayField(
        "subscriptionAcknowledgements", subscriptionAcknowledgements, writeBuffer);

    writeBuffer.popContext("PublishRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PublishRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Implicit Field (noOfSubscriptionAcknowledgements)
    lengthInBits += 32;

    // Array field
    if (subscriptionAcknowledgements != null) {
      int i = 0;
      for (SubscriptionAcknowledgement element : subscriptionAcknowledgements) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= subscriptionAcknowledgements.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("PublishRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    RequestHeader requestHeader =
        readSimpleField(
            "requestHeader",
            readComplex(
                () ->
                    (RequestHeader) ExtensionObjectDefinition.staticParse(readBuffer, (int) (391)),
                readBuffer));

    int noOfSubscriptionAcknowledgements =
        readImplicitField("noOfSubscriptionAcknowledgements", readSignedInt(readBuffer, 32));

    List<SubscriptionAcknowledgement> subscriptionAcknowledgements =
        readCountArrayField(
            "subscriptionAcknowledgements",
            readComplex(
                () ->
                    (SubscriptionAcknowledgement)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (823)),
                readBuffer),
            noOfSubscriptionAcknowledgements);

    readBuffer.closeContext("PublishRequest");
    // Create the instance
    return new PublishRequestBuilderImpl(requestHeader, subscriptionAcknowledgements);
  }

  public static class PublishRequestBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final RequestHeader requestHeader;
    private final List<SubscriptionAcknowledgement> subscriptionAcknowledgements;

    public PublishRequestBuilderImpl(
        RequestHeader requestHeader,
        List<SubscriptionAcknowledgement> subscriptionAcknowledgements) {
      this.requestHeader = requestHeader;
      this.subscriptionAcknowledgements = subscriptionAcknowledgements;
    }

    public PublishRequest build() {
      PublishRequest publishRequest =
          new PublishRequest(requestHeader, subscriptionAcknowledgements);
      return publishRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PublishRequest)) {
      return false;
    }
    PublishRequest that = (PublishRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getSubscriptionAcknowledgements() == that.getSubscriptionAcknowledgements())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getRequestHeader(), getSubscriptionAcknowledgements());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
