/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ReadRawModifiedDetails extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 649;
  }

  // Properties.
  protected final boolean isReadModified;
  protected final long startTime;
  protected final long endTime;
  protected final long numValuesPerNode;
  protected final boolean returnBounds;

  public ReadRawModifiedDetails(
      boolean isReadModified,
      long startTime,
      long endTime,
      long numValuesPerNode,
      boolean returnBounds) {
    super();
    this.isReadModified = isReadModified;
    this.startTime = startTime;
    this.endTime = endTime;
    this.numValuesPerNode = numValuesPerNode;
    this.returnBounds = returnBounds;
  }

  public boolean getIsReadModified() {
    return isReadModified;
  }

  public long getStartTime() {
    return startTime;
  }

  public long getEndTime() {
    return endTime;
  }

  public long getNumValuesPerNode() {
    return numValuesPerNode;
  }

  public boolean getReturnBounds() {
    return returnBounds;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ReadRawModifiedDetails");

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (isReadModified)
    writeSimpleField("isReadModified", isReadModified, writeBoolean(writeBuffer));

    // Simple Field (startTime)
    writeSimpleField("startTime", startTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (endTime)
    writeSimpleField("endTime", endTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (numValuesPerNode)
    writeSimpleField("numValuesPerNode", numValuesPerNode, writeUnsignedLong(writeBuffer, 32));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (returnBounds)
    writeSimpleField("returnBounds", returnBounds, writeBoolean(writeBuffer));

    writeBuffer.popContext("ReadRawModifiedDetails");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ReadRawModifiedDetails _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (isReadModified)
    lengthInBits += 1;

    // Simple field (startTime)
    lengthInBits += 64;

    // Simple field (endTime)
    lengthInBits += 64;

    // Simple field (numValuesPerNode)
    lengthInBits += 32;

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (returnBounds)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ReadRawModifiedDetails");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean isReadModified = readSimpleField("isReadModified", readBoolean(readBuffer));

    long startTime = readSimpleField("startTime", readSignedLong(readBuffer, 64));

    long endTime = readSimpleField("endTime", readSignedLong(readBuffer, 64));

    long numValuesPerNode = readSimpleField("numValuesPerNode", readUnsignedLong(readBuffer, 32));

    Byte reservedField1 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean returnBounds = readSimpleField("returnBounds", readBoolean(readBuffer));

    readBuffer.closeContext("ReadRawModifiedDetails");
    // Create the instance
    return new ReadRawModifiedDetailsBuilderImpl(
        isReadModified, startTime, endTime, numValuesPerNode, returnBounds);
  }

  public static class ReadRawModifiedDetailsBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final boolean isReadModified;
    private final long startTime;
    private final long endTime;
    private final long numValuesPerNode;
    private final boolean returnBounds;

    public ReadRawModifiedDetailsBuilderImpl(
        boolean isReadModified,
        long startTime,
        long endTime,
        long numValuesPerNode,
        boolean returnBounds) {
      this.isReadModified = isReadModified;
      this.startTime = startTime;
      this.endTime = endTime;
      this.numValuesPerNode = numValuesPerNode;
      this.returnBounds = returnBounds;
    }

    public ReadRawModifiedDetails build() {
      ReadRawModifiedDetails readRawModifiedDetails =
          new ReadRawModifiedDetails(
              isReadModified, startTime, endTime, numValuesPerNode, returnBounds);
      return readRawModifiedDetails;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ReadRawModifiedDetails)) {
      return false;
    }
    ReadRawModifiedDetails that = (ReadRawModifiedDetails) o;
    return (getIsReadModified() == that.getIsReadModified())
        && (getStartTime() == that.getStartTime())
        && (getEndTime() == that.getEndTime())
        && (getNumValuesPerNode() == that.getNumValuesPerNode())
        && (getReturnBounds() == that.getReturnBounds())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getIsReadModified(),
        getStartTime(),
        getEndTime(),
        getNumValuesPerNode(),
        getReturnBounds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
