/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SemanticChangeStructureDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 899;
  }

  // Properties.
  protected final NodeId affected;
  protected final NodeId affectedType;

  public SemanticChangeStructureDataType(NodeId affected, NodeId affectedType) {
    super();
    this.affected = affected;
    this.affectedType = affectedType;
  }

  public NodeId getAffected() {
    return affected;
  }

  public NodeId getAffectedType() {
    return affectedType;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SemanticChangeStructureDataType");

    // Simple Field (affected)
    writeSimpleField("affected", affected, writeComplex(writeBuffer));

    // Simple Field (affectedType)
    writeSimpleField("affectedType", affectedType, writeComplex(writeBuffer));

    writeBuffer.popContext("SemanticChangeStructureDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SemanticChangeStructureDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (affected)
    lengthInBits += affected.getLengthInBits();

    // Simple field (affectedType)
    lengthInBits += affectedType.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("SemanticChangeStructureDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NodeId affected =
        readSimpleField("affected", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    NodeId affectedType =
        readSimpleField(
            "affectedType", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("SemanticChangeStructureDataType");
    // Create the instance
    return new SemanticChangeStructureDataTypeBuilderImpl(affected, affectedType);
  }

  public static class SemanticChangeStructureDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId affected;
    private final NodeId affectedType;

    public SemanticChangeStructureDataTypeBuilderImpl(NodeId affected, NodeId affectedType) {
      this.affected = affected;
      this.affectedType = affectedType;
    }

    public SemanticChangeStructureDataType build() {
      SemanticChangeStructureDataType semanticChangeStructureDataType =
          new SemanticChangeStructureDataType(affected, affectedType);
      return semanticChangeStructureDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SemanticChangeStructureDataType)) {
      return false;
    }
    SemanticChangeStructureDataType that = (SemanticChangeStructureDataType) o;
    return (getAffected() == that.getAffected())
        && (getAffectedType() == that.getAffectedType())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getAffected(), getAffectedType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
