/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TlvProfibusSubTypeMeasuredDelay extends TlvOrgSpecificProfibusUnit implements Message {

  // Accessors for discriminator values.
  public TlvProfibusSubType getSubType() {
    return TlvProfibusSubType.MEASURED_DELAY;
  }

  // Properties.
  protected final long localPortRxDelay;
  protected final long remotePortRxDelay;
  protected final long localPortTxDelay;
  protected final long remotePortTxDelay;
  protected final long portCableDelay;

  public TlvProfibusSubTypeMeasuredDelay(
      long localPortRxDelay,
      long remotePortRxDelay,
      long localPortTxDelay,
      long remotePortTxDelay,
      long portCableDelay) {
    super();
    this.localPortRxDelay = localPortRxDelay;
    this.remotePortRxDelay = remotePortRxDelay;
    this.localPortTxDelay = localPortTxDelay;
    this.remotePortTxDelay = remotePortTxDelay;
    this.portCableDelay = portCableDelay;
  }

  public long getLocalPortRxDelay() {
    return localPortRxDelay;
  }

  public long getRemotePortRxDelay() {
    return remotePortRxDelay;
  }

  public long getLocalPortTxDelay() {
    return localPortTxDelay;
  }

  public long getRemotePortTxDelay() {
    return remotePortTxDelay;
  }

  public long getPortCableDelay() {
    return portCableDelay;
  }

  @Override
  protected void serializeTlvOrgSpecificProfibusUnitChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TlvProfibusSubTypeMeasuredDelay");

    // Simple Field (localPortRxDelay)
    writeSimpleField("localPortRxDelay", localPortRxDelay, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (remotePortRxDelay)
    writeSimpleField("remotePortRxDelay", remotePortRxDelay, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (localPortTxDelay)
    writeSimpleField("localPortTxDelay", localPortTxDelay, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (remotePortTxDelay)
    writeSimpleField("remotePortTxDelay", remotePortTxDelay, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (portCableDelay)
    writeSimpleField("portCableDelay", portCableDelay, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("TlvProfibusSubTypeMeasuredDelay");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TlvProfibusSubTypeMeasuredDelay _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (localPortRxDelay)
    lengthInBits += 32;

    // Simple field (remotePortRxDelay)
    lengthInBits += 32;

    // Simple field (localPortTxDelay)
    lengthInBits += 32;

    // Simple field (remotePortTxDelay)
    lengthInBits += 32;

    // Simple field (portCableDelay)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static TlvOrgSpecificProfibusUnitBuilder staticParseTlvOrgSpecificProfibusUnitBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("TlvProfibusSubTypeMeasuredDelay");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long localPortRxDelay = readSimpleField("localPortRxDelay", readUnsignedLong(readBuffer, 32));

    long remotePortRxDelay = readSimpleField("remotePortRxDelay", readUnsignedLong(readBuffer, 32));

    long localPortTxDelay = readSimpleField("localPortTxDelay", readUnsignedLong(readBuffer, 32));

    long remotePortTxDelay = readSimpleField("remotePortTxDelay", readUnsignedLong(readBuffer, 32));

    long portCableDelay = readSimpleField("portCableDelay", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("TlvProfibusSubTypeMeasuredDelay");
    // Create the instance
    return new TlvProfibusSubTypeMeasuredDelayBuilderImpl(
        localPortRxDelay, remotePortRxDelay, localPortTxDelay, remotePortTxDelay, portCableDelay);
  }

  public static class TlvProfibusSubTypeMeasuredDelayBuilderImpl
      implements TlvOrgSpecificProfibusUnit.TlvOrgSpecificProfibusUnitBuilder {
    private final long localPortRxDelay;
    private final long remotePortRxDelay;
    private final long localPortTxDelay;
    private final long remotePortTxDelay;
    private final long portCableDelay;

    public TlvProfibusSubTypeMeasuredDelayBuilderImpl(
        long localPortRxDelay,
        long remotePortRxDelay,
        long localPortTxDelay,
        long remotePortTxDelay,
        long portCableDelay) {
      this.localPortRxDelay = localPortRxDelay;
      this.remotePortRxDelay = remotePortRxDelay;
      this.localPortTxDelay = localPortTxDelay;
      this.remotePortTxDelay = remotePortTxDelay;
      this.portCableDelay = portCableDelay;
    }

    public TlvProfibusSubTypeMeasuredDelay build() {
      TlvProfibusSubTypeMeasuredDelay tlvProfibusSubTypeMeasuredDelay =
          new TlvProfibusSubTypeMeasuredDelay(
              localPortRxDelay,
              remotePortRxDelay,
              localPortTxDelay,
              remotePortTxDelay,
              portCableDelay);
      return tlvProfibusSubTypeMeasuredDelay;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TlvProfibusSubTypeMeasuredDelay)) {
      return false;
    }
    TlvProfibusSubTypeMeasuredDelay that = (TlvProfibusSubTypeMeasuredDelay) o;
    return (getLocalPortRxDelay() == that.getLocalPortRxDelay())
        && (getRemotePortRxDelay() == that.getRemotePortRxDelay())
        && (getLocalPortTxDelay() == that.getLocalPortTxDelay())
        && (getRemotePortTxDelay() == that.getRemotePortTxDelay())
        && (getPortCableDelay() == that.getPortCableDelay())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getLocalPortRxDelay(),
        getRemotePortRxDelay(),
        getLocalPortTxDelay(),
        getRemotePortTxDelay(),
        getPortCableDelay());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
