/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7discovery.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class PnDcp_Pdu implements Message {

  // Abstract accessors for discriminator values.

  // Properties.
  protected final int frameIdValue;

  public PnDcp_Pdu(int frameIdValue) {
    super();
    this.frameIdValue = frameIdValue;
  }

  public int getFrameIdValue() {
    return frameIdValue;
  }

  protected abstract void serializePnDcp_PduChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnDcp_Pdu");

    // Simple Field (frameIdValue)
    writeSimpleField(
        "frameIdValue",
        frameIdValue,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Switch field (Serialize the sub-type)
    serializePnDcp_PduChild(writeBuffer);

    writeBuffer.popContext("PnDcp_Pdu");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    PnDcp_Pdu _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (frameIdValue)
    lengthInBits += 16;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static PnDcp_Pdu staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("PnDcp_Pdu");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int frameIdValue =
        readSimpleField(
            "frameIdValue",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    PnDcp_PduBuilder builder = null;
    if (EvaluationHelper.equals(frameIdValue, (int) 0xFEFE)) {
      builder = PnDcp_Pdu_IdentifyReq.staticParsePnDcp_PduBuilder(readBuffer);
    } else if (EvaluationHelper.equals(frameIdValue, (int) 0xFEFF)) {
      builder = PnDcp_Pdu_IdentifyRes.staticParsePnDcp_PduBuilder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "frameIdValue="
              + frameIdValue
              + "]");
    }

    readBuffer.closeContext("PnDcp_Pdu");
    // Create the instance
    PnDcp_Pdu _pnDcp_Pdu = builder.build(frameIdValue);
    return _pnDcp_Pdu;
  }

  public interface PnDcp_PduBuilder {
    PnDcp_Pdu build(int frameIdValue);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnDcp_Pdu)) {
      return false;
    }
    PnDcp_Pdu that = (PnDcp_Pdu) o;
    return (getFrameIdValue() == that.getFrameIdValue()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getFrameIdValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
