
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by code-generation. DO NOT EDIT.

[enum uint 16 KnxDatapointMainType(uint 16 number, uint 8 sizeInBits, string 8 name)
    ['0' DPT_UNKNOWN ['0', '0', '"Unknown Datapoint Type"']]
    // Begin: Some typed needed to support all IEC types on KNX (Which the standard generally doesn't support)
    ['1' DPT_64_BIT_SET ['0', '64', '"Unknown Datapoint Type"']]
    ['2' DPT_8_BYTE_UNSIGNED_VALUE ['0', '64', '"Unknown Datapoint Type"']]
    ['3' DPT_8_BYTE_SIGNED_VALUE ['0', '64', '"Unknown Datapoint Type"']]
    ['4' DPT_12_BYTE_SIGNED_VALUE ['0', '96', '"Unknown Datapoint Type"']]
    ['5' DPT_8_BYTE_FLOAT_VALUE ['0', '64', '"Unknown Datapoint Type"']]
    // End: Custom types
    ['6' DPT_1_BIT ['1', '1', '"1-bit"']]
    ['7' DPT_1_BIT_CONTROLLED ['2', '2', '"1-bit controlled"']]
    ['8' DPT_3_BIT_CONTROLLED ['3', '4', '"3-bit controlled"']]
    ['9' DPT_CHARACTER ['4', '8', '"character"']]
    ['10' DPT_8_BIT_UNSIGNED_VALUE ['5', '8', '"8-bit unsigned value"']]
    ['11' DPT_8_BIT_SIGNED_VALUE ['6', '8', '"8-bit signed value"']]
    ['12' DPT_2_BYTE_UNSIGNED_VALUE ['7', '16', '"2-byte unsigned value"']]
    ['13' DPT_2_BYTE_SIGNED_VALUE ['8', '16', '"2-byte signed value"']]
    ['14' DPT_2_BYTE_FLOAT_VALUE ['9', '16', '"2-byte float value"']]
    ['15' DPT_TIME ['10', '24', '"time"']]
    ['16' DPT_DATE ['11', '24', '"date"']]
    ['17' DPT_4_BYTE_UNSIGNED_VALUE ['12', '32', '"4-byte unsigned value"']]
    ['18' DPT_4_BYTE_SIGNED_VALUE ['13', '32', '"4-byte signed value"']]
    ['19' DPT_4_BYTE_FLOAT_VALUE ['14', '32', '"4-byte float value"']]
    ['20' DPT_ENTRANCE_ACCESS ['15', '32', '"entrance access"']]
    ['21' DPT_CHARACTER_STRING ['16', '112', '"character string"']]
    ['22' DPT_SCENE_NUMBER ['17', '8', '"scene number"']]
    ['23' DPT_SCENE_CONTROL ['18', '8', '"scene control"']]
    ['24' DPT_DATE_TIME ['19', '64', '"Date Time"']]
    ['25' DPT_1_BYTE ['20', '8', '"1-byte"']]
    ['26' DPT_8_BIT_SET ['21', '8', '"8-bit set"']]
    ['27' DPT_16_BIT_SET ['22', '16', '"16-bit set"']]
    ['28' DPT_2_BIT_SET ['23', '2', '"2-bit set"']]
    ['29' DPT_2_NIBBLE_SET ['25', '8', '"2-nibble set"']]
    ['30' DPT_8_BIT_SET_2 ['26', '8', '"8-bit set"']]
    ['31' DPT_32_BIT_SET ['27', '32', '"32-bit set"']]
    ['32' DPT_ELECTRICAL_ENERGY ['29', '64', '"electrical energy"']]
    ['33' DPT_24_TIMES_CHANNEL_ACTIVATION ['30', '24', '"24 times channel activation"']]
    ['34' DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM ['206', '24', '"16-bit unsigned value & 8-bit enum"']]
    ['35' DPT_8_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM ['207', '16', '"8-bit unsigned value & 8-bit enum"']]
    ['36' DPT_DATAPOINT_TYPE_VERSION ['217', '16', '"datapoint type version"']]
    ['37' DPT_ALARM_INFO ['219', '48', '"alarm info"']]
    ['38' DPT_3X_2_BYTE_FLOAT_VALUE ['222', '48', '"3x 2-byte float value"']]
    ['39' DPT_SCALING_SPEED ['225', '24', '"scaling speed"']]
    ['40' DPT_4_1_1_BYTE_COMBINED_INFORMATION ['229', '48', '"4-1-1 byte combined information"']]
    ['41' DPT_MBUS_ADDRESS ['230', '64', '"MBus address"']]
    ['42' DPT_3_BYTE_COLOUR_RGB ['232', '24', '"3-byte colour RGB"']]
    ['43' DPT_LANGUAGE_CODE_ISO_639_1 ['234', '16', '"language code ISO 639-1"']]
    ['44' DPT_SIGNED_VALUE_WITH_CLASSIFICATION_AND_VALIDITY ['235', '48', '"Signed value with classification and validity"']]
    ['45' DPT_PRIORITISED_MODE_CONTROL ['236', '8', '"Prioritised Mode Control"']]
    ['46' DPT_CONFIGURATION_DIAGNOSTICS_16_BIT ['237', '16', '"configuration/ diagnostics"']]
    ['47' DPT_CONFIGURATION_DIAGNOSTICS_8_BIT ['238', '8', '"configuration/ diagnostics"']]
    ['48' DPT_POSITIONS ['240', '24', '"positions"']]
    ['49' DPT_STATUS_32_BIT ['241', '32', '"status"']]
    ['50' DPT_STATUS_48_BIT ['242', '48', '"status"']]
    ['51' DPT_CONVERTER_STATUS ['244', '16', '"Converter Status"']]
    ['52' DPT_CONVERTER_TEST_RESULT ['245', '48', '"Converter test result"']]
    ['53' DPT_BATTERY_INFORMATION ['246', '16', '"Battery Information"']]
    ['54' DPT_BRIGHTNESS_COLOUR_TEMPERATURE_TRANSITION ['249', '48', '"brightness colour temperature transition"']]
    ['55' DPT_STATUS_24_BIT ['250', '24', '"status"']]
    ['56' DPT_COLOUR_RGBW ['251', '48', '"Colour RGBW"']]
    ['57' DPT_RELATIVE_CONTROL_RGBW ['252', '40', '"Relative Control RGBW"']]
    ['58' DPT_RELATIVE_CONTROL_RGB ['254', '24', '"Relative Control RGB"']]
    ['59' DPT_F32F32 ['255', '64', '"F32F32"']]
    ['60' DPT_F16F16F16F16 ['275', '64', '"F16F16F16F16"']]
    
]

[enum uint 32 KnxDatapointType(vstring id, uint 16 number, KnxDatapointMainType datapointMainType, string 8 name, PlcValueType plcValueTpe)
    ['0' DPT_UNKNOWN    ['', '0', 'DPT_UNKNOWN',               '"Unknown Datapoint Subtype"', 'Struct'       ]]
    // Begin: Some typed needed to support all IEC types on KNX (Which the standard generally doesn't support)
    ['1' BOOL           ['', '0', 'DPT_1_BIT',                 '"BOOL"',                      'BOOL'         ]]
    ['2' BYTE           ['', '0', 'DPT_8_BIT_SET',             '"BYTE"',                      'BYTE'         ]]
    ['3' WORD           ['', '0', 'DPT_16_BIT_SET',            '"WORD"',                      'WORD'         ]]
    ['4' DWORD          ['', '0', 'DPT_32_BIT_SET',            '"DWORD"',                     'DWORD'        ]]
    ['5' LWORD          ['', '0', 'DPT_64_BIT_SET',            '"LWORD"',                     'LWORD'        ]]
    ['6' USINT          ['', '0', 'DPT_8_BIT_UNSIGNED_VALUE',  '"USINT"',                     'USINT'        ]]
    ['7' SINT           ['', '0', 'DPT_8_BIT_SIGNED_VALUE',    '"SINT"',                      'SINT'         ]]
    ['8' UINT           ['', '0', 'DPT_2_BYTE_UNSIGNED_VALUE', '"UINT"',                      'UINT'         ]]
    ['9' INT            ['', '0', 'DPT_2_BYTE_SIGNED_VALUE',   '"INT"',                       'INT'          ]]
    ['10' UDINT         ['', '0', 'DPT_4_BYTE_UNSIGNED_VALUE', '"UDINT"',                     'UDINT'        ]]
    ['11' DINT          ['', '0', 'DPT_4_BYTE_SIGNED_VALUE',   '"DINT"',                      'DINT'         ]]
    ['12' ULINT         ['', '0', 'DPT_8_BYTE_UNSIGNED_VALUE', '"ULINT"',                     'ULINT'        ]]
    ['13' LINT          ['', '0', 'DPT_8_BYTE_SIGNED_VALUE',   '"LINT"',                      'LINT'         ]]
    ['14' REAL          ['', '0', 'DPT_4_BYTE_FLOAT_VALUE',    '"REAL"',                      'REAL'         ]]
    ['15' LREAL         ['', '0', 'DPT_8_BYTE_FLOAT_VALUE',    '"LREAL"',                     'LREAL'        ]]
    ['16' CHAR          ['', '0', 'DPT_CHARACTER',             '"CHAR"',                      'CHAR'         ]]
    ['17' WCHAR         ['', '0', 'DPT_2_BYTE_UNSIGNED_VALUE', '"WCHAR"',                     'WCHAR'        ]]
    ['18' STRING        ['', '0', 'DPT_UNKNOWN',               '"STRING"',                    'STRING'       ]]
    ['19' WSTRING       ['', '0', 'DPT_UNKNOWN',               '"WSTRING"',                   'WSTRING'      ]]
    ['20' TIME          ['', '0', 'DPT_4_BYTE_UNSIGNED_VALUE', '"TIME"',                      'TIME'         ]]
    ['21' LTIME         ['', '0', 'DPT_8_BYTE_UNSIGNED_VALUE', '"LTIME"',                     'LTIME'        ]]
    ['22' DATE          ['', '0', 'DPT_2_BYTE_UNSIGNED_VALUE', '"DATE"',                      'DATE'         ]]
    ['23' TIME_OF_DAY   ['', '0', 'DPT_4_BYTE_UNSIGNED_VALUE', '"TIME_OF_DAY"',               'TIME_OF_DAY'  ]]
    ['24' TOD           ['', '0', 'DPT_4_BYTE_UNSIGNED_VALUE', '"TOD"',                       'TIME_OF_DAY'  ]]
    ['25' DATE_AND_TIME ['', '0', 'DPT_12_BYTE_SIGNED_VALUE',  '"DATE_AND_TIME"',             'DATE_AND_TIME']]
    ['26' DT            ['', '0', 'DPT_12_BYTE_SIGNED_VALUE',  '"DT"',                        'DATE_AND_TIME']]
    // End: Custom types
        ['27' DPT_Switch ['DPST-1-1', '1', 'DPT_1_BIT', '"switch"', 'BOOL']]
    ['28' DPT_Bool ['DPST-1-2', '2', 'DPT_1_BIT', '"boolean"', 'BOOL']]
    ['29' DPT_Enable ['DPST-1-3', '3', 'DPT_1_BIT', '"enable"', 'BOOL']]
    ['30' DPT_Ramp ['DPST-1-4', '4', 'DPT_1_BIT', '"ramp"', 'BOOL']]
    ['31' DPT_Alarm ['DPST-1-5', '5', 'DPT_1_BIT', '"alarm"', 'BOOL']]
    ['32' DPT_BinaryValue ['DPST-1-6', '6', 'DPT_1_BIT', '"binary value"', 'BOOL']]
    ['33' DPT_Step ['DPST-1-7', '7', 'DPT_1_BIT', '"step"', 'BOOL']]
    ['34' DPT_UpDown ['DPST-1-8', '8', 'DPT_1_BIT', '"up/down"', 'BOOL']]
    ['35' DPT_OpenClose ['DPST-1-9', '9', 'DPT_1_BIT', '"open/close"', 'BOOL']]
    ['36' DPT_Start ['DPST-1-10', '10', 'DPT_1_BIT', '"start/stop"', 'BOOL']]
    ['37' DPT_State ['DPST-1-11', '11', 'DPT_1_BIT', '"state"', 'BOOL']]
    ['38' DPT_Invert ['DPST-1-12', '12', 'DPT_1_BIT', '"invert"', 'BOOL']]
    ['39' DPT_DimSendStyle ['DPST-1-13', '13', 'DPT_1_BIT', '"dim send style"', 'BOOL']]
    ['40' DPT_InputSource ['DPST-1-14', '14', 'DPT_1_BIT', '"input source"', 'BOOL']]
    ['41' DPT_Reset ['DPST-1-15', '15', 'DPT_1_BIT', '"reset"', 'BOOL']]
    ['42' DPT_Ack ['DPST-1-16', '16', 'DPT_1_BIT', '"acknowledge"', 'BOOL']]
    ['43' DPT_Trigger ['DPST-1-17', '17', 'DPT_1_BIT', '"trigger"', 'BOOL']]
    ['44' DPT_Occupancy ['DPST-1-18', '18', 'DPT_1_BIT', '"occupancy"', 'BOOL']]
    ['45' DPT_Window_Door ['DPST-1-19', '19', 'DPT_1_BIT', '"window/door"', 'BOOL']]
    ['46' DPT_LogicalFunction ['DPST-1-21', '21', 'DPT_1_BIT', '"logical function"', 'BOOL']]
    ['47' DPT_Scene_AB ['DPST-1-22', '22', 'DPT_1_BIT', '"scene"', 'BOOL']]
    ['48' DPT_ShutterBlinds_Mode ['DPST-1-23', '23', 'DPT_1_BIT', '"shutter/blinds mode"', 'BOOL']]
    ['49' DPT_DayNight ['DPST-1-24', '24', 'DPT_1_BIT', '"day/night"', 'BOOL']]
    ['50' DPT_Heat_Cool ['DPST-1-100', '100', 'DPT_1_BIT', '"cooling/heating"', 'BOOL']]
    ['51' DPT_Switch_Control ['DPST-2-1', '1', 'DPT_1_BIT_CONTROLLED', '"switch control"', 'Struct']]
    ['52' DPT_Bool_Control ['DPST-2-2', '2', 'DPT_1_BIT_CONTROLLED', '"boolean control"', 'Struct']]
    ['53' DPT_Enable_Control ['DPST-2-3', '3', 'DPT_1_BIT_CONTROLLED', '"enable control"', 'Struct']]
    ['54' DPT_Ramp_Control ['DPST-2-4', '4', 'DPT_1_BIT_CONTROLLED', '"ramp control"', 'Struct']]
    ['55' DPT_Alarm_Control ['DPST-2-5', '5', 'DPT_1_BIT_CONTROLLED', '"alarm control"', 'Struct']]
    ['56' DPT_BinaryValue_Control ['DPST-2-6', '6', 'DPT_1_BIT_CONTROLLED', '"binary value control"', 'Struct']]
    ['57' DPT_Step_Control ['DPST-2-7', '7', 'DPT_1_BIT_CONTROLLED', '"step control"', 'Struct']]
    ['58' DPT_Direction1_Control ['DPST-2-8', '8', 'DPT_1_BIT_CONTROLLED', '"direction control 1"', 'Struct']]
    ['59' DPT_Direction2_Control ['DPST-2-9', '9', 'DPT_1_BIT_CONTROLLED', '"direction control 2"', 'Struct']]
    ['60' DPT_Start_Control ['DPST-2-10', '10', 'DPT_1_BIT_CONTROLLED', '"start control"', 'Struct']]
    ['61' DPT_State_Control ['DPST-2-11', '11', 'DPT_1_BIT_CONTROLLED', '"state control"', 'Struct']]
    ['62' DPT_Invert_Control ['DPST-2-12', '12', 'DPT_1_BIT_CONTROLLED', '"invert control"', 'Struct']]
    ['63' DPT_Control_Dimming ['DPST-3-7', '7', 'DPT_3_BIT_CONTROLLED', '"dimming control"', 'Struct']]
    ['64' DPT_Control_Blinds ['DPST-3-8', '8', 'DPT_3_BIT_CONTROLLED', '"blind control"', 'Struct']]
    ['65' DPT_Char_ASCII ['DPST-4-1', '1', 'DPT_CHARACTER', '"character (ASCII)"', 'STRING']]
    ['66' DPT_Char_8859_1 ['DPST-4-2', '2', 'DPT_CHARACTER', '"character (ISO 8859-1)"', 'STRING']]
    ['67' DPT_Scaling ['DPST-5-1', '1', 'DPT_8_BIT_UNSIGNED_VALUE', '"percentage (0..100%)"', 'USINT']]
    ['68' DPT_Angle ['DPST-5-3', '3', 'DPT_8_BIT_UNSIGNED_VALUE', '"angle (degrees)"', 'USINT']]
    ['69' DPT_Percent_U8 ['DPST-5-4', '4', 'DPT_8_BIT_UNSIGNED_VALUE', '"percentage (0..255%)"', 'USINT']]
    ['70' DPT_DecimalFactor ['DPST-5-5', '5', 'DPT_8_BIT_UNSIGNED_VALUE', '"ratio (0..255)"', 'USINT']]
    ['71' DPT_Tariff ['DPST-5-6', '6', 'DPT_8_BIT_UNSIGNED_VALUE', '"tariff (0..255)"', 'USINT']]
    ['72' DPT_Value_1_Ucount ['DPST-5-10', '10', 'DPT_8_BIT_UNSIGNED_VALUE', '"counter pulses (0..255)"', 'USINT']]
    ['73' DPT_FanStage ['DPST-5-100', '100', 'DPT_8_BIT_UNSIGNED_VALUE', '"fan stage (0..255)"', 'USINT']]
    ['74' DPT_Percent_V8 ['DPST-6-1', '1', 'DPT_8_BIT_SIGNED_VALUE', '"percentage (-128..127%)"', 'SINT']]
    ['75' DPT_Value_1_Count ['DPST-6-10', '10', 'DPT_8_BIT_SIGNED_VALUE', '"counter pulses (-128..127)"', 'SINT']]
    ['76' DPT_Status_Mode3 ['DPST-6-20', '20', 'DPT_8_BIT_SIGNED_VALUE', '"status with mode"', 'Struct']]
    ['77' DPT_Value_2_Ucount ['DPST-7-1', '1', 'DPT_2_BYTE_UNSIGNED_VALUE', '"pulses"', 'UINT']]
    ['78' DPT_TimePeriodMsec ['DPST-7-2', '2', 'DPT_2_BYTE_UNSIGNED_VALUE', '"time (ms)"', 'UINT']]
    ['79' DPT_TimePeriod10Msec ['DPST-7-3', '3', 'DPT_2_BYTE_UNSIGNED_VALUE', '"time (10 ms)"', 'UINT']]
    ['80' DPT_TimePeriod100Msec ['DPST-7-4', '4', 'DPT_2_BYTE_UNSIGNED_VALUE', '"time (100 ms)"', 'UINT']]
    ['81' DPT_TimePeriodSec ['DPST-7-5', '5', 'DPT_2_BYTE_UNSIGNED_VALUE', '"time (s)"', 'UINT']]
    ['82' DPT_TimePeriodMin ['DPST-7-6', '6', 'DPT_2_BYTE_UNSIGNED_VALUE', '"time (min)"', 'UINT']]
    ['83' DPT_TimePeriodHrs ['DPST-7-7', '7', 'DPT_2_BYTE_UNSIGNED_VALUE', '"time (h)"', 'UINT']]
    ['84' DPT_PropDataType ['DPST-7-10', '10', 'DPT_2_BYTE_UNSIGNED_VALUE', '"property data type"', 'UINT']]
    ['85' DPT_Length_mm ['DPST-7-11', '11', 'DPT_2_BYTE_UNSIGNED_VALUE', '"length (mm)"', 'UINT']]
    ['86' DPT_UElCurrentmA ['DPST-7-12', '12', 'DPT_2_BYTE_UNSIGNED_VALUE', '"current (mA)"', 'UINT']]
    ['87' DPT_Brightness ['DPST-7-13', '13', 'DPT_2_BYTE_UNSIGNED_VALUE', '"brightness (lux)"', 'UINT']]
    ['88' DPT_Absolute_Colour_Temperature ['DPST-7-600', '600', 'DPT_2_BYTE_UNSIGNED_VALUE', '"absolute colour temperature (K)"', 'UINT']]
    ['89' DPT_Value_2_Count ['DPST-8-1', '1', 'DPT_2_BYTE_SIGNED_VALUE', '"pulses difference"', 'INT']]
    ['90' DPT_DeltaTimeMsec ['DPST-8-2', '2', 'DPT_2_BYTE_SIGNED_VALUE', '"time lag (ms)"', 'INT']]
    ['91' DPT_DeltaTime10Msec ['DPST-8-3', '3', 'DPT_2_BYTE_SIGNED_VALUE', '"time lag(10 ms)"', 'INT']]
    ['92' DPT_DeltaTime100Msec ['DPST-8-4', '4', 'DPT_2_BYTE_SIGNED_VALUE', '"time lag (100 ms)"', 'INT']]
    ['93' DPT_DeltaTimeSec ['DPST-8-5', '5', 'DPT_2_BYTE_SIGNED_VALUE', '"time lag (s)"', 'INT']]
    ['94' DPT_DeltaTimeMin ['DPST-8-6', '6', 'DPT_2_BYTE_SIGNED_VALUE', '"time lag (min)"', 'INT']]
    ['95' DPT_DeltaTimeHrs ['DPST-8-7', '7', 'DPT_2_BYTE_SIGNED_VALUE', '"time lag (h)"', 'INT']]
    ['96' DPT_Percent_V16 ['DPST-8-10', '10', 'DPT_2_BYTE_SIGNED_VALUE', '"percentage difference (%)"', 'INT']]
    ['97' DPT_Rotation_Angle ['DPST-8-11', '11', 'DPT_2_BYTE_SIGNED_VALUE', '"rotation angle (°)"', 'INT']]
    ['98' DPT_Length_m ['DPST-8-12', '12', 'DPT_2_BYTE_SIGNED_VALUE', '"length (m)"', 'INT']]
    ['99' DPT_Value_Temp ['DPST-9-1', '1', 'DPT_2_BYTE_FLOAT_VALUE', '"temperature (°C)"', 'REAL']]
    ['100' DPT_Value_Tempd ['DPST-9-2', '2', 'DPT_2_BYTE_FLOAT_VALUE', '"temperature difference (K)"', 'REAL']]
    ['101' DPT_Value_Tempa ['DPST-9-3', '3', 'DPT_2_BYTE_FLOAT_VALUE', '"kelvin/hour (K/h)"', 'REAL']]
    ['102' DPT_Value_Lux ['DPST-9-4', '4', 'DPT_2_BYTE_FLOAT_VALUE', '"lux (Lux)"', 'REAL']]
    ['103' DPT_Value_Wsp ['DPST-9-5', '5', 'DPT_2_BYTE_FLOAT_VALUE', '"speed (m/s)"', 'REAL']]
    ['104' DPT_Value_Pres ['DPST-9-6', '6', 'DPT_2_BYTE_FLOAT_VALUE', '"pressure (Pa)"', 'REAL']]
    ['105' DPT_Value_Humidity ['DPST-9-7', '7', 'DPT_2_BYTE_FLOAT_VALUE', '"humidity (%)"', 'REAL']]
    ['106' DPT_Value_AirQuality ['DPST-9-8', '8', 'DPT_2_BYTE_FLOAT_VALUE', '"parts/million (ppm)"', 'REAL']]
    ['107' DPT_Value_AirFlow ['DPST-9-9', '9', 'DPT_2_BYTE_FLOAT_VALUE', '"air flow (m³/h)"', 'REAL']]
    ['108' DPT_Value_Time1 ['DPST-9-10', '10', 'DPT_2_BYTE_FLOAT_VALUE', '"time (s)"', 'REAL']]
    ['109' DPT_Value_Time2 ['DPST-9-11', '11', 'DPT_2_BYTE_FLOAT_VALUE', '"time (ms)"', 'REAL']]
    ['110' DPT_Value_Volt ['DPST-9-20', '20', 'DPT_2_BYTE_FLOAT_VALUE', '"voltage (mV)"', 'REAL']]
    ['111' DPT_Value_Curr ['DPST-9-21', '21', 'DPT_2_BYTE_FLOAT_VALUE', '"current (mA)"', 'REAL']]
    ['112' DPT_PowerDensity ['DPST-9-22', '22', 'DPT_2_BYTE_FLOAT_VALUE', '"power density (W/m²)"', 'REAL']]
    ['113' DPT_KelvinPerPercent ['DPST-9-23', '23', 'DPT_2_BYTE_FLOAT_VALUE', '"kelvin/percent (K/%)"', 'REAL']]
    ['114' DPT_Power ['DPST-9-24', '24', 'DPT_2_BYTE_FLOAT_VALUE', '"power (kW)"', 'REAL']]
    ['115' DPT_Value_Volume_Flow ['DPST-9-25', '25', 'DPT_2_BYTE_FLOAT_VALUE', '"volume flow (l/h)"', 'REAL']]
    ['116' DPT_Rain_Amount ['DPST-9-26', '26', 'DPT_2_BYTE_FLOAT_VALUE', '"rain amount (l/m²)"', 'REAL']]
    ['117' DPT_Value_Temp_F ['DPST-9-27', '27', 'DPT_2_BYTE_FLOAT_VALUE', '"temperature (°F)"', 'REAL']]
    ['118' DPT_Value_Wsp_kmh ['DPST-9-28', '28', 'DPT_2_BYTE_FLOAT_VALUE', '"wind speed (km/h)"', 'REAL']]
    ['119' DPT_Value_Absolute_Humidity ['DPST-9-29', '29', 'DPT_2_BYTE_FLOAT_VALUE', '"absolute humidity (g/m³)"', 'REAL']]
    ['120' DPT_Concentration_ygm3 ['DPST-9-30', '30', 'DPT_2_BYTE_FLOAT_VALUE', '"concentration (µg/m³)"', 'REAL']]
    ['121' DPT_Coefficient ['DPST-9-31', '31', 'DPT_2_BYTE_FLOAT_VALUE', '"coefficient"', 'REAL']]
    ['122' DPT_TimeOfDay ['DPST-10-1', '1', 'DPT_TIME', '"time of day"', 'Struct']]
    ['123' DPT_Date ['DPST-11-1', '1', 'DPT_DATE', '"date"', 'Struct']]
    ['124' DPT_Value_4_Ucount ['DPST-12-1', '1', 'DPT_4_BYTE_UNSIGNED_VALUE', '"counter pulses (unsigned)"', 'UDINT']]
    ['125' DPT_LongTimePeriod_Sec ['DPST-12-100', '100', 'DPT_4_BYTE_UNSIGNED_VALUE', '"counter timesec (s)"', 'UDINT']]
    ['126' DPT_LongTimePeriod_Min ['DPST-12-101', '101', 'DPT_4_BYTE_UNSIGNED_VALUE', '"counter timemin (min)"', 'UDINT']]
    ['127' DPT_LongTimePeriod_Hrs ['DPST-12-102', '102', 'DPT_4_BYTE_UNSIGNED_VALUE', '"counter timehrs (h)"', 'UDINT']]
    ['128' DPT_VolumeLiquid_Litre ['DPST-12-1200', '1200', 'DPT_4_BYTE_UNSIGNED_VALUE', '"volume liquid (l)"', 'UDINT']]
    ['129' DPT_Volume_m_3 ['DPST-12-1201', '1201', 'DPT_4_BYTE_UNSIGNED_VALUE', '"volume (m³)"', 'UDINT']]
    ['130' DPT_Value_4_Count ['DPST-13-1', '1', 'DPT_4_BYTE_SIGNED_VALUE', '"counter pulses (signed)"', 'DINT']]
    ['131' DPT_FlowRate_m3h ['DPST-13-2', '2', 'DPT_4_BYTE_SIGNED_VALUE', '"flow rate (m³/h)"', 'DINT']]
    ['132' DPT_ActiveEnergy ['DPST-13-10', '10', 'DPT_4_BYTE_SIGNED_VALUE', '"active energy (Wh)"', 'DINT']]
    ['133' DPT_ApparentEnergy ['DPST-13-11', '11', 'DPT_4_BYTE_SIGNED_VALUE', '"apparent energy (VAh)"', 'DINT']]
    ['134' DPT_ReactiveEnergy ['DPST-13-12', '12', 'DPT_4_BYTE_SIGNED_VALUE', '"reactive energy (VARh)"', 'DINT']]
    ['135' DPT_ActiveEnergy_kWh ['DPST-13-13', '13', 'DPT_4_BYTE_SIGNED_VALUE', '"active energy (kWh)"', 'DINT']]
    ['136' DPT_ApparentEnergy_kVAh ['DPST-13-14', '14', 'DPT_4_BYTE_SIGNED_VALUE', '"apparent energy (kVAh)"', 'DINT']]
    ['137' DPT_ReactiveEnergy_kVARh ['DPST-13-15', '15', 'DPT_4_BYTE_SIGNED_VALUE', '"reactive energy (kVARh)"', 'DINT']]
    ['138' DPT_ActiveEnergy_MWh ['DPST-13-16', '16', 'DPT_4_BYTE_SIGNED_VALUE', '"active energy (MWh)"', 'DINT']]
    ['139' DPT_LongDeltaTimeSec ['DPST-13-100', '100', 'DPT_4_BYTE_SIGNED_VALUE', '"time lag (s)"', 'DINT']]
    ['140' DPT_DeltaVolumeLiquid_Litre  ['DPST-13-1200', '1200', 'DPT_4_BYTE_SIGNED_VALUE', '"delta volume liquid (l)"', 'DINT']]
    ['141' DPT_DeltaVolume_m_3 ['DPST-13-1201', '1201', 'DPT_4_BYTE_SIGNED_VALUE', '"delta volume (m³)"', 'DINT']]
    ['142' DPT_Value_Acceleration ['DPST-14-0', '0', 'DPT_4_BYTE_FLOAT_VALUE', '"acceleration (m/s²)"', 'REAL']]
    ['143' DPT_Value_Acceleration_Angular ['DPST-14-1', '1', 'DPT_4_BYTE_FLOAT_VALUE', '"angular acceleration (rad/s²)"', 'REAL']]
    ['144' DPT_Value_Activation_Energy ['DPST-14-2', '2', 'DPT_4_BYTE_FLOAT_VALUE', '"activation energy (J/mol)"', 'REAL']]
    ['145' DPT_Value_Activity ['DPST-14-3', '3', 'DPT_4_BYTE_FLOAT_VALUE', '"radioactive activity (1/s)"', 'REAL']]
    ['146' DPT_Value_Mol ['DPST-14-4', '4', 'DPT_4_BYTE_FLOAT_VALUE', '"amount of substance (mol)"', 'REAL']]
    ['147' DPT_Value_Amplitude ['DPST-14-5', '5', 'DPT_4_BYTE_FLOAT_VALUE', '"amplitude"', 'REAL']]
    ['148' DPT_Value_AngleRad ['DPST-14-6', '6', 'DPT_4_BYTE_FLOAT_VALUE', '"angle (radiant)"', 'REAL']]
    ['149' DPT_Value_AngleDeg ['DPST-14-7', '7', 'DPT_4_BYTE_FLOAT_VALUE', '"angle (degree)"', 'REAL']]
    ['150' DPT_Value_Angular_Momentum ['DPST-14-8', '8', 'DPT_4_BYTE_FLOAT_VALUE', '"angular momentum (Js)"', 'REAL']]
    ['151' DPT_Value_Angular_Velocity ['DPST-14-9', '9', 'DPT_4_BYTE_FLOAT_VALUE', '"angular velocity (rad/s)"', 'REAL']]
    ['152' DPT_Value_Area ['DPST-14-10', '10', 'DPT_4_BYTE_FLOAT_VALUE', '"area (m*m)"', 'REAL']]
    ['153' DPT_Value_Capacitance ['DPST-14-11', '11', 'DPT_4_BYTE_FLOAT_VALUE', '"capacitance (F)"', 'REAL']]
    ['154' DPT_Value_Charge_DensitySurface ['DPST-14-12', '12', 'DPT_4_BYTE_FLOAT_VALUE', '"flux density (C/m²)"', 'REAL']]
    ['155' DPT_Value_Charge_DensityVolume ['DPST-14-13', '13', 'DPT_4_BYTE_FLOAT_VALUE', '"charge density (C/m³)"', 'REAL']]
    ['156' DPT_Value_Compressibility ['DPST-14-14', '14', 'DPT_4_BYTE_FLOAT_VALUE', '"compressibility (m²/N)"', 'REAL']]
    ['157' DPT_Value_Conductance ['DPST-14-15', '15', 'DPT_4_BYTE_FLOAT_VALUE', '"conductance (S)"', 'REAL']]
    ['158' DPT_Value_Electrical_Conductivity ['DPST-14-16', '16', 'DPT_4_BYTE_FLOAT_VALUE', '"conductivity  (S/m)"', 'REAL']]
    ['159' DPT_Value_Density ['DPST-14-17', '17', 'DPT_4_BYTE_FLOAT_VALUE', '"density (kg/m³)"', 'REAL']]
    ['160' DPT_Value_Electric_Charge ['DPST-14-18', '18', 'DPT_4_BYTE_FLOAT_VALUE', '"electric charge (C)"', 'REAL']]
    ['161' DPT_Value_Electric_Current ['DPST-14-19', '19', 'DPT_4_BYTE_FLOAT_VALUE', '"electric current (A)"', 'REAL']]
    ['162' DPT_Value_Electric_CurrentDensity ['DPST-14-20', '20', 'DPT_4_BYTE_FLOAT_VALUE', '"electric current density (A/m²)"', 'REAL']]
    ['163' DPT_Value_Electric_DipoleMoment ['DPST-14-21', '21', 'DPT_4_BYTE_FLOAT_VALUE', '"electric dipole moment (Cm)"', 'REAL']]
    ['164' DPT_Value_Electric_Displacement ['DPST-14-22', '22', 'DPT_4_BYTE_FLOAT_VALUE', '"electric displacement (C/m²)"', 'REAL']]
    ['165' DPT_Value_Electric_FieldStrength ['DPST-14-23', '23', 'DPT_4_BYTE_FLOAT_VALUE', '"electric field strength (V/m)"', 'REAL']]
    ['166' DPT_Value_Electric_Flux ['DPST-14-24', '24', 'DPT_4_BYTE_FLOAT_VALUE', '"electric flux (C)"', 'REAL']]
    ['167' DPT_Value_Electric_FluxDensity ['DPST-14-25', '25', 'DPT_4_BYTE_FLOAT_VALUE', '"electric flux density (C/m²)"', 'REAL']]
    ['168' DPT_Value_Electric_Polarization ['DPST-14-26', '26', 'DPT_4_BYTE_FLOAT_VALUE', '"electric polarization (C/m²)"', 'REAL']]
    ['169' DPT_Value_Electric_Potential ['DPST-14-27', '27', 'DPT_4_BYTE_FLOAT_VALUE', '"electric potential (V)"', 'REAL']]
    ['170' DPT_Value_Electric_PotentialDifference ['DPST-14-28', '28', 'DPT_4_BYTE_FLOAT_VALUE', '"electric potential difference (V)"', 'REAL']]
    ['171' DPT_Value_ElectromagneticMoment ['DPST-14-29', '29', 'DPT_4_BYTE_FLOAT_VALUE', '"electromagnetic moment (Am²)"', 'REAL']]
    ['172' DPT_Value_Electromotive_Force ['DPST-14-30', '30', 'DPT_4_BYTE_FLOAT_VALUE', '"electromotive force (V)"', 'REAL']]
    ['173' DPT_Value_Energy ['DPST-14-31', '31', 'DPT_4_BYTE_FLOAT_VALUE', '"energy (J)"', 'REAL']]
    ['174' DPT_Value_Force ['DPST-14-32', '32', 'DPT_4_BYTE_FLOAT_VALUE', '"force (N)"', 'REAL']]
    ['175' DPT_Value_Frequency ['DPST-14-33', '33', 'DPT_4_BYTE_FLOAT_VALUE', '"frequency (Hz)"', 'REAL']]
    ['176' DPT_Value_Angular_Frequency ['DPST-14-34', '34', 'DPT_4_BYTE_FLOAT_VALUE', '"angular frequency (rad/s)"', 'REAL']]
    ['177' DPT_Value_Heat_Capacity ['DPST-14-35', '35', 'DPT_4_BYTE_FLOAT_VALUE', '"heat capacity (J/K)"', 'REAL']]
    ['178' DPT_Value_Heat_FlowRate ['DPST-14-36', '36', 'DPT_4_BYTE_FLOAT_VALUE', '"heat flow rate (W)"', 'REAL']]
    ['179' DPT_Value_Heat_Quantity ['DPST-14-37', '37', 'DPT_4_BYTE_FLOAT_VALUE', '"heat quantity"', 'REAL']]
    ['180' DPT_Value_Impedance ['DPST-14-38', '38', 'DPT_4_BYTE_FLOAT_VALUE', '"impedance (Ω)"', 'REAL']]
    ['181' DPT_Value_Length ['DPST-14-39', '39', 'DPT_4_BYTE_FLOAT_VALUE', '"length (m)"', 'REAL']]
    ['182' DPT_Value_Light_Quantity ['DPST-14-40', '40', 'DPT_4_BYTE_FLOAT_VALUE', '"light quantity (J)"', 'REAL']]
    ['183' DPT_Value_Luminance ['DPST-14-41', '41', 'DPT_4_BYTE_FLOAT_VALUE', '"luminance (cd/m²)"', 'REAL']]
    ['184' DPT_Value_Luminous_Flux ['DPST-14-42', '42', 'DPT_4_BYTE_FLOAT_VALUE', '"luminous flux (lm)"', 'REAL']]
    ['185' DPT_Value_Luminous_Intensity ['DPST-14-43', '43', 'DPT_4_BYTE_FLOAT_VALUE', '"luminous intensity (cd)"', 'REAL']]
    ['186' DPT_Value_Magnetic_FieldStrength ['DPST-14-44', '44', 'DPT_4_BYTE_FLOAT_VALUE', '"magnetic field strength (A/m)"', 'REAL']]
    ['187' DPT_Value_Magnetic_Flux ['DPST-14-45', '45', 'DPT_4_BYTE_FLOAT_VALUE', '"magnetic flux (Wb)"', 'REAL']]
    ['188' DPT_Value_Magnetic_FluxDensity ['DPST-14-46', '46', 'DPT_4_BYTE_FLOAT_VALUE', '"magnetic flux density (T)"', 'REAL']]
    ['189' DPT_Value_Magnetic_Moment ['DPST-14-47', '47', 'DPT_4_BYTE_FLOAT_VALUE', '"magnetic moment (Am²)"', 'REAL']]
    ['190' DPT_Value_Magnetic_Polarization ['DPST-14-48', '48', 'DPT_4_BYTE_FLOAT_VALUE', '"magnetic polarization (T)"', 'REAL']]
    ['191' DPT_Value_Magnetization ['DPST-14-49', '49', 'DPT_4_BYTE_FLOAT_VALUE', '"magnetization (A/m)"', 'REAL']]
    ['192' DPT_Value_MagnetomotiveForce ['DPST-14-50', '50', 'DPT_4_BYTE_FLOAT_VALUE', '"magnetomotive force (A)"', 'REAL']]
    ['193' DPT_Value_Mass ['DPST-14-51', '51', 'DPT_4_BYTE_FLOAT_VALUE', '"mass (kg)"', 'REAL']]
    ['194' DPT_Value_MassFlux ['DPST-14-52', '52', 'DPT_4_BYTE_FLOAT_VALUE', '"mass flux (kg/s)"', 'REAL']]
    ['195' DPT_Value_Momentum ['DPST-14-53', '53', 'DPT_4_BYTE_FLOAT_VALUE', '"momentum (N/s)"', 'REAL']]
    ['196' DPT_Value_Phase_AngleRad ['DPST-14-54', '54', 'DPT_4_BYTE_FLOAT_VALUE', '"phase angle (rad)"', 'REAL']]
    ['197' DPT_Value_Phase_AngleDeg ['DPST-14-55', '55', 'DPT_4_BYTE_FLOAT_VALUE', '"phase angle (°)"', 'REAL']]
    ['198' DPT_Value_Power ['DPST-14-56', '56', 'DPT_4_BYTE_FLOAT_VALUE', '"power (W)"', 'REAL']]
    ['199' DPT_Value_Power_Factor ['DPST-14-57', '57', 'DPT_4_BYTE_FLOAT_VALUE', '"power factor (cos Φ)"', 'REAL']]
    ['200' DPT_Value_Pressure ['DPST-14-58', '58', 'DPT_4_BYTE_FLOAT_VALUE', '"pressure (Pa)"', 'REAL']]
    ['201' DPT_Value_Reactance ['DPST-14-59', '59', 'DPT_4_BYTE_FLOAT_VALUE', '"reactance (Ω)"', 'REAL']]
    ['202' DPT_Value_Resistance ['DPST-14-60', '60', 'DPT_4_BYTE_FLOAT_VALUE', '"resistance (Ω)"', 'REAL']]
    ['203' DPT_Value_Resistivity ['DPST-14-61', '61', 'DPT_4_BYTE_FLOAT_VALUE', '"resistivity (Ωm)"', 'REAL']]
    ['204' DPT_Value_SelfInductance ['DPST-14-62', '62', 'DPT_4_BYTE_FLOAT_VALUE', '"self inductance (H)"', 'REAL']]
    ['205' DPT_Value_SolidAngle ['DPST-14-63', '63', 'DPT_4_BYTE_FLOAT_VALUE', '"solid angle (sr)"', 'REAL']]
    ['206' DPT_Value_Sound_Intensity ['DPST-14-64', '64', 'DPT_4_BYTE_FLOAT_VALUE', '"sound intensity (W/m²)"', 'REAL']]
    ['207' DPT_Value_Speed ['DPST-14-65', '65', 'DPT_4_BYTE_FLOAT_VALUE', '"speed (m/s)"', 'REAL']]
    ['208' DPT_Value_Stress ['DPST-14-66', '66', 'DPT_4_BYTE_FLOAT_VALUE', '"stress (Pa)"', 'REAL']]
    ['209' DPT_Value_Surface_Tension ['DPST-14-67', '67', 'DPT_4_BYTE_FLOAT_VALUE', '"surface tension (N/m)"', 'REAL']]
    ['210' DPT_Value_Common_Temperature ['DPST-14-68', '68', 'DPT_4_BYTE_FLOAT_VALUE', '"temperature (°C)"', 'REAL']]
    ['211' DPT_Value_Absolute_Temperature ['DPST-14-69', '69', 'DPT_4_BYTE_FLOAT_VALUE', '"temperature absolute (K)"', 'REAL']]
    ['212' DPT_Value_TemperatureDifference ['DPST-14-70', '70', 'DPT_4_BYTE_FLOAT_VALUE', '"temperature difference (K)"', 'REAL']]
    ['213' DPT_Value_Thermal_Capacity ['DPST-14-71', '71', 'DPT_4_BYTE_FLOAT_VALUE', '"thermal capacity (J/K)"', 'REAL']]
    ['214' DPT_Value_Thermal_Conductivity ['DPST-14-72', '72', 'DPT_4_BYTE_FLOAT_VALUE', '"thermal conductivity (W/mK)"', 'REAL']]
    ['215' DPT_Value_ThermoelectricPower ['DPST-14-73', '73', 'DPT_4_BYTE_FLOAT_VALUE', '"thermoelectric power (V/K)"', 'REAL']]
    ['216' DPT_Value_Time ['DPST-14-74', '74', 'DPT_4_BYTE_FLOAT_VALUE', '"time (s)"', 'REAL']]
    ['217' DPT_Value_Torque ['DPST-14-75', '75', 'DPT_4_BYTE_FLOAT_VALUE', '"torque (Nm)"', 'REAL']]
    ['218' DPT_Value_Volume ['DPST-14-76', '76', 'DPT_4_BYTE_FLOAT_VALUE', '"volume (m³)"', 'REAL']]
    ['219' DPT_Value_Volume_Flux ['DPST-14-77', '77', 'DPT_4_BYTE_FLOAT_VALUE', '"volume flux (m³/s)"', 'REAL']]
    ['220' DPT_Value_Weight ['DPST-14-78', '78', 'DPT_4_BYTE_FLOAT_VALUE', '"weight (N)"', 'REAL']]
    ['221' DPT_Value_Work ['DPST-14-79', '79', 'DPT_4_BYTE_FLOAT_VALUE', '"work (J)"', 'REAL']]
    ['222' DPT_Value_ApparentPower ['DPST-14-80', '80', 'DPT_4_BYTE_FLOAT_VALUE', '"apparent power (VA)"', 'REAL']]
    ['223' DPT_Volume_Flux_Meter ['DPST-14-1200', '1200', 'DPT_4_BYTE_FLOAT_VALUE', '"volume flux for meters (m³/h)"', 'REAL']]
    ['224' DPT_Volume_Flux_ls ['DPST-14-1201', '1201', 'DPT_4_BYTE_FLOAT_VALUE', '"volume flux for meters (1/ls)"', 'REAL']]
    ['225' DPT_Access_Data ['DPST-15-0', '0', 'DPT_ENTRANCE_ACCESS', '"entrance access"', 'Struct']]
    ['226' DPT_String_ASCII ['DPST-16-0', '0', 'DPT_CHARACTER_STRING', '"Character String (ASCII)"', 'STRING']]
    ['227' DPT_String_8859_1 ['DPST-16-1', '1', 'DPT_CHARACTER_STRING', '"Character String (ISO 8859-1)"', 'STRING']]
    ['228' DPT_SceneNumber ['DPST-17-1', '1', 'DPT_SCENE_NUMBER', '"scene number"', 'USINT']]
    ['229' DPT_SceneControl ['DPST-18-1', '1', 'DPT_SCENE_CONTROL', '"scene control"', 'Struct']]
    ['230' DPT_DateTime ['DPST-19-1', '1', 'DPT_DATE_TIME', '"date time"', 'Struct']]
    ['231' DPT_SCLOMode ['DPST-20-1', '1', 'DPT_1_BYTE', '"SCLO mode"', 'USINT']]
    ['232' DPT_BuildingMode ['DPST-20-2', '2', 'DPT_1_BYTE', '"building mode"', 'USINT']]
    ['233' DPT_OccMode ['DPST-20-3', '3', 'DPT_1_BYTE', '"occupied"', 'USINT']]
    ['234' DPT_Priority ['DPST-20-4', '4', 'DPT_1_BYTE', '"priority"', 'USINT']]
    ['235' DPT_LightApplicationMode ['DPST-20-5', '5', 'DPT_1_BYTE', '"light application mode"', 'USINT']]
    ['236' DPT_ApplicationArea ['DPST-20-6', '6', 'DPT_1_BYTE', '"light application area"', 'USINT']]
    ['237' DPT_AlarmClassType ['DPST-20-7', '7', 'DPT_1_BYTE', '"alarm class"', 'USINT']]
    ['238' DPT_PSUMode ['DPST-20-8', '8', 'DPT_1_BYTE', '"PSU mode"', 'USINT']]
    ['239' DPT_ErrorClass_System ['DPST-20-11', '11', 'DPT_1_BYTE', '"system error class"', 'USINT']]
    ['240' DPT_ErrorClass_HVAC ['DPST-20-12', '12', 'DPT_1_BYTE', '"HVAC error class"', 'USINT']]
    ['241' DPT_Time_Delay ['DPST-20-13', '13', 'DPT_1_BYTE', '"time delay"', 'USINT']]
    ['242' DPT_Beaufort_Wind_Force_Scale ['DPST-20-14', '14', 'DPT_1_BYTE', '"wind force scale (0..12)"', 'USINT']]
    ['243' DPT_SensorSelect ['DPST-20-17', '17', 'DPT_1_BYTE', '"sensor mode"', 'USINT']]
    ['244' DPT_ActuatorConnectType ['DPST-20-20', '20', 'DPT_1_BYTE', '"actuator connect type"', 'USINT']]
    ['245' DPT_Cloud_Cover ['DPST-20-21', '21', 'DPT_1_BYTE', '"cloud cover"', 'USINT']]
    ['246' DPT_PowerReturnMode ['DPST-20-22', '22', 'DPT_1_BYTE', '"power return mode"', 'USINT']]
    ['247' DPT_FuelType ['DPST-20-100', '100', 'DPT_1_BYTE', '"fuel type"', 'USINT']]
    ['248' DPT_BurnerType ['DPST-20-101', '101', 'DPT_1_BYTE', '"burner type"', 'USINT']]
    ['249' DPT_HVACMode ['DPST-20-102', '102', 'DPT_1_BYTE', '"HVAC mode"', 'USINT']]
    ['250' DPT_DHWMode ['DPST-20-103', '103', 'DPT_1_BYTE', '"DHW mode"', 'USINT']]
    ['251' DPT_LoadPriority ['DPST-20-104', '104', 'DPT_1_BYTE', '"load priority"', 'USINT']]
    ['252' DPT_HVACContrMode ['DPST-20-105', '105', 'DPT_1_BYTE', '"HVAC control mode"', 'USINT']]
    ['253' DPT_HVACEmergMode ['DPST-20-106', '106', 'DPT_1_BYTE', '"HVAC emergency mode"', 'USINT']]
    ['254' DPT_ChangeoverMode ['DPST-20-107', '107', 'DPT_1_BYTE', '"changeover mode"', 'USINT']]
    ['255' DPT_ValveMode ['DPST-20-108', '108', 'DPT_1_BYTE', '"valve mode"', 'USINT']]
    ['256' DPT_DamperMode ['DPST-20-109', '109', 'DPT_1_BYTE', '"damper mode"', 'USINT']]
    ['257' DPT_HeaterMode ['DPST-20-110', '110', 'DPT_1_BYTE', '"heater mode"', 'USINT']]
    ['258' DPT_FanMode ['DPST-20-111', '111', 'DPT_1_BYTE', '"fan mode"', 'USINT']]
    ['259' DPT_MasterSlaveMode ['DPST-20-112', '112', 'DPT_1_BYTE', '"master/slave mode"', 'USINT']]
    ['260' DPT_StatusRoomSetp ['DPST-20-113', '113', 'DPT_1_BYTE', '"status room setpoint"', 'USINT']]
    ['261' DPT_Metering_DeviceType ['DPST-20-114', '114', 'DPT_1_BYTE', '"metering device type"', 'USINT']]
    ['262' DPT_HumDehumMode ['DPST-20-115', '115', 'DPT_1_BYTE', '"hum dehum mode"', 'USINT']]
    ['263' DPT_EnableHCStage ['DPST-20-116', '116', 'DPT_1_BYTE', '"enable H/C stage"', 'USINT']]
    ['264' DPT_ADAType ['DPST-20-120', '120', 'DPT_1_BYTE', '"ADA type"', 'USINT']]
    ['265' DPT_BackupMode ['DPST-20-121', '121', 'DPT_1_BYTE', '"backup mode"', 'USINT']]
    ['266' DPT_StartSynchronization ['DPST-20-122', '122', 'DPT_1_BYTE', '"start syncronization type"', 'USINT']]
    ['267' DPT_Behaviour_Lock_Unlock ['DPST-20-600', '600', 'DPT_1_BYTE', '"behavior lock/unlock"', 'USINT']]
    ['268' DPT_Behaviour_Bus_Power_Up_Down ['DPST-20-601', '601', 'DPT_1_BYTE', '"behavior bus power up/down"', 'USINT']]
    ['269' DPT_DALI_Fade_Time ['DPST-20-602', '602', 'DPT_1_BYTE', '"dali fade time"', 'USINT']]
    ['270' DPT_BlinkingMode ['DPST-20-603', '603', 'DPT_1_BYTE', '"blink mode"', 'USINT']]
    ['271' DPT_LightControlMode ['DPST-20-604', '604', 'DPT_1_BYTE', '"light control mode"', 'USINT']]
    ['272' DPT_SwitchPBModel ['DPST-20-605', '605', 'DPT_1_BYTE', '"PB switch mode"', 'USINT']]
    ['273' DPT_PBAction ['DPST-20-606', '606', 'DPT_1_BYTE', '"PB action mode"', 'USINT']]
    ['274' DPT_DimmPBModel ['DPST-20-607', '607', 'DPT_1_BYTE', '"PB dimm mode"', 'USINT']]
    ['275' DPT_SwitchOnMode ['DPST-20-608', '608', 'DPT_1_BYTE', '"switch on mode"', 'USINT']]
    ['276' DPT_LoadTypeSet ['DPST-20-609', '609', 'DPT_1_BYTE', '"load type"', 'USINT']]
    ['277' DPT_LoadTypeDetected ['DPST-20-610', '610', 'DPT_1_BYTE', '"load type detection"', 'USINT']]
    ['278' DPT_Converter_Test_Control ['DPST-20-611', '611', 'DPT_1_BYTE', '"converter test control"', 'USINT']]
    ['279' DPT_Converter_Control ['DPST-20-612', '612', 'DPT_1_BYTE', '"converter control"', 'USINT']]
    ['280' DPT_SABExcept_Behaviour ['DPST-20-801', '801', 'DPT_1_BYTE', '"SAB except behavior"', 'USINT']]
    ['281' DPT_SABBehaviour_Lock_Unlock ['DPST-20-802', '802', 'DPT_1_BYTE', '"SAB behavior on lock/unlock"', 'USINT']]
    ['282' DPT_SSSBMode ['DPST-20-803', '803', 'DPT_1_BYTE', '"SSSB mode"', 'USINT']]
    ['283' DPT_BlindsControlMode ['DPST-20-804', '804', 'DPT_1_BYTE', '"blinds control mode"', 'USINT']]
    ['284' DPT_CommMode ['DPST-20-1000', '1000', 'DPT_1_BYTE', '"communication mode"', 'USINT']]
    ['285' DPT_AddInfoTypes ['DPST-20-1001', '1001', 'DPT_1_BYTE', '"additional information type"', 'USINT']]
    ['286' DPT_RF_ModeSelect ['DPST-20-1002', '1002', 'DPT_1_BYTE', '"RF mode selection"', 'USINT']]
    ['287' DPT_RF_FilterSelect ['DPST-20-1003', '1003', 'DPT_1_BYTE', '"RF filter mode selection"', 'USINT']]
    ['288' DPT_StatusGen ['DPST-21-1', '1', 'DPT_8_BIT_SET', '"general status"', 'Struct']]
    ['289' DPT_Device_Control ['DPST-21-2', '2', 'DPT_8_BIT_SET', '"device control"', 'Struct']]
    ['290' DPT_ForceSign ['DPST-21-100', '100', 'DPT_8_BIT_SET', '"forcing signal"', 'Struct']]
    ['291' DPT_ForceSignCool ['DPST-21-101', '101', 'DPT_8_BIT_SET', '"forcing signal cool"', 'BOOL']]
    ['292' DPT_StatusRHC ['DPST-21-102', '102', 'DPT_8_BIT_SET', '"room heating controller status"', 'Struct']]
    ['293' DPT_StatusSDHWC ['DPST-21-103', '103', 'DPT_8_BIT_SET', '"solar DHW controller status"', 'Struct']]
    ['294' DPT_FuelTypeSet ['DPST-21-104', '104', 'DPT_8_BIT_SET', '"fuel type set"', 'Struct']]
    ['295' DPT_StatusRCC ['DPST-21-105', '105', 'DPT_8_BIT_SET', '"room cooling controller status"', 'BOOL']]
    ['296' DPT_StatusAHU ['DPST-21-106', '106', 'DPT_8_BIT_SET', '"ventilation controller status"', 'Struct']]
    ['297' DPT_CombinedStatus_RTSM ['DPST-21-107', '107', 'DPT_8_BIT_SET', '"combined status RTSM"', 'Struct']]
    ['298' DPT_LightActuatorErrorInfo ['DPST-21-601', '601', 'DPT_8_BIT_SET', '"lighting actuator error information"', 'Struct']]
    ['299' DPT_RF_ModeInfo ['DPST-21-1000', '1000', 'DPT_8_BIT_SET', '"RF communication mode info"', 'Struct']]
    ['300' DPT_RF_FilterInfo ['DPST-21-1001', '1001', 'DPT_8_BIT_SET', '"cEMI server supported RF filtering modes"', 'Struct']]
    ['301' DPT_Channel_Activation_8 ['DPST-21-1010', '1010', 'DPT_8_BIT_SET', '"channel activation for 8 channels"', 'Struct']]
    ['302' DPT_StatusDHWC ['DPST-22-100', '100', 'DPT_16_BIT_SET', '"DHW controller status"', 'Struct']]
    ['303' DPT_StatusRHCC ['DPST-22-101', '101', 'DPT_16_BIT_SET', '"RHCC status"', 'Struct']]
    ['304' DPT_CombinedStatus_HVA ['DPST-22-102', '102', 'DPT_16_BIT_SET', '"combined status HVA"', 'Struct']]
    ['305' DPT_CombinedStatus_RTC ['DPST-22-103', '103', 'DPT_16_BIT_SET', '"combined status RTC"', 'Struct']]
    ['306' DPT_Media ['DPST-22-1000', '1000', 'DPT_16_BIT_SET', '"media"', 'Struct']]
    ['307' DPT_Channel_Activation_16 ['DPST-22-1010', '1010', 'DPT_16_BIT_SET', '"channel activation for 16 channels"', 'Struct']]
    ['308' DPT_OnOffAction ['DPST-23-1', '1', 'DPT_2_BIT_SET', '"on/off action"', 'USINT']]
    ['309' DPT_Alarm_Reaction ['DPST-23-2', '2', 'DPT_2_BIT_SET', '"alarm reaction"', 'USINT']]
    ['310' DPT_UpDown_Action ['DPST-23-3', '3', 'DPT_2_BIT_SET', '"up/down action"', 'USINT']]
    ['311' DPT_HVAC_PB_Action ['DPST-23-102', '102', 'DPT_2_BIT_SET', '"HVAC push button action"', 'USINT']]
    ['312' DPT_DoubleNibble ['DPST-25-1000', '1000', 'DPT_2_NIBBLE_SET', '"busy/nak repetitions"', 'Struct']]
    ['313' DPT_SceneInfo ['DPST-26-1', '1', 'DPT_8_BIT_SET_2', '"scene information"', 'Struct']]
    ['314' DPT_CombinedInfoOnOff ['DPST-27-1', '1', 'DPT_32_BIT_SET', '"bit-combined info on/off"', 'Struct']]
    ['315' DPT_ActiveEnergy_V64 ['DPST-29-10', '10', 'DPT_ELECTRICAL_ENERGY', '"active energy (Wh)"', 'LINT']]
    ['316' DPT_ApparentEnergy_V64 ['DPST-29-11', '11', 'DPT_ELECTRICAL_ENERGY', '"apparent energy (VAh)"', 'LINT']]
    ['317' DPT_ReactiveEnergy_V64 ['DPST-29-12', '12', 'DPT_ELECTRICAL_ENERGY', '"reactive energy (VARh)"', 'LINT']]
    ['318' DPT_Channel_Activation_24 ['DPST-30-1010', '1010', 'DPT_24_TIMES_CHANNEL_ACTIVATION', '"activation state 0..23"', 'Struct']]
    ['319' DPT_HVACModeNext ['DPST-206-100', '100', 'DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM', '"time delay & HVAC mode"', 'Struct']]
    ['320' DPT_DHWModeNext ['DPST-206-102', '102', 'DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM', '"time delay & DHW mode"', 'Struct']]
    ['321' DPT_OccModeNext ['DPST-206-104', '104', 'DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM', '"time delay & occupancy mode"', 'Struct']]
    ['322' DPT_BuildingModeNext ['DPST-206-105', '105', 'DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM', '"time delay & building mode"', 'Struct']]
    ['323' DPT_StatusLightingActuator ['DPST-207-600', '600', 'DPT_8_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM', '"Status Lighting Actuator"', 'Struct']]
    ['324' DPT_Version ['DPST-217-1', '1', 'DPT_DATAPOINT_TYPE_VERSION', '"DPT version"', 'Struct']]
    ['325' DPT_AlarmInfo ['DPST-219-1', '1', 'DPT_ALARM_INFO', '"alarm info"', 'Struct']]
    ['326' DPT_TempRoomSetpSetF16_3 ['DPST-222-100', '100', 'DPT_3X_2_BYTE_FLOAT_VALUE', '"room temperature setpoint"', 'Struct']]
    ['327' DPT_TempRoomSetpSetShiftF16_3 ['DPST-222-101', '101', 'DPT_3X_2_BYTE_FLOAT_VALUE', '"room temperature setpoint shift"', 'Struct']]
    ['328' DPT_Scaling_Speed ['DPST-225-1', '1', 'DPT_SCALING_SPEED', '"scaling speed"', 'Struct']]
    ['329' DPT_Scaling_Step_Time ['DPST-225-2', '2', 'DPT_SCALING_SPEED', '"scaling step time"', 'Struct']]
    ['330' DPT_MeteringValue ['DPST-229-1', '1', 'DPT_4_1_1_BYTE_COMBINED_INFORMATION', '"metering value (value,encoding,cmd)"', 'Struct']]
    ['331' DPT_MBus_Address ['DPST-230-1000', '1000', 'DPT_MBUS_ADDRESS', '"MBus address"', 'Struct']]
    ['332' DPT_Colour_RGB ['DPST-232-600', '600', 'DPT_3_BYTE_COLOUR_RGB', '"RGB value 3x(0..255)"', 'Struct']]
    ['333' DPT_LanguageCodeAlpha2_ASCII ['DPST-234-1', '1', 'DPT_LANGUAGE_CODE_ISO_639_1', '"language code (ASCII)"', 'STRING']]
    ['334' DPT_Tariff_ActiveEnergy ['DPST-235-1', '1', 'DPT_SIGNED_VALUE_WITH_CLASSIFICATION_AND_VALIDITY', '"electrical energy with tariff"', 'Struct']]
    ['335' DPT_Prioritised_Mode_Control ['DPST-236-1', '1', 'DPT_PRIORITISED_MODE_CONTROL', '"priority control"', 'Struct']]
    ['336' DPT_DALI_Control_Gear_Diagnostic ['DPST-237-600', '600', 'DPT_CONFIGURATION_DIAGNOSTICS_16_BIT', '"diagnostic value"', 'Struct']]
    ['337' DPT_DALI_Diagnostics ['DPST-238-600', '600', 'DPT_CONFIGURATION_DIAGNOSTICS_8_BIT', '"diagnostic value"', 'Struct']]
    ['338' DPT_CombinedPosition ['DPST-240-800', '800', 'DPT_POSITIONS', '"combined position"', 'Struct']]
    ['339' DPT_StatusSAB ['DPST-241-800', '800', 'DPT_STATUS_32_BIT', '"status sunblind & shutter actuator"', 'Struct']]
    ['340' DPT_Colour_xyY ['DPST-242-600', '600', 'DPT_STATUS_48_BIT', '"colour xyY"', 'Struct']]
    ['341' DPT_Converter_Status ['DPST-244-600', '600', 'DPT_CONVERTER_STATUS', '"DALI converter status"', 'Struct']]
    ['342' DPT_Converter_Test_Result ['DPST-245-600', '600', 'DPT_CONVERTER_TEST_RESULT', '"DALI converter test result"', 'Struct']]
    ['343' DPT_Battery_Info ['DPST-246-600', '600', 'DPT_BATTERY_INFORMATION', '"Battery Information"', 'Struct']]
    ['344' DPT_Brightness_Colour_Temperature_Transition ['DPST-249-600', '600', 'DPT_BRIGHTNESS_COLOUR_TEMPERATURE_TRANSITION', '"brightness colour temperature transition"', 'Struct']]
    ['345' DPT_Brightness_Colour_Temperature_Control ['DPST-250-600', '600', 'DPT_STATUS_24_BIT', '"brightness colour temperature control"', 'Struct']]
    ['346' DPT_Colour_RGBW ['DPST-251-600', '600', 'DPT_COLOUR_RGBW', '"RGBW value 4x(0..100%)"', 'Struct']]
    ['347' DPT_Relative_Control_RGBW ['DPST-252-600', '600', 'DPT_RELATIVE_CONTROL_RGBW', '"RGBW relative control"', 'Struct']]
    ['348' DPT_Relative_Control_RGB ['DPST-254-600', '600', 'DPT_RELATIVE_CONTROL_RGB', '"RGB relative control"', 'Struct']]
    ['349' DPT_GeographicalLocation ['DPST-255-1', '1', 'DPT_F32F32', '"geographical location (longitude and latitude) expressed in degrees"', 'Struct']]
    ['350' DPT_TempRoomSetpSetF16_4 ['DPST-275-100', '100', 'DPT_F16F16F16F16', '"Temperature setpoint setting for 4 HVAC Modes"', 'Struct']]
    ['351' DPT_TempRoomSetpSetShiftF16_4 ['DPST-275-101', '101', 'DPT_F16F16F16F16', '"Temperature setpoint shift setting for 4 HVAC Modes"', 'Struct']]
    
]

[enum uint 16 KnxInterfaceObjectType(string 8 code, string 8 name)
    ['0' OT_UNKNOWN ['U', '"Unknown Interface Object Type"']]
    ['1' OT_GENERAL ['G', '"General Interface Object Type"']]
    ['2' OT_DEVICE ['0', '"Device Object"']]
    ['3' OT_ADDRESS_TABLE ['1', '"Addresstable Object"']]
    ['4' OT_ASSOCIATION_TABLE ['2', '"Associationtable Object"']]
    ['5' OT_APPLICATION_PROGRAM ['3', '"Applicationprogram Object"']]
    ['6' OT_INTERACE_PROGRAM ['4', '"Interfaceprogram Object"']]
    ['7' OT_EIBOBJECT_ASSOCIATATION_TABLE ['5', '"KNX-Object Associationtable Object"']]
    ['8' OT_ROUTER ['6', '"Router Object"']]
    ['9' OT_LTE_ADDRESS_ROUTING_TABLE ['7', '"LTE Address Routing Table Object"']]
    ['10' OT_CEMI_SERVER ['8', '"cEMI Server Object"']]
    ['11' OT_GROUP_OBJECT_TABLE ['9', '"Group Object Table Object"']]
    ['12' OT_POLLING_MASTER ['10', '"Polling Master"']]
    ['13' OT_KNXIP_PARAMETER ['11', '"KNXnet/IP Parameter Object"']]
    ['14' OT_FILE_SERVER ['13', '"File Server Object"']]
    ['15' OT_SECURITY ['17', '"Security Object"']]
    ['16' OT_RF_MEDIUM ['19', '"RF Medium Object"']]
    ['17' OT_INDOOR_BRIGHTNESS_SENSOR ['409', '"Indoor Brightness Sensor"']]
    ['18' OT_INDOOR_LUMINANCE_SENSOR ['410', '"Indoor Luminance Sensor"']]
    ['19' OT_LIGHT_SWITCHING_ACTUATOR_BASIC ['417', '"Light Switching Actuator Basic"']]
    ['20' OT_DIMMING_ACTUATOR_BASIC ['418', '"Dimming Actuator Basic"']]
    ['21' OT_DIMMING_SENSOR_BASIC ['420', '"Dimming   Sensor Basic"']]
    ['22' OT_SWITCHING_SENSOR_BASIC ['421', '"Switching Sensor Basic"']]
    ['23' OT_SUNBLIND_ACTUATOR_BASIC ['800', '"Sunblind Actuator Basic"']]
    ['24' OT_SUNBLIND_SENSOR_BASIC ['801', '"Sunblind Sensor Basic"']]
    
]

[enum uint 32 KnxInterfaceObjectProperty(uint 8 propertyId, KnxInterfaceObjectType objectType, KnxPropertyDataType propertyDataType, string 8 name)
    ['0' PID_UNKNOWN    ['0', 'OT_UNKNOWN', 'PDT_UNKNOWN', '"Unknown Interface Object Property"']]
    ['1' PID_GENERAL_OBJECT_TYPE ['1', 'OT_GENERAL', 'PDT_UNSIGNED_INT', '"Interface Object Type"']]
    ['2' PID_GENERAL_OBJECT_NAME ['2', 'OT_GENERAL', 'PDT_UNSIGNED_CHAR', '"Interface Object Name"']]
    ['3' PID_GENERAL_SEMAPHOR ['3', 'OT_GENERAL', 'PDT_UNKNOWN', '"Semaphor"']]
    ['4' PID_GENERAL_GROUP_OBJECT_REFERENCE ['4', 'OT_GENERAL', 'PDT_UNKNOWN', '"Group Object Reference"']]
    ['5' PID_GENERAL_LOAD_STATE_CONTROL ['5', 'OT_GENERAL', 'PDT_CONTROL', '"Load Control"']]
    ['6' PID_GENERAL_RUN_STATE_CONTROL ['6', 'OT_GENERAL', 'PDT_CONTROL', '"Run Control"']]
    ['7' PID_GENERAL_TABLE_REFERENCE ['7', 'OT_GENERAL', 'PDT_UNSIGNED_INT', '"Table Reference"']]
    ['8' PID_GENERAL_SERVICE_CONTROL ['8', 'OT_GENERAL', 'PDT_UNSIGNED_INT', '"Service Control"']]
    ['9' PID_GENERAL_FIRMWARE_REVISION ['9', 'OT_GENERAL', 'PDT_UNSIGNED_CHAR', '"Firmware Revision"']]
    ['10' PID_GENERAL_SERVICES_SUPPORTED ['10', 'OT_GENERAL', 'PDT_UNKNOWN', '"Services Supported"']]
    ['11' PID_GENERAL_SERIAL_NUMBER ['11', 'OT_GENERAL', 'PDT_GENERIC_06', '"KNX Serial Number"']]
    ['12' PID_GENERAL_MANUFACTURER_ID ['12', 'OT_GENERAL', 'PDT_UNSIGNED_INT', '"Manufacturer Identifier"']]
    ['13' PID_GENERAL_PROGRAM_VERSION ['13', 'OT_GENERAL', 'PDT_GENERIC_05', '"Application Version"']]
    ['14' PID_GENERAL_DEVICE_CONTROL ['14', 'OT_GENERAL', 'PDT_BITSET8', '"Device Control"']]
    ['15' PID_GENERAL_ORDER_INFO ['15', 'OT_GENERAL', 'PDT_GENERIC_10', '"Order Info"']]
    ['16' PID_GENERAL_PEI_TYPE ['16', 'OT_GENERAL', 'PDT_UNSIGNED_CHAR', '"PEI Type"']]
    ['17' PID_GENERAL_PORT_CONFIGURATION ['17', 'OT_GENERAL', 'PDT_UNSIGNED_CHAR', '"PortADDR"']]
    ['18' PID_GENERAL_POLL_GROUP_SETTINGS ['18', 'OT_GENERAL', 'PDT_POLL_GROUP_SETTINGS', '"Polling Group Settings"']]
    ['19' PID_GENERAL_MANUFACTURER_DATA ['19', 'OT_GENERAL', 'PDT_GENERIC_04', '"Manufacturer Data"']]
    ['20' PID_GENERAL_ENABLE ['20', 'OT_GENERAL', 'PDT_UNKNOWN', '""']]
    ['21' PID_GENERAL_DESCRIPTION ['21', 'OT_GENERAL', 'PDT_UNSIGNED_CHAR', '"Description"']]
    ['22' PID_GENERAL_FILE ['22', 'OT_GENERAL', 'PDT_UNKNOWN', '""']]
    ['23' PID_GENERAL_TABLE ['23', 'OT_GENERAL', 'PDT_UNSIGNED_INT', '"Table"']]
    ['24' PID_GENERAL_ENROL ['24', 'OT_GENERAL', 'PDT_FUNCTION', '"Interface Object Link"']]
    ['25' PID_GENERAL_VERSION ['25', 'OT_GENERAL', 'PDT_VERSION', '"Version"']]
    ['26' PID_GENERAL_GROUP_OBJECT_LINK ['26', 'OT_GENERAL', 'PDT_FUNCTION', '"Group Address Assignment"']]
    ['27' PID_GENERAL_MCB_TABLE ['27', 'OT_GENERAL', 'PDT_GENERIC_08', '"Memory Control Table"']]
    ['28' PID_GENERAL_ERROR_CODE ['28', 'OT_GENERAL', 'PDT_GENERIC_01', '"Error Code"']]
    ['29' PID_GENERAL_OBJECT_INDEX ['29', 'OT_GENERAL', 'PDT_UNSIGNED_CHAR', '"Object Index"']]
    ['30' PID_GENERAL_DOWNLOAD_COUNTER ['30', 'OT_GENERAL', 'PDT_UNSIGNED_CHAR', '"Download Counter"']]
    ['31' PID_DEVICE_ROUTING_COUNT ['51', 'OT_DEVICE', 'PDT_UNSIGNED_CHAR', '"Routing Count"']]
    ['32' PID_DEVICE_MAX_RETRY_COUNT ['52', 'OT_DEVICE', 'PDT_GENERIC_01', '"Maximum Retry Count"']]
    ['33' PID_DEVICE_ERROR_FLAGS ['53', 'OT_DEVICE', 'PDT_UNSIGNED_CHAR', '"Error Flags"']]
    ['34' PID_DEVICE_PROGMODE ['54', 'OT_DEVICE', 'PDT_BITSET8', '"Programming Mode"']]
    ['35' PID_DEVICE_PRODUCT_ID ['55', 'OT_DEVICE', 'PDT_GENERIC_10', '"Product Identification"']]
    ['36' PID_DEVICE_MAX_APDULENGTH ['56', 'OT_DEVICE', 'PDT_UNSIGNED_INT', '"Max. APDU-Length"']]
    ['37' PID_DEVICE_SUBNET_ADDR ['57', 'OT_DEVICE', 'PDT_UNSIGNED_CHAR', '"Subnetwork Address"']]
    ['38' PID_DEVICE_DEVICE_ADDR ['58', 'OT_DEVICE', 'PDT_UNSIGNED_CHAR', '"Device Address"']]
    ['39' PID_DEVICE_PB_CONFIG ['59', 'OT_DEVICE', 'PDT_GENERIC_04', '"Config Link"']]
    ['40' PID_DEVICE_ADDR_REPORT ['60', 'OT_DEVICE', 'PDT_GENERIC_06', '""']]
    ['41' PID_DEVICE_ADDR_CHECK ['61', 'OT_DEVICE', 'PDT_GENERIC_01', '""']]
    ['42' PID_DEVICE_OBJECT_VALUE ['62', 'OT_DEVICE', 'PDT_FUNCTION', '""']]
    ['43' PID_DEVICE_OBJECTLINK ['63', 'OT_DEVICE', 'PDT_FUNCTION', '""']]
    ['44' PID_DEVICE_APPLICATION ['64', 'OT_DEVICE', 'PDT_FUNCTION', '""']]
    ['45' PID_DEVICE_PARAMETER ['65', 'OT_DEVICE', 'PDT_FUNCTION', '""']]
    ['46' PID_DEVICE_OBJECTADDRESS ['66', 'OT_DEVICE', 'PDT_FUNCTION', '""']]
    ['47' PID_DEVICE_PSU_TYPE ['67', 'OT_DEVICE', 'PDT_UNSIGNED_INT', '""']]
    ['48' PID_DEVICE_PSU_STATUS ['68', 'OT_DEVICE', 'PDT_BINARY_INFORMATION', '""']]
    ['49' PID_DEVICE_PSU_ENABLE ['69', 'OT_DEVICE', 'PDT_ENUM8', '""']]
    ['50' PID_DEVICE_DOMAIN_ADDRESS ['70', 'OT_DEVICE', 'PDT_UNSIGNED_INT', '"Domain Address"']]
    ['51' PID_DEVICE_IO_LIST ['71', 'OT_DEVICE', 'PDT_UNSIGNED_INT', '""']]
    ['52' PID_DEVICE_MGT_DESCRIPTOR_01 ['72', 'OT_DEVICE', 'PDT_GENERIC_10', '"Management Descriptor 1"']]
    ['53' PID_DEVICE_PL110_PARAM ['73', 'OT_DEVICE', 'PDT_GENERIC_01', '"PL110 Parameters"']]
    ['54' PID_DEVICE_RF_REPEAT_COUNTER ['74', 'OT_DEVICE', 'PDT_UNSIGNED_CHAR', '""']]
    ['55' PID_DEVICE_RECEIVE_BLOCK_TABLE ['75', 'OT_DEVICE', 'PDT_UNSIGNED_CHAR', '""']]
    ['56' PID_DEVICE_RANDOM_PAUSE_TABLE ['76', 'OT_DEVICE', 'PDT_UNSIGNED_CHAR', '""']]
    ['57' PID_DEVICE_RECEIVE_BLOCK_NR ['77', 'OT_DEVICE', 'PDT_UNSIGNED_CHAR', '""']]
    ['58' PID_DEVICE_HARDWARE_TYPE ['78', 'OT_DEVICE', 'PDT_GENERIC_06', '"Hardware Type"']]
    ['59' PID_DEVICE_RETRANSMITTER_NUMBER ['79', 'OT_DEVICE', 'PDT_UNSIGNED_CHAR', '""']]
    ['60' PID_DEVICE_SERIAL_NR_TABLE ['80', 'OT_DEVICE', 'PDT_GENERIC_06', '""']]
    ['61' PID_DEVICE_BIBATMASTER_ADDRESS ['81', 'OT_DEVICE', 'PDT_UNSIGNED_INT', '""']]
    ['62' PID_DEVICE_RF_DOMAIN_ADDRESS ['82', 'OT_DEVICE', 'PDT_GENERIC_06', '"RF Domain Address"']]
    ['63' PID_DEVICE_DEVICE_DESCRIPTOR ['83', 'OT_DEVICE', 'PDT_GENERIC_02', '""']]
    ['64' PID_DEVICE_METERING_FILTER_TABLE ['84', 'OT_DEVICE', 'PDT_GENERIC_08', '""']]
    ['65' PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_TIME_BASE ['85', 'OT_DEVICE', 'PDT_UNSIGNED_INT', '""']]
    ['66' PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_NO_OF_TELEGR ['86', 'OT_DEVICE', 'PDT_UNSIGNED_INT', '""']]
    ['67' PID_GROUP_OBJECT_TABLE_GRPOBJTABLE ['51', 'OT_GROUP_OBJECT_TABLE', 'PDT_GENERIC_06', '""']]
    ['68' PID_GROUP_OBJECT_TABLE_EXT_GRPOBJREFERENCE ['52', 'OT_GROUP_OBJECT_TABLE', 'PDT_GENERIC_08', '""']]
    ['69' PID_ROUTER_LINE_STATUS ['51', 'OT_ROUTER', 'PDT_GENERIC_01', '""']]
    ['70' PID_ROUTER_MAIN_LCCONFIG ['52', 'OT_ROUTER', 'PDT_GENERIC_01', '""']]
    ['71' PID_ROUTER_SUB_LCCONFIG ['53', 'OT_ROUTER', 'PDT_GENERIC_01', '""']]
    ['72' PID_ROUTER_MAIN_LCGRPCONFIG ['54', 'OT_ROUTER', 'PDT_GENERIC_01', '""']]
    ['73' PID_ROUTER_SUB_LCGRPCONFIG ['55', 'OT_ROUTER', 'PDT_GENERIC_01', '""']]
    ['74' PID_ROUTER_ROUTETABLE_CONTROL ['56', 'OT_ROUTER', 'PDT_FUNCTION', '""']]
    ['75' PID_ROUTER_COUPL_SERV_CONTROL ['57', 'OT_ROUTER', 'PDT_GENERIC_01', '""']]
    ['76' PID_ROUTER_MAX_ROUTER_APDU_LENGTH ['58', 'OT_ROUTER', 'PDT_UNSIGNED_INT', '""']]
    ['77' PID_ROUTER_MEDIUM ['63', 'OT_ROUTER', 'PDT_ENUM8', '""']]
    ['78' PID_ROUTER_FILTER_TABLE_USE ['67', 'OT_ROUTER', 'PDT_BINARY_INFORMATION', '""']]
    ['79' PID_ROUTER_RF_ENABLE_SBC ['112', 'OT_ROUTER', 'PDT_FUNCTION', '""']]
    ['80' PID_KNXIP_PARAMETER_PROJECT_INSTALLATION_ID ['51', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_INT', '"Project Installation Identification"']]
    ['81' PID_KNXIP_PARAMETER_KNX_INDIVIDUAL_ADDRESS ['52', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_INT', '"KNX Individual Address"']]
    ['82' PID_KNXIP_PARAMETER_ADDITIONAL_INDIVIDUAL_ADDRESSES ['53', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_INT', '"Additional Individual Addresses"']]
    ['83' PID_KNXIP_PARAMETER_CURRENT_IP_ASSIGNMENT_METHOD ['54', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_CHAR', '""']]
    ['84' PID_KNXIP_PARAMETER_IP_ASSIGNMENT_METHOD ['55', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_CHAR', '""']]
    ['85' PID_KNXIP_PARAMETER_IP_CAPABILITIES ['56', 'OT_KNXIP_PARAMETER', 'PDT_BITSET8', '""']]
    ['86' PID_KNXIP_PARAMETER_CURRENT_IP_ADDRESS ['57', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['87' PID_KNXIP_PARAMETER_CURRENT_SUBNET_MASK ['58', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['88' PID_KNXIP_PARAMETER_CURRENT_DEFAULT_GATEWAY ['59', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['89' PID_KNXIP_PARAMETER_IP_ADDRESS ['60', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['90' PID_KNXIP_PARAMETER_SUBNET_MASK ['61', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['91' PID_KNXIP_PARAMETER_DEFAULT_GATEWAY ['62', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['92' PID_KNXIP_PARAMETER_DHCP_BOOTP_SERVER ['63', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['93' PID_KNXIP_PARAMETER_MAC_ADDRESS ['64', 'OT_KNXIP_PARAMETER', 'PDT_GENERIC_06', '""']]
    ['94' PID_KNXIP_PARAMETER_SYSTEM_SETUP_MULTICAST_ADDRESS ['65', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['95' PID_KNXIP_PARAMETER_ROUTING_MULTICAST_ADDRESS ['66', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['96' PID_KNXIP_PARAMETER_TTL ['67', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_CHAR', '""']]
    ['97' PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_CAPABILITIES ['68', 'OT_KNXIP_PARAMETER', 'PDT_BITSET16', '""']]
    ['98' PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_STATE ['69', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_CHAR', '""']]
    ['99' PID_KNXIP_PARAMETER_KNXNETIP_ROUTING_CAPABILITIES ['70', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_CHAR', '""']]
    ['100' PID_KNXIP_PARAMETER_PRIORITY_FIFO_ENABLED ['71', 'OT_KNXIP_PARAMETER', 'PDT_BINARY_INFORMATION', '""']]
    ['101' PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_IP ['72', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_INT', '""']]
    ['102' PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_KNX ['73', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_INT', '""']]
    ['103' PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_IP ['74', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['104' PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_KNX ['75', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_LONG', '""']]
    ['105' PID_KNXIP_PARAMETER_FRIENDLY_NAME ['76', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_CHAR', '""']]
    ['106' PID_KNXIP_PARAMETER_BACKBONE_KEY ['91', 'OT_KNXIP_PARAMETER', 'PDT_GENERIC_16', '""']]
    ['107' PID_KNXIP_PARAMETER_DEVICE_AUTHENTICATION_CODE ['92', 'OT_KNXIP_PARAMETER', 'PDT_GENERIC_16', '""']]
    ['108' PID_KNXIP_PARAMETER_PASSWORD_HASHES ['93', 'OT_KNXIP_PARAMETER', 'PDT_GENERIC_16', '""']]
    ['109' PID_KNXIP_PARAMETER_SECURED_SERVICE_FAMILIES ['94', 'OT_KNXIP_PARAMETER', 'PDT_FUNCTION', '""']]
    ['110' PID_KNXIP_PARAMETER_MULTICAST_LATENCY_TOLERANCE ['95', 'OT_KNXIP_PARAMETER', 'PDT_UNSIGNED_INT', '""']]
    ['111' PID_KNXIP_PARAMETER_SYNC_LATENCY_FRACTION ['96', 'OT_KNXIP_PARAMETER', 'PDT_SCALING', '""']]
    ['112' PID_KNXIP_PARAMETER_TUNNELLING_USERS ['97', 'OT_KNXIP_PARAMETER', 'PDT_GENERIC_02', '""']]
    ['113' PID_SECURITY_SECURITY_MODE ['51', 'OT_SECURITY', 'PDT_FUNCTION', '""']]
    ['114' PID_SECURITY_P2P_KEY_TABLE ['52', 'OT_SECURITY', 'PDT_GENERIC_18', '""']]
    ['115' PID_SECURITY_GRP_KEY_TABLE ['53', 'OT_SECURITY', 'PDT_GENERIC_18', '""']]
    ['116' PID_SECURITY_SECURITY_INDIVIDUAL_ADDRESS_TABLE ['54', 'OT_SECURITY', 'PDT_GENERIC_08', '""']]
    ['117' PID_SECURITY_SECURITY_FAILURES_LOG ['55', 'OT_SECURITY', 'PDT_FUNCTION', '""']]
    ['118' PID_SECURITY_SKI_TOOL ['56', 'OT_SECURITY', 'PDT_GENERIC_16', '""']]
    ['119' PID_SECURITY_SECURITY_REPORT ['57', 'OT_SECURITY', 'PDT_BITSET8', '""']]
    ['120' PID_SECURITY_SECURITY_REPORT_CONTROL ['58', 'OT_SECURITY', 'PDT_BINARY_INFORMATION', '""']]
    ['121' PID_SECURITY_SEQUENCE_NUMBER_SENDING ['59', 'OT_SECURITY', 'PDT_GENERIC_06', '""']]
    ['122' PID_SECURITY_ZONE_KEYS_TABLE ['60', 'OT_SECURITY', 'PDT_GENERIC_19', '""']]
    ['123' PID_SECURITY_GO_SECURITY_FLAGS ['61', 'OT_SECURITY', 'PDT_GENERIC_01', '""']]
    ['124' PID_RF_MEDIUM_RF_MULTI_TYPE ['51', 'OT_RF_MEDIUM', 'PDT_GENERIC_01', '""']]
    ['125' PID_RF_MEDIUM_RF_DOMAIN_ADDRESS ['56', 'OT_RF_MEDIUM', 'PDT_GENERIC_06', '""']]
    ['126' PID_RF_MEDIUM_RF_RETRANSMITTER ['57', 'OT_RF_MEDIUM', 'PDT_BINARY_INFORMATION', '""']]
    ['127' PID_RF_MEDIUM_SECURITY_REPORT_CONTROL ['58', 'OT_RF_MEDIUM', 'PDT_BINARY_INFORMATION', '""']]
    ['128' PID_RF_MEDIUM_RF_FILTERING_MODE_SELECT ['59', 'OT_RF_MEDIUM', 'PDT_BITSET8', '""']]
    ['129' PID_RF_MEDIUM_RF_BIDIR_TIMEOUT ['60', 'OT_RF_MEDIUM', 'PDT_FUNCTION', '""']]
    ['130' PID_RF_MEDIUM_RF_DIAG_SA_FILTER_TABLE ['61', 'OT_RF_MEDIUM', 'PDT_GENERIC_03', '""']]
    ['131' PID_RF_MEDIUM_RF_DIAG_QUALITY_TABLE ['62', 'OT_RF_MEDIUM', 'PDT_GENERIC_04', '""']]
    ['132' PID_RF_MEDIUM_RF_DIAG_PROBE ['63', 'OT_RF_MEDIUM', 'PDT_FUNCTION', '""']]
    ['133' PID_INDOOR_BRIGHTNESS_SENSOR_CHANGE_OF_VALUE ['110', 'OT_INDOOR_BRIGHTNESS_SENSOR', 'PDT_UNKNOWN', '""']]
    ['134' PID_INDOOR_BRIGHTNESS_SENSOR_REPETITION_TIME ['111', 'OT_INDOOR_BRIGHTNESS_SENSOR', 'PDT_UNKNOWN', '""']]
    ['135' PID_INDOOR_LUMINANCE_SENSOR_CHANGE_OF_VALUE ['110', 'OT_INDOOR_LUMINANCE_SENSOR', 'PDT_UNKNOWN', '""']]
    ['136' PID_INDOOR_LUMINANCE_SENSOR_REPETITION_TIME ['111', 'OT_INDOOR_LUMINANCE_SENSOR', 'PDT_UNKNOWN', '""']]
    ['137' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_ON_DELAY ['101', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['138' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_OFF_DELAY ['102', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['139' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_DURATION ['103', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['140' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_PREWARNING_DURATION ['104', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['141' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME ['105', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['142' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY ['106', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['143' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING ['107', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['144' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING ['108', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['145' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP ['109', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['146' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN ['110', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['147' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_OUTPUT_STATE ['111', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['148' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION ['112', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['149' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE ['113', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['150' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE ['114', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['151' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_LOCK_STATE ['115', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['152' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_UNLOCK_STATE ['116', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['153' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STATE_FOR_SCENE_NUMBER ['117', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['154' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE ['118', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['155' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_STATE ['119', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['156' PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_2 ['120', 'OT_LIGHT_SWITCHING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['157' PID_DIMMING_ACTUATOR_BASIC_ON_DELAY ['101', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['158' PID_DIMMING_ACTUATOR_BASIC_OFF_DELAY ['102', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['159' PID_DIMMING_ACTUATOR_BASIC_SWITCH_OFF_BRIGHTNESS_DELAY_TIME ['103', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['160' PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_DURATION ['104', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['161' PID_DIMMING_ACTUATOR_BASIC_PREWARNING_DURATION ['105', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['162' PID_DIMMING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME ['106', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['163' PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY ['107', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['164' PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED ['108', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['165' PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME ['109', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['166' PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_ON_SET_VALUE ['110', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['167' PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_OFF ['111', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['168' PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_ON_SET_VALUE ['112', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['169' PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_OFF ['113', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['170' PID_DIMMING_ACTUATOR_BASIC_SWITCFH_OFF_BRIGHTNESS ['114', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['171' PID_DIMMING_ACTUATOR_BASIC_MINIMUM_SET_VALUE ['115', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['172' PID_DIMMING_ACTUATOR_BASIC_MAXIMUM_SET_VALUE ['116', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['173' PID_DIMMING_ACTUATOR_BASIC_SWITCH_ON_SET_VALUE ['117', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['174' PID_DIMMING_ACTUATOR_BASIC_DIMM_MODE_SELECTION ['118', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['175' PID_DIMMING_ACTUATOR_BASIC_RELATIV_OFF_ENABLE ['119', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['176' PID_DIMMING_ACTUATOR_BASIC_MEMORY_FUNCTION ['120', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['177' PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION ['121', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['178' PID_DIMMING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE ['122', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['179' PID_DIMMING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE ['123', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['180' PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING ['124', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['181' PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING ['125', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['182' PID_DIMMING_ACTUATOR_BASIC_LOCK_SETVALUE ['126', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['183' PID_DIMMING_ACTUATOR_BASIC_UNLOCK_SETVALUE ['127', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['184' PID_DIMMING_ACTUATOR_BASIC_BIGHTNESS_FOR_SCENE ['128', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['185' PID_DIMMING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE ['129', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['186' PID_DIMMING_ACTUATOR_BASIC_DELTA_DIMMING_VALUE ['130', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['187' PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP ['131', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['188' PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_SET_VALUE ['132', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['189' PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN ['133', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['190' PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_DOWN_SET_VALUE ['134', 'OT_DIMMING_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['191' PID_DIMMING_SENSOR_BASIC_ON_OFF_ACTION ['51', 'OT_DIMMING_SENSOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['192' PID_DIMMING_SENSOR_BASIC_ENABLE_TOGGLE_MODE ['52', 'OT_DIMMING_SENSOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['193' PID_DIMMING_SENSOR_BASIC_ABSOLUTE_SETVALUE ['53', 'OT_DIMMING_SENSOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['194' PID_SWITCHING_SENSOR_BASIC_ON_OFF_ACTION ['51', 'OT_SWITCHING_SENSOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['195' PID_SWITCHING_SENSOR_BASIC_ENABLE_TOGGLE_MODE ['52', 'OT_SWITCHING_SENSOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['196' PID_SUNBLIND_ACTUATOR_BASIC_REVERSION_PAUSE_TIME ['51', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['197' PID_SUNBLIND_ACTUATOR_BASIC_MOVE_UP_DOWN_TIME ['52', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['198' PID_SUNBLIND_ACTUATOR_BASIC_SLAT_STEP_TIME ['53', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['199' PID_SUNBLIND_ACTUATOR_BASIC_MOVE_PRESET_POSITION_TIME ['54', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['200' PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_IN_PERCENT ['55', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['201' PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_LENGTH ['57', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['202' PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_PERCENT ['58', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['203' PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_ANGLE ['60', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['204' PID_SUNBLIND_ACTUATOR_BASIC_REACTION_WIND_ALARM ['61', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['205' PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_WIND_ALARM ['62', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['206' PID_SUNBLIND_ACTUATOR_BASIC_REACTION_ON_RAIN_ALARM ['63', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['207' PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_RAIN_ALARM ['64', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['208' PID_SUNBLIND_ACTUATOR_BASIC_REACTION_FROST_ALARM ['65', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['209' PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_FROST_ALARM ['66', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['210' PID_SUNBLIND_ACTUATOR_BASIC_MAX_SLAT_MOVE_TIME ['67', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['211' PID_SUNBLIND_ACTUATOR_BASIC_ENABLE_BLINDS_MODE ['68', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['212' PID_SUNBLIND_ACTUATOR_BASIC_STORAGE_FUNCTIONS_FOR_SCENE ['69', 'OT_SUNBLIND_ACTUATOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['213' PID_SUNBLIND_SENSOR_BASIC_ENABLE_BLINDS_MODE ['51', 'OT_SUNBLIND_SENSOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['214' PID_SUNBLIND_SENSOR_BASIC_UP_DOWN_ACTION ['52', 'OT_SUNBLIND_SENSOR_BASIC', 'PDT_UNKNOWN', '""']]
    ['215' PID_SUNBLIND_SENSOR_BASIC_ENABLE_TOGGLE_MODE ['53', 'OT_SUNBLIND_SENSOR_BASIC', 'PDT_UNKNOWN', '""']]
    
]

[enum uint 8 KnxPropertyDataType(uint 8 number, uint 8 sizeInBytes, string 8 name)
    ['0' PDT_UNKNOWN    ['0', '0',  '"Unknown Property Data Type"']]
    ['1' PDT_CONTROL ['0', '10', '"PDT_CONTROL"']]
    ['2' PDT_CHAR ['1', '1', '"PDT_CHAR"']]
    ['3' PDT_UNSIGNED_CHAR ['2', '1', '"PDT_UNSIGNED_CHAR"']]
    ['4' PDT_INT ['3', '2', '"PDT_INT"']]
    ['5' PDT_UNSIGNED_INT ['4', '2', '"PDT_UNSIGNED_INT"']]
    ['6' PDT_KNX_FLOAT ['5', '2', '"PDT_KNX_FLOAT"']]
    ['7' PDT_DATE ['6', '3', '"PDT_DATE"']]
    ['8' PDT_TIME ['7', '3', '"PDT_TIME"']]
    ['9' PDT_LONG ['8', '4', '"PDT_LONG"']]
    ['10' PDT_UNSIGNED_LONG ['9', '4', '"PDT_UNSIGNED_LONG"']]
    ['11' PDT_FLOAT ['10', '4', '"PDT_FLOAT"']]
    ['12' PDT_DOUBLE ['11', '8', '"PDT_DOUBLE"']]
    ['13' PDT_CHAR_BLOCK ['12', '10', '"PDT_CHAR_BLOCK"']]
    ['14' PDT_POLL_GROUP_SETTINGS ['13', '3', '"PDT_POLL_GROUP_SETTINGS"']]
    ['15' PDT_SHORT_CHAR_BLOCK ['14', '5', '"PDT_SHORT_CHAR_BLOCK"']]
    ['16' PDT_DATE_TIME ['15', '8', '"PDT_DATE_TIME"']]
    ['17' PDT_VARIABLE_LENGTH ['16', '0', '"PDT_VARIABLE_LENGTH"']]
    ['18' PDT_GENERIC_01 ['17', '1', '"PDT_GENERIC_01"']]
    ['19' PDT_GENERIC_02 ['18', '2', '"PDT_GENERIC_02"']]
    ['20' PDT_GENERIC_03 ['19', '3', '"PDT_GENERIC_03"']]
    ['21' PDT_GENERIC_04 ['20', '4', '"PDT_GENERIC_04"']]
    ['22' PDT_GENERIC_05 ['21', '5', '"PDT_GENERIC_05"']]
    ['23' PDT_GENERIC_06 ['22', '6', '"PDT_GENERIC_06"']]
    ['24' PDT_GENERIC_07 ['23', '7', '"PDT_GENERIC_07"']]
    ['25' PDT_GENERIC_08 ['24', '8', '"PDT_GENERIC_08"']]
    ['26' PDT_GENERIC_09 ['25', '9', '"PDT_GENERIC_09"']]
    ['27' PDT_GENERIC_10 ['26', '10', '"PDT_GENERIC_10"']]
    ['28' PDT_GENERIC_11 ['27', '11', '"PDT_GENERIC_11"']]
    ['29' PDT_GENERIC_12 ['28', '12', '"PDT_GENERIC_12"']]
    ['30' PDT_GENERIC_13 ['29', '13', '"PDT_GENERIC_13"']]
    ['31' PDT_GENERIC_14 ['30', '14', '"PDT_GENERIC_14"']]
    ['32' PDT_GENERIC_15 ['31', '15', '"PDT_GENERIC_15"']]
    ['33' PDT_GENERIC_16 ['32', '16', '"PDT_GENERIC_16"']]
    ['34' PDT_GENERIC_17 ['33', '17', '"PDT_GENERIC_17"']]
    ['35' PDT_GENERIC_18 ['34', '18', '"PDT_GENERIC_18"']]
    ['36' PDT_GENERIC_19 ['35', '19', '"PDT_GENERIC_19"']]
    ['37' PDT_GENERIC_20 ['36', '20', '"PDT_GENERIC_20"']]
    ['38' PDT_UTF_8 ['47', '0', '"PDT_UTF-8"']]
    ['39' PDT_VERSION ['48', '2', '"PDT_VERSION"']]
    ['40' PDT_ALARM_INFO ['49', '6', '"PDT_ALARM_INFO"']]
    ['41' PDT_BINARY_INFORMATION ['50', '1', '"PDT_BINARY_INFORMATION"']]
    ['42' PDT_BITSET8 ['51', '1', '"PDT_BITSET8"']]
    ['43' PDT_BITSET16 ['52', '2', '"PDT_BITSET16"']]
    ['44' PDT_ENUM8 ['53', '1', '"PDT_ENUM8"']]
    ['45' PDT_SCALING ['54', '1', '"PDT_SCALING"']]
    ['46' PDT_NE_VL ['60', '0', '"PDT_NE_VL"']]
    ['47' PDT_NE_FL ['61', '0', '"PDT_NE_FL"']]
    ['48' PDT_FUNCTION ['62', '0', '"PDT_FUNCTION"']]
    ['49' PDT_ESCAPE ['63', '0', '"PDT_ESCAPE"']]
    
]

[enum uint 16 KnxManufacturer(uint 16 number, string 8 name)
    ['0' M_UNKNOWN ['0', '"Unknown Manufacturer"']]
    ['1' M_SIEMENS ['1', '"Siemens"']]
    ['2' M_ABB ['2', '"ABB"']]
    ['3' M_ALBRECHT_JUNG ['4', '"Albrecht Jung"']]
    ['4' M_BTICINO ['5', '"Bticino"']]
    ['5' M_BERKER ['6', '"Berker"']]
    ['6' M_BUSCH_JAEGER_ELEKTRO ['7', '"Busch-Jaeger Elektro"']]
    ['7' M_GIRA_GIERSIEPEN ['8', '"GIRA Giersiepen"']]
    ['8' M_HAGER_ELECTRO ['9', '"Hager Electro"']]
    ['9' M_INSTA_GMBH ['10', '"Insta GmbH"']]
    ['10' M_LEGRAND_APPAREILLAGE_ELECTRIQUE ['11', '"LEGRAND Appareillage électrique"']]
    ['11' M_MERTEN ['12', '"Merten"']]
    ['12' M_ABB_SPA_SACE_DIVISION ['14', '"ABB SpA-SACE Division"']]
    ['13' M_SIEDLE_AND_SOEHNE ['22', '"Siedle & Söhne"']]
    ['14' M_EBERLE ['24', '"Eberle"']]
    ['15' M_GEWISS ['25', '"GEWISS"']]
    ['16' M_ALBERT_ACKERMANN ['27', '"Albert Ackermann"']]
    ['17' M_SCHUPA_GMBH ['28', '"Schupa GmbH"']]
    ['18' M_ABB_SCHWEIZ ['29', '"ABB SCHWEIZ"']]
    ['19' M_FELLER ['30', '"Feller"']]
    ['20' M_GLAMOX_AS ['31', '"Glamox AS"']]
    ['21' M_DEHN_AND_SOEHNE ['32', '"DEHN & SÖHNE"']]
    ['22' M_CRABTREE ['33', '"CRABTREE"']]
    ['23' M_EVOKNX ['34', '"eVoKNX"']]
    ['24' M_PAUL_HOCHKOEPPER ['36', '"Paul Hochköpper"']]
    ['25' M_ALTENBURGER_ELECTRONIC ['37', '"Altenburger Electronic"']]
    ['26' M_GRAESSLIN ['41', '"Grässlin"']]
    ['27' M_SIMON_42 ['42', '"Simon"']]
    ['28' M_VIMAR ['44', '"VIMAR"']]
    ['29' M_MOELLER_GEBAEUDEAUTOMATION_KG ['45', '"Moeller Gebäudeautomation KG"']]
    ['30' M_ELTAKO ['46', '"Eltako"']]
    ['31' M_BOSCH_SIEMENS_HAUSHALTSGERAETE ['49', '"Bosch-Siemens Haushaltsgeräte"']]
    ['32' M_RITTO_GMBHANDCO_KG ['52', '"RITTO GmbH&Co.KG"']]
    ['33' M_POWER_CONTROLS ['53', '"Power Controls"']]
    ['34' M_ZUMTOBEL ['55', '"ZUMTOBEL"']]
    ['35' M_HOLEC_SYSTEMEN ['56', '"HOLEC Systemen"']]
    ['36' M_PHOENIX_CONTACT ['57', '"Phoenix Contact"']]
    ['37' M_WAGO_GMBH_AND_CO_KG ['61', '"WAGO GmbH & Co.KG"']]
    ['38' M_KNXPRESSO ['62', '"knXpresso"']]
    ['39' M_WIELAND_ELECTRIC ['66', '"Wieland Electric"']]
    ['40' M_HERMANN_KLEINHUIS ['67', '"Hermann Kleinhuis"']]
    ['41' M_STIEBEL_ELTRON ['69', '"Stiebel Eltron"']]
    ['42' M_TEHALIT ['71', '"Tehalit"']]
    ['43' M_THEBEN_AG ['72', '"Theben AG"']]
    ['44' M_WILHELM_RUTENBECK ['73', '"Wilhelm Rutenbeck"']]
    ['45' M_WINKHAUS ['75', '"Winkhaus"']]
    ['46' M_ROBERT_BOSCH ['76', '"Robert Bosch"']]
    ['47' M_SOMFY ['78', '"Somfy"']]
    ['48' M_WOERTZ ['80', '"Woertz"']]
    ['49' M_VIESSMANN_WERKE ['81', '"Viessmann Werke"']]
    ['50' M_IMI_HYDRONIC_ENGINEERING ['82', '"IMI Hydronic Engineering"']]
    ['51' M_JOH__VAILLANT ['83', '"Joh. Vaillant"']]
    ['52' M_AMP_DEUTSCHLAND ['85', '"AMP Deutschland"']]
    ['53' M_BOSCH_THERMOTECHNIK_GMBH ['89', '"Bosch Thermotechnik GmbH"']]
    ['54' M_SEF___ECOTEC ['90', '"SEF - ECOTEC"']]
    ['55' M_DORMA_GMBH_Plus_CO__KG ['92', '"DORMA GmbH + Co. KG"']]
    ['56' M_WINDOWMASTER_AS ['93', '"WindowMaster A/S"']]
    ['57' M_WALTHER_WERKE ['94', '"Walther Werke"']]
    ['58' M_ORAS ['95', '"ORAS"']]
    ['59' M_DAETWYLER ['97', '"Dätwyler"']]
    ['60' M_ELECTRAK ['98', '"Electrak"']]
    ['61' M_TECHEM ['99', '"Techem"']]
    ['62' M_SCHNEIDER_ELECTRIC_INDUSTRIES_SAS ['100', '"Schneider Electric Industries SAS"']]
    ['63' M_WHD_WILHELM_HUBER_Plus_SOEHNE ['101', '"WHD Wilhelm Huber + Söhne"']]
    ['64' M_BISCHOFF_ELEKTRONIK ['102', '"Bischoff Elektronik"']]
    ['65' M_JEPAZ ['104', '"JEPAZ"']]
    ['66' M_RTS_AUTOMATION ['105', '"RTS Automation"']]
    ['67' M_EIBMARKT_GMBH ['106', '"EIBMARKT GmbH"']]
    ['68' M_WAREMA_RENKHOFF_SE ['107', '"WAREMA Renkhoff SE"']]
    ['69' M_EELECTRON ['108', '"Eelectron"']]
    ['70' M_BELDEN_WIRE_AND_CABLE_B_V_ ['109', '"Belden Wire & Cable B.V."']]
    ['71' M_BECKER_ANTRIEBE_GMBH ['110', '"Becker-Antriebe GmbH"']]
    ['72' M_J_STEHLEPlusSOEHNE_GMBH ['111', '"J.Stehle+Söhne GmbH"']]
    ['73' M_AGFEO ['112', '"AGFEO"']]
    ['74' M_ZENNIO ['113', '"Zennio"']]
    ['75' M_TAPKO_TECHNOLOGIES ['114', '"TAPKO Technologies"']]
    ['76' M_HDL ['115', '"HDL"']]
    ['77' M_UPONOR ['116', '"Uponor"']]
    ['78' M_SE_LIGHTMANAGEMENT_AG ['117', '"se Lightmanagement AG"']]
    ['79' M_ARCUS_EDS ['118', '"Arcus-eds"']]
    ['80' M_INTESIS ['119', '"Intesis"']]
    ['81' M_HERHOLDT_CONTROLS_SRL ['120', '"Herholdt Controls srl"']]
    ['82' M_NIKO_ZUBLIN ['121', '"Niko-Zublin"']]
    ['83' M_DURABLE_TECHNOLOGIES ['122', '"Durable Technologies"']]
    ['84' M_INNOTEAM ['123', '"Innoteam"']]
    ['85' M_ISE_GMBH ['124', '"ise GmbH"']]
    ['86' M_TEAM_FOR_TRONICS ['125', '"TEAM FOR TRONICS"']]
    ['87' M_CARRIER_SAS ['126', '"CARRIER SAS"']]
    ['88' M_REMEHA_BV ['127', '"Remeha BV"']]
    ['89' M_ESYLUX ['128', '"ESYLUX"']]
    ['90' M_BASALTE ['129', '"BASALTE"']]
    ['91' M_VESTAMATIC ['130', '"Vestamatic"']]
    ['92' M_MDT_TECHNOLOGIES ['131', '"MDT technologies"']]
    ['93' M_WARENDORFER_KUECHEN_GMBH ['132', '"Warendorfer Küchen GmbH"']]
    ['94' M_GVS ['133', '"GVS"']]
    ['95' M_SITEK ['134', '"Sitek"']]
    ['96' M_CONTROLTRONIC ['135', '"CONTROLtronic"']]
    ['97' M_FUNCTION_TECHNOLOGY ['136', '"function Technology"']]
    ['98' M_AMX ['137', '"AMX"']]
    ['99' M_ELDAT ['138', '"ELDAT"']]
    ['100' M_PANASONIC ['139', '"Panasonic"']]
    ['101' M_PULSE_TECHNOLOGIES ['140', '"Pulse Technologies"']]
    ['102' M_CRESTRON ['141', '"Crestron"']]
    ['103' M_STEINEL_PROFESSIONAL ['142', '"STEINEL professional"']]
    ['104' M_BILTON_LED_LIGHTING ['143', '"BILTON LED Lighting"']]
    ['105' M_DENRO_AG ['144', '"denro AG"']]
    ['106' M_GEPRO ['145', '"GePro"']]
    ['107' M_PREUSSEN_AUTOMATION ['146', '"preussen automation"']]
    ['108' M_ZOPPAS_INDUSTRIES ['147', '"Zoppas Industries"']]
    ['109' M_MACTECH ['148', '"MACTECH"']]
    ['110' M_TECHNO_TREND ['149', '"TECHNO-TREND"']]
    ['111' M_FS_CABLES ['150', '"FS Cables"']]
    ['112' M_DELTA_DORE ['151', '"Delta Dore"']]
    ['113' M_EISSOUND ['152', '"Eissound"']]
    ['114' M_CISCO ['153', '"Cisco"']]
    ['115' M_DINUY ['154', '"Dinuy"']]
    ['116' M_IKNIX ['155', '"iKNiX"']]
    ['117' M_RADEMACHER_GERAETE_ELEKTRONIK_GMBH ['156', '"Rademacher Geräte-Elektronik GmbH"']]
    ['118' M_EGI_ELECTROACUSTICA_GENERAL_IBERICA ['157', '"EGi Electroacustica General Iberica"']]
    ['119' M_BES___INGENIUM ['158', '"Bes – Ingenium"']]
    ['120' M_ELABNET ['159', '"ElabNET"']]
    ['121' M_BLUMOTIX ['160', '"Blumotix"']]
    ['122' M_HUNTER_DOUGLAS ['161', '"Hunter Douglas"']]
    ['123' M_APRICUM ['162', '"APRICUM"']]
    ['124' M_TIANSU_AUTOMATION ['163', '"TIANSU Automation"']]
    ['125' M_BUBENDORFF ['164', '"Bubendorff"']]
    ['126' M_MBS_GMBH ['165', '"MBS GmbH"']]
    ['127' M_ENERTEX_BAYERN_GMBH ['166', '"Enertex Bayern GmbH"']]
    ['128' M_BMS ['167', '"BMS"']]
    ['129' M_SINAPSI ['168', '"Sinapsi"']]
    ['130' M_EMBEDDED_SYSTEMS_SIA ['169', '"Embedded Systems SIA"']]
    ['131' M_KNX1 ['170', '"KNX1"']]
    ['132' M_TOKKA ['171', '"Tokka"']]
    ['133' M_NANOSENSE ['172', '"NanoSense"']]
    ['134' M_PEAR_AUTOMATION_GMBH ['173', '"PEAR Automation GmbH"']]
    ['135' M_DGA ['174', '"DGA"']]
    ['136' M_LUTRON ['175', '"Lutron"']]
    ['137' M_AIRZONE___ALTRA ['176', '"AIRZONE – ALTRA"']]
    ['138' M_LITHOSS_DESIGN_SWITCHES ['177', '"Lithoss Design Switches"']]
    ['139' M_THREEATEL ['178', '"3ATEL"']]
    ['140' M_PHILIPS_CONTROLS ['179', '"Philips Controls"']]
    ['141' M_VELUX_AS ['180', '"VELUX A/S"']]
    ['142' M_LOYTEC ['181', '"LOYTEC"']]
    ['143' M_EKINEX_S_P_A_ ['182', '"Ekinex S.p.A."']]
    ['144' M_SIRLAN_TECHNOLOGIES ['183', '"SIRLAN Technologies"']]
    ['145' M_PROKNX_SAS ['184', '"ProKNX SAS"']]
    ['146' M_IT_GMBH ['185', '"IT GmbH"']]
    ['147' M_RENSON ['186', '"RENSON"']]
    ['148' M_HEP_GROUP ['187', '"HEP Group"']]
    ['149' M_BALMART ['188', '"Balmart"']]
    ['150' M_GFS_GMBH ['189', '"GFS GmbH"']]
    ['151' M_SCHENKER_STOREN_AG ['190', '"Schenker Storen AG"']]
    ['152' M_ALGODUE_ELETTRONICA_S_R_L_ ['191', '"Algodue Elettronica S.r.L."']]
    ['153' M_ABB_FRANCE ['192', '"ABB France"']]
    ['154' M_MAINTRONIC ['193', '"maintronic"']]
    ['155' M_VANTAGE ['194', '"Vantage"']]
    ['156' M_FORESIS ['195', '"Foresis"']]
    ['157' M_RESEARCH_AND_PRODUCTION_ASSOCIATION_SEM ['196', '"Research & Production Association SEM"']]
    ['158' M_WEINZIERL_ENGINEERING_GMBH ['197', '"Weinzierl Engineering GmbH"']]
    ['159' M_MOEHLENHOFF_WAERMETECHNIK_GMBH ['198', '"Möhlenhoff Wärmetechnik GmbH"']]
    ['160' M_PKC_GROUP_OYJ ['199', '"PKC-GROUP Oyj"']]
    ['161' M_B_E_G_ ['200', '"B.E.G."']]
    ['162' M_ELSNER_ELEKTRONIK_GMBH ['201', '"Elsner Elektronik GmbH"']]
    ['163' M_SIEMENS_BUILDING_TECHNOLOGIES_HKCHINA_LTD_ ['202', '"Siemens Building Technologies (HK/China) Ltd."']]
    ['164' M_EUTRAC ['204', '"Eutrac"']]
    ['165' M_GUSTAV_HENSEL_GMBH_AND_CO__KG ['205', '"Gustav Hensel GmbH & Co. KG"']]
    ['166' M_GARO_AB ['206', '"GARO AB"']]
    ['167' M_WALDMANN_LICHTTECHNIK ['207', '"Waldmann Lichttechnik"']]
    ['168' M_SCHUECO ['208', '"SCHÜCO"']]
    ['169' M_EMU ['209', '"EMU"']]
    ['170' M_JNET_SYSTEMS_AG ['210', '"JNet Systems AG"']]
    ['171' M_TOTAL_SOLUTION_GMBH ['211', '"Total Solution GmbH"']]
    ['172' M_O_Y_L__ELECTRONICS ['214', '"O.Y.L. Electronics"']]
    ['173' M_GALAX_SYSTEM ['215', '"Galax System"']]
    ['174' M_DISCH ['216', '"Disch"']]
    ['175' M_AUCOTEAM ['217', '"Aucoteam"']]
    ['176' M_LUXMATE_CONTROLS ['218', '"Luxmate Controls"']]
    ['177' M_DANFOSS ['219', '"Danfoss"']]
    ['178' M_AST_GMBH ['220', '"AST GmbH"']]
    ['179' M_WILA_LEUCHTEN ['222', '"WILA Leuchten"']]
    ['180' M_BPlusB_AUTOMATIONS__UND_STEUERUNGSTECHNIK ['223', '"b+b Automations- und Steuerungstechnik"']]
    ['181' M_LINGG_AND_JANKE ['225', '"Lingg & Janke"']]
    ['182' M_SAUTER ['227', '"Sauter"']]
    ['183' M_SIMU ['228', '"SIMU"']]
    ['184' M_THEBEN_HTS_AG ['232', '"Theben HTS AG"']]
    ['185' M_AMANN_GMBH ['233', '"Amann GmbH"']]
    ['186' M_BERG_ENERGIEKONTROLLSYSTEME_GMBH ['234', '"BERG Energiekontrollsysteme GmbH"']]
    ['187' M_HUEPPE_FORM_SONNENSCHUTZSYSTEME_GMBH ['235', '"Hüppe Form Sonnenschutzsysteme GmbH"']]
    ['188' M_OVENTROP_KG ['237', '"Oventrop KG"']]
    ['189' M_GRIESSER_AG ['238', '"Griesser AG"']]
    ['190' M_IPAS_GMBH ['239', '"IPAS GmbH"']]
    ['191' M_ELERO_GMBH ['240', '"elero GmbH"']]
    ['192' M_ARDAN_PRODUCTION_AND_INDUSTRIAL_CONTROLS_LTD_ ['241', '"Ardan Production and Industrial Controls Ltd."']]
    ['193' M_METEC_MESSTECHNIK_GMBH ['242', '"Metec Meßtechnik GmbH"']]
    ['194' M_BUERK_MOBATIME ['243', '"BÜRK MOBATIME"']]
    ['195' M_ELKA_ELEKTRONIK_GMBH ['244', '"ELKA-Elektronik GmbH"']]
    ['196' M_ELEKTROANLAGEN_D__NAGEL ['245', '"ELEKTROANLAGEN D. NAGEL"']]
    ['197' M_TRIDONIC_BAUELEMENTE_GMBH ['246', '"Tridonic Bauelemente GmbH"']]
    ['198' M_STENGLER_GESELLSCHAFT ['248', '"Stengler Gesellschaft"']]
    ['199' M_SCHNEIDER_ELECTRIC_MG ['249', '"Schneider Electric (MG)"']]
    ['200' M_KNX_ASSOCIATION ['250', '"KNX Association"']]
    ['201' M_VIVO ['251', '"VIVO"']]
    ['202' M_HUGO_MUELLER_GMBH_AND_CO_KG ['252', '"Hugo Müller GmbH & Co KG"']]
    ['203' M_SIEMENS_HVAC ['253', '"Siemens HVAC"']]
    ['204' M_APT ['254', '"APT"']]
    ['205' M_HIGHDOM ['256', '"HighDom"']]
    ['206' M_TOP_SERVICES ['257', '"Top Services"']]
    ['207' M_AMBIHOME ['258', '"ambiHome"']]
    ['208' M_DATEC_ELECTRONIC_AG ['259', '"DATEC electronic AG"']]
    ['209' M_ABUS_SECURITY_CENTER ['260', '"ABUS Security-Center"']]
    ['210' M_LITE_PUTER ['261', '"Lite-Puter"']]
    ['211' M_TANTRON_ELECTRONIC ['262', '"Tantron Electronic"']]
    ['212' M_INTERRA ['263', '"Interra"']]
    ['213' M_DKX_TECH ['264', '"DKX Tech"']]
    ['214' M_VIATRON ['265', '"Viatron"']]
    ['215' M_NAUTIBUS ['266', '"Nautibus"']]
    ['216' M_ON_SEMICONDUCTOR ['267', '"ON Semiconductor"']]
    ['217' M_LONGCHUANG ['268', '"Longchuang"']]
    ['218' M_AIR_ON_AG ['269', '"Air-On AG"']]
    ['219' M_IB_COMPANY_GMBH ['270', '"ib-company GmbH"']]
    ['220' M_SATION_FACTORY ['271', '"Sation Factory"']]
    ['221' M_AGENTILO_GMBH ['272', '"Agentilo GmbH"']]
    ['222' M_MAKEL_ELEKTRIK ['273', '"Makel Elektrik"']]
    ['223' M_HELIOS_VENTILATOREN ['274', '"Helios Ventilatoren"']]
    ['224' M_OTTO_SOLUTIONS_PTE_LTD ['275', '"Otto Solutions Pte Ltd"']]
    ['225' M_AIRMASTER ['276', '"Airmaster"']]
    ['226' M_VALLOX_GMBH ['277', '"Vallox GmbH"']]
    ['227' M_DALITEK ['278', '"Dalitek"']]
    ['228' M_ASIN ['279', '"ASIN"']]
    ['229' M_BRIDGES_INTELLIGENCE_TECHNOLOGY_INC_ ['280', '"Bridges Intelligence Technology Inc."']]
    ['230' M_ARBONIA ['281', '"ARBONIA"']]
    ['231' M_KERMI ['282', '"KERMI"']]
    ['232' M_PROLUX ['283', '"PROLUX"']]
    ['233' M_CLICHOME ['284', '"ClicHome"']]
    ['234' M_COMMAX ['285', '"COMMAX"']]
    ['235' M_EAE ['286', '"EAE"']]
    ['236' M_TENSE ['287', '"Tense"']]
    ['237' M_SEYOUNG_ELECTRONICS ['288', '"Seyoung Electronics"']]
    ['238' M_LIFEDOMUS ['289', '"Lifedomus"']]
    ['239' M_EUROTRONIC_TECHNOLOGY_GMBH ['290', '"EUROtronic Technology GmbH"']]
    ['240' M_TCI ['291', '"tci"']]
    ['241' M_RISHUN_ELECTRONIC ['292', '"Rishun Electronic"']]
    ['242' M_ZIPATO ['293', '"Zipato"']]
    ['243' M_CM_SECURITY_GMBH_AND_CO_KG ['294', '"cm-security GmbH & Co KG"']]
    ['244' M_QING_CABLES ['295', '"Qing Cables"']]
    ['245' M_WOLF ['296', '"WOLF"']]
    ['246' M_COSTER_TECNOLOGIE_ELETTRONICHE_S_P_A_ ['297', '"Coster Tecnologie Elettroniche S.p.A."']]
    ['247' M_E_G_E ['298', '"E.G.E"']]
    ['248' M_NETXAUTOMATION ['299', '"NETxAutomation"']]
    ['249' M_TECALOR ['300', '"tecalor"']]
    ['250' M_URMET_ELECTRONICS_HUIZHOU_LTD_ ['301', '"Urmet Electronics (Huizhou) Ltd."']]
    ['251' M_PEIYING_BUILDING_CONTROL ['302', '"Peiying Building Control"']]
    ['252' M_BPT_S_P_A__A_SOCIO_UNICO ['303', '"BPT S.p.A. a Socio Unico"']]
    ['253' M_KANONTEC___KANONBUS ['304', '"Kanontec - KanonBUS"']]
    ['254' M_ISER_TECH ['305', '"ISER Tech"']]
    ['255' M_FINELINE ['306', '"Fineline"']]
    ['256' M_CP_ELECTRONICS_LTD ['307', '"CP Electronics Ltd"']]
    ['257' M_NIKO_SERVODAN_AS ['308', '"Niko-Servodan A/S"']]
    ['258' M_SIMON_309 ['309', '"Simon"']]
    ['259' M_GM_MODULAR_PVT__LTD_ ['310', '"GM modular pvt. Ltd."']]
    ['260' M_FU_CHENG_INTELLIGENCE ['311', '"FU CHENG Intelligence"']]
    ['261' M_NEXKON ['312', '"NexKon"']]
    ['262' M_FEEL_S_R_L ['313', '"FEEL s.r.l"']]
    ['263' M_NOT_ASSIGNED_314 ['314', '"Not Assigned"']]
    ['264' M_SHENZHEN_FANHAI_SANJIANG_ELECTRONICS_CO___LTD_ ['315', '"Shenzhen Fanhai Sanjiang Electronics Co., Ltd."']]
    ['265' M_JIUZHOU_GREEBLE ['316', '"Jiuzhou Greeble"']]
    ['266' M_AUMUELLER_AUMATIC_GMBH ['317', '"Aumüller Aumatic GmbH"']]
    ['267' M_ETMAN_ELECTRIC ['318', '"Etman Electric"']]
    ['268' M_BLACK_NOVA ['319', '"Black Nova"']]
    ['269' M_ZIDATECH_AG ['320', '"ZidaTech AG"']]
    ['270' M_IDGS_BVBA ['321', '"IDGS bvba"']]
    ['271' M_DAKANIMO ['322', '"dakanimo"']]
    ['272' M_TREBOR_AUTOMATION_AB ['323', '"Trebor Automation AB"']]
    ['273' M_SATEL_SP__Z_O_O_ ['324', '"Satel sp. z o.o."']]
    ['274' M_RUSSOUND__INC_ ['325', '"Russound, Inc."']]
    ['275' M_MIDEA_HEATING_AND_VENTILATING_EQUIPMENT_CO_LTD ['326', '"Midea Heating & Ventilating Equipment CO LTD"']]
    ['276' M_CONSORZIO_TERRANUOVA ['327', '"Consorzio Terranuova"']]
    ['277' M_WOLF_HEIZTECHNIK_GMBH ['328', '"Wolf Heiztechnik GmbH"']]
    ['278' M_SONTEC ['329', '"SONTEC"']]
    ['279' M_BELCOM_CABLES_LTD_ ['330', '"Belcom Cables Ltd."']]
    ['280' M_GUANGZHOU_SEAWIN_ELECTRICAL_TECHNOLOGIES_CO___LTD_ ['331', '"Guangzhou SeaWin Electrical Technologies Co., Ltd."']]
    ['281' M_ACREL ['332', '"Acrel"']]
    ['282' M_KWC_AQUAROTTER_GMBH ['333', '"KWC Aquarotter GmbH"']]
    ['283' M_ORION_SYSTEMS ['334', '"Orion Systems"']]
    ['284' M_SCHRACK_TECHNIK_GMBH ['335', '"Schrack Technik GmbH"']]
    ['285' M_INSPRID ['336', '"INSPRID"']]
    ['286' M_SUNRICHER ['337', '"Sunricher"']]
    ['287' M_MENRED_AUTOMATION_SYSTEMSHANGHAI_CO__LTD_ ['338', '"Menred automation system(shanghai) Co.,Ltd."']]
    ['288' M_AUREX ['339', '"Aurex"']]
    ['289' M_JOSEF_BARTHELME_GMBH_AND_CO__KG ['340', '"Josef Barthelme GmbH & Co. KG"']]
    ['290' M_ARCHITECTURE_NUMERIQUE ['341', '"Architecture Numerique"']]
    ['291' M_UP_GROUP ['342', '"UP GROUP"']]
    ['292' M_TEKNOS_AVINNO ['343', '"Teknos-Avinno"']]
    ['293' M_NINGBO_DOOYA_MECHANIC_AND_ELECTRONIC_TECHNOLOGY ['344', '"Ningbo Dooya Mechanic & Electronic Technology"']]
    ['294' M_THERMOKON_SENSORTECHNIK_GMBH ['345', '"Thermokon Sensortechnik GmbH"']]
    ['295' M_BELIMO_AUTOMATION_AG ['346', '"BELIMO Automation AG"']]
    ['296' M_ZEHNDER_GROUP_INTERNATIONAL_AG ['347', '"Zehnder Group International AG"']]
    ['297' M_SKS_KINKEL_ELEKTRONIK ['348', '"sks Kinkel Elektronik"']]
    ['298' M_ECE_WURMITZER_GMBH ['349', '"ECE Wurmitzer GmbH"']]
    ['299' M_LARS ['350', '"LARS"']]
    ['300' M_URC ['351', '"URC"']]
    ['301' M_LIGHTCONTROL ['352', '"LightControl"']]
    ['302' M_SHENZHEN_YM ['353', '"ShenZhen YM"']]
    ['303' M_MEAN_WELL_ENTERPRISES_CO__LTD_ ['354', '"MEAN WELL Enterprises Co. Ltd."']]
    ['304' M_OSIX ['355', '"OSix"']]
    ['305' M_AYPRO_TECHNOLOGY ['356', '"AYPRO Technology"']]
    ['306' M_HEFEI_ECOLITE_SOFTWARE ['357', '"Hefei Ecolite Software"']]
    ['307' M_ENNO ['358', '"Enno"']]
    ['308' M_OHOSURE ['359', '"OHOSURE"']]
    ['309' M_GAREFOWL ['360', '"Garefowl"']]
    ['310' M_GEZE ['361', '"GEZE"']]
    ['311' M_LG_ELECTRONICS_INC_ ['362', '"LG Electronics Inc."']]
    ['312' M_SMC_INTERIORS ['363', '"SMC interiors"']]
    ['313' M_NOT_ASSIGNED_364 ['364', '"Not Assigned"']]
    ['314' M_SCS_CABLE ['365', '"SCS Cable"']]
    ['315' M_HOVAL ['366', '"Hoval"']]
    ['316' M_CANST ['367', '"CANST"']]
    ['317' M_HANGZHOU_BERLIN ['368', '"HangZhou Berlin"']]
    ['318' M_EVN_LICHTTECHNIK ['369', '"EVN-Lichttechnik"']]
    ['319' M_RUTEC ['370', '"rutec"']]
    ['320' M_FINDER ['371', '"Finder"']]
    ['321' M_FUJITSU_GENERAL_LIMITED ['372', '"Fujitsu General Limited"']]
    ['322' M_ZF_FRIEDRICHSHAFEN_AG ['373', '"ZF Friedrichshafen AG"']]
    ['323' M_CREALED ['374', '"Crealed"']]
    ['324' M_MILES_MAGIC_AUTOMATION_PRIVATE_LIMITED ['375', '"Miles Magic Automation Private Limited"']]
    ['325' M_EPlus ['376', '"E+"']]
    ['326' M_ITALCOND ['377', '"Italcond"']]
    ['327' M_SATION ['378', '"SATION"']]
    ['328' M_NEWBEST ['379', '"NewBest"']]
    ['329' M_GDS_DIGITAL_SYSTEMS ['380', '"GDS DIGITAL SYSTEMS"']]
    ['330' M_IDDERO ['381', '"Iddero"']]
    ['331' M_MBNLED ['382', '"MBNLED"']]
    ['332' M_VITRUM ['383', '"VITRUM"']]
    ['333' M_EKEY_BIOMETRIC_SYSTEMS_GMBH ['384', '"ekey biometric systems GmbH"']]
    ['334' M_AMC ['385', '"AMC"']]
    ['335' M_TRILUX_GMBH_AND_CO__KG ['386', '"TRILUX GmbH & Co. KG"']]
    ['336' M_WEXCEDO ['387', '"WExcedo"']]
    ['337' M_VEMER_SPA ['388', '"VEMER SPA"']]
    ['338' M_ALEXANDER_BUERKLE_GMBH_AND_CO_KG ['389', '"Alexander Bürkle GmbH & Co KG"']]
    ['339' M_CITRON ['390', '"Citron"']]
    ['340' M_SHENZHEN_HEGUANG ['391', '"Shenzhen HeGuang"']]
    ['341' M_NOT_ASSIGNED_392 ['392', '"Not Assigned"']]
    ['342' M_TRANE_B_V_B_A ['393', '"TRANE B.V.B.A"']]
    ['343' M_CAREL ['394', '"CAREL"']]
    ['344' M_PROLITE_CONTROLS ['395', '"Prolite Controls"']]
    ['345' M_BOSMER ['396', '"BOSMER"']]
    ['346' M_EUCHIPS ['397', '"EUCHIPS"']]
    ['347' M_CONNECT_THINKA_CONNECT ['398', '"connect (Thinka connect)"']]
    ['348' M_PEAKNX_A_DOGAWIST_COMPANY ['399', '"PEAKnx a DOGAWIST company"']]
    ['349' M_ACEMATIC ['400', '"ACEMATIC"']]
    ['350' M_ELAUSYS ['401', '"ELAUSYS"']]
    ['351' M_ITK_ENGINEERING_AG ['402', '"ITK Engineering AG"']]
    ['352' M_INTEGRA_METERING_AG ['403', '"INTEGRA METERING AG"']]
    ['353' M_FMS_HOSPITALITY_PTE_LTD ['404', '"FMS Hospitality Pte Ltd"']]
    ['354' M_NUVO ['405', '"Nuvo"']]
    ['355' M_U__LUX_GMBH ['406', '"u::Lux GmbH"']]
    ['356' M_BRUMBERG_LEUCHTEN ['407', '"Brumberg Leuchten"']]
    ['357' M_LIME ['408', '"Lime"']]
    ['358' M_GREAT_EMPIRE_INTERNATIONAL_GROUP_CO___LTD_ ['409', '"Great Empire International Group Co., Ltd."']]
    ['359' M_KAVOSHPISHRO_ASIA ['410', '"Kavoshpishro Asia"']]
    ['360' M_V2_SPA ['411', '"V2 SpA"']]
    ['361' M_JOHNSON_CONTROLS ['412', '"Johnson Controls"']]
    ['362' M_ARKUD ['413', '"Arkud"']]
    ['363' M_IRIDI_LTD_ ['414', '"iRidi Ltd."']]
    ['364' M_BSMART ['415', '"bsmart"']]
    ['365' M_BAB_TECHNOLOGIE_GMBH ['416', '"BAB TECHNOLOGIE GmbH"']]
    ['366' M_NICE_SPA ['417', '"NICE Spa"']]
    ['367' M_REDFISH_GROUP_PTY_LTD ['418', '"Redfish Group Pty Ltd"']]
    ['368' M_SABIANA_SPA ['419', '"SABIANA spa"']]
    ['369' M_UBEE_INTERACTIVE_EUROPE ['420', '"Ubee Interactive Europe"']]
    ['370' M_REXEL ['421', '"Rexel"']]
    ['371' M_GES_TEKNIK_A_S_ ['422', '"Ges Teknik A.S."']]
    ['372' M_AVE_S_P_A_ ['423', '"Ave S.p.A."']]
    ['373' M_ZHUHAI_LTECH_TECHNOLOGY_CO___LTD_ ['424', '"Zhuhai Ltech Technology Co., Ltd."']]
    ['374' M_ARCOM ['425', '"ARCOM"']]
    ['375' M_VIA_TECHNOLOGIES__INC_ ['426', '"VIA Technologies, Inc."']]
    ['376' M_FEELSMART_ ['427', '"FEELSMART."']]
    ['377' M_SUPCON ['428', '"SUPCON"']]
    ['378' M_MANIC ['429', '"MANIC"']]
    ['379' M_TDE_GMBH ['430', '"TDE GmbH"']]
    ['380' M_NANJING_SHUFAN_INFORMATION_TECHNOLOGY_CO__LTD_ ['431', '"Nanjing Shufan Information technology Co.,Ltd."']]
    ['381' M_EWTECH ['432', '"EWTech"']]
    ['382' M_KLUGER_AUTOMATION_GMBH ['433', '"Kluger Automation GmbH"']]
    ['383' M_JOONGANG_CONTROL ['434', '"JoongAng Control"']]
    ['384' M_GREENCONTROLS_TECHNOLOGY_SDN__BHD_ ['435', '"GreenControls Technology Sdn. Bhd."']]
    ['385' M_IME_S_P_A_ ['436', '"IME S.p.a."']]
    ['386' M_SICHUAN_HAODING ['437', '"SiChuan HaoDing"']]
    ['387' M_MINDJAGA_LTD_ ['438', '"Mindjaga Ltd."']]
    ['388' M_RUILI_SMART_CONTROL ['439', '"RuiLi Smart Control"']]
    ['389' M_CODESYS_GMBH ['440', '"CODESYS GmbH"']]
    ['390' M_MOORGEN_DEUTSCHLAND_GMBH ['441', '"Moorgen Deutschland GmbH"']]
    ['391' M_CULLMANN_TECH ['442', '"CULLMANN TECH"']]
    ['392' M_EYRISE_B_V ['443', '"eyrise B.V"']]
    ['393' M_DOBNEL ['444', '"Dobnel"']]
    ['394' M_MYGEKKO ['445', '"myGEKKO"']]
    ['395' M_ERGO3_SARL ['446', '"Ergo3 Sarl"']]
    ['396' M_STMICROELECTRONICS_INTERNATIONAL_N_V_ ['447', '"STmicroelectronics International N.V."']]
    ['397' M_CJC_SYSTEMS ['448', '"cjc systems"']]
    ['398' M_SUDOKU ['449', '"Sudoku"']]
    ['399' M_AZ_E_LITE_PTE_LTD ['451', '"AZ e-lite Pte Ltd"']]
    ['400' M_ARLIGHT ['452', '"Arlight"']]
    ['401' M_GRUENBECK_WASSERAUFBEREITUNG_GMBH ['453', '"Grünbeck Wasseraufbereitung GmbH"']]
    ['402' M_MODULE_ELECTRONIC ['454', '"Module Electronic"']]
    ['403' M_KOPLAT ['455', '"KOPLAT"']]
    ['404' M_GUANGZHOU_LETOUR_LIFE_TECHNOLOGY_CO___LTD ['456', '"Guangzhou Letour Life Technology Co., Ltd"']]
    ['405' M_ILEVIA ['457', '"ILEVIA"']]
    ['406' M_LN_SYSTEMTEQ ['458', '"LN SYSTEMTEQ"']]
    ['407' M_HISENSE_SMARTHOME ['459', '"Hisense SmartHome"']]
    ['408' M_FLINK_AUTOMATION_SYSTEM ['460', '"Flink Automation System"']]
    ['409' M_XXTER_BV ['461', '"xxter bv"']]
    ['410' M_LYNXUS_TECHNOLOGY ['462', '"lynxus technology"']]
    ['411' M_ROBOT_S_A_ ['463', '"ROBOT S.A."']]
    ['412' M_SHENZHEN_ATTE_SMART_LIFE_CO__LTD_ ['464', '"Shenzhen Atte Smart Life Co.,Ltd."']]
    ['413' M_NOBLESSE ['465', '"Noblesse"']]
    ['414' M_ADVANCED_DEVICES ['466', '"Advanced Devices"']]
    ['415' M_ATRINA_BUILDING_AUTOMATION_CO__LTD ['467', '"Atrina Building Automation Co. Ltd"']]
    ['416' M_GUANGDONG_DAMING_LAFFEY_ELECTRIC_CO___LTD_ ['468', '"Guangdong Daming Laffey electric Co., Ltd."']]
    ['417' M_WESTERSTRAND_URFABRIK_AB ['469', '"Westerstrand Urfabrik AB"']]
    ['418' M_CONTROL4_CORPORATE ['470', '"Control4 Corporate"']]
    ['419' M_ONTROL ['471', '"Ontrol"']]
    ['420' M_STARNET ['472', '"Starnet"']]
    ['421' M_BETA_CAVI ['473', '"BETA CAVI"']]
    ['422' M_HANGZHOU_YIYUE_TECHNOLOGY_CO___LTD_ ['474', '"Hangzhou YiYue Technology Co., Ltd."']]
    ['423' M_VIVALDI_SRL ['475', '"Vivaldi srl"']]
    ['424' M_GREE_ELECTRIC_APPLIANCES_INC__OF_ZHUHAI ['476', '"Gree Electric Appliances,Inc. of Zhuhai"']]
    ['425' M_HWISCON ['477', '"HWISCON"']]
    ['426' M_SHANGHAI_ELECON_INTELLIGENT_TECHNOLOGY_CO___LTD_ ['478', '"Shanghai ELECON Intelligent Technology Co., Ltd."']]
    ['427' M_KAMPMANN ['479', '"Kampmann"']]
    ['428' M_IMPOLUX_GMBH_LEDIMAX ['480', '"Impolux GmbH / LEDIMAX"']]
    ['429' M_EVAUX ['481', '"Evaux"']]
    ['430' M_WEBRO_CABLES_AND_CONNECTORS_LIMITED ['482', '"Webro Cables & Connectors Limited"']]
    ['431' M_SHANGHAI_E_TECH_SOLUTION ['483', '"Shanghai E-tech Solution"']]
    ['432' M_GUANGZHOU_HOKO_ELECTRIC_CO__LTD_ ['484', '"Guangzhou HOKO Electric Co.,Ltd."']]
    ['433' M_LAMMIN_HIGH_TECH_CO__LTD ['485', '"LAMMIN HIGH TECH CO.,LTD"']]
    ['434' M_SHENZHEN_MERRYTEK_TECHNOLOGY_CO___LTD ['486', '"Shenzhen Merrytek Technology Co., Ltd"']]
    ['435' M_I_LUXUS ['487', '"I-Luxus"']]
    ['436' M_ELMOS_SEMICONDUCTOR_AG ['488', '"Elmos Semiconductor AG"']]
    ['437' M_EMCOM_TECHNOLOGY_INC ['489', '"EmCom Technology Inc"']]
    ['438' M_PROJECT_INNOVATIONS_GMBH ['490', '"project innovations GmbH"']]
    ['439' M_ITC ['491', '"Itc"']]
    ['440' M_ABB_LV_INSTALLATION_MATERIALS_COMPANY_LTD__BEIJING ['492', '"ABB LV Installation Materials Company Ltd, Beijing"']]
    ['441' M_MAICO ['493', '"Maico"']]
    ['442' M_ELAN_SRL ['495', '"ELAN SRL"']]
    ['443' M_MINHHA_TECHNOLOGY_CO__LTD ['496', '"MinhHa Technology co.,Ltd"']]
    ['444' M_ZHEJIANG_TIANJIE_INDUSTRIAL_CORP_ ['497', '"Zhejiang Tianjie Industrial CORP."']]
    ['445' M_IAUTOMATION_PTY_LIMITED ['498', '"iAutomation Pty Limited"']]
    ['446' M_EXTRON ['499', '"Extron"']]
    ['447' M_FREEDOMPRO ['500', '"Freedompro"']]
    ['448' M_ONEHOME ['501', '"1Home"']]
    ['449' M_EOS_SAUNATECHNIK_GMBH ['502', '"EOS Saunatechnik GmbH"']]
    ['450' M_KUSATEK_GMBH ['503', '"KUSATEK GmbH"']]
    ['451' M_ALEXANDER_MAIER_GMBH ['504', '"Alexander Maier GmbH"']]
    ['452' M_AUTOMATISMI_BENINCA_S_P_A_ ['505', '"AUTOMATISMI BENINCA S.P.A."']]
    ['453' M_BLENDOM ['506', '"Blendom"']]
    ['454' M_MADEL_AIR_TECHNICAL_DIFFUSION ['507', '"Madel Air Technical diffusion"']]
    ['455' M_NIKO ['508', '"NIKO"']]
    ['456' M_BOSCH_REXROTH_AG ['509', '"Bosch Rexroth AG"']]
    ['457' M_CANDM_PRODUCTS ['512', '"C&M Products"']]
    ['458' M_HOERMANN_KG_VERKAUFSGESELLSCHAFT ['513', '"Hörmann KG Verkaufsgesellschaft"']]
    ['459' M_SHANGHAI_RAJAYASA_CO__LTD ['514', '"Shanghai Rajayasa co.,LTD"']]
    ['460' M_SUZUKI ['515', '"SUZUKI"']]
    ['461' M_SILENT_GLISS_INTERNATIONAL_LTD_ ['516', '"Silent Gliss International Ltd."']]
    ['462' M_BEE_CONTROLS_ADGSC_GROUP ['517', '"BEE Controls (ADGSC Group)"']]
    ['463' M_XDTECGMBH ['518', '"xDTecGmbH"']]
    ['464' M_OSRAM ['519', '"OSRAM"']]
    ['465' M_LEBENOR ['520', '"Lebenor"']]
    ['466' M_AUTOMANENG ['521', '"automaneng"']]
    ['467' M_HONEYWELL_AUTOMATION_CONTROL_SOLUTIONSCHINACOLTD ['522', '"Honeywell Automation Control Solutions(China)CoLtd"']]
    ['468' M_HANGZHOU_BINTHEN_INTELLIGENCE_TECHNOLOGY_CO__LTD ['523', '"Hangzhou binthen Intelligence Technology Co.,Ltd"']]
    ['469' M_ETA_HEIZTECHNIK ['524', '"ETA Heiztechnik"']]
    ['470' M_DIVUS_GMBH ['525', '"DIVUS GmbH"']]
    ['471' M_NANJING_TAIJIESAI_INTELLIGENT_TECHNOLOGY_CO__LTD_ ['526', '"Nanjing Taijiesai Intelligent Technology Co. Ltd."']]
    ['472' M_LUNATONE ['527', '"Lunatone"']]
    ['473' M_ZHEJIANG_SCTECH_BUILDING_INTELLIGENT ['528', '"ZHEJIANG SCTECH BUILDING INTELLIGENT"']]
    ['474' M_FOSHAN_QITE_TECHNOLOGY_CO___LTD_ ['529', '"Foshan Qite Technology Co., Ltd."']]
    ['475' M_NOKE ['530', '"NOKE"']]
    ['476' M_LANDCOM ['531', '"LANDCOM"']]
    ['477' M_STORK_AS ['532', '"Stork AS"']]
    ['478' M_HANGZHOU_SHENDU_TECHNOLOGY_CO___LTD_ ['533', '"Hangzhou Shendu Technology Co., Ltd."']]
    ['479' M_COOLAUTOMATION ['534', '"CoolAutomation"']]
    ['480' M_APRSTERN ['535', '"Aprstern"']]
    ['481' M_SONNEN ['536', '"sonnen"']]
    ['482' M_DNAKE ['537', '"DNAKE"']]
    ['483' M_NEUBERGER_GEBAEUDEAUTOMATION_GMBH ['538', '"Neuberger Gebäudeautomation GmbH"']]
    ['484' M_STILIGER ['539', '"Stiliger"']]
    ['485' M_BERGHOF_AUTOMATION_GMBH ['540', '"Berghof Automation GmbH"']]
    ['486' M_TOTAL_AUTOMATION_AND_CONTROLS_GMBH ['541', '"Total Automation and controls GmbH"']]
    ['487' M_DOVIT ['542', '"DOVIT"']]
    ['488' M_INSTALIGHTING_GMBH ['543', '"Instalighting GmbH"']]
    ['489' M_UNI_TEC ['544', '"UNI-TEC"']]
    ['490' M_CASATUNES ['545', '"CasaTunes"']]
    ['491' M_EMT ['546', '"EMT"']]
    ['492' M_SENFFICIENT ['547', '"Senfficient"']]
    ['493' M_AUROLITE_ELECTRICAL_PANYU_GUANGZHOU_LIMITED ['548', '"Aurolite electrical panyu guangzhou limited"']]
    ['494' M_ABB_XIAMEN_SMART_TECHNOLOGY_CO___LTD_ ['549', '"ABB Xiamen Smart Technology Co., Ltd."']]
    ['495' M_SAMSON_ELECTRIC_WIRE ['550', '"Samson Electric Wire"']]
    ['496' M_T_TOUCHING ['551', '"T-Touching"']]
    ['497' M_CORE_SMART_HOME ['552', '"Core Smart Home"']]
    ['498' M_GREENCONNECT_SOLUTIONS_SA ['553', '"GreenConnect Solutions SA"']]
    ['499' M_ELETTRONICA_CONDUTTORI ['554', '"ELETTRONICA CONDUTTORI"']]
    ['500' M_MKFC ['555', '"MKFC"']]
    ['501' M_AUTOMATIONPlus ['556', '"Automation+"']]
    ['502' M_BLUE_AND_RED ['557', '"blue and red"']]
    ['503' M_FROGBLUE ['558', '"frogblue"']]
    ['504' M_LUXIO ['559', '"LUXIO"']]
    ['505' M_APP_TECH ['560', '"App Tech"']]
    ['506' M_SENSORTEC_AG ['561', '"sensortec AG"']]
    ['507' M_NYSA_TECHNOLOGY_AND_SOLUTIONS ['562', '"nysa technology & solutions"']]
    ['508' M_FARADITE ['563', '"FARADITE"']]
    ['509' M_OPTIMUS ['564', '"Optimus"']]
    ['510' M_KTS_S_R_L_ ['565', '"KTS s.r.l."']]
    ['511' M_RAMCRO_SPA ['566', '"Ramcro SPA"']]
    ['512' M_WUHAN_WISECREATE_UNIVERSE_TECHNOLOGY_CO___LTD ['567', '"Wuhan WiseCreate Universe Technology Co., Ltd"']]
    ['513' M_BEMI_SMART_HOME_LTD ['568', '"BEMI Smart Home Ltd"']]
    ['514' M_ARDOMUS ['569', '"Ardomus"']]
    ['515' M_CHANGXING ['570', '"ChangXing"']]
    ['516' M_E_CONTROLS ['571', '"E-Controls"']]
    ['517' M_AIB_TECHNOLOGY ['572', '"AIB Technology"']]
    ['518' M_NVC ['573', '"NVC"']]
    ['519' M_KBOX ['574', '"Kbox"']]
    ['520' M_CNS ['575', '"CNS"']]
    ['521' M_TYBA ['576', '"Tyba"']]
    ['522' M_ATREL ['577', '"Atrel"']]
    ['523' M_SIMON_ELECTRIC_CHINA_CO___LTD ['578', '"Simon Electric (China) Co., LTD"']]
    ['524' M_KORDZ_GROUP ['579', '"Kordz Group"']]
    ['525' M_ND_ELECTRIC ['580', '"ND Electric"']]
    ['526' M_CONTROLIUM ['581', '"Controlium"']]
    ['527' M_FAMO_GMBH_AND_CO__KG ['582', '"FAMO GmbH & Co. KG"']]
    ['528' M_CDN_SMART ['583', '"CDN Smart"']]
    ['529' M_HESTON ['584', '"Heston"']]
    ['530' M_ESLA_CONEXIONES_S_L_ ['585', '"ESLA CONEXIONES S.L."']]
    ['531' M_WEISHAUPT ['586', '"Weishaupt"']]
    ['532' M_ASTRUM_TECHNOLOGY ['587', '"ASTRUM TECHNOLOGY"']]
    ['533' M_WUERTH_ELEKTRONIK_STELVIO_KONTEK_S_P_A_ ['588', '"WUERTH ELEKTRONIK STELVIO KONTEK S.p.A."']]
    ['534' M_NANOTECO_CORPORATION ['589', '"NANOTECO corporation"']]
    ['535' M_NIETIAN ['590', '"Nietian"']]
    ['536' M_SUMSIR ['591', '"Sumsir"']]
    ['537' M_ORBIS_TECNOLOGIA_ELECTRICA_SA ['592', '"ORBIS TECNOLOGIA ELECTRICA SA"']]
    ['538' M_NANJING_ZHONGYI_IOT_TECHNOLOGY_CO___LTD_ ['593', '"Nanjing Zhongyi IoT Technology Co., Ltd."']]
    ['539' M_ANLIPS ['594', '"Anlips"']]
    ['540' M_GUANGDONG_PAK_CORPORATION_CO___LTD ['595', '"GUANGDONG PAK CORPORATION CO., LTD"']]
    ['541' M_BVK_TECHNOLOGY ['596', '"BVK Technology"']]
    ['542' M_SOLOMIO_SRL ['597', '"Solomio srl"']]
    ['543' M_DOMOTICA_LABS ['598', '"Domotica Labs"']]
    ['544' M_NVC_INTERNATIONAL ['599', '"NVC International"']]
    ['545' M_BA ['600', '"BA"']]
    ['546' M_IRIS_CERAMICA_GROUP ['601', '"Iris Ceramica Group"']]
    ['547' M_WIREEO ['602', '"Wireeo"']]
    ['548' M_NVCLIGHTING ['603', '"nvclighting"']]
    ['549' M_JINAN_TIAN_DA_SHENG_INFORMATION_TECHNOLOGY_CO_ ['604', '"Jinan Tian Da Sheng Information Technology Co."']]
    ['550' M_ARMITI_TRADING ['605', '"Armiti trading"']]
    ['551' M_ELEK ['606', '"ELEK"']]
    ['552' M_ACCORDIA_SA ['607', '"Accordia sa"']]
    ['553' M_OURICAN ['608', '"OURICAN"']]
    ['554' M_INLIWOSE ['609', '"INLIWOSE"']]
    ['555' M_BOSCH_SHANGHAI_SMART_LIFE_TECHNOLOGY_LTD_ ['610', '"Bosch (Shanghai) Smart Life Technology Ltd."']]
    ['556' M_SHK_KNX ['611', '"SHK KNX"']]
    ['557' M_AMPIO ['612', '"Ampio"']]
    ['558' M_MINGXING_WISDOM ['613', '"Mingxing Wisdom"']]
    ['559' M_ALTEN_SW_GMBH ['614', '"ALTEN SW GmbH"']]
    ['560' M_V_Y_C_SRL ['615', '"V.Y.C.srl"']]
    ['561' M_TERMINUS_GROUP ['616', '"TERMINUS GROUP"']]
    ['562' M_WONDERFUL_CITY_TECHNOLOGY ['617', '"Wonderful City Technology"']]
    ['563' M_QBICTECHNOLOGY ['618', '"QbicTechnology"']]
    ['564' M_EMBEDDED_AUTOMATION_EQUIPMENT_SHANGHAI_LIMITED ['619', '"Embedded Automation Equipment (Shanghai) Limited"']]
    ['565' M_ONEWORK ['620', '"onework"']]
    ['566' M_PL_LINK ['621', '"PL LINK"']]
    ['567' M_FASEL_GMBH_ELEKTRONIK ['622', '"Fasel GmbH Elektronik"']]
    ['568' M_GOLDENHOME_SMART ['623', '"GoldenHome Smart"']]
    ['569' M_GOLDMEDAL ['624', '"Goldmedal"']]
    ['570' M_CannX ['625', '"Can'nX"']]
    ['571' M_EGI___EARTH_GOODNESS ['627', '"EGI - Earth Goodness"']]
    ['572' M_VIEGA_GMBH_AND_CO__KG ['628', '"Viega GmbH & Co. KG"']]
    ['573' M_FREDON_DIGITAL_BUILDINGS ['629', '"Fredon Digital Buildings"']]
    ['574' M_HELUKABEL_THAILAND_CO__LTD_ ['630', '"Helukabel (Thailand) Co.,Ltd."']]
    ['575' M_SICS ['631', '"SICS"']]
    ['576' M_MEX_ELECTRIC_TECHNOLOGY_SHANGHAI_CO___LTD ['632', '"MEX Electric Technology (Shanghai) Co., Ltd"']]
    ['577' M_SUMAMO ['633', '"SUMAMO"']]
    ['578' M_SVIT ['634', '"SVIT"']]
    ['579' M_TECGET ['635', '"tecget"']]
    ['580' M_XEROPOINT ['636', '"Xeropoint"']]
    ['581' M_HONEYWELL_BUILDING_TECHNOLOGIES ['637', '"Honeywell Building Technologies"']]
    ['582' M_COMFORTCLICK ['638', '"ComfortClick"']]
    ['583' M_DORBAS_ELECTRIC ['639', '"DORBAS ELECTRIC"']]
    ['584' M_REMKO_GMBH_AND_CO__KG ['640', '"REMKO GmbH & Co. KG"']]
    ['585' M_SHENZHEN_CONGXUN_INTELLIGENT_TECHNOLOGY_CO___LTD ['641', '"Shenzhen Congxun Intelligent Technology Co., LTD"']]
    ['586' M_ANDAS ['642', '"ANDAS"']]
    ['587' M_HEFEI_CHUANG_YUE_INTELLIGENT_TECHNOLOGY_CO__LTD ['643', '"Hefei Chuang Yue Intelligent Technology Co.,LTD"']]
    ['588' M_LARFE ['644', '"Larfe"']]
    ['589' M_DONGGUAN_MUHCCI_ELECTRICAL ['645', '"Dongguan Muhcci Electrical"']]
    ['590' M_STEC ['646', '"STEC"']]
    ['591' M_ARIGO_SOFTWARE_GMBH ['647', '"ARIGO Software GmbH"']]
    ['592' M_FEISHELEC ['648', '"Feishelec"']]
    ['593' M_GORDIC ['649', '"GORDIC"']]
    ['594' M_DELTA_ELECTRONICS ['650', '"Delta Electronics"']]
    ['595' M_SHANGHAI_LEWIN_INTELLIGENT_TECHNOLOGY_CO__LTD_ ['651', '"Shanghai Lewin Intelligent Technology Co.,Ltd."']]
    ['596' M_KG_POWER ['652', '"KG-POWER"']]
    ['597' M_ZHEJIANG_MOORGEN_GROUP_CO__LTD ['653', '"Zhejiang Moorgen Group Co.,Ltd"']]
    ['598' M_GUANGDONG_KANWAY ['654', '"Guangdong Kanway"']]
    ['599' M_RAMIREZ_ENGINEERING_GMBH ['656', '"RAMIREZ Engineering GmbH"']]
    ['600' M_ZHONGSHAN_TAIYANG_IMPANDEXP__CO_LTD ['657', '"Zhongshan Taiyang IMP&EXP. CO LTD"']]
    ['601' M_VIHAN_ELECTRIC_PVT_LTD ['658', '"Vihan electric pvt ltd"']]
    ['602' M_SPLENDID_MINDS_GMBH ['659', '"Splendid Minds GmbH"']]
    ['603' M_ESTADA ['660', '"Estada"']]
    ['604' M_ZHONGYUNXINZHIKONGGUJITUANYOUXIANGONGSI ['661', '"zhongyunxinzhikonggujituanyouxiangongsi"']]
    ['605' M_STUHL_REGELSYSTEME_GMBH ['662', '"Stuhl Regelsysteme GmbH"']]
    ['606' M_SHENZHEN_GLUCK_TECHNOLOGY_CO___LTD ['663', '"Shenzhen Gluck Technology Co., LTD"']]
    ['607' M_GAIMEX ['664', '"Gaimex"']]
    ['608' M_B3_INTERNATIONAL_S_R_L ['665', '"B3 International S.R.L"']]
    ['609' M_MM_ELECTRO ['666', '"MM Electro"']]
    ['610' M_CASCODA ['667', '"CASCODA"']]
    ['611' M_XIAMEN_INTRETECH_INC_ ['668', '"Xiamen Intretech Inc."']]
    ['612' M_KILOELEC_TECHNOLOGY ['669', '"KiloElec Technology"']]
    ['613' M_INYX ['670', '"Inyx"']]
    ['614' M_SMART_BUILDING_SERVICES_GMBH ['671', '"Smart Building Services GmbH"']]
    ['615' M_BSS_GMBH ['672', '"BSS GmbH"']]
    ['616' M_LUMI_ELECTRONICS ['673', '"Lumi Electronics"']]
    ['617' M_OJEAELECTRONICS ['674', '"OjeaElectronics"']]
    ['618' M_SMART_NODE ['675', '"Smart Node"']]
    ['619' M_NEXHOME ['676', '"NEXhome"']]
    ['620' M_HUOTENG_WULIAN_JIANGSU_CO___LTD ['677', '"Huoteng Wulian (Jiangsu) Co., Ltd"']]
    ['621' M_RAYLOGIC_CONTROL_SYSTEMS_PVT_LTD ['678', '"Raylogic Control Systems Pvt Ltd"']]
    ['622' M_BITS_AND_BYTES ['679', '"Bits & Bytes"']]
    ['623' M_KFV_SIEGENIA_GRUPPE ['680', '"KFV (SIEGENIA GRUPPE)"']]
    ['624' M_SYMCON ['681', '"Symcon"']]
    ['625' M_I_TRUST ['682', '"I.Trust"']]
    ['626' M_DRD_TECHNICS ['683', '"DRD-Technics"']]
    ['627' M_LENGEN ['684', '"LENGEN"']]
    ['628' M_SHENZHEN_EXC_LED_TECHNOLOGY_CO__LTD ['685', '"Shenzhen EXC-LED Technology Co.,LTD"']]
    ['629' M_VIBROXX_FZCO ['686', '"Vibroxx-FZCO"']]
    ['630' M_SUZHOU_HONGYUN_INTELLIGENT_TECHNOLOGYCO___LTD ['687', '"Suzhou Hongyun Intelligent TechnologyCo., Ltd"']]
    ['631' M_PASSIV_ENERGIE_GMBH ['688', '"Passiv Energie GmbH"']]
    ['632' M_PAYNE_TECHNOLOGIES_LTD ['689', '"Payne Technologies Ltd"']]
    ['633' M_GUANGDONG_YOZEWIT_INTELLIGENT_TECHNOLOGY_CO__LTD_ ['690', '"Guangdong Yozewit Intelligent Technology Co.,Ltd."']]
    ['634' M_SEXANKA ['691', '"SEXANKA"']]
    ['635' M_SECURI_FLEX_LTD ['692', '"Securi-Flex Ltd"']]
    ['636' M_BOKE ['693', '"BOKE"']]
    ['637' M_SBR_SYSTEM_TECHNICAL ['695', '"SBR System Technical"']]
    ['638' M_SHENZHEN_EASTKAME_TECHNOLOGY_CO___LTD_ ['696', '"Shenzhen EastKame Technology Co., Ltd."']]
    ['639' M_BOLATU ['697', '"BOLATU"']]
    ['640' M_RECBER_KABLO_A_S_ ['698', '"RECBER KABLO A.S."']]
    ['641' M_ILITE_KNX ['699', '"ILite-Knx"']]
    ['642' M_LAZZEN ['700', '"LAZZEN"']]
    ['643' M_MOX_CONTROL_IT_CHINA_LIMITED ['701', '"MOX CONTROL IT (CHINA) LIMITED"']]
    ['644' M_CLOWIRE ['702', '"CLOWIRE"']]
    ['645' M_NINGBO_QIYUAN_LIGHTING_TECH_CO__LTD ['703', '"NINGBO QIYUAN LIGHTING TECH CO.,LTD"']]
    ['646' M_NS_TOUCH ['704', '"NS Touch"']]
    ['647' M_ROOMIO ['705', '"ROOMIO"']]
    ['648' M_ATOUCH ['706', '"Atouch"']]
    ['649' M_PANASONIC_LIFE_SOLUTIONS_INDIA_PVT__LTD ['707', '"Panasonic Life Solutions India Pvt. Ltd"']]
    ['650' M_WALLYONS ['708', '"WallYons"']]
    ['651' M_ZIMMEX ['709', '"Zimmex"']]
    ['652' M_RHOMBUS_EUROPE ['710', '"Rhombus Europe"']]
    ['653' M_TURING_THINK ['711', '"Turing-Think"']]
    ['654' M_MICHOI ['712', '"Michoi"']]
    ['655' M_CAV_SMARTGUANGZHOUCO__LTD ['713', '"CAV SMART(GUANGZHOU)CO.,LTD"']]
    ['656' M_HELKAMA_BICA_OY ['714', '"Helkama Bica Oy"']]
    ['657' M_MODULYTE ['715', '"ModuLyte"']]
    ['658' M_CONSOLINNO_ENERGY_GMBH ['716', '"Consolinno Energy GmbH"']]
    ['659' M_SCHIDERON_ELECTRIC_ASIA_LIMITED ['717', '"SCHIDERON ELECTRIC (ASIA) LIMITED"']]
    ['660' M_3R ['718', '"3R"']]
    ['661' M_ARKLYFE ['719', '"Arklyfe"']]
    ['662' M_FOSHAN_HAYDN_TECHNOLOGY_LIGHTING_CO__LTD_ ['720', '"Foshan Haydn Technology Lighting Co.,Ltd."']]
    ['663' M_KNXES_COMPANY_LIMITED ['721', '"KNXES COMPANY LIMITED"']]
    ['664' M_AKUVOX ['722', '"Akuvox"']]
    ['665' M_NINGBO_YINZHOU_SHENGRUIJIE_ELECTRONICS_CO__LTD_ ['723', '"NingBo Yinzhou ShengRuiJie Electronics Co. Ltd."']]
    ['666' M_SHENZHEN_HAIZHICHUANG_TECHNOLOGY_CO___LTD ['724', '"Shenzhen Haizhichuang Technology Co., Ltd"']]
    ['667' M_SHENZHEN_EASYDETEK_TECHNOLOGY_CO_LTD ['725', '"Shenzhen easydetek technology Co.Ltd"']]
    ['668' M_MUTLUSAN_ELECTRIC ['726', '"Mutlusan Electric"']]
    ['669' M_HANGZHOU_BROADLINK_TECHNOLOGY_CO__LTD_ ['727', '"Hangzhou BroadLink Technology Co.,Ltd."']]
    ['670' M_MARLEY_DEUTSCHLAND_GMBH ['728', '"Marley Deutschland GmbH"']]
    ['671' M_CREATROL ['729', '"Creatrol"']]
    ['672' M_EUTELSAT ['730', '"EUTELSAT"']]
    ['673' M_TECNIKABEL ['731', '"TECNIKABEL"']]
    ['674' M_ATIOS_AG ['732', '"Atios AG"']]
    ['675' M_SMARTLICHT ['733', '"SmartLicht"']]
    ['676' M_BEIJING_BEVONE_ELECTRIC_CO__LTD_ ['734', '"Beijing Bevone Electric Co. Ltd."']]
    ['677' M_ELSMART ['735', '"ELSMART"']]
    ['678' M_MIDDLE_EAST_SPECIALIZED_CABLES_CO__MESC ['736', '"Middle East Specialized Cables Co. (MESC)"']]
    ['679' M_HANGZHOU_SANYUAN_CABLE_CO___LTD ['737', '"HANGZHOU SANYUAN CABLE CO., LTD"']]
    ['680' M_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC_ ['738', '"Beijing HaiLin Control Technology Inc."']]
    ['681' M_HANGZHOU_SNOWYI_TECHNOLOGY_CO__LTD_ ['739', '"HangZhou Snowyi Technology Co.,LTD."']]
    ['682' M_XIAMEN_E_TOP_CONTROLS_TECHNOLOGY_CO__LTD ['740', '"Xiamen E-Top Controls Technology Co.,Ltd"']]
    ['683' M_VITRUM_DESIGN ['741', '"Vitrum Design"']]
    ['684' M_DETRONS ['742', '"DETRONS"']]
    ['685' M_ZHEJIANG_FORICK__INTELLIGENT_TECHNOLOGY_CO___LTD ['743', '"Zhejiang FORICK, Intelligent Technology Co., LTD"']]
    ['686' M_VARNI_DIGITAL_PRIVATE_LIMITED ['744', '"Varni Digital Private Limited"']]
    ['687' M_3A_ENTREPRISE_APS ['745', '"3a entreprise aps"']]
    ['688' M_ITALIANA_CONDUTTORI_SRL ['746', '"Italiana Conduttori srl"']]
    ['689' M_XIAMEN_LEELEN_TECHNOLOGY_CO__LTD_ ['747', '"Xiamen Leelen Technology Co.,Ltd."']]
    ['690' M_LEDNX ['748', '"LedNX"']]
    ['691' M_EBELONG ['749', '"ebelong"']]
    ['692' M_ASTRA_LED_AG ['750', '"Astra-LED AG"']]
    ['693' M_WONDERFUL_HI_TECH_CO___LTD_ ['751', '"Wonderful Hi-Tech Co., Ltd."']]
    ['694' M_REXLITE_AI_INTEGRATIONS_CO__LTD ['752', '"REXLiTE Ai Integrations CO.,LTD"']]
    ['695' M_ALLORADO ['753', '"Allorado"']]
    ['696' M_FUZHOU_MILI_TECHNOLOGY_CO___LTD ['754', '"FUZHOU MILI TECHNOLOGY CO., LTD"']]
    ['697' M_MAXTREEN_BUILDING_TECHNOLOGY_CO__LTD ['755', '"Maxtreen building technology co.,ltd"']]
    ['698' M_HYSINE ['756', '"Hysine"']]
    ['699' M_SANTAN ['757', '"SANTAN"']]
    ['700' M_HUIXIANGJU_IOT_TECHNOLOGY_SHANGHAI_CO___LTD ['758', '"Huixiangju IoT Technology (Shanghai) Co., Ltd"']]
    ['701' M_SHANGHAI_BENKONG_ELECTRONIC_TECHNOLOGY_CO__LTD ['759', '"Shanghai Benkong Electronic Technology Co.,Ltd"']]
    ['702' M_POLAR_BEAR_DESIGN ['760', '"Polar Bear Design"']]
    ['703' M_ELESSAN_NV ['761', '"Elessan NV"']]
    ['704' M_MIR ['762', '"MIR"']]
    ['705' M_ZHEJIANG_MISILIN_TECHNOLOGY_CO___LTD ['763', '"Zhejiang Misilin Technology Co., Ltd"']]
    ['706' M_LEAX_CONTROLS_CO___LTD_ ['764', '"LEAX CONTROLS CO., LTD."']]
    ['707' M_ALCAD ['765', '"alcad"']]
    ['708' M_GUANG_DONG_REMAC_SMART_TECHNOLOGY_CO___LTD ['766', '"GUANG DONG REMAC SMART TECHNOLOGY CO., LTD"']]
    ['709' M_TAOS_ELECTRIC_CO___LTD ['769', '"Taos Electric Co., Ltd"']]
    ['710' M_KONSTANTIN_BOBIC_SYSTEMINTEGRATION ['771', '"Konstantin Bobic Systemintegration"']]
    ['711' M_ASAY_Q ['772', '"Asay Q"']]
    ['712' M_LAPP ['773', '"LAPP"']]
    ['713' M_ZEROBIT_DYNAMIC ['774', '"ZEROBIT DYNAMIC"']]
    ['714' M_HAVELLS ['775', '"havells"']]
    ['715' M_MULLER_INTUITIV ['776', '"Muller Intuitiv"']]
    ['716' M_TASKIT_GMBH ['777', '"taskit GmbH"']]
    ['717' M_COSTER_GROUP ['778', '"Coster Group"']]
    ['718' M_NXP_SEMICONDUCTOR ['779', '"NXP Semiconductor"']]
    ['719' M_COGCONS ['780', '"CogCons"']]
    ['720' M_MICRO_TEK_SRL_F_M_C_TRADE_MARK ['781', '"Micro Tek Srl (F.M.C trade mark)"']]
    ['721' M_ORENDA_ELECTRIC ['782', '"Orenda Electric"']]
    ['722' M_ERSE_KABLO ['783', '"ERSE KABLO"']]
    ['723' M_PRADO_EUROPE_BV ['784', '"prado europe bv"']]
    ['724' M_E2S_GBR ['785', '"e2s GbR"']]
    ['725' M_UNITLINK ['786', '"UnitLink"']]
    ['726' M_ONNA ['787', '"ONNA"']]
    ['727' M_CENTERSVET_LLC ['788', '"CENTERSVET LLC"']]
    ['728' M_ADVECO_TECHNOLOGY_CO___LTD_ ['789', '"Adveco Technology Co., Ltd."']]
    ['729' M_FR__LUERSSEN_WERFT ['790', '"Fr. Lürssen Werft"']]
    ['730' M_MYLYR ['791', '"mylyr"']]
    ['731' M_HYUNDAI_HT ['792', '"HYUNDAI HT"']]
    ['732' M_GUANGDONG_YUEJINGRUN_TECHNOLOGY_CO__LTD ['793', '"Guangdong Yuejingrun Technology Co.,Ltd"']]
    ['733' M_SMATEK_ELECTRONICS_LIMITED ['794', '"SMATEK ELECTRONICS LIMITED"']]
    ['734' M_ANYTEK_ELECTRONIC_TECHNOLOGY_SZ_CO___LTD_ ['795', '"Anytek Electronic Technology (SZ) Co., Ltd."']]
    ['735' M_MORELINKS_SMART_HOME ['796', '"Morelinks Smart Home"']]
    ['736' M_CIRTX_GMBH ['797', '"Cirtx GmbH"']]
    ['737' M_QLITE ['798', '"QLITE"']]
    ['738' M_ZHONGSHAN_ILLUS_LIGHTING_CO__LTD ['799', '"Zhongshan Illus LIghting Co.,Ltd"']]
    ['739' M_HANGZHOU_KONKE_INFORMATION_TECHNOLOGY_CO___LTD_ ['800', '"Hangzhou Konke Information Technology Co., Ltd."']]
    ['740' M_SHANGHAI_FANTE_DIGITAL_TECHNOLOGY_CO___LTD ['801', '"Shanghai Fante Digital Technology Co., Ltd"']]
    ['741' M_CONFIO ['802', '"CONFIO"']]
    ['742' M_SONIC_TECHNOLOGIES ['803', '"Sonic Technologies"']]
    ['743' M_SHANGHAI_INNOVATECH_INFORMATION_TECHNOLOGY_CO___LT ['804', '"Shanghai Innovatech Information Technology Co., Lt"']]
    ['744' M_ABI_SICHERHEITSSYSTEME_GMBH ['805', '"ABI Sicherheitssysteme GmbH"']]
    ['745' M_RYT ['806', '"RYT"']]
    ['746' M_AURIGA_SYSTEMS ['807', '"Auriga Systems"']]
    ['747' M_ALZINGERANDVOGEL_SOFTWAREENTWICKLUNGS_GMBH ['808', '"Alzinger&Vogel Softwareentwicklungs GmbH"']]
    ['748' M_GIANFRANCO_SMART_SOLUTIONS_LTD ['809', '"Gianfranco Smart Solutions Ltd"']]
    ['749' M_ROGERWELL_CONTROL_SYSTEM_LIMITED ['810', '"Rogerwell Control System Limited"']]
    ['750' M_SHANGHAI_YUKON_AUTOMATION_TECHNOLOGIES_CO___LTD_ ['811', '"Shanghai YUKON Automation Technologies Co., Ltd."']]
    ['751' M_TECCO_PTY_LTD ['812', '"Tecco Pty Ltd"']]
    ['752' M_A_LAN_TECHNOLOGIE ['813', '"A-LAN Technologie"']]
    ['753' M_ABB___RESERVED ['43954', '"ABB - reserved"']]
    ['754' M_BUSCH_JAEGER_ELEKTRO___RESERVED ['43959', '"Busch-Jaeger Elektro - reserved"']]
    
]

[dataIo KnxDatapoint(KnxDatapointType datapointType)
    [typeSwitch datapointType
        ['BOOL' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value]
        ]
        ['BYTE' BYTE
            [reserved uint 8    '0x00']
            [simple   uint 8    value ]
        ]
        ['WORD' WORD
            [reserved uint 8    '0x00']
            [simple   uint 16    value]
        ]
        ['DWORD' DWORD
            [reserved uint 8    '0x00']
            [simple   uint 32    value]
        ]
        ['LWORD' LWORD
            [reserved uint 8    '0x00']
            [simple   uint 64    value]
        ]
        ['USINT' USINT
            [reserved uint 8    '0x00']
            [simple   uint 8     value]
        ]
        ['SINT' SINT
            [reserved uint 8    '0x00']
            [simple   int 8      value]
        ]
        ['UINT' UINT
            [reserved uint 8    '0x00']
            [simple   uint 16    value]
        ]
        ['INT' INT
            [reserved uint 8    '0x00']
            [simple   int 16     value]
        ]
        ['UDINT' UDINT
            [reserved uint 8    '0x00']
            [simple   uint 32    value]
        ]
        ['DINT' DINT
            [reserved uint 8    '0x00']
            [simple   int 32     value]
        ]
        ['ULINT' ULINT
            [reserved uint 8    '0x00']
            [simple   uint 64    value]
        ]
        ['LINT' LINT
            [reserved uint 8    '0x00']
            [simple   int 64     value]
        ]
        ['REAL' REAL
            [reserved uint 8    '0x00']
            [simple   float 32 value]
        ]
        ['LREAL' LREAL
            [reserved uint 8    '0x00']
            [simple   float 64  value ]
        ]
        ['CHAR' CHAR
            [reserved uint 8    '0x00']
            [simple   string 8  value  encoding='"UTF-8"']
        ]
        ['WCHAR' WCHAR
            [reserved uint 8    '0x00']
            [simple   string 16 value  encoding='"UTF-16"']
        ]
        //['STRING' STRING
        //]
        //['WSTRING' WSTRING
        //]
        ['TIME' TIME
            [reserved uint 8    '0x00'      ]
            // TODO: Check if this is correct ...
            [simple   uint 32   milliseconds]
        ]
        ['LTIME' LTIME
            [reserved uint 8    '0x00'     ]
            // TODO: Check if this is correct ...
            [simple   uint 64   nanoseconds]
        ]
        ['DATE' DATE
            [reserved uint 8    '0x00'           ]
            // TODO: Check if this is correct ...
            [simple   uint 32   secondsSinceEpoch]
        ]
        ['TIME_OF_DAY' TIME_OF_DAY
            [reserved uint 8    '0x00'                   ]
            // TODO: Check if this is correct ...
            [simple   uint 32   millisecondsSinceMidnight]
        ]
        ['TOD' TIME_OF_DAY
            [reserved uint 8    '0x00'                   ]
            // TODO: Check if this is correct ...
            [simple   uint 32   millisecondsSinceMidnight]
        ]
        ['DATE_AND_TIME' DATE_AND_TIME
            [reserved uint 8  '0x00'     ]
            [simple   uint 16 year       ]
            [simple   uint 8  month      ]
            [simple   uint 8  day        ]
            [simple   uint 8  dayOfWeek  ]
            [simple   uint 8  hour       ]
            [simple   uint 8  minutes    ]
            [simple   uint 8  seconds    ]
            [simple   uint 32 nanoseconds]
        ]
        ['DT' DATE_AND_TIME
            [reserved uint 8  '0x00'     ]
            [simple   uint 16 year       ]
            [simple   uint 8  month      ]
            [simple   uint 8  day        ]
            [simple   uint 8  dayOfWeek  ]
            [simple   uint 8  hour       ]
            [simple   uint 8  minutes    ]
            [simple   uint 8  seconds    ]
            [simple   uint 32 nanoseconds]
        ]

    
        ['DPT_Switch' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Bool' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Enable' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Ramp' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Alarm' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_BinaryValue' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Step' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_UpDown' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_OpenClose' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Start' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_State' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Invert' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_DimSendStyle' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_InputSource' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Reset' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Ack' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Trigger' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Occupancy' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Window_Door' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_LogicalFunction' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Scene_AB' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_ShutterBlinds_Mode' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_DayNight' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Heat_Cool' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_Switch_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit on]
                
        ]
    
        ['DPT_Bool_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit valueTrue]
                
        ]
    
        ['DPT_Enable_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit enable]
                
        ]
    
        ['DPT_Ramp_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit ramp]
                
        ]
    
        ['DPT_Alarm_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit alarm]
                
        ]
    
        ['DPT_BinaryValue_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit high]
                
        ]
    
        ['DPT_Step_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit increase]
                
        ]
    
        ['DPT_Direction1_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit down]
                
        ]
    
        ['DPT_Direction2_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit close]
                
        ]
    
        ['DPT_Start_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit start]
                
        ]
    
        ['DPT_State_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit active]
                
        ]
    
        ['DPT_Invert_Control' Struct
           // Field Size 2
           [reserved uint 6 '0x00']

                    
                    [simple bit control]
                
                    [simple bit inverted]
                
        ]
    
        ['DPT_Control_Dimming' Struct
           // Field Size 4
           [reserved uint 4 '0x00']

                    
                    [simple bit increase]
                
                    [simple uint 3 stepcode]
                
        ]
    
        ['DPT_Control_Blinds' Struct
           // Field Size 4
           [reserved uint 4 '0x00']

                    
                    [simple bit down]
                
                    [simple uint 3 stepcode]
                
        ]
    
        ['DPT_Char_ASCII' STRING
            [reserved uint 8 '0x00']
            [simple   string 8 value encoding='"ASCII"']
            
        ]
    
        ['DPT_Char_8859_1' STRING
            [reserved uint 8 '0x00']
            [simple   string 8 value encoding='"ISO-8859-1"']
            
        ]
    
        ['DPT_Scaling' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Angle' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Percent_U8' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_DecimalFactor' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Tariff' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Value_1_Ucount' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_FanStage' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Percent_V8' SINT
            [reserved uint 8 '0x00']
                    
            [simple   int 8 value]
            
        ]
    
        ['DPT_Value_1_Count' SINT
            [reserved uint 8 '0x00']
                    
            [simple   int 8 value]
            
        ]
    
        ['DPT_Status_Mode3' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [simple bit statusA]
                
                    [simple bit statusB]
                
                    [simple bit statusC]
                
                    [simple bit statusD]
                
                    [simple bit statusE]
                
                    [simple uint 3 mode]
                
        ]
    
        ['DPT_Value_2_Ucount' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_TimePeriodMsec' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_TimePeriod10Msec' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_TimePeriod100Msec' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_TimePeriodSec' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_TimePeriodMin' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_TimePeriodHrs' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_PropDataType' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_Length_mm' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_UElCurrentmA' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_Brightness' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_Absolute_Colour_Temperature' UINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 16 value]
            
        ]
    
        ['DPT_Value_2_Count' INT
            [reserved uint 8 '0x00']
                    
            [simple   int 16 value]
            
        ]
    
        ['DPT_DeltaTimeMsec' INT
            [reserved uint 8 '0x00']
                    
            [simple   int 16 value]
            
        ]
    
        ['DPT_DeltaTime10Msec' INT
            [reserved uint 8 '0x00']
                    
            [simple   int 16 value]
            
        ]
    
        ['DPT_DeltaTime100Msec' INT
            [reserved uint 8 '0x00']
                    
            [simple   int 16 value]
            
        ]
    
        ['DPT_DeltaTimeSec' INT
            [reserved uint 8 '0x00']
                    
            [simple   int 16 value]
            
        ]
    
        ['DPT_DeltaTimeMin' INT
            [reserved uint 8 '0x00']
                    
            [simple   int 16 value]
            
        ]
    
        ['DPT_DeltaTimeHrs' INT
            [reserved uint 8 '0x00']
                    
            [simple   int 16 value]
            
        ]
    
        ['DPT_Percent_V16' INT
            [reserved uint 8 '0x00']
                    
            [simple   int 16 value]
            
        ]
    
        ['DPT_Rotation_Angle' INT
            [reserved uint 8 '0x00']
                    
            [simple   int 16 value]
            
        ]
    
        ['DPT_Length_m' INT
            [reserved uint 8 '0x00']
                    
            [simple   int 16 value]
            
        ]
    
        ['DPT_Value_Temp' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Tempd' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Tempa' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Lux' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Wsp' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Pres' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Humidity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_AirQuality' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_AirFlow' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Time1' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Time2' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Volt' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Curr' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_PowerDensity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_KelvinPerPercent' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Power' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Volume_Flow' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Rain_Amount' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Temp_F' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Wsp_kmh' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Value_Absolute_Humidity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Concentration_ygm3' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Coefficient' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_TimeOfDay' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [simple uint 3 day]
                
                    [simple uint 5 hour]
                
                    [reserved uint 2 '0x00']
                
                    [simple uint 6 minutes]
                
                    [reserved uint 2 '0x00']
                
                    [simple uint 6 seconds]
                
        ]
    
        ['DPT_Date' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [reserved uint 3 '0x00']
                
                    [simple uint 5 dayOfMonth]
                
                    [reserved uint 4 '0x00']
                
                    [simple uint 4 month]
                
                    [reserved uint 1 '0x00']
                
                    [simple uint 7 year]
                
        ]
    
        ['DPT_Value_4_Ucount' UDINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 32 value]
            
        ]
    
        ['DPT_LongTimePeriod_Sec' UDINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 32 value]
            
        ]
    
        ['DPT_LongTimePeriod_Min' UDINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 32 value]
            
        ]
    
        ['DPT_LongTimePeriod_Hrs' UDINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 32 value]
            
        ]
    
        ['DPT_VolumeLiquid_Litre' UDINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 32 value]
            
        ]
    
        ['DPT_Volume_m_3' UDINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 32 value]
            
        ]
    
        ['DPT_Value_4_Count' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_FlowRate_m3h' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_ActiveEnergy' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_ApparentEnergy' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_ReactiveEnergy' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_ActiveEnergy_kWh' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_ApparentEnergy_kVAh' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_ReactiveEnergy_kVARh' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_ActiveEnergy_MWh' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_LongDeltaTimeSec' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_DeltaVolumeLiquid_Litre ' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_DeltaVolume_m_3' DINT
            [reserved uint 8 '0x00']
                    
            [simple   int 32 value]
            
        ]
    
        ['DPT_Value_Acceleration' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Acceleration_Angular' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Activation_Energy' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Activity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Mol' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Amplitude' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_AngleRad' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_AngleDeg' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Angular_Momentum' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Angular_Velocity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Area' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Capacitance' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Charge_DensitySurface' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Charge_DensityVolume' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Compressibility' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Conductance' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electrical_Conductivity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Density' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_Charge' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_Current' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_CurrentDensity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_DipoleMoment' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_Displacement' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_FieldStrength' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_Flux' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_FluxDensity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_Polarization' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_Potential' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electric_PotentialDifference' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_ElectromagneticMoment' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Electromotive_Force' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Energy' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Force' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Frequency' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Angular_Frequency' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Heat_Capacity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Heat_FlowRate' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Heat_Quantity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Impedance' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Length' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Light_Quantity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Luminance' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Luminous_Flux' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Luminous_Intensity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Magnetic_FieldStrength' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Magnetic_Flux' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Magnetic_FluxDensity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Magnetic_Moment' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Magnetic_Polarization' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Magnetization' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_MagnetomotiveForce' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Mass' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_MassFlux' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Momentum' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Phase_AngleRad' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Phase_AngleDeg' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Power' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Power_Factor' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Pressure' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Reactance' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Resistance' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Resistivity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_SelfInductance' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_SolidAngle' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Sound_Intensity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Speed' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Stress' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Surface_Tension' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Common_Temperature' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Absolute_Temperature' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_TemperatureDifference' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Thermal_Capacity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Thermal_Conductivity' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_ThermoelectricPower' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Time' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Torque' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Volume' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Volume_Flux' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Weight' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_Work' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Value_ApparentPower' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 32 value]
                    
        ]
    
        ['DPT_Volume_Flux_Meter' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Volume_Flux_ls' REAL
            [reserved uint 8 '0x00']
                
            [simple   float 16 value encoding='"KNXFloat"']
                    
        ]
    
        ['DPT_Access_Data' Struct
           // Field Size 32
           [reserved uint 8 '0x00']

                    
                    [simple uint 4 hurz]
                
                    [simple uint 4 value1]
                
                    [simple uint 4 value2]
                
                    [simple uint 4 value3]
                
                    [simple uint 4 value4]
                
                    [simple uint 4 value5]
                
                    [simple bit detectionError]
                
                    [simple bit permission]
                
                    [simple bit readDirection]
                
                    [simple bit encryptionOfAccessInformation]
                
                    [simple uint 4 indexOfAccessIdentificationCode]
                
        ]
    
        ['DPT_String_ASCII' STRING
            [reserved uint 8 '0x00']
            [simple   string 112 value encoding='"ASCII"']
            
        ]
    
        ['DPT_String_8859_1' STRING
            [reserved uint 8 '0x00']
            [simple   string 112 value encoding='"ISO-8859-1"']
            
        ]
    
        ['DPT_SceneNumber' USINT
            [reserved uint 2 '0x00']
                    
            [simple   uint 6 value]
            
        ]
    
        ['DPT_SceneControl' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [simple bit learnTheSceneCorrespondingToTheFieldSceneNumber]
                
                    [reserved uint 1 '0x00']
                
                    [simple uint 6 sceneNumber]
                
        ]
    
        ['DPT_DateTime' Struct
           // Field Size 64
           [reserved uint 8 '0x00']

                    
                    [simple uint 8 year]
                
                    [reserved uint 4 '0x00']
                
                    [simple uint 4 month]
                
                    [reserved uint 3 '0x00']
                
                    [simple uint 5 dayofmonth]
                
                    [simple uint 3 dayofweek]
                
                    [simple uint 5 hourofday]
                
                    [reserved uint 2 '0x00']
                
                    [simple uint 6 minutes]
                
                    [reserved uint 2 '0x00']
                
                    [simple uint 6 seconds]
                
                    [simple bit fault]
                
                    [simple bit workingDay]
                
                    [simple bit noWd]
                
                    [simple bit noYear]
                
                    [simple bit noDate]
                
                    [simple bit noDayOfWeek]
                
                    [simple bit noTime]
                
                    [simple bit standardSummerTime]
                
                    [simple bit qualityOfClock]
                
                    [reserved uint 7 '0x00']
                
        ]
    
        ['DPT_SCLOMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_BuildingMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_OccMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Priority' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_LightApplicationMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_ApplicationArea' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_AlarmClassType' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_PSUMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_ErrorClass_System' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_ErrorClass_HVAC' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Time_Delay' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Beaufort_Wind_Force_Scale' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_SensorSelect' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_ActuatorConnectType' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Cloud_Cover' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_PowerReturnMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_FuelType' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_BurnerType' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_HVACMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_DHWMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_LoadPriority' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_HVACContrMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_HVACEmergMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_ChangeoverMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_ValveMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_DamperMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_HeaterMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_FanMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_MasterSlaveMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_StatusRoomSetp' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Metering_DeviceType' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_HumDehumMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_EnableHCStage' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_ADAType' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_BackupMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_StartSynchronization' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Behaviour_Lock_Unlock' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Behaviour_Bus_Power_Up_Down' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_DALI_Fade_Time' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_BlinkingMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_LightControlMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_SwitchPBModel' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_PBAction' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_DimmPBModel' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_SwitchOnMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_LoadTypeSet' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_LoadTypeDetected' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Converter_Test_Control' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_Converter_Control' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_SABExcept_Behaviour' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_SABBehaviour_Lock_Unlock' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_SSSBMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_BlindsControlMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_CommMode' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_AddInfoTypes' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_RF_ModeSelect' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_RF_FilterSelect' USINT
            [reserved uint 8 '0x00']
                    
            [simple   uint 8 value]
            
        ]
    
        ['DPT_StatusGen' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [reserved uint 3 '0x00']
                
                    [simple bit alarmStatusOfCorrespondingDatapointIsNotAcknowledged]
                
                    [simple bit correspondingDatapointIsInAlarm]
                
                    [simple bit correspondingDatapointMainValueIsOverridden]
                
                    [simple bit correspondingDatapointMainValueIsCorruptedDueToFailure]
                
                    [simple bit correspondingDatapointValueIsOutOfService]
                
        ]
    
        ['DPT_Device_Control' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [reserved uint 5 '0x00']
                
                    [simple bit verifyModeIsOn]
                
                    [simple bit aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived]
                
                    [simple bit theUserApplicationIsStopped]
                
        ]
    
        ['DPT_ForceSign' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [simple bit roomhmax]
                
                    [simple bit roomhconf]
                
                    [simple bit dhwlegio]
                
                    [simple bit dhwnorm]
                
                    [simple bit overrun]
                
                    [simple bit oversupply]
                
                    [simple bit protection]
                
                    [simple bit forcerequest]
                
        ]
    
        ['DPT_ForceSignCool' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_StatusRHC' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [simple bit summermode]
                
                    [simple bit statusstopoptim]
                
                    [simple bit statusstartoptim]
                
                    [simple bit statusmorningboost]
                
                    [simple bit tempreturnlimit]
                
                    [simple bit tempflowlimit]
                
                    [simple bit satuseco]
                
                    [simple bit fault]
                
        ]
    
        ['DPT_StatusSDHWC' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [reserved uint 5 '0x00']
                
                    [simple bit solarloadsufficient]
                
                    [simple bit sdhwloadactive]
                
                    [simple bit fault]
                
        ]
    
        ['DPT_FuelTypeSet' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [reserved uint 5 '0x00']
                
                    [simple bit solidstate]
                
                    [simple bit gas]
                
                    [simple bit oil]
                
        ]
    
        ['DPT_StatusRCC' BOOL
            [reserved uint 7 '0x00']
            [simple   bit    value ]
            
        ]
    
        ['DPT_StatusAHU' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [reserved uint 4 '0x00']
                
                    [simple bit cool]
                
                    [simple bit heat]
                
                    [simple bit fanactive]
                
                    [simple bit fault]
                
        ]
    
        ['DPT_CombinedStatus_RTSM' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [reserved uint 3 '0x00']
                
                    [simple bit statusOfHvacModeUser]
                
                    [simple bit statusOfComfortProlongationUser]
                
                    [simple bit effectiveValueOfTheComfortPushButton]
                
                    [simple bit effectiveValueOfThePresenceStatus]
                
                    [simple bit effectiveValueOfTheWindowStatus]
                
        ]
    
        ['DPT_LightActuatorErrorInfo' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [reserved uint 1 '0x00']
                
                    [simple bit overheat]
                
                    [simple bit lampfailure]
                
                    [simple bit defectiveload]
                
                    [simple bit underload]
                
                    [simple bit overcurrent]
                
                    [simple bit undervoltage]
                
                    [simple bit loaddetectionerror]
                
        ]
    
        ['DPT_RF_ModeInfo' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [reserved uint 5 '0x00']
                
                    [simple bit bibatSlave]
                
                    [simple bit bibatMaster]
                
                    [simple bit asynchronous]
                
        ]
    
        ['DPT_RF_FilterInfo' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [reserved uint 5 '0x00']
                
                    [simple bit doa]
                
                    [simple bit knxSn]
                
                    [simple bit doaAndKnxSn]
                
        ]
    
        ['DPT_Channel_Activation_8' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [simple bit activationStateOfChannel1]
                
                    [simple bit activationStateOfChannel2]
                
                    [simple bit activationStateOfChannel3]
                
                    [simple bit activationStateOfChannel4]
                
                    [simple bit activationStateOfChannel5]
                
                    [simple bit activationStateOfChannel6]
                
                    [simple bit activationStateOfChannel7]
                
                    [simple bit activationStateOfChannel8]
                
        ]
    
        ['DPT_StatusDHWC' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [reserved uint 8 '0x00']
                
                    [simple bit tempoptimshiftactive]
                
                    [simple bit solarenergysupport]
                
                    [simple bit solarenergyonly]
                
                    [simple bit otherenergysourceactive]
                
                    [simple bit dhwpushactive]
                
                    [simple bit legioprotactive]
                
                    [simple bit dhwloadactive]
                
                    [simple bit fault]
                
        ]
    
        ['DPT_StatusRHCC' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [reserved uint 1 '0x00']
                
                    [simple bit overheatalarm]
                
                    [simple bit frostalarm]
                
                    [simple bit dewpointstatus]
                
                    [simple bit coolingdisabled]
                
                    [simple bit statusprecool]
                
                    [simple bit statusecoc]
                
                    [simple bit heatcoolmode]
                
                    [simple bit heatingdiabled]
                
                    [simple bit statusstopoptim]
                
                    [simple bit statusstartoptim]
                
                    [simple bit statusmorningboosth]
                
                    [simple bit tempflowreturnlimit]
                
                    [simple bit tempflowlimit]
                
                    [simple bit statusecoh]
                
                    [simple bit fault]
                
        ]
    
        ['DPT_CombinedStatus_HVA' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [reserved uint 7 '0x00']
                
                    [simple bit calibrationMode]
                
                    [simple bit lockedPosition]
                
                    [simple bit forcedPosition]
                
                    [simple bit manuaOperationOverridden]
                
                    [simple bit serviceMode]
                
                    [simple bit valveKick]
                
                    [simple bit overload]
                
                    [simple bit shortCircuit]
                
                    [simple bit currentValvePosition]
                
        ]
    
        ['DPT_CombinedStatus_RTC' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [reserved uint 7 '0x00']
                
                    [simple bit coolingModeEnabled]
                
                    [simple bit heatingModeEnabled]
                
                    [simple bit additionalHeatingCoolingStage2Stage]
                
                    [simple bit controllerInactive]
                
                    [simple bit overheatAlarm]
                
                    [simple bit frostAlarm]
                
                    [simple bit dewPointStatus]
                
                    [simple bit activeMode]
                
                    [simple bit generalFailureInformation]
                
        ]
    
        ['DPT_Media' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [reserved uint 10 '0x00']
                
                    [simple bit knxIp]
                
                    [simple bit rf]
                
                    [reserved uint 1 '0x00']
                
                    [simple bit pl110]
                
                    [simple bit tp1]
                
                    [reserved uint 1 '0x00']
                
        ]
    
        ['DPT_Channel_Activation_16' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [simple bit activationStateOfChannel1]
                
                    [simple bit activationStateOfChannel2]
                
                    [simple bit activationStateOfChannel3]
                
                    [simple bit activationStateOfChannel4]
                
                    [simple bit activationStateOfChannel5]
                
                    [simple bit activationStateOfChannel6]
                
                    [simple bit activationStateOfChannel7]
                
                    [simple bit activationStateOfChannel8]
                
                    [simple bit activationStateOfChannel9]
                
                    [simple bit activationStateOfChannel10]
                
                    [simple bit activationStateOfChannel11]
                
                    [simple bit activationStateOfChannel12]
                
                    [simple bit activationStateOfChannel13]
                
                    [simple bit activationStateOfChannel14]
                
                    [simple bit activationStateOfChannel15]
                
                    [simple bit activationStateOfChannel16]
                
        ]
    
        ['DPT_OnOffAction' USINT
            [reserved uint 6 '0x00']
                    
            [simple   uint 2 value]
            
        ]
    
        ['DPT_Alarm_Reaction' USINT
            [reserved uint 6 '0x00']
                    
            [simple   uint 2 value]
            
        ]
    
        ['DPT_UpDown_Action' USINT
            [reserved uint 6 '0x00']
                    
            [simple   uint 2 value]
            
        ]
    
        ['DPT_HVAC_PB_Action' USINT
            [reserved uint 6 '0x00']
                    
            [simple   uint 2 value]
            
        ]
    
        ['DPT_DoubleNibble' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [simple uint 4 busy]
                
                    [simple uint 4 nak]
                
        ]
    
        ['DPT_SceneInfo' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [reserved uint 1 '0x00']
                
                    [simple bit sceneIsInactive]
                
                    [simple uint 6 scenenumber]
                
        ]
    
        ['DPT_CombinedInfoOnOff' Struct
           // Field Size 32
           [reserved uint 8 '0x00']

                    
                    [simple bit maskBitInfoOnOffOutput16]
                
                    [simple bit maskBitInfoOnOffOutput15]
                
                    [simple bit maskBitInfoOnOffOutput14]
                
                    [simple bit maskBitInfoOnOffOutput13]
                
                    [simple bit maskBitInfoOnOffOutput12]
                
                    [simple bit maskBitInfoOnOffOutput11]
                
                    [simple bit maskBitInfoOnOffOutput10]
                
                    [simple bit maskBitInfoOnOffOutput9]
                
                    [simple bit maskBitInfoOnOffOutput8]
                
                    [simple bit maskBitInfoOnOffOutput7]
                
                    [simple bit maskBitInfoOnOffOutput6]
                
                    [simple bit maskBitInfoOnOffOutput5]
                
                    [simple bit maskBitInfoOnOffOutput4]
                
                    [simple bit maskBitInfoOnOffOutput3]
                
                    [simple bit maskBitInfoOnOffOutput2]
                
                    [simple bit maskBitInfoOnOffOutput1]
                
                    [simple bit infoOnOffOutput16]
                
                    [simple bit infoOnOffOutput15]
                
                    [simple bit infoOnOffOutput14]
                
                    [simple bit infoOnOffOutput13]
                
                    [simple bit infoOnOffOutput12]
                
                    [simple bit infoOnOffOutput11]
                
                    [simple bit infoOnOffOutput10]
                
                    [simple bit infoOnOffOutput9]
                
                    [simple bit infoOnOffOutput8]
                
                    [simple bit infoOnOffOutput7]
                
                    [simple bit infoOnOffOutput6]
                
                    [simple bit infoOnOffOutput5]
                
                    [simple bit infoOnOffOutput4]
                
                    [simple bit infoOnOffOutput3]
                
                    [simple bit infoOnOffOutput2]
                
                    [simple bit infoOnOffOutput1]
                
        ]
    
        ['DPT_ActiveEnergy_V64' LINT
            [reserved uint 8 '0x00']
                    
            [simple   int 64 value]
            
        ]
    
        ['DPT_ApparentEnergy_V64' LINT
            [reserved uint 8 '0x00']
                    
            [simple   int 64 value]
            
        ]
    
        ['DPT_ReactiveEnergy_V64' LINT
            [reserved uint 8 '0x00']
                    
            [simple   int 64 value]
            
        ]
    
        ['DPT_Channel_Activation_24' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [simple bit activationStateOfChannel1]
                
                    [simple bit activationStateOfChannel2]
                
                    [simple bit activationStateOfChannel3]
                
                    [simple bit activationStateOfChannel4]
                
                    [simple bit activationStateOfChannel5]
                
                    [simple bit activationStateOfChannel6]
                
                    [simple bit activationStateOfChannel7]
                
                    [simple bit activationStateOfChannel8]
                
                    [simple bit activationStateOfChannel9]
                
                    [simple bit activationStateOfChannel10]
                
                    [simple bit activationStateOfChannel11]
                
                    [simple bit activationStateOfChannel12]
                
                    [simple bit activationStateOfChannel13]
                
                    [simple bit activationStateOfChannel14]
                
                    [simple bit activationStateOfChannel15]
                
                    [simple bit activationStateOfChannel16]
                
                    [simple bit activationStateOfChannel17]
                
                    [simple bit activationStateOfChannel18]
                
                    [simple bit activationStateOfChannel19]
                
                    [simple bit activationStateOfChannel20]
                
                    [simple bit activationStateOfChannel21]
                
                    [simple bit activationStateOfChannel22]
                
                    [simple bit activationStateOfChannel23]
                
                    [simple bit activationStateOfChannel24]
                
        ]
    
        ['DPT_HVACModeNext' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [simple uint 16 delayTimeMin]
                
                    [simple uint 8 hvacMode]
                
        ]
    
        ['DPT_DHWModeNext' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [simple uint 16 delayTimeMin]
                
                    [simple uint 8 dhwMode]
                
        ]
    
        ['DPT_OccModeNext' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [simple uint 16 delayTimeMin]
                
                    [simple uint 8 occupancyMode]
                
        ]
    
        ['DPT_BuildingModeNext' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [simple uint 16 delayTimeMin]
                
                    [simple uint 8 buildingMode]
                
        ]
    
        ['DPT_StatusLightingActuator' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [simple bit validactualvalue]
                
                    [simple bit locked]
                
                    [simple bit forced]
                
                    [simple bit nightmodeactive]
                
                    [simple bit staircaselightingFunction]
                
                    [simple bit dimming]
                
                    [simple bit localoverride]
                
                    [simple bit failure]
                
                    [simple uint 8 actualvalue]
                
        ]
    
        ['DPT_Version' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [simple uint 5 magicNumber]
                
                    [simple uint 5 versionNumber]
                
                    [simple uint 6 revisionNumber]
                
        ]
    
        ['DPT_AlarmInfo' Struct
           // Field Size 48
           [reserved uint 8 '0x00']

                    
                    [simple uint 8 logNumber]
                
                    [simple uint 8 alarmPriority]
                
                    [simple uint 8 applicationArea]
                
                    [simple uint 8 errorClass]
                
                    [reserved uint 4 '0x00']
                
                    [simple bit errorcodeSup]
                
                    [simple bit alarmtextSup]
                
                    [simple bit timestampSup]
                
                    [simple bit ackSup]
                
                    [reserved uint 5 '0x00']
                
                    [simple bit locked]
                
                    [simple bit alarmunack]
                
                    [simple bit inalarm]
                
        ]
    
        ['DPT_TempRoomSetpSetF16_3' Struct
           // Field Size 48
           [reserved uint 8 '0x00']

                    
                    [simple float 16 tempsetpcomf encoding='"KNXFloat"']
                
                    [simple float 16 tempsetpstdby encoding='"KNXFloat"']
                
                    [simple float 16 tempsetpeco encoding='"KNXFloat"']
                
        ]
    
        ['DPT_TempRoomSetpSetShiftF16_3' Struct
           // Field Size 48
           [reserved uint 8 '0x00']

                    
                    [simple float 16 tempsetpshiftcomf encoding='"KNXFloat"']
                
                    [simple float 16 tempsetpshiftstdby encoding='"KNXFloat"']
                
                    [simple float 16 tempsetpshifteco encoding='"KNXFloat"']
                
        ]
    
        ['DPT_Scaling_Speed' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [simple uint 16 timePeriod]
                
                    [simple uint 8 percent]
                
        ]
    
        ['DPT_Scaling_Step_Time' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [simple uint 16 timePeriod]
                
                    [simple uint 8 percent]
                
        ]
    
        ['DPT_MeteringValue' Struct
           // Field Size 48
           [reserved uint 8 '0x00']

                    
                    [simple int 32 countval]
                
                    [simple uint 8 valinffield]
                
                    [reserved uint 3 '0x00']
                
                    [simple bit alarmunack]
                
                    [simple bit inalarm]
                
                    [simple bit overridden]
                
                    [simple bit fault]
                
                    [simple bit outofservice]
                
        ]
    
        ['DPT_MBus_Address' Struct
           // Field Size 64
           [reserved uint 8 '0x00']

                    
                    [simple uint 16 manufactid]
                
                    [simple uint 32 identnumber]
                
                    [simple uint 8 version]
                
                    [simple uint 8 medium]
                
        ]
    
        ['DPT_Colour_RGB' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [simple uint 8 r]
                
                    [simple uint 8 g]
                
                    [simple uint 8 b]
                
        ]
    
        ['DPT_LanguageCodeAlpha2_ASCII' STRING
            [reserved uint 8 '0x00']
            [simple   string 16 value encoding='"ASCII"']
            
        ]
    
        ['DPT_Tariff_ActiveEnergy' Struct
           // Field Size 48
           [reserved uint 8 '0x00']

                    
                    [simple int 32 activeelectricalenergy]
                
                    [simple uint 8 tariff]
                
                    [reserved uint 6 '0x00']
                
                    [simple bit electricalengergyvalidity]
                
                    [simple bit tariffvalidity]
                
        ]
    
        ['DPT_Prioritised_Mode_Control' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [simple bit deactivationOfPriority]
                
                    [simple uint 3 priorityLevel]
                
                    [simple uint 4 modeLevel]
                
        ]
    
        ['DPT_DALI_Control_Gear_Diagnostic' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [reserved uint 5 '0x00']
                
                    [simple bit convertorError]
                
                    [simple bit ballastFailure]
                
                    [simple bit lampFailure]
                
                    [simple bit readOrResponse]
                
                    [simple bit addressIndicator]
                
                    [simple uint 6 daliDeviceAddressOrDaliGroupAddress]
                
        ]
    
        ['DPT_DALI_Diagnostics' Struct
           // Field Size 8
           [reserved uint 8 '0x00']

                    
                    [simple bit ballastFailure]
                
                    [simple bit lampFailure]
                
                    [simple uint 6 deviceAddress]
                
        ]
    
        ['DPT_CombinedPosition' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [simple uint 8 heightPosition]
                
                    [simple uint 8 slatsPosition]
                
                    [reserved uint 6 '0x00']
                
                    [simple bit validitySlatsPosition]
                
                    [simple bit validityHeightPosition]
                
        ]
    
        ['DPT_StatusSAB' Struct
           // Field Size 32
           [reserved uint 8 '0x00']

                    
                    [simple uint 8 heightPosition]
                
                    [simple uint 8 slatsPosition]
                
                    [simple bit upperEndPosReached]
                
                    [simple bit lowerEndPosReached]
                
                    [simple bit lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent]
                
                    [simple bit targetPosDrive]
                
                    [simple bit restrictionOfTargetHeightPosPosCanNotBeReached]
                
                    [simple bit restrictionOfSlatsHeightPosPosCanNotBeReached]
                
                    [simple bit atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm]
                
                    [simple bit upDownPositionIsForcedByMoveupdownforcedInput]
                
                    [simple bit movementIsLockedEGByDevicelockedInput]
                
                    [simple bit actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface]
                
                    [simple bit generalFailureOfTheActuatorOrTheDrive]
                
                    [reserved uint 3 '0x00']
                
                    [simple bit validityHeightPos]
                
                    [simple bit validitySlatsPos]
                
        ]
    
        ['DPT_Colour_xyY' Struct
           // Field Size 48
           [reserved uint 8 '0x00']

                    
                    [simple uint 16 xAxis]
                
                    [simple uint 16 yAxis]
                
                    [simple uint 8 brightness]
                
                    [reserved uint 6 '0x00']
                
                    [simple bit validityXy]
                
                    [simple bit validityBrightness]
                
        ]
    
        ['DPT_Converter_Status' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [simple uint 4 converterModeAccordingToTheDaliConverterStateMachine]
                
                    [reserved uint 2 '0x00']
                
                    [simple bit hardwiredSwitchIsActive]
                
                    [simple bit hardwiredInhibitIsActive]
                
                    [simple uint 2 functionTestPending]
                
                    [simple uint 2 durationTestPending]
                
                    [simple uint 2 partialDurationTestPending]
                
                    [simple uint 2 converterFailure]
                
        ]
    
        ['DPT_Converter_Test_Result' Struct
           // Field Size 48
           [reserved uint 8 '0x00']

                    
                    [simple uint 4 ltrf]
                
                    [simple uint 4 ltrd]
                
                    [simple uint 4 ltrp]
                
                    [reserved uint 4 '0x00']
                
                    [simple uint 2 sf]
                
                    [simple uint 2 sd]
                
                    [simple uint 2 sp]
                
                    [reserved uint 2 '0x00']
                
                    [simple uint 16 ldtr]
                
                    [simple uint 8 lpdtr]
                
        ]
    
        ['DPT_Battery_Info' Struct
           // Field Size 16
           [reserved uint 8 '0x00']

                    
                    [reserved uint 5 '0x00']
                
                    [simple bit batteryFailure]
                
                    [simple bit batteryDurationFailure]
                
                    [simple bit batteryFullyCharged]
                
                    [simple uint 8 batteryChargeLevel]
                
        ]
    
        ['DPT_Brightness_Colour_Temperature_Transition' Struct
           // Field Size 48
           [reserved uint 8 '0x00']

                    
                    [simple uint 16 ms]
                
                    [simple uint 16 temperatureK]
                
                    [simple uint 8 percent]
                
                    [reserved uint 5 '0x00']
                
                    [simple bit validityOfTheTimePeriod]
                
                    [simple bit validityOfTheAbsoluteColourTemperature]
                
                    [simple bit validityOfTheAbsoluteBrightness]
                
        ]
    
        ['DPT_Brightness_Colour_Temperature_Control' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [reserved uint 4 '0x00']
                
                    [simple bit cct]
                
                    [simple uint 3 stepCodeColourTemperature]
                
                    [reserved uint 4 '0x00']
                
                    [simple bit cb]
                
                    [simple uint 3 stepCodeBrightness]
                
                    [reserved uint 6 '0x00']
                
                    [simple bit cctAndStepCodeColourValidity]
                
                    [simple bit cbAndStepCodeBrightnessValidity]
                
        ]
    
        ['DPT_Colour_RGBW' Struct
           // Field Size 48
           [reserved uint 8 '0x00']

                    
                    [simple uint 8 colourLevelRed]
                
                    [simple uint 8 colourLevelGreen]
                
                    [simple uint 8 colourLevelBlue]
                
                    [simple uint 8 colourLevelWhite]
                
                    [reserved uint 8 '0x00']
                
                    [reserved uint 4 '0x00']
                
                    [simple bit mr]
                
                    [simple bit mg]
                
                    [simple bit mb]
                
                    [simple bit mw]
                
        ]
    
        ['DPT_Relative_Control_RGBW' Struct
           // Field Size 40
           [reserved uint 8 '0x00']

                    
                    [reserved uint 4 '0x00']
                
                    [simple bit maskcw]
                
                    [simple bit maskcb]
                
                    [simple bit maskcg]
                
                    [simple bit maskcr]
                
                    [reserved uint 4 '0x00']
                
                    [simple bit cw]
                
                    [simple uint 3 stepCodeColourWhite]
                
                    [reserved uint 4 '0x00']
                
                    [simple bit cb]
                
                    [simple uint 3 stepCodeColourBlue]
                
                    [reserved uint 4 '0x00']
                
                    [simple bit cg]
                
                    [simple uint 3 stepCodeColourGreen]
                
                    [reserved uint 4 '0x00']
                
                    [simple bit cr]
                
                    [simple uint 3 stepCodeColourRed]
                
        ]
    
        ['DPT_Relative_Control_RGB' Struct
           // Field Size 24
           [reserved uint 8 '0x00']

                    
                    [reserved uint 4 '0x00']
                
                    [simple bit cb]
                
                    [simple uint 3 stepCodeColourBlue]
                
                    [reserved uint 4 '0x00']
                
                    [simple bit cg]
                
                    [simple uint 3 stepCodeColourGreen]
                
                    [reserved uint 4 '0x00']
                
                    [simple bit cr]
                
                    [simple uint 3 stepCodeColourRed]
                
        ]
    
        ['DPT_GeographicalLocation' Struct
           // Field Size 64
           [reserved uint 8 '0x00']

                    
                    [simple float 32 longitude]
                
                    [simple float 32 latitude]
                
        ]
    
        ['DPT_TempRoomSetpSetF16_4' Struct
           // Field Size 64
           [reserved uint 8 '0x00']

                    
                    [simple float 16 roomTemperatureSetpointComfort encoding='"KNXFloat"']
                
                    [simple float 16 roomTemperatureSetpointStandby encoding='"KNXFloat"']
                
                    [simple float 16 roomTemperatureSetpointEconomy encoding='"KNXFloat"']
                
                    [simple float 16 roomTemperatureSetpointBuildingProtection encoding='"KNXFloat"']
                
        ]
    
        ['DPT_TempRoomSetpSetShiftF16_4' Struct
           // Field Size 64
           [reserved uint 8 '0x00']

                    
                    [simple float 16 roomTemperatureSetpointShiftComfort encoding='"KNXFloat"']
                
                    [simple float 16 roomTemperatureSetpointShiftStandby encoding='"KNXFloat"']
                
                    [simple float 16 roomTemperatureSetpointShiftEconomy encoding='"KNXFloat"']
                
                    [simple float 16 roomTemperatureSetpointShiftBuildingProtection encoding='"KNXFloat"']
                
        ]
    
    ]
]

////////////////////////////////////////////////////////////////
// External types
////////////////////////////////////////////////////////////////

[enum PlcValueType external='true']

    