/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * Test the setAttributeNodeNS method.
 * Retreive the street attribute from the second address element node.
 * Clone it and add it to the first address node.  The INUSE_ATTRIBUTE_ERR exception
 * should not be thrown. Check the name and value of the newly added node.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
 * @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=259">http://www.w3.org/Bugs/Public/show_bug.cgi?id=259</a>
 */
public class elementsetattributenodens02 {
    @Test
    void testRun() throws Throwable {
        String nullNS = null;

        Document doc = load("staffNS", true);
        NodeList elementList = doc.getElementsByTagNameNS("http://www.nist.gov", "address");
        Element element = (Element) elementList.item(1);
        Attr attribute = element.getAttributeNodeNS(nullNS, "street");
        Attr attributeCloned = (Attr) attribute.cloneNode(true);
        Element element2 = (Element) elementList.item(2);
        Attr newAttr = element2.setAttributeNodeNS(attributeCloned);
        String attrName = newAttr.getNodeName();
        String attrValue = newAttr.getNodeValue();
        assertEquals("street", attrName, "elementsetattributenodens02_attrName");
        assertEquals("Yes", attrValue, "elementsetattributenodens02_attrValue");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementsetattributenodens02";
    }

}
