/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The method setAttributeNS adds a new attribute.
 * Retreive an existing element node with a default attribute node and
 * add two new attribute nodes that have the same local name as the
 * default attribute but different namespaceURI to it using the setAttributeNS method.
 * Check if the attribute was correctly set by invoking the getAttributeNodeNS method
 * and checking the nodeName and nodeValue of the returned nodes.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAttrNS</a>
 */
public class elementsetattributens03 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", true);
        NodeList elementList = doc.getElementsByTagName("emp:employee");
        Element element = (Element) elementList.item(0);
        element.setAttributeNS("http://www.w3.org/DOM/Test/1", "defaultAttr", "default1");
        element.setAttributeNS("http://www.w3.org/DOM/Test/2", "defaultAttr", "default2");
        Attr attribute = element.getAttributeNodeNS("http://www.w3.org/DOM/Test/1", "defaultAttr");
        String attrName = attribute.getNodeName();
        String attrValue = attribute.getNodeValue();
        assertEquals("defaultAttr", attrName, "elementsetattributens03_attrName");
        assertEquals("default1", attrValue, "elementsetattributens03_attrValue");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementsetattributens03";
    }

}
