/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The "importNode(importedNode,deep)" method for a
 * Document should import the given importedNode into that Document.
 * The importedNode is of type Element.
 * If this document defines default attributes for this element name (importedNode),
 * those default attributes are assigned.
 * Create an element whose name is "emp:employee" in a different document.
 * Invoke method importNode(importedNode,deep) on this document which
 * defines default attribute for the element name "emp:employee".
 * Method should return an the imported element with an assigned default attribute.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode">http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode</a>
 * @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=238">http://www.w3.org/Bugs/Public/show_bug.cgi?id=238</a>
 */
public class importNode07 {
    @Test
    @Disabled("default attribute not supported")
    public void testRun() throws Throwable {
        String namespaceURI = "http://www.nist.gov";
        String qualifiedName = "emp:employee";
        Document doc = load("staffNS", true);
        Document aNewDoc = load("staff", true);
        Element element = aNewDoc.createElementNS(namespaceURI, qualifiedName);
        Node aNode = doc.importNode(element, false);
        NamedNodeMap attributes = aNode.getAttributes();
        assertEquals(1, attributes.getLength(), "throw_Size");
        String name = aNode.getNodeName();
        assertEquals("emp:employee", name, "nodeName");
        Node attr = attributes.item(0);
        String lname = attr.getLocalName();
        assertEquals("defaultAttr", lname, "lname");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/importNode07";
    }

}
