/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The method setNamedItemNS adds a node using its namespaceURI and localName. If a node with
 * that namespace URI and that local name is already present in this map, it is replaced
 * by the new one.
 * Create a new element and attribute Node and add the newly created attribute node to the elements
 * NamedNodeMap.  Verify if the new attr node has been successfully added to the map by checking
 * the nodeName of the retreived atttribute from the list of attribute nodes in this map.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS</a>
 */
public class namednodemapsetnameditemns02 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", true);
        Element element = doc.createElementNS("http://www.w3.org/DOM/Test", "root");
        Attr attribute1 = doc.createAttributeNS("http://www.w3.org/DOM/L1", "L1:att");
        NamedNodeMap attributes = element.getAttributes();
        Node newNode = attributes.setNamedItemNS(attribute1);
        Attr attribute = (Attr) attributes.getNamedItemNS("http://www.w3.org/DOM/L1", "att");
        String attrName = attribute.getNodeName();
        assertEquals("L1:att", attrName, "namednodemapsetnameditemns02");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/namednodemapsetnameditemns02";
    }

}
