/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * Retreieve the first element whose localName is address and its attributes into a named node map.
 * Retreiving the domestic attribute from the namednodemap.
 * Retreieve the second element whose localName is address and its attributes into a named node map.
 * Invoke setNamedItemNS on the second NamedNodeMap specifying the first domestic attribute from
 * the first map.  This should raise an INUSE_ATTRIBIUTE_ERR.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS</a>
 */
public class namednodemapsetnameditemns06 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", true);
        NodeList elementList = doc.getElementsByTagNameNS("*", "address");
        Element element = (Element) elementList.item(0);
        NamedNodeMap attributes = element.getAttributes();
        Attr attr = (Attr) attributes.getNamedItemNS("http://www.usa.com", "domestic");
        element = (Element) elementList.item(1);
        NamedNodeMap attributes2 = element.getAttributes();

        DOMException ex = assertThrows(DOMException.class, () -> attributes2.setNamedItemNS(attr));
        assertEquals(DOMException.INUSE_ATTRIBUTE_ERR, ex.code, "namednodemapsetnameditemns06");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/namednodemapsetnameditemns06";
    }

}
