/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.w3c.domts.DOMTest.load;


/**
 * The method hasAttributes returns whether this node (if it is an element) has any attributes.
 * Create a new Document, Element and Attr node.  Add the Attr to the Element and append the
 * Element to the Document.  Retreive the newly created element node from the document and check
 * if it has attributes using hasAttributes.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeHasAttrs">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeHasAttrs</a>
 */
public class nodehasattributes04 {
    @Test
    void testRun() throws Throwable {
        DocumentType docType = null;

        Document doc = load("staffNS", false);
        DOMImplementation domImpl = doc.getImplementation();
        Document newDoc = domImpl.createDocument("http://www.w3.org/DOM/Test", "test", docType);
        Element element = newDoc.createElementNS("http://www.w3.org/DOM/Test", "dom:elem");
        Attr attribute = newDoc.createAttribute("attr");
        Node setNode = element.setAttributeNode(attribute);
        Element elementDoc = newDoc.getDocumentElement();
        Node appendedChild = elementDoc.appendChild(element);
        NodeList elementList = newDoc.getElementsByTagNameNS("http://www.w3.org/DOM/Test", "elem");
        Element elementTest = (Element) elementList.item(0);
        boolean hasAttributes = elementTest.hasAttributes();
        assertTrue(hasAttributes, "nodehasattributes04");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/nodehasattributes04";
    }

}
