/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.internal.PropertiesUtils;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.websocket.ConsumerHandler;
import org.apache.pulsar.websocket.CryptoKeyReaderFactory;
import org.apache.pulsar.websocket.ProducerHandler;
import org.apache.pulsar.websocket.ReaderHandler;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.apache.pulsar.websocket.stats.ProxyStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketService
implements Closeable {
    AuthenticationService authenticationService;
    AuthorizationService authorizationService;
    PulsarClient pulsarClient;
    private final ScheduledExecutorService executor;
    private PulsarResources pulsarResources;
    private MetadataStoreExtended configMetadataStore;
    private ServiceConfiguration config;
    private Optional<CryptoKeyReader> cryptoKeyReader = Optional.empty();
    private ClusterData localCluster;
    private final ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<ProducerHandler>> topicProducerMap;
    private final ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<ConsumerHandler>> topicConsumerMap;
    private final ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<ReaderHandler>> topicReaderMap;
    private final ProxyStats proxyStats;
    private static final Logger log = LoggerFactory.getLogger(WebSocketService.class);

    public WebSocketService(WebSocketProxyConfiguration config) {
        this(WebSocketService.createClusterData(config), PulsarConfigurationLoader.convertFrom((PulsarConfiguration)config));
    }

    public WebSocketService(ClusterData localCluster, ServiceConfiguration config) {
        this.config = config;
        this.executor = Executors.newScheduledThreadPool(config.getWebSocketNumServiceThreads(), (ThreadFactory)new DefaultThreadFactory("pulsar-websocket"));
        this.localCluster = localCluster;
        this.topicProducerMap = ConcurrentOpenHashMap.newBuilder().build();
        this.topicConsumerMap = ConcurrentOpenHashMap.newBuilder().build();
        this.topicReaderMap = ConcurrentOpenHashMap.newBuilder().build();
        this.proxyStats = new ProxyStats(this);
    }

    public void start() throws PulsarServerException, PulsarClientException, MalformedURLException, ServletException, DeploymentException {
        if (StringUtils.isNotBlank((CharSequence)this.config.getConfigurationMetadataStoreUrl())) {
            try {
                this.configMetadataStore = this.createConfigMetadataStore(this.config.getConfigurationMetadataStoreUrl(), (int)this.config.getMetadataStoreSessionTimeoutMillis(), this.config.isMetadataStoreAllowReadOnlyOperations());
            }
            catch (MetadataStoreException e) {
                throw new PulsarServerException((Throwable)e);
            }
            this.pulsarResources = new PulsarResources(null, (MetadataStore)this.configMetadataStore);
        }
        if (this.config.isAuthorizationEnabled()) {
            if (this.pulsarResources == null) {
                throw new PulsarServerException("Failed to initialize authorization manager due to empty ConfigurationStoreServers");
            }
            this.authorizationService = new AuthorizationService(this.config, this.pulsarResources);
        }
        this.authenticationService = new AuthenticationService(this.config);
        String cryptoFactoryClassName = (String)this.config.getProperties().get("cryptoKeyReaderFactoryClassName");
        if (StringUtils.isNotBlank((CharSequence)cryptoFactoryClassName)) {
            try {
                CryptoKeyReaderFactory factoryInstance = (CryptoKeyReaderFactory)Class.forName(cryptoFactoryClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.cryptoKeyReader = Optional.ofNullable(factoryInstance.create());
            }
            catch (Exception e) {
                log.info("Failed to initialize crypto-key reader", (Throwable)e);
                throw new PulsarServerException((Throwable)e);
            }
        }
        log.info("Pulsar WebSocket Service started");
    }

    public MetadataStoreExtended createConfigMetadataStore(String serverUrls, int sessionTimeoutMs, boolean isAllowReadOnlyOperations) throws MetadataStoreException {
        return PulsarResources.createConfigMetadataStore((String)serverUrls, (int)sessionTimeoutMs, (boolean)isAllowReadOnlyOperations);
    }

    @Override
    public void close() throws IOException {
        if (this.pulsarClient != null) {
            this.pulsarClient.close();
        }
        if (this.authenticationService != null) {
            this.authenticationService.close();
        }
        if (this.configMetadataStore != null) {
            try {
                this.configMetadataStore.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.executor.shutdown();
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public synchronized PulsarClient getPulsarClient() throws IOException {
        if (this.pulsarClient == null) {
            if (this.localCluster == null) {
                this.localCluster = this.retrieveClusterData();
            }
            this.pulsarClient = this.createClientInstance(this.localCluster);
        }
        return this.pulsarClient;
    }

    public synchronized void setLocalCluster(ClusterData clusterData) {
        this.localCluster = clusterData;
    }

    private PulsarClient createClientInstance(ClusterData clusterData) throws IOException {
        ClientBuilder clientBuilder = PulsarClient.builder().memoryLimit(SizeUnit.MEGA_BYTES.toBytes((long)this.config.getWebSocketPulsarClientMemoryLimitInMB()), SizeUnit.BYTES).statsInterval(0L, TimeUnit.SECONDS).enableTls(this.config.isTlsEnabled()).allowTlsInsecureConnection(this.config.isTlsAllowInsecureConnection()).enableTlsHostnameVerification(this.config.isTlsHostnameVerificationEnabled()).tlsTrustCertsFilePath(this.config.getBrokerClientTrustCertsFilePath()).ioThreads(this.config.getWebSocketNumIoThreads()).connectionsPerBroker(this.config.getWebSocketConnectionsPerBroker());
        clientBuilder.loadConf(PropertiesUtils.filterAndMapProperties((Properties)this.config.getProperties(), (String)"brokerClient_"));
        clientBuilder.connectionMaxIdleSeconds(-1);
        if (StringUtils.isNotBlank((CharSequence)this.config.getBrokerClientAuthenticationPlugin()) && StringUtils.isNotBlank((CharSequence)this.config.getBrokerClientAuthenticationParameters())) {
            clientBuilder.authentication(this.config.getBrokerClientAuthenticationPlugin(), this.config.getBrokerClientAuthenticationParameters());
        }
        if (this.config.isBrokerClientTlsEnabled()) {
            if (StringUtils.isNotBlank((CharSequence)clusterData.getBrokerServiceUrlTls())) {
                clientBuilder.serviceUrl(clusterData.getBrokerServiceUrlTls());
            } else if (StringUtils.isNotBlank((CharSequence)clusterData.getServiceUrlTls())) {
                clientBuilder.serviceUrl(clusterData.getServiceUrlTls());
            }
        } else if (StringUtils.isNotBlank((CharSequence)clusterData.getBrokerServiceUrl())) {
            clientBuilder.serviceUrl(clusterData.getBrokerServiceUrl());
        } else {
            clientBuilder.serviceUrl(clusterData.getServiceUrl());
        }
        return clientBuilder.build();
    }

    private static ClusterData createClusterData(WebSocketProxyConfiguration config) {
        if (StringUtils.isNotBlank((CharSequence)config.getBrokerServiceUrl()) || StringUtils.isNotBlank((CharSequence)config.getBrokerServiceUrlTls())) {
            return ClusterData.builder().serviceUrl(config.getServiceUrl()).serviceUrlTls(config.getServiceUrlTls()).brokerServiceUrl(config.getBrokerServiceUrl()).brokerServiceUrlTls(config.getBrokerServiceUrlTls()).build();
        }
        if (StringUtils.isNotBlank((CharSequence)config.getServiceUrl()) || StringUtils.isNotBlank((CharSequence)config.getServiceUrlTls())) {
            return ClusterData.builder().serviceUrl(config.getServiceUrl()).serviceUrlTls(config.getServiceUrlTls()).build();
        }
        return null;
    }

    private ClusterData retrieveClusterData() throws PulsarServerException {
        if (this.pulsarResources == null) {
            throw new PulsarServerException("Failed to retrieve Cluster data due to empty ConfigurationStoreServers");
        }
        try {
            this.localCluster = (ClusterData)this.pulsarResources.getClusterResources().getCluster(this.config.getClusterName()).orElseThrow(() -> new MetadataStoreException.NotFoundException("Cluster " + this.config.getClusterName()));
            return this.localCluster;
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    public ProxyStats getProxyStats() {
        return this.proxyStats;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public boolean isAuthenticationEnabled() {
        if (this.config == null) {
            return false;
        }
        return this.config.isAuthenticationEnabled();
    }

    public boolean isAuthorizationEnabled() {
        if (this.config == null) {
            return false;
        }
        return this.config.isAuthorizationEnabled();
    }

    public boolean addProducer(ProducerHandler producer) {
        return ((ConcurrentOpenHashSet)this.topicProducerMap.computeIfAbsent((Object)producer.getProducer().getTopic(), topic -> ConcurrentOpenHashSet.newBuilder().build())).add((Object)producer);
    }

    public ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<ProducerHandler>> getProducers() {
        return this.topicProducerMap;
    }

    public boolean removeProducer(ProducerHandler producer) {
        String topicName = producer.getProducer().getTopic();
        if (this.topicProducerMap.containsKey((Object)topicName)) {
            return ((ConcurrentOpenHashSet)this.topicProducerMap.get((Object)topicName)).remove((Object)producer);
        }
        return false;
    }

    public boolean addConsumer(ConsumerHandler consumer) {
        return ((ConcurrentOpenHashSet)this.topicConsumerMap.computeIfAbsent((Object)consumer.getConsumer().getTopic(), topic -> ConcurrentOpenHashSet.newBuilder().build())).add((Object)consumer);
    }

    public ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<ConsumerHandler>> getConsumers() {
        return this.topicConsumerMap;
    }

    public boolean removeConsumer(ConsumerHandler consumer) {
        String topicName = consumer.getConsumer().getTopic();
        if (this.topicConsumerMap.containsKey((Object)topicName)) {
            return ((ConcurrentOpenHashSet)this.topicConsumerMap.get((Object)topicName)).remove((Object)consumer);
        }
        return false;
    }

    public boolean addReader(ReaderHandler reader) {
        return ((ConcurrentOpenHashSet)this.topicReaderMap.computeIfAbsent((Object)reader.getConsumer().getTopic(), topic -> ConcurrentOpenHashSet.newBuilder().build())).add((Object)reader);
    }

    public ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<ReaderHandler>> getReaders() {
        return this.topicReaderMap;
    }

    public boolean removeReader(ReaderHandler reader) {
        String topicName = reader.getConsumer().getTopic();
        if (this.topicReaderMap.containsKey((Object)topicName)) {
            return ((ConcurrentOpenHashSet)this.topicReaderMap.get((Object)topicName)).remove((Object)reader);
        }
        return false;
    }

    public ServiceConfiguration getConfig() {
        return this.config;
    }

    @Generated
    public Optional<CryptoKeyReader> getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }
}

