/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShutdownUtil.class);
    private static final Method log4j2ShutdownMethod;

    public static void triggerImmediateForcefulShutdown(int status) {
        ShutdownUtil.triggerImmediateForcefulShutdown(status, true);
    }

    public static void triggerImmediateForcefulShutdown(int status, boolean logging) {
        try {
            if (status != 0 && logging) {
                log.warn("Triggering immediate shutdown of current process with status {}", (Object)status, (Object)new Exception("Stacktrace for immediate shutdown"));
            }
            ShutdownUtil.shutdownLogging();
        }
        finally {
            Runtime.getRuntime().halt(status);
        }
    }

    private static void shutdownLogging() {
        if (log4j2ShutdownMethod != null) {
            try {
                log4j2ShutdownMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("Unable to call org.apache.logging.log4j.LogManager.shutdown using reflection.", (Throwable)e);
            }
        }
    }

    public static void triggerImmediateForcefulShutdown() {
        ShutdownUtil.triggerImmediateForcefulShutdown(1);
    }

    static {
        Method shutdownMethod = null;
        try {
            shutdownMethod = Class.forName("org.apache.logging.log4j.LogManager").getMethod("shutdown", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            log.debug("Cannot find org.apache.logging.log4j.LogManager.shutdown method", (Throwable)e);
        }
        log4j2ShutdownMethod = shutdownMethod;
    }
}

