/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFinder;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.plugin.ContentFactory;

public class ContentServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;
    private final ContentFactory _contentFactory;

    public ContentServlet(ContentFactory contentFactory) {
        this._contentFactory = contentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException {
        ConfiguredObject root = managedObject;
        String pathInfo = request.getPathInfo();
        if (managedObject instanceof Broker && null != pathInfo && !pathInfo.isEmpty()) {
            ConfiguredObjectFinder finder = this.getConfiguredObjectFinder(managedObject);
            ConfiguredObject virtualHost = finder.findObjectFromPath(pathInfo.substring(1), VirtualHost.class);
            if (null == virtualHost) {
                this.sendError(response, 404);
                return;
            }
            root = virtualHost;
        } else if (managedObject instanceof VirtualHost && null != pathInfo && !pathInfo.isEmpty()) {
            this.sendError(response, 400);
            return;
        }
        Map parameters = request.getParameterMap();
        Content content = this._contentFactory.createContent(root, parameters);
        try {
            this.writeContent(content, request, response);
        }
        finally {
            content.release();
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp, ConfiguredObject<?> managedObject) throws IOException {
        this.doGet(req, resp, managedObject);
    }
}

