/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlContext;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.Subject;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.configuration.updater.TaskExecutorImpl;
import org.apache.qpid.server.exchange.DefaultDestination;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.MessageStoreMessages;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.logging.subjects.MessageStoreLogSubject;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDeletedException;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageNode;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfigurationExtractor;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.DoOnConfigThread;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.NoFactoryForTypeException;
import org.apache.qpid.server.model.NotFoundException;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAccessControlProvider;
import org.apache.qpid.server.model.VirtualHostLogger;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.model.preferences.UserPreferencesImpl;
import org.apache.qpid.server.plugin.ConnectionValidator;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.plugin.SystemNodeCreator;
import org.apache.qpid.server.pool.SuppressingInheritedAccessControlContextThreadFactory;
import org.apache.qpid.server.protocol.LinkModel;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.CompoundAccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SubjectFixedResultAccessControl;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.SocketConnectionMetaData;
import org.apache.qpid.server.stats.StatisticsReportingTask;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.VirtualHostStoreUpgraderAndRecoverer;
import org.apache.qpid.server.store.handler.DistributedTransactionHandler;
import org.apache.qpid.server.store.handler.MessageHandler;
import org.apache.qpid.server.store.handler.MessageInstanceHandler;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdaterImpl;
import org.apache.qpid.server.store.preferences.PreferencesRecoverer;
import org.apache.qpid.server.store.serializer.MessageStoreSerializer;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.HousekeepingExecutor;
import org.apache.qpid.server.util.Strings;
import org.apache.qpid.server.virtualhost.AsynchronousMessageStoreRecoverer;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.LinkRegistryFactory;
import org.apache.qpid.server.virtualhost.LinkRegistryModel;
import org.apache.qpid.server.virtualhost.MessageStoreRecoverer;
import org.apache.qpid.server.virtualhost.NodeAutoCreationPolicy;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.apache.qpid.server.virtualhost.SynchronousMessageStoreRecoverer;
import org.apache.qpid.server.virtualhost.VirtualHostConnectionLimiter;
import org.apache.qpid.server.virtualhost.VirtualHostPrincipal;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVirtualHost<X extends AbstractVirtualHost<X>>
extends AbstractConfiguredObject<X>
implements QueueManagingVirtualHost<X> {
    private static final String USE_ASYNC_RECOVERY = "use_async_message_store_recovery";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVirtualHost.class);
    private static final Logger DIRECT_MEMORY_USAGE_LOGGER = LoggerFactory.getLogger((String)"org.apache.qpid.server.directMemory.virtualhost");
    private static final int HOUSEKEEPING_SHUTDOWN_TIMEOUT = 5;
    private final Collection<ConnectionValidator> _connectionValidators = new ArrayList<ConnectionValidator>();
    private final Set<AMQPConnection<?>> _connections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AccessControlContext _housekeepingJobContext;
    private final AccessControlContext _fileSystemSpaceCheckerJobContext;
    private final AtomicBoolean _acceptsConnections = new AtomicBoolean(false);
    private final ConcurrentMap<String, Cache> _caches = new ConcurrentHashMap<String, Cache>();
    private final Broker<?> _broker;
    private final DtxRegistry _dtxRegistry;
    private final SystemNodeRegistry _systemNodeRegistry = new SystemNodeRegistry();
    private final AtomicLong _messagesIn = new AtomicLong();
    private final AtomicLong _messagesOut = new AtomicLong();
    private final AtomicLong _transactedMessagesIn = new AtomicLong();
    private final AtomicLong _transactedMessagesOut = new AtomicLong();
    private final AtomicLong _bytesIn = new AtomicLong();
    private final AtomicLong _bytesOut = new AtomicLong();
    private final AtomicLong _totalConnectionCount = new AtomicLong();
    private final AtomicLong _maximumMessageSize = new AtomicLong();
    private final AtomicBoolean _blocked = new AtomicBoolean();
    private final Map<String, MessageDestination> _systemNodeDestinations = Collections.synchronizedMap(new HashMap());
    private final Map<String, MessageSource> _systemNodeSources = Collections.synchronizedMap(new HashMap());
    private final EventLogger _eventLogger;
    private final VirtualHostNode<?> _virtualHostNode;
    private final AtomicLong _targetSize = new AtomicLong(0x6400000L);
    private final Set<BlockingType> _blockingReasons = Collections.synchronizedSet(EnumSet.noneOf(BlockingType.class));
    private final VirtualHostPrincipal _principal;
    private final ConfigurationChangeListener _accessControlProviderListener = new AccessControlProviderListener();
    private final AccessControl _accessControl;
    private final AtomicBoolean _directMemoryExceedsTargetReported = new AtomicBoolean();
    private final AccessControl _systemUserAllowed = new SubjectFixedResultAccessControl(subject -> this.isSystemSubject(subject) ? Result.ALLOWED : Result.DEFER, Result.DEFER);
    private final VirtualHostConnectionLimiter _connectionLimiter;
    private final MessageDestination _defaultDestination;
    private final FileSystemSpaceChecker _fileSystemSpaceChecker;
    private volatile TaskExecutor _preferenceTaskExecutor;
    private volatile boolean _deleteRequested;
    private volatile ScheduledThreadPoolExecutor _houseKeepingTaskExecutor;
    private volatile ScheduledFuture<?> _statisticsReportingFuture;
    private volatile LinkRegistryModel _linkRegistry;
    private MessageStoreLogSubject _messageStoreLogSubject;
    private NetworkConnectionScheduler _networkConnectionScheduler;
    private volatile boolean _createDefaultExchanges;
    @ManagedAttributeField
    private boolean _queue_deadLetterQueueEnabled;
    @ManagedAttributeField
    private long _housekeepingCheckPeriod;
    @ManagedAttributeField
    private long _storeTransactionIdleTimeoutClose;
    @ManagedAttributeField
    private long _storeTransactionIdleTimeoutWarn;
    @ManagedAttributeField
    private long _storeTransactionOpenTimeoutClose;
    @ManagedAttributeField
    private long _storeTransactionOpenTimeoutWarn;
    @ManagedAttributeField
    private int _housekeepingThreadCount;
    @ManagedAttributeField
    private int _connectionThreadPoolSize;
    @ManagedAttributeField
    private int _numberOfSelectors;
    @ManagedAttributeField
    private List<String> _enabledConnectionValidators;
    @ManagedAttributeField
    private List<String> _disabledConnectionValidators;
    @ManagedAttributeField
    private List<String> _globalAddressDomains;
    @ManagedAttributeField
    private List<NodeAutoCreationPolicy> _nodeAutoCreationPolicies;
    @ManagedAttributeField
    private volatile int _statisticsReportingPeriod;
    private boolean _useAsyncRecoverer;
    private MessageStore _messageStore;
    private MessageStoreRecoverer _messageStoreRecoverer;
    private int _fileSystemMaxUsagePercent;
    private Collection<VirtualHostLogger> _virtualHostLoggersToClose;
    private PreferenceStore _preferenceStore;
    private long _flowToDiskCheckPeriod;
    private volatile boolean _isDiscardGlobalSharedSubscriptionLinksOnDetach;

    public AbstractVirtualHost(Map<String, Object> attributes, VirtualHostNode<?> virtualHostNode) {
        super(virtualHostNode, attributes);
        this._broker = (Broker)virtualHostNode.getParent();
        this._virtualHostNode = virtualHostNode;
        this._dtxRegistry = new DtxRegistry(this);
        SystemConfig systemConfig = (SystemConfig)this._broker.getParent();
        this._eventLogger = systemConfig.getEventLogger();
        this._principal = new VirtualHostPrincipal(this);
        this._accessControl = systemConfig.isManagementMode() ? AccessControl.ALWAYS_ALLOWED : new CompoundAccessControl(List.of(), Result.DEFER);
        this._defaultDestination = new DefaultDestination(this, this._accessControl);
        this._housekeepingJobContext = this.getSystemTaskControllerContext("Housekeeping[" + this.getName() + "]", this._principal);
        this._fileSystemSpaceCheckerJobContext = this.getSystemTaskControllerContext("FileSystemSpaceChecker[" + this.getName() + "]", this._principal);
        this._fileSystemSpaceChecker = new FileSystemSpaceChecker();
        this._connectionLimiter = new VirtualHostConnectionLimiter(this, this._broker);
    }

    private void updateAccessControl() {
        if (!((SystemConfig)this._broker.getParent()).isManagementMode()) {
            ArrayList<VirtualHostAccessControlProvider> children = new ArrayList<VirtualHostAccessControlProvider>(this.getChildren(VirtualHostAccessControlProvider.class));
            LOGGER.debug("Updating access control list with {} provider children", (Object)children.size());
            Collections.sort(children, VirtualHostAccessControlProvider.ACCESS_CONTROL_PROVIDER_COMPARATOR);
            ArrayList accessControls = new ArrayList(children.size() + 2);
            accessControls.add(this._systemUserAllowed);
            for (VirtualHostAccessControlProvider prov : children) {
                if (prov.getState() == State.ERRORED) {
                    accessControls.clear();
                    accessControls.add(AccessControl.ALWAYS_DENIED);
                    break;
                }
                if (prov.getState() != State.ACTIVE) continue;
                accessControls.add(prov.getController());
            }
            accessControls.add(this.getParentAccessControl());
            ((CompoundAccessControl)this._accessControl).setAccessControls(accessControls);
        }
    }

    private void openConnectionLimiter() {
        this._connectionLimiter.open();
    }

    private void activateConnectionLimiter() {
        this._connectionLimiter.activate();
    }

    private void closeConnectionLimiter() {
        this._connectionLimiter.close();
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this._createDefaultExchanges = true;
    }

    @Override
    public void setFirstOpening(boolean firstOpening) {
        this._createDefaultExchanges = firstOpening;
    }

    @Override
    public void onValidate() {
        super.onValidate();
        String name = this.getName();
        if (name == null || "".equals(name.trim())) {
            throw new IllegalConfigurationException("Virtual host name must be specified");
        }
        String type = this.getType();
        if (type == null || "".equals(type.trim())) {
            throw new IllegalConfigurationException("Virtual host type must be specified");
        }
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
        if (this.getGlobalAddressDomains() != null) {
            for (String domain : this.getGlobalAddressDomains()) {
                this.validateGlobalAddressDomain(domain);
            }
        }
        if (this.getNodeAutoCreationPolicies() != null) {
            for (NodeAutoCreationPolicy policy : this.getNodeAutoCreationPolicies()) {
                this.validateNodeAutoCreationPolicy(policy);
            }
        }
        this.validateConnectionThreadPoolSettings(this);
        this.validateMessageStoreCreation();
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        QueueManagingVirtualHost virtualHost = (QueueManagingVirtualHost)proxyForValidation;
        if (changedAttributes.contains("globalAddressDomains") && virtualHost.getGlobalAddressDomains() != null) {
            for (String name : virtualHost.getGlobalAddressDomains()) {
                this.validateGlobalAddressDomain(name);
            }
        }
        if (changedAttributes.contains("nodeAutoCreationPolicies") && this.getNodeAutoCreationPolicies() != null) {
            for (NodeAutoCreationPolicy policy : virtualHost.getNodeAutoCreationPolicies()) {
                this.validateNodeAutoCreationPolicy(policy);
            }
        }
        if (changedAttributes.contains("connectionThreadPoolSize") || changedAttributes.contains("numberOfSelectors")) {
            this.validateConnectionThreadPoolSettings(virtualHost);
        }
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        super.changeAttributes(attributes);
        if (attributes.containsKey("statisticsReportingPeriod")) {
            this.initialiseStatisticsReporting();
        }
    }

    @Override
    protected AccessControl getAccessControl() {
        return this._accessControl;
    }

    private AccessControl getParentAccessControl() {
        return super.getAccessControl();
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        this.addChangeListener(this._accessControlProviderListener);
        Collection<VirtualHostAccessControlProvider> accessControlProviders = this.getChildren(VirtualHostAccessControlProvider.class);
        if (!accessControlProviders.isEmpty()) {
            accessControlProviders.forEach(child -> child.addChangeListener(this._accessControlProviderListener));
        }
    }

    private void validateNodeAutoCreationPolicy(NodeAutoCreationPolicy policy) {
        String pattern = policy.getPattern();
        if (pattern == null) {
            throw new IllegalArgumentException("The 'pattern' attribute of a NodeAutoCreationPolicy MUST be supplied: " + String.valueOf(policy));
        }
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("The 'pattern' attribute of a NodeAutoCreationPolicy MUST be a valid Java Regular Expression Pattern, the value '" + pattern + "' is not: " + String.valueOf(policy));
        }
        String nodeType = policy.getNodeType();
        Class<? extends ConfiguredObject> sourceClass = null;
        for (Class<? extends ConfiguredObject> childClass : this.getModel().getChildTypes(this.getCategoryClass())) {
            if (!childClass.getSimpleName().equalsIgnoreCase(nodeType.trim())) continue;
            sourceClass = childClass;
            break;
        }
        if (sourceClass == null) {
            throw new IllegalArgumentException("The node type of a NodeAutoCreationPolicy must be a valid child type of a VirtualHost, '" + nodeType + "' is not.");
        }
        if (policy.isCreatedOnConsume() && !MessageSource.class.isAssignableFrom(sourceClass)) {
            throw new IllegalArgumentException("A NodeAutoCreationPolicy which creates nodes on consume must have a nodeType which implements MessageSource, '" + nodeType + "' does not.");
        }
        if (policy.isCreatedOnPublish() && !MessageDestination.class.isAssignableFrom(sourceClass)) {
            throw new IllegalArgumentException("A NodeAutoCreationPolicy which creates nodes on publish must have a nodeType which implements MessageDestination, '" + nodeType + "' does not.");
        }
        if (!policy.isCreatedOnConsume() && !policy.isCreatedOnPublish()) {
            throw new IllegalArgumentException("A NodeAutoCreationPolicy must create on consume, create on publish or both.");
        }
    }

    private void validateGlobalAddressDomain(String name) {
        String regex = "/(/?)([\\w_\\-:.\\$]+/)*[\\w_\\-:.\\$]+";
        if (!name.matches(regex)) {
            throw new IllegalArgumentException("'" + name + "' is not a valid global address domain");
        }
    }

    @Override
    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    private void validateConnectionThreadPoolSettings(QueueManagingVirtualHost<?> virtualHost) {
        if (virtualHost.getConnectionThreadPoolSize() < 1) {
            throw new IllegalConfigurationException(String.format("Thread pool size %d on VirtualHost %s must be greater than zero.", virtualHost.getConnectionThreadPoolSize(), this.getName()));
        }
        if (virtualHost.getNumberOfSelectors() < 1) {
            throw new IllegalConfigurationException(String.format("Number of Selectors %d on VirtualHost %s must be greater than zero.", virtualHost.getNumberOfSelectors(), this.getName()));
        }
        if (virtualHost.getConnectionThreadPoolSize() <= virtualHost.getNumberOfSelectors()) {
            throw new IllegalConfigurationException(String.format("Number of Selectors %d on VirtualHost %s must be less than the connection pool size %d.", virtualHost.getNumberOfSelectors(), this.getName(), virtualHost.getConnectionThreadPoolSize()));
        }
    }

    protected void validateMessageStoreCreation() {
        MessageStore store = this.createMessageStore();
        if (store != null) {
            try {
                store.openMessageStore(this);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException("Cannot open virtual host message store:" + e.getMessage(), e);
            }
            finally {
                try {
                    store.closeMessageStore();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to close database", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void onExceptionInOpen(RuntimeException e) {
        super.onExceptionInOpen(e);
        this.shutdownHouseKeeping();
        this.closeNetworkConnectionScheduler();
        this.closeMessageStore();
        this.stopPreferenceTaskExecutor();
        this.closePreferenceStore();
        this.closeConnectionLimiter();
        this.stopLogging(new ArrayList<VirtualHostLogger>(this.getChildren(VirtualHostLogger.class)));
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.registerSystemNodes();
        this._messageStore = this.createMessageStore();
        this._messageStoreLogSubject = new MessageStoreLogSubject(this.getName(), this._messageStore.getClass().getSimpleName());
        this._messageStore.addEventListener(this, Event.PERSISTENT_MESSAGE_SIZE_OVERFULL);
        this._messageStore.addEventListener(this, Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
        this._fileSystemMaxUsagePercent = this.getContextValue(Integer.class, "store.filesystem.maxUsagePercent");
        this._flowToDiskCheckPeriod = this.getContextValue(Long.class, "virtualhost.flowToDiskCheckPeriod");
        this._isDiscardGlobalSharedSubscriptionLinksOnDetach = this.getContextValue(Boolean.class, "qpid.jms.discardGlobalSharedSubscriptionLinksOnDetach");
        QpidServiceLoader serviceLoader = new QpidServiceLoader();
        for (ConnectionValidator validator : serviceLoader.instancesOf(ConnectionValidator.class)) {
            if ((!this._enabledConnectionValidators.isEmpty() || !this._disabledConnectionValidators.isEmpty()) && this._disabledConnectionValidators.contains(validator.getType()) && !this._enabledConnectionValidators.contains(validator.getType())) continue;
            this._connectionValidators.add(validator);
        }
        VirtualHostNode preferencesRoot = (VirtualHostNode)this.getParent();
        this._preferenceStore = preferencesRoot.createPreferenceStore();
        this._linkRegistry = this.createLinkRegistry();
        this.createHousekeepingExecutor();
        this.openConnectionLimiter();
    }

    LinkRegistryModel createLinkRegistry() {
        LinkRegistryModel linkRegistry;
        Iterator<LinkRegistryFactory> linkRegistryFactories = new QpidServiceLoader().instancesOf(LinkRegistryFactory.class).iterator();
        if (linkRegistryFactories.hasNext()) {
            LinkRegistryFactory linkRegistryFactory = linkRegistryFactories.next();
            if (linkRegistryFactories.hasNext()) {
                throw new RuntimeException("Found multiple implementations of LinkRegistry");
            }
            linkRegistry = linkRegistryFactory.create(this);
        } else {
            linkRegistry = null;
        }
        return linkRegistry;
    }

    private void createHousekeepingExecutor() {
        if (this._houseKeepingTaskExecutor == null || this._houseKeepingTaskExecutor.isTerminated()) {
            this._houseKeepingTaskExecutor = new HousekeepingExecutor("virtualhost-" + this.getName() + "-pool", this.getHousekeepingThreadCount(), this.getSystemTaskSubject("Housekeeping", this.getPrincipal()));
        }
    }

    private void checkVHostStateIsActive() {
        if (this.getState() != State.ACTIVE) {
            throw new IllegalStateException("The virtual host state of " + String.valueOf((Object)this.getState()) + " does not permit this operation.");
        }
    }

    @Override
    public boolean isActive() {
        return this.getState() == State.ACTIVE;
    }

    private void registerSystemNodes() {
        QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
        Iterable<SystemNodeCreator> factories = qpidServiceLoader.instancesOf(SystemNodeCreator.class);
        for (SystemNodeCreator creator : factories) {
            creator.register(this._systemNodeRegistry);
        }
    }

    protected abstract MessageStore createMessageStore();

    private CompletableFuture<Void> createDefaultExchanges() {
        return Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> run() {
                ArrayList<CompletableFuture<Void>> standardExchangeFutures = new ArrayList<CompletableFuture<Void>>();
                standardExchangeFutures.add(this.addStandardExchange("amq.direct", "direct"));
                standardExchangeFutures.add(this.addStandardExchange("amq.topic", "topic"));
                standardExchangeFutures.add(this.addStandardExchange("amq.match", "headers"));
                standardExchangeFutures.add(this.addStandardExchange("amq.fanout", "fanout"));
                return CompletableFuture.allOf((CompletableFuture[])standardExchangeFutures.toArray(CompletableFuture[]::new));
            }

            CompletableFuture<Void> addStandardExchange(String name, String type) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("name", name);
                attributes.put("type", type);
                attributes.put("id", UUIDGenerator.generateExchangeUUID(name, AbstractVirtualHost.this.getName()));
                CompletableFuture<Exchange<?>> future = AbstractVirtualHost.this.addExchangeAsync(attributes);
                CompletableFuture<Void> returnVal = new CompletableFuture<Void>();
                future.whenCompleteAsync((result, throwable) -> {
                    if (throwable != null) {
                        returnVal.completeExceptionally((Throwable)throwable);
                    } else {
                        try {
                            AbstractVirtualHost.this.childAdded(result);
                            returnVal.complete(null);
                        }
                        catch (Throwable t) {
                            returnVal.completeExceptionally(t);
                        }
                    }
                }, (Executor)AbstractVirtualHost.this.getTaskExecutor());
                return returnVal;
            }
        });
    }

    protected MessageStoreLogSubject getMessageStoreLogSubject() {
        return this._messageStoreLogSubject;
    }

    @Override
    public Collection<? extends Connection<?>> getConnections() {
        return this._connections;
    }

    @Override
    public Connection<?> getConnection(String name) {
        for (Connection connection : this._connections) {
            if (!connection.getName().equals(name)) continue;
            return connection;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int publishMessage(@Param(name="message") ManageableMessage message) {
        MessageDestination destination;
        String address = message.getAddress();
        MessageDestination messageDestination = destination = address == null ? this.getDefaultDestination() : this.getAttainedMessageDestination(address, true);
        if (destination == null) {
            destination = this.getDefaultDestination();
        }
        MessageHeaderImpl header = new MessageHeaderImpl(message);
        Object body = null;
        Object messageContent = message.getContent();
        if (messageContent != null) {
            if (messageContent instanceof Map || messageContent instanceof List) {
                if (message.getMimeType() != null || message.getEncoding() != null) {
                    throw new IllegalArgumentException("If the message content is provided as map or list, the mime type and encoding must be left unset");
                }
                body = (Serializable)messageContent;
            } else {
                if (!(messageContent instanceof String)) throw new IllegalArgumentException("The message content (if present) can only be a string, map or list");
                String contentTransferEncoding = message.getContentTransferEncoding();
                if ("base64".equalsIgnoreCase(contentTransferEncoding)) {
                    body = Strings.decodeBase64((String)messageContent);
                } else {
                    if (contentTransferEncoding != null && !contentTransferEncoding.trim().equals("") && !contentTransferEncoding.trim().equalsIgnoreCase("identity")) throw new IllegalArgumentException("contentTransferEncoding value '" + contentTransferEncoding + "' is invalid.  The only valid values are base64 and identity");
                    String mimeType = message.getMimeType();
                    if (mimeType != null && !(mimeType = mimeType.trim().toLowerCase()).equals("")) {
                        if (!mimeType.startsWith("text/") && !Arrays.asList("application/json", "application/xml").contains(mimeType)) {
                            throw new IllegalArgumentException(message.getMimeType() + " is invalid as a MIME type for this message. Only MIME types of the text type can be used if a string is supplied as the content");
                        }
                        if (mimeType.matches(".*;\\s*charset\\s*=.*")) {
                            throw new IllegalArgumentException(message.getMimeType() + " is invalid as a MIME type for this message. If a string is supplied as the content, the MIME type must not include a charset parameter");
                        }
                    }
                    body = (String)messageContent;
                }
            }
        }
        InternalMessage internalMessage = InternalMessage.createMessage(this.getMessageStore(), header, body, message.isPersistent(), address);
        AutoCommitTransaction txn = new AutoCommitTransaction(this.getMessageStore());
        InstanceProperties instanceProperties = prop -> {
            switch (prop) {
                case EXPIRATION: {
                    Date expiration = message.getExpiration();
                    return expiration == null ? 0L : expiration.getTime();
                }
                case IMMEDIATE: 
                case MANDATORY: 
                case REDELIVERED: {
                    return false;
                }
                case PERSISTENT: {
                    return message.isPersistent();
                }
            }
            return null;
        };
        RoutingResult<InternalMessage> result = destination.route(internalMessage, address, instanceProperties);
        return result.send(txn, null);
    }

    @Override
    protected <C extends ConfiguredObject> CompletableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes) {
        this.checkVHostStateIsActive();
        return super.addChildAsync(childClass, attributes);
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLogger;
    }

    @Override
    public Map<String, Object> extractConfig(final boolean includeSecureAttributes) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Map<String, Object>>, RuntimeException>(){

            @Override
            public CompletableFuture<Map<String, Object>> execute() throws RuntimeException {
                ConfigurationExtractor configExtractor = new ConfigurationExtractor();
                Map<String, Object> config = configExtractor.extractConfig(AbstractVirtualHost.this, includeSecureAttributes);
                return CompletableFuture.completedFuture(config);
            }

            @Override
            public String getObject() {
                return AbstractVirtualHost.this.toString();
            }

            @Override
            public String getAction() {
                return "extractConfig";
            }

            @Override
            public String getArguments() {
                return "includeSecureAttributes=" + String.valueOf(includeSecureAttributes);
            }
        }));
    }

    @Override
    public Content exportMessageStore() {
        return new MessageStoreContent();
    }

    @Override
    public void importMessageStore(final String source) {
        try {
            final URL url = AbstractVirtualHost.convertStringToURL(source);
            try (InputStream input = url.openStream();
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(input);
                 final DataInputStream data = new DataInputStream(bufferedInputStream);){
                final MessageStoreSerializer serializer = MessageStoreSerializer.FACTORY.newInstance(data);
                this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, IOException>(){

                    @Override
                    public CompletableFuture<Void> execute() throws IOException {
                        if (AbstractVirtualHost.this.getState() != State.STOPPED) {
                            throw new IllegalArgumentException("The importMessageStore operation can only be called when the virtual host is stopped");
                        }
                        try {
                            AbstractVirtualHost.this._messageStore.openMessageStore(AbstractVirtualHost.this);
                            AbstractVirtualHost.this.checkMessageStoreEmpty();
                            HashMap<String, UUID> queueMap = new HashMap<String, UUID>();
                            AbstractVirtualHost.this.getDurableConfigurationStore().reload(record -> {
                                if (record.getType().equals(Queue.class.getSimpleName())) {
                                    queueMap.put((String)record.getAttributes().get("name"), record.getId());
                                }
                            });
                            serializer.deserialize(queueMap, AbstractVirtualHost.this._messageStore, data);
                        }
                        finally {
                            AbstractVirtualHost.this._messageStore.closeMessageStore();
                        }
                        return CompletableFuture.completedFuture(null);
                    }

                    @Override
                    public String getObject() {
                        return AbstractVirtualHost.this.toString();
                    }

                    @Override
                    public String getAction() {
                        return "importMessageStore";
                    }

                    @Override
                    public String getArguments() {
                        if (url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https") || url.getProtocol().equalsIgnoreCase("file")) {
                            return "source=" + source;
                        }
                        if (url.getProtocol().equalsIgnoreCase("data")) {
                            return "source=<data stream>";
                        }
                        return "source=<unknown source type>";
                    }
                }));
            }
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot convert '" + source + "' to a readable resource", e);
        }
    }

    private void checkMessageStoreEmpty() {
        MessageStore.MessageStoreReader reader = this._messageStore.newMessageStoreReader();
        StoreEmptyCheckingHandler handler = new StoreEmptyCheckingHandler();
        reader.visitMessages(handler);
        if (handler.isEmpty()) {
            reader.visitMessageInstances(handler);
            if (handler.isEmpty()) {
                reader.visitDistributedTransactions(handler);
            }
        }
        if (!handler.isEmpty()) {
            throw new IllegalArgumentException("The message store is not empty");
        }
    }

    private static URL convertStringToURL(String source) {
        URL url;
        try {
            url = new URL(source);
        }
        catch (MalformedURLException e) {
            File file = new File(source);
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException notAFile) {
                throw new IllegalConfigurationException("Cannot convert " + source + " to a readable resource", notAFile);
            }
        }
        return url;
    }

    @Override
    public boolean authoriseCreateConnection(AMQPConnection<?> connection) {
        this.authorise(Operation.PERFORM_ACTION("connect"));
        for (ConnectionValidator validator : this._connectionValidators) {
            if (validator.validateConnectionCreation(connection, this)) continue;
            return false;
        }
        return true;
    }

    private void initialiseStatisticsReporting() {
        long report = (long)this.getStatisticsReportingPeriod() * 1000L;
        ScheduledFuture<?> previousStatisticsReportingFuture = this._statisticsReportingFuture;
        if (previousStatisticsReportingFuture != null) {
            previousStatisticsReportingFuture.cancel(false);
        }
        if (report > 0L) {
            this._statisticsReportingFuture = this._houseKeepingTaskExecutor.scheduleAtFixedRate(new StatisticsReportingTask(this, this.getSystemTaskSubject("Statistics", this._principal)), report, report, TimeUnit.MILLISECONDS);
        }
    }

    private void initialiseHouseKeeping() {
        long period = this.getHousekeepingCheckPeriod();
        if (period > 0L) {
            this.scheduleHouseKeepingTask(period, new VirtualHostHouseKeepingTask());
        }
    }

    private void initialiseFlowToDiskChecking() {
        long period = this.getFlowToDiskCheckPeriod();
        if (period > 0L) {
            this.scheduleHouseKeepingTask(period, new FlowToDiskCheckingTask());
        }
    }

    private void shutdownHouseKeeping() {
        if (this._houseKeepingTaskExecutor != null) {
            this._houseKeepingTaskExecutor.shutdown();
            try {
                if (!this._houseKeepingTaskExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this._houseKeepingTaskExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted during Housekeeping shutdown:", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                this._houseKeepingTaskExecutor = null;
            }
        }
    }

    private void closeNetworkConnectionScheduler() {
        if (this._networkConnectionScheduler != null) {
            this._networkConnectionScheduler.close();
            this._networkConnectionScheduler = null;
        }
    }

    @Override
    public void scheduleHouseKeepingTask(long period, HouseKeepingTask task) {
        task.setFuture(this._houseKeepingTaskExecutor.scheduleAtFixedRate(task, period / 2L, period, TimeUnit.MILLISECONDS));
    }

    @Override
    public ScheduledFuture<?> scheduleTask(long delay, Runnable task) {
        return this._houseKeepingTaskExecutor.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void executeTask(String name, final Runnable task, AccessControlContext context) {
        this._houseKeepingTaskExecutor.execute(new HouseKeepingTask(name, this, context){

            @Override
            public void execute() {
                task.run();
            }
        });
    }

    @Override
    public List<String> getEnabledConnectionValidators() {
        return this._enabledConnectionValidators;
    }

    @Override
    public List<String> getDisabledConnectionValidators() {
        return this._disabledConnectionValidators;
    }

    @Override
    public List<String> getGlobalAddressDomains() {
        return this._globalAddressDomains;
    }

    @Override
    public List<NodeAutoCreationPolicy> getNodeAutoCreationPolicies() {
        return this._nodeAutoCreationPolicies;
    }

    @Override
    public MessageSource getAttainedMessageSource(String name) {
        MessageSource messageSource = this._systemNodeSources.get(name);
        if (messageSource == null) {
            messageSource = this.getAttainedChildFromAddress(Queue.class, name);
        }
        if (messageSource == null) {
            messageSource = this.autoCreateNode(name, MessageSource.class, false);
        }
        return messageSource;
    }

    private <T> T autoCreateNode(String name, Class<T> clazz, boolean publish) {
        for (NodeAutoCreationPolicy policy : this.getNodeAutoCreationPolicies()) {
            Class<? extends ConfiguredObject> childClass2;
            String pattern = policy.getPattern();
            if (!name.matches(pattern) || (!publish || !policy.isCreatedOnPublish()) && (publish || !policy.isCreatedOnConsume())) continue;
            String nodeType = policy.getNodeType();
            Class<? extends ConfiguredObject> sourceClass = null;
            for (Class<? extends ConfiguredObject> childClass2 : this.getModel().getChildTypes(this.getCategoryClass())) {
                if (!childClass2.getSimpleName().equalsIgnoreCase(nodeType.trim()) || !clazz.isAssignableFrom(childClass2)) continue;
                sourceClass = childClass2;
            }
            if (sourceClass == null) continue;
            HashMap<String, String> attributes = policy.getAttributes() == null ? new HashMap<String, String>() : new HashMap<String, Object>(policy.getAttributes());
            attributes.remove("id");
            attributes.put("name", name);
            childClass2 = sourceClass;
            try {
                Object node = Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> this.doSync(this.createChildAsync(childClass2, attributes)));
                if (node == null) continue;
                return (T)node;
            }
            catch (AbstractConfiguredObject.DuplicateNameException e) {
                return (T)e.getExisting();
            }
            catch (RuntimeException e) {
                LOGGER.info("Unable to auto create a node named '{}' due to exception", (Object)name, (Object)e);
            }
        }
        return null;
    }

    @Override
    public Queue<?> getAttainedQueue(UUID id) {
        return this.awaitChildClassToAttainState(Queue.class, id);
    }

    @Override
    public Queue<?> getAttainedQueue(String name) {
        return this.awaitChildClassToAttainState(Queue.class, name);
    }

    @Override
    public Broker<?> getBroker() {
        return this._broker;
    }

    @Override
    public MessageDestination getAttainedMessageDestination(String name, boolean mayCreate) {
        MessageDestination destination = this._systemNodeDestinations.get(name);
        if (destination == null) {
            destination = this.getAttainedChildFromAddress(Exchange.class, name);
        }
        if (destination == null) {
            destination = this.getAttainedChildFromAddress(Queue.class, name);
        }
        if (destination == null && mayCreate) {
            destination = this.autoCreateNode(name, MessageDestination.class, true);
        }
        return destination;
    }

    @Override
    public MessageDestination getSystemDestination(String name) {
        return this._systemNodeDestinations.get(name);
    }

    @Override
    public CompletableFuture<Void> reallocateMessages() {
        block3: {
            ScheduledThreadPoolExecutor houseKeepingTaskExecutor = this._houseKeepingTaskExecutor;
            if (houseKeepingTaskExecutor != null) {
                try {
                    return CompletableFuture.runAsync(() -> {
                        Collection<Queue> queues = this.getChildren(Queue.class);
                        for (Queue q : queues) {
                            if (q.getState() != State.ACTIVE) continue;
                            q.reallocateMessages();
                        }
                    }, houseKeepingTaskExecutor);
                }
                catch (RejectedExecutionException e) {
                    if (houseKeepingTaskExecutor.isShutdown()) break block3;
                    LOGGER.warn("Failed to schedule reallocation of messages", (Throwable)e);
                }
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public long getTotalDepthOfQueuesBytes() {
        long total = 0L;
        Collection<Queue> queues = this.getChildren(Queue.class);
        for (Queue q : queues) {
            total += q.getQueueDepthBytes();
        }
        return total;
    }

    @Override
    public long getTotalDepthOfQueuesMessages() {
        long total = 0L;
        Collection<Queue> queues = this.getChildren(Queue.class);
        for (Queue q : queues) {
            total += (long)q.getQueueDepthMessages();
        }
        return total;
    }

    @Override
    public long getInMemoryMessageSize() {
        return this._messageStore == null ? -1L : this._messageStore.getInMemorySize();
    }

    @Override
    public long getBytesEvacuatedFromMemory() {
        return this._messageStore == null ? -1L : this._messageStore.getBytesEvacuatedFromMemory();
    }

    @Override
    public long getInMemoryMessageThreshold() {
        return this.getTargetSize();
    }

    @Override
    public <T extends ConfiguredObject<?>> T getAttainedChildFromAddress(Class<T> childClass, String address) {
        T child;
        block1: {
            child = this.awaitChildClassToAttainState(childClass, address);
            if (child != null || this.getGlobalAddressDomains() == null) break block1;
            for (String domain : this.getGlobalAddressDomains()) {
                if (address.startsWith(domain + "/") && (child = this.awaitChildClassToAttainState(childClass, address.substring(domain.length() + 1))) != null) break;
            }
        }
        return child;
    }

    @Override
    public long getInboundMessageSizeHighWatermark() {
        return this._maximumMessageSize.get();
    }

    @Override
    public MessageDestination getDefaultDestination() {
        return this._defaultDestination;
    }

    @Override
    public void resetStatistics() {
        this._totalConnectionCount.set(0L);
        this._maximumMessageSize.set(0L);
        this._bytesIn.set(0L);
        this._bytesOut.set(0L);
        this._messagesIn.set(0L);
        this._messagesOut.set(0L);
        this._transactedMessagesIn.set(0L);
        this._transactedMessagesOut.set(0L);
        this._messageStore.resetStatistics();
        this.getChildren(VirtualHostLogger.class).forEach(VirtualHostLogger::resetStatistics);
        this.getChildren(Queue.class).forEach(Queue::resetStatistics);
        this.getChildren(Exchange.class).forEach(Exchange::resetStatistics);
    }

    private CompletableFuture<Exchange<?>> addExchangeAsync(Map<String, Object> attributes) throws ReservedExchangeNameException, NoFactoryForTypeException {
        CompletableFuture returnVal = new CompletableFuture();
        this.getObjectFactory().createAsync(Exchange.class, attributes, this).whenCompleteAsync((result, throwable) -> {
            if (throwable != null) {
                returnVal.completeExceptionally((Throwable)throwable);
            } else {
                returnVal.complete((Exchange)result);
            }
        }, (Executor)this.getTaskExecutor());
        return returnVal;
    }

    @Override
    public String getLocalAddress(String routingAddress) {
        if (this.getGlobalAddressDomains() != null) {
            for (String domain : this.getGlobalAddressDomains()) {
                if (!routingAddress.startsWith(domain + "/")) continue;
                return routingAddress.substring(domain.length() + 1);
            }
        }
        return routingAddress;
    }

    @Override
    protected CompletableFuture<Void> beforeClose() {
        return this.beforeDeleteOrClose();
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        return this.onCloseOrDelete();
    }

    @Override
    protected CompletableFuture<Void> beforeDelete() {
        return this.beforeDeleteOrClose();
    }

    @Override
    protected CompletableFuture<Void> onDelete() {
        this._deleteRequested = true;
        return this.onCloseOrDelete();
    }

    private CompletableFuture<Void> beforeDeleteOrClose() {
        this.setState(State.UNAVAILABLE);
        this._virtualHostLoggersToClose = new ArrayList<VirtualHostLogger>(this.getChildren(VirtualHostLogger.class));
        return this.closeConnections();
    }

    private CompletableFuture<Void> onCloseOrDelete() {
        this._dtxRegistry.close();
        this.shutdownHouseKeeping();
        if (this._deleteRequested) {
            this.deleteLinkRegistry();
        }
        this.closeMessageStore();
        this.stopPreferenceTaskExecutor();
        this.closePreferenceStore();
        if (this._deleteRequested) {
            this.deleteMessageStore();
            this.deletePreferenceStore();
        }
        this.closeNetworkConnectionScheduler();
        this._eventLogger.message(VirtualHostMessages.CLOSE(this.getName()));
        this.stopLogging(this._virtualHostLoggersToClose);
        this._systemNodeRegistry.close();
        this.closeConnectionLimiter();
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> closeConnections() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing connection registry : {} connection(s).", (Object)this._connections.size());
        }
        this._acceptsConnections.set(false);
        for (AMQPConnection<?> conn : this._connections) {
            conn.stopConnection();
        }
        ArrayList<CompletableFuture<Void>> connectionCloseFutures = new ArrayList<CompletableFuture<Void>>();
        while (!this._connections.isEmpty()) {
            Iterator<AMQPConnection<?>> itr = this._connections.iterator();
            while (itr.hasNext()) {
                Connection connection = itr.next();
                try {
                    connectionCloseFutures.add(connection.closeAsync());
                }
                catch (Exception e) {
                    LOGGER.warn("Exception closing connection " + connection.getName() + " from " + connection.getRemoteAddress(), (Throwable)e);
                }
                finally {
                    itr.remove();
                }
            }
        }
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])connectionCloseFutures.toArray(CompletableFuture[]::new));
        return combinedFuture.thenApply(voids -> null);
    }

    private void closeMessageStore() {
        if (this.getMessageStore() != null) {
            try {
                if (this._messageStoreRecoverer != null) {
                    this._messageStoreRecoverer.cancel();
                }
                this.getMessageStore().closeMessageStore();
            }
            catch (StoreException e) {
                LOGGER.error("Failed to close message store", (Throwable)e);
            }
            if (!(this._virtualHostNode.getConfigurationStore() instanceof MessageStoreProvider)) {
                this.getEventLogger().message(this.getMessageStoreLogSubject(), MessageStoreMessages.CLOSED());
            }
        }
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesOut.incrementAndGet();
        this._bytesOut.addAndGet(messageSize);
        this._broker.registerMessageDelivered(messageSize);
        this.reportDirectMemoryBelowTargetIfReached();
    }

    @Override
    public void registerMessageReceived(long messageSize) {
        long hwm;
        this._messagesIn.incrementAndGet();
        this._bytesIn.addAndGet(messageSize);
        this._broker.registerMessageReceived(messageSize);
        while ((hwm = this._maximumMessageSize.get()) < messageSize) {
            this._maximumMessageSize.compareAndSet(hwm, messageSize);
        }
        this.reportDirectMemoryAboveTargetIfExceeded();
    }

    @Override
    public void registerTransactedMessageReceived() {
        this._transactedMessagesIn.incrementAndGet();
        this._broker.registerTransactedMessageReceived();
    }

    @Override
    public void registerTransactedMessageDelivered() {
        this._transactedMessagesOut.incrementAndGet();
        this._broker.registerTransactedMessageDelivered();
    }

    @Override
    public long getMessagesIn() {
        return this._messagesIn.get();
    }

    @Override
    public long getBytesIn() {
        return this._bytesIn.get();
    }

    @Override
    public long getMessagesOut() {
        return this._messagesOut.get();
    }

    @Override
    public long getBytesOut() {
        return this._bytesOut.get();
    }

    @Override
    public long getTransactedMessagesIn() {
        return this._transactedMessagesIn.get();
    }

    @Override
    public long getTransactedMessagesOut() {
        return this._transactedMessagesOut.get();
    }

    @Override
    public <T extends LinkModel> T getSendingLink(final String remoteContainerId, final String linkName) {
        return (T)((LinkModel)this.doSync(this.doOnConfigThread(new Task<CompletableFuture<T>, RuntimeException>(){

            @Override
            public CompletableFuture<T> execute() {
                return CompletableFuture.completedFuture(AbstractVirtualHost.this._linkRegistry.getSendingLink(remoteContainerId, linkName));
            }

            @Override
            public String getObject() {
                return AbstractVirtualHost.this.toString();
            }

            @Override
            public String getAction() {
                return "getSendingLink";
            }

            @Override
            public String getArguments() {
                return String.format("remoteContainerId='%s', linkName='%s'", remoteContainerId, linkName);
            }
        })));
    }

    @Override
    public <T extends LinkModel> T getReceivingLink(final String remoteContainerId, final String linkName) {
        return (T)((LinkModel)this.doSync(this.doOnConfigThread(new Task<CompletableFuture<T>, RuntimeException>(){

            @Override
            public CompletableFuture<T> execute() {
                return CompletableFuture.completedFuture(AbstractVirtualHost.this._linkRegistry.getReceivingLink(remoteContainerId, linkName));
            }

            @Override
            public String getObject() {
                return AbstractVirtualHost.this.toString();
            }

            @Override
            public String getAction() {
                return "getReceivingLink";
            }

            @Override
            public String getArguments() {
                return String.format("remoteContainerId='%s', linkName='%s'", remoteContainerId, linkName);
            }
        })));
    }

    @Override
    public <T extends LinkModel> Collection<T> findSendingLinks(final Pattern containerIdPattern, final Pattern linkNamePattern) {
        return (Collection)this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Collection<T>>, RuntimeException>(){

            @Override
            public CompletableFuture<Collection<T>> execute() {
                return CompletableFuture.completedFuture(AbstractVirtualHost.this._linkRegistry.findSendingLinks(containerIdPattern, linkNamePattern));
            }

            @Override
            public String getObject() {
                return AbstractVirtualHost.this.toString();
            }

            @Override
            public String getAction() {
                return "findSendingLinks";
            }

            @Override
            public String getArguments() {
                return String.format("containerIdPattern='%s', linkNamePattern='%s'", containerIdPattern, linkNamePattern);
            }
        }));
    }

    @Override
    public <T extends LinkModel> void visitSendingLinks(final LinkRegistryModel.LinkVisitor<T> visitor) {
        this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, RuntimeException>(){

            @Override
            public CompletableFuture<Void> execute() {
                AbstractVirtualHost.this._linkRegistry.visitSendingLinks(visitor);
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public String getObject() {
                return AbstractVirtualHost.this.toString();
            }

            @Override
            public String getAction() {
                return "visitSendingLinks";
            }

            @Override
            public String getArguments() {
                return String.format("visitor='%s'", visitor);
            }
        }));
    }

    @Override
    public DtxRegistry getDtxRegistry() {
        return this._dtxRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block(BlockingType blockingType) {
        Set<AMQPConnection<?>> set = this._connections;
        synchronized (set) {
            this._blockingReasons.add(blockingType);
            if (this._blocked.compareAndSet(false, true)) {
                for (AMQPConnection<?> conn : this._connections) {
                    conn.block();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblock(BlockingType blockingType) {
        Set<AMQPConnection<?>> set = this._connections;
        synchronized (set) {
            this._blockingReasons.remove((Object)blockingType);
            if (this._blockingReasons.isEmpty() && this._blocked.compareAndSet(true, false)) {
                for (AMQPConnection<?> conn : this._connections) {
                    conn.unblock();
                }
            }
        }
    }

    @Override
    public void event(Event event) {
        switch (event) {
            case PERSISTENT_MESSAGE_SIZE_OVERFULL: {
                this.block(BlockingType.STORE);
                this._eventLogger.message(this.getMessageStoreLogSubject(), MessageStoreMessages.OVERFULL());
                break;
            }
            case PERSISTENT_MESSAGE_SIZE_UNDERFULL: {
                this.unblock(BlockingType.STORE);
                this._eventLogger.message(this.getMessageStoreLogSubject(), MessageStoreMessages.UNDERFULL());
            }
        }
    }

    private void reportIfError(State state) {
        if (state == State.ERRORED) {
            this._eventLogger.message(VirtualHostMessages.ERRORED(this.getName()));
        }
    }

    @Override
    public String getRedirectHost(AmqpPort<?> port) {
        return null;
    }

    @Override
    public boolean isOverTargetSize() {
        return this.getInMemoryMessageSize() > this._targetSize.get();
    }

    @Override
    public void executeTransaction(QueueManagingVirtualHost.TransactionalOperation op) {
        final MessageStore store = this.getMessageStore();
        final LocalTransaction txn = new LocalTransaction(store);
        op.withinTransaction(new QueueManagingVirtualHost.Transaction(){

            @Override
            public void dequeue(final QueueEntry messageInstance) {
                ServerTransaction.Action deleteAction = new ServerTransaction.Action(){

                    @Override
                    public void postCommit() {
                        messageInstance.delete();
                    }

                    @Override
                    public void onRollback() {
                    }
                };
                boolean acquired = messageInstance.acquireOrSteal(() -> {
                    AutoCommitTransaction txn1 = new AutoCommitTransaction(store);
                    txn1.dequeue(messageInstance.getEnqueueRecord(), deleteAction);
                });
                if (acquired) {
                    txn.dequeue(messageInstance.getEnqueueRecord(), deleteAction);
                }
            }

            @Override
            public void copy(QueueEntry entry, final Queue<?> queue) {
                final ServerMessage message = entry.getMessage();
                txn.enqueue(queue, (EnqueueableMessage)message, new ServerTransaction.EnqueueAction(){

                    @Override
                    public void postCommit(MessageEnqueueRecord ... records) {
                        queue.enqueue(message, null, records[0]);
                    }

                    @Override
                    public void onRollback() {
                    }
                });
            }

            @Override
            public void move(final QueueEntry entry, final Queue<?> queue) {
                final ServerMessage message = entry.getMessage();
                if (entry.acquire()) {
                    txn.enqueue(queue, (EnqueueableMessage)message, new ServerTransaction.EnqueueAction(){

                        @Override
                        public void postCommit(MessageEnqueueRecord ... records) {
                            queue.enqueue(message, null, records[0]);
                        }

                        @Override
                        public void onRollback() {
                            entry.release();
                        }
                    });
                    txn.dequeue(entry.getEnqueueRecord(), new ServerTransaction.Action(){

                        @Override
                        public void postCommit() {
                            entry.delete();
                        }

                        @Override
                        public void onRollback() {
                        }
                    });
                }
            }
        });
        txn.commit();
    }

    @Override
    public long getHousekeepingCheckPeriod() {
        return this._housekeepingCheckPeriod;
    }

    @Override
    public long getFlowToDiskCheckPeriod() {
        return this._flowToDiskCheckPeriod;
    }

    @Override
    public boolean isDiscardGlobalSharedSubscriptionLinksOnDetach() {
        return this._isDiscardGlobalSharedSubscriptionLinksOnDetach;
    }

    @Override
    public long getStoreTransactionIdleTimeoutClose() {
        return this._storeTransactionIdleTimeoutClose;
    }

    @Override
    public long getStoreTransactionIdleTimeoutWarn() {
        return this._storeTransactionIdleTimeoutWarn;
    }

    @Override
    public long getStoreTransactionOpenTimeoutClose() {
        return this._storeTransactionOpenTimeoutClose;
    }

    @Override
    public long getStoreTransactionOpenTimeoutWarn() {
        return this._storeTransactionOpenTimeoutWarn;
    }

    @Override
    public long getQueueCount() {
        return this.getChildren(Queue.class).size();
    }

    @Override
    public long getExchangeCount() {
        return this.getChildren(Exchange.class).size();
    }

    @Override
    public long getConnectionCount() {
        return this._connections.size();
    }

    @Override
    public long getTotalConnectionCount() {
        return this._totalConnectionCount.get();
    }

    @Override
    public int getHousekeepingThreadCount() {
        return this._housekeepingThreadCount;
    }

    @Override
    public int getStatisticsReportingPeriod() {
        return this._statisticsReportingPeriod;
    }

    @Override
    public int getConnectionThreadPoolSize() {
        return this._connectionThreadPoolSize;
    }

    @Override
    public int getNumberOfSelectors() {
        return this._numberOfSelectors;
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ACTIVE, State.ERRORED}, desiredState=State.STOPPED)
    protected CompletableFuture<Void> doStop() {
        ArrayList<VirtualHostLogger> loggers = new ArrayList<VirtualHostLogger>(this.getChildren(VirtualHostLogger.class));
        return ((CompletableFuture)this.closeConnections().thenApplyAsync(result -> this.closeChildren(), (Executor)this.getTaskExecutor())).thenRunAsync(() -> {
            this.shutdownHouseKeeping();
            this.closeNetworkConnectionScheduler();
            if (this._linkRegistry != null) {
                this._linkRegistry.close();
            }
            this.closeMessageStore();
            this.stopPreferenceTaskExecutor();
            this.closePreferenceStore();
            this.setState(State.STOPPED);
            this.stopLogging(loggers);
            this.closeConnectionLimiter();
        }, this.getTaskExecutor());
    }

    @Override
    public UserPreferences createUserPreferences(ConfiguredObject<?> object) {
        if (this._preferenceTaskExecutor == null || !this._preferenceTaskExecutor.isRunning()) {
            throw new IllegalStateException("Cannot create user preferences in not fully initialized virtual host");
        }
        return new UserPreferencesImpl(this._preferenceTaskExecutor, object, this._preferenceStore, Set.of());
    }

    private void stopPreferenceTaskExecutor() {
        if (this._preferenceTaskExecutor != null) {
            this._preferenceTaskExecutor.stop();
            this._preferenceTaskExecutor = null;
        }
    }

    private void closePreferenceStore() {
        if (this._preferenceStore != null) {
            this._preferenceStore.close();
        }
    }

    private void stopLogging(Collection<VirtualHostLogger> loggers) {
        for (VirtualHostLogger logger : loggers) {
            logger.stopLogging();
        }
    }

    private void deleteLinkRegistry() {
        if (this._linkRegistry != null) {
            this._linkRegistry.delete();
            this._linkRegistry = null;
        }
    }

    private void deletePreferenceStore() {
        PreferenceStore ps = this._preferenceStore;
        if (ps != null) {
            try {
                ps.onDelete();
            }
            catch (Exception e) {
                LOGGER.warn("Exception occurred on preference store deletion", (Throwable)e);
            }
            finally {
                this._preferenceStore = null;
            }
        }
    }

    private void deleteMessageStore() {
        MessageStore ms = this._messageStore;
        if (ms != null) {
            try {
                ms.onDelete(this);
            }
            catch (Exception e) {
                LOGGER.warn("Exception occurred on message store deletion", (Throwable)e);
            }
            finally {
                this._messageStore = null;
            }
        }
    }

    @Override
    public String getModelVersion() {
        return "9.1";
    }

    @Override
    public String getProductVersion() {
        return this._broker.getProductVersion();
    }

    @Override
    public DurableConfigurationStore getDurableConfigurationStore() {
        return this._virtualHostNode.getConfigurationStore();
    }

    @Override
    public void setTargetSize(long targetSize) {
        this._targetSize.set(targetSize);
        long inMemoryMessageSize = this.getInMemoryMessageSize();
        this.reportDirectMemoryAboveTargetIfExceeded(targetSize, inMemoryMessageSize);
        this.reportDirectMemoryBelowTargetIfReached(targetSize, inMemoryMessageSize);
    }

    @Override
    public long getTargetSize() {
        return this._targetSize.get();
    }

    @Override
    public Principal getPrincipal() {
        return this._principal;
    }

    @Override
    public void registerConnection(AMQPConnection<?> connection) {
        if (!this._acceptsConnections.get()) {
            throw new VirtualHostUnavailableException(String.format("VirtualHost '%s' not accepting connections", this.getName()));
        }
        this._connectionLimiter.register(connection);
        this._connections.add(connection);
        this._totalConnectionCount.incrementAndGet();
        if (this._blocked.get()) {
            connection.block();
        }
        connection.pushScheduler(this._networkConnectionScheduler);
    }

    @Override
    public void deregisterConnection(AMQPConnection<?> connection) {
        try {
            this._connectionLimiter.deregister(connection);
        }
        finally {
            connection.popScheduler();
            this._connections.remove(connection);
        }
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private CompletableFuture<Void> onActivate() {
        long threadPoolKeepAliveTimeout = this.getContextValue(Long.class, "connectionThreadPoolKeepAliveTimeout");
        SuppressingInheritedAccessControlContextThreadFactory connectionThreadFactory = new SuppressingInheritedAccessControlContextThreadFactory("virtualhost-" + this.getName() + "-iopool", this.getSystemTaskSubject("IO Pool", this.getPrincipal()));
        this._networkConnectionScheduler = new NetworkConnectionScheduler("virtualhost-" + this.getName() + "-iopool", this.getNumberOfSelectors(), this.getConnectionThreadPoolSize(), threadPoolKeepAliveTimeout, connectionThreadFactory);
        this._networkConnectionScheduler.start();
        this.updateAccessControl();
        this.initialiseStatisticsReporting();
        MessageStore messageStore = this.getMessageStore();
        messageStore.openMessageStore(this);
        this.startFileSystemSpaceChecking();
        if (!(this._virtualHostNode.getConfigurationStore() instanceof MessageStoreProvider)) {
            this.getEventLogger().message(this.getMessageStoreLogSubject(), MessageStoreMessages.CREATED());
            this.getEventLogger().message(this.getMessageStoreLogSubject(), MessageStoreMessages.STORE_LOCATION(messageStore.getStoreLocation()));
        }
        messageStore.upgradeStoreStructure();
        if (this._linkRegistry != null) {
            this._linkRegistry.open();
        }
        this.getBroker().assignTargetSizes();
        PreferenceStoreUpdaterImpl updater = new PreferenceStoreUpdaterImpl();
        Collection<PreferenceRecord> records = this._preferenceStore.openAndLoad(updater);
        this._preferenceTaskExecutor = new TaskExecutorImpl("virtualhost-" + this.getName() + "-preferences", null);
        this._preferenceTaskExecutor.start();
        PreferencesRecoverer preferencesRecoverer = new PreferencesRecoverer(this._preferenceTaskExecutor);
        preferencesRecoverer.recoverPreferences(this, records, this._preferenceStore);
        this.activateConnectionLimiter();
        if (this._createDefaultExchanges) {
            return this.createDefaultExchanges().thenRunAsync(() -> {
                this._createDefaultExchanges = false;
                this.postCreateDefaultExchangeTasks();
            }, this.getTaskExecutor());
        }
        this.postCreateDefaultExchangeTasks();
        return CompletableFuture.completedFuture(null);
    }

    private void postCreateDefaultExchangeTasks() {
        this._messageStoreRecoverer = this.getContextValue(Boolean.class, USE_ASYNC_RECOVERY) != false ? new AsynchronousMessageStoreRecoverer() : new SynchronousMessageStoreRecoverer();
        CompletableFuture<Void> recoveryResult = this._messageStoreRecoverer.recover(this);
        recoveryResult.whenCompleteAsync((result, throwable) -> {
            try {
                recoveryResult.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }, (Executor)this._houseKeepingTaskExecutor);
        State finalState = State.ERRORED;
        try {
            this.initialiseHouseKeeping();
            this.initialiseFlowToDiskChecking();
            finalState = State.ACTIVE;
            this._acceptsConnections.set(true);
        }
        finally {
            this.setState(finalState);
            this.reportIfError(this.getState());
        }
    }

    @Override
    protected void logOperation(String operation) {
        this.getEventLogger().message(VirtualHostMessages.OPERATION(operation));
    }

    protected void startFileSystemSpaceChecking() {
        long housekeepingCheckPeriod = this.getHousekeepingCheckPeriod();
        File storeLocationAsFile = this._messageStore.getStoreLocationAsFile();
        if (storeLocationAsFile != null && this._fileSystemMaxUsagePercent > 0 && housekeepingCheckPeriod > 0L) {
            this._fileSystemSpaceChecker.setFileSystem(storeLocationAsFile);
            this.scheduleHouseKeepingTask(housekeepingCheckPeriod, this._fileSystemSpaceChecker);
        }
    }

    @Override
    public SocketConnectionMetaData getConnectionMetaData() {
        return this.getBroker().getConnectionMetaData();
    }

    @StateTransition(currentState={State.STOPPED}, desiredState=State.ACTIVE)
    private CompletableFuture<Void> onRestart() {
        CompletableFuture<Void> returnVal = new CompletableFuture<Void>();
        try {
            this.doRestart().whenCompleteAsync((result, throwable) -> {
                if (throwable != null) {
                    this.onRestartFailure().whenComplete((result1, throwable1) -> returnVal.completeExceptionally((Throwable)throwable));
                } else {
                    returnVal.complete(null);
                }
            }, (Executor)this.getTaskExecutor());
        }
        catch (IllegalArgumentException | IllegalConfigurationException e) {
            this.onRestartFailure().whenComplete((result, throwable) -> returnVal.completeExceptionally(e));
        }
        return returnVal;
    }

    private CompletableFuture<Void> doRestart() {
        this.createHousekeepingExecutor();
        VirtualHostStoreUpgraderAndRecoverer virtualHostStoreUpgraderAndRecoverer = new VirtualHostStoreUpgraderAndRecoverer((VirtualHostNode)this.getParent());
        virtualHostStoreUpgraderAndRecoverer.reloadAndRecoverVirtualHost(this.getDurableConfigurationStore());
        Collection<VirtualHostAccessControlProvider> accessControlProviders = this.getChildren(VirtualHostAccessControlProvider.class);
        if (!accessControlProviders.isEmpty()) {
            accessControlProviders.forEach(child -> child.addChangeListener(this._accessControlProviderListener));
        }
        ArrayList childOpenFutures = new ArrayList();
        Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> {
            this.applyToChildren(child -> {
                CompletableFuture<Void> childOpenFuture = child.openAsync();
                childOpenFutures.add(childOpenFuture);
                childOpenFuture.whenCompleteAsync((result, throwable) -> {
                    if (throwable != null) {
                        LOGGER.error("Exception occurred while opening {} : {}", new Object[]{child.getClass().getSimpleName(), child.getName(), throwable});
                        this.onRestartFailure();
                    }
                }, (Executor)this.getTaskExecutor());
            });
            return null;
        });
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])childOpenFutures.toArray(CompletableFuture[]::new));
        return combinedFuture.thenAccept(result -> this.onActivate());
    }

    private CompletableFuture<Void> onRestartFailure() {
        ArrayList<VirtualHostLogger> loggers = new ArrayList<VirtualHostLogger>(this.getChildren(VirtualHostLogger.class));
        return this.closeChildren().thenRunAsync(() -> {
            this.shutdownHouseKeeping();
            this.closeNetworkConnectionScheduler();
            if (this._linkRegistry != null) {
                this._linkRegistry.close();
            }
            this.closeMessageStore();
            this.stopPreferenceTaskExecutor();
            this.closePreferenceStore();
            this.setState(State.ERRORED);
            this.stopLogging(loggers);
            this.closeConnectionLimiter();
        }, this.getTaskExecutor());
    }

    @Override
    public <T extends MessageSource> T createMessageSource(Class<T> clazz, Map<String, Object> attributes) {
        if (Queue.class.isAssignableFrom(clazz)) {
            return (T)((MessageSource)this.createChild(clazz, attributes));
        }
        if (clazz.isAssignableFrom(Queue.class)) {
            return (T)this.createChild(Queue.class, attributes);
        }
        throw new IllegalArgumentException("Cannot create message source children of class " + clazz.getSimpleName());
    }

    @Override
    public <T extends MessageDestination> T createMessageDestination(Class<T> clazz, Map<String, Object> attributes) {
        if (Exchange.class.isAssignableFrom(clazz)) {
            return (T)((MessageDestination)this.createChild(clazz, attributes));
        }
        if (Queue.class.isAssignableFrom(clazz)) {
            return (T)((MessageDestination)this.createChild(clazz, attributes));
        }
        if (clazz.isAssignableFrom(Queue.class)) {
            return (T)this.createChild(Queue.class, attributes);
        }
        throw new IllegalArgumentException("Cannot create message destination children of class " + clazz.getSimpleName());
    }

    @Override
    public boolean hasMessageSources() {
        return !this._systemNodeSources.isEmpty() || !this.getChildren(Queue.class).isEmpty();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @DoOnConfigThread
    public Queue<?> getSubscriptionQueue(@Param(name="exchangeName", mandatory=true) String exchangeName, @Param(name="attributes", mandatory=true) Map<String, Object> attributes, @Param(name="bindings", mandatory=true) Map<String, Map<String, Object>> bindings) {
        Queue queue;
        void var5_6;
        Object object = attributes.get("exclusive");
        if (object == null) {
            ExclusivityPolicy exclusivityPolicy = this.getContextValue(ExclusivityPolicy.class, "queue.defaultExclusivityPolicy");
        }
        if (!(var5_6 instanceof ExclusivityPolicy)) {
            throw new IllegalArgumentException("Exclusivity policy is required");
        }
        Exchange exchange = this.findConfiguredObject(Exchange.class, exchangeName);
        if (exchange == null) {
            throw new NotFoundException(String.format("Exchange '%s' was not found", exchangeName));
        }
        try {
            queue = this.createMessageDestination(Queue.class, attributes);
            Iterator<String> iterator = bindings.keySet().iterator();
            while (iterator.hasNext()) {
                String binding = iterator.next();
                exchange.addBinding(binding, queue, bindings.get(binding));
            }
            return queue;
        }
        catch (AbstractConfiguredObject.DuplicateNameException e) {
            Queue existingQueue = (Queue)e.getExisting();
            if (existingQueue.getExclusive() != var5_6) throw new IllegalStateException("subscription already in use");
            if (!this.hasDifferentBindings(exchange, existingQueue, bindings)) return existingQueue;
            if (!existingQueue.getConsumers().isEmpty()) throw new IllegalStateException("subscription already in use");
            existingQueue.delete();
            queue = this.createMessageDestination(Queue.class, attributes);
            Iterator<String> iterator = bindings.keySet().iterator();
            while (iterator.hasNext()) {
                String binding = iterator.next();
                try {
                    exchange.addBinding(binding, queue, bindings.get(binding));
                }
                catch (AMQInvalidArgumentException ia) {
                    throw new IllegalArgumentException("Unexpected bind argument : " + ia.getMessage(), ia);
                }
            }
            return queue;
        }
        catch (AMQInvalidArgumentException e) {
            throw new IllegalArgumentException("Unexpected bind argument : " + e.getMessage(), e);
        }
    }

    @Override
    @DoOnConfigThread
    public void removeSubscriptionQueue(@Param(name="queueName", mandatory=true) String queueName) throws NotFoundException {
        Queue queue = this.findConfiguredObject(Queue.class, queueName);
        if (queue == null) {
            throw new NotFoundException(String.format("Queue '%s' was not found", queueName));
        }
        if (!queue.getConsumers().isEmpty()) {
            throw new IllegalStateException("There are consumers on Queue '" + queueName + "'");
        }
        queue.delete();
    }

    @Override
    public Object dumpLinkRegistry() {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Object>, IOException>(){

            @Override
            public CompletableFuture<Object> execute() throws IOException {
                Object dump;
                block9: {
                    if (AbstractVirtualHost.this.getState() == State.STOPPED) {
                        AbstractVirtualHost.this._messageStore.openMessageStore(AbstractVirtualHost.this);
                        try {
                            AbstractVirtualHost.this._linkRegistry.open();
                            try {
                                dump = AbstractVirtualHost.this._linkRegistry.dump();
                                break block9;
                            }
                            finally {
                                AbstractVirtualHost.this._linkRegistry.close();
                            }
                        }
                        finally {
                            AbstractVirtualHost.this._messageStore.closeMessageStore();
                        }
                    }
                    if (AbstractVirtualHost.this.getState() == State.ACTIVE) {
                        dump = AbstractVirtualHost.this._linkRegistry.dump();
                    } else {
                        throw new IllegalStateException("The dumpLinkRegistry operation can only be called when the virtual host is active or stopped.");
                    }
                }
                return CompletableFuture.completedFuture(dump);
            }

            @Override
            public String getObject() {
                return AbstractVirtualHost.this.toString();
            }

            @Override
            public String getAction() {
                return "dumpLinkRegistry";
            }

            @Override
            public String getArguments() {
                return null;
            }
        }));
    }

    @Override
    public void purgeLinkRegistry(final String containerIdPatternString, final String role, final String linkNamePatternString) {
        this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompletableFuture<Void> execute() throws IOException {
                if (AbstractVirtualHost.this.getState() != State.STOPPED) {
                    throw new IllegalArgumentException("The purgeLinkRegistry operation can only be called when the virtual host is stopped.");
                }
                Pattern containerIdPattern = Pattern.compile(containerIdPatternString);
                Pattern linkNamePattern = Pattern.compile(linkNamePatternString);
                AbstractVirtualHost.this._messageStore.openMessageStore(AbstractVirtualHost.this);
                try {
                    AbstractVirtualHost.this._linkRegistry.open();
                    try {
                        if ("SENDER".equals(role) || "BOTH".equals(role)) {
                            AbstractVirtualHost.this._linkRegistry.purgeSendingLinks(containerIdPattern, linkNamePattern);
                        }
                        if ("RECEIVER".equals(role) || "BOTH".equals(role)) {
                            AbstractVirtualHost.this._linkRegistry.purgeReceivingLinks(containerIdPattern, linkNamePattern);
                        }
                        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                        AbstractVirtualHost.this._linkRegistry.close();
                        return completableFuture;
                    }
                    catch (Throwable throwable) {
                        AbstractVirtualHost.this._linkRegistry.close();
                        throw throwable;
                    }
                }
                finally {
                    AbstractVirtualHost.this._messageStore.closeMessageStore();
                }
            }

            @Override
            public String getObject() {
                return AbstractVirtualHost.this.toString();
            }

            @Override
            public String getAction() {
                return "purgeLinkRegistry";
            }

            @Override
            public String getArguments() {
                return String.format("containerIdPattern='%s',role='%s',linkNamePattern='%s'", containerIdPatternString, role, linkNamePatternString);
            }
        }));
    }

    @Override
    public <K, V> Cache<K, V> getNamedCache(String cacheName) {
        String maxSizeContextVarName = String.format("virtualhost.namedCache.%s.maximumSize", cacheName);
        String expirationContextVarName = String.format("virtualhost.namedCache.%s.expiration", cacheName);
        Set<String> contextKeys = this.getContextKeys(false);
        int maxSize = contextKeys.contains(maxSizeContextVarName) ? this.getContextValue(Integer.class, maxSizeContextVarName).intValue() : this.getContextValue(Integer.class, "virtualhost.namedCache.maximumSize").intValue();
        long expiration = contextKeys.contains(expirationContextVarName) ? this.getContextValue(Long.class, expirationContextVarName).longValue() : this.getContextValue(Long.class, "virtualhost.namedCache.expiration").longValue();
        return this._caches.computeIfAbsent(cacheName, k -> Caffeine.newBuilder().maximumSize((long)maxSize).expireAfterAccess(expiration, TimeUnit.MILLISECONDS).build());
    }

    private boolean hasDifferentBindings(Exchange<?> exchange, Queue queue, Map<String, Map<String, Object>> bindings) {
        for (String binding : bindings.keySet()) {
            boolean theSameBindingFound = false;
            for (Binding publishingLink : exchange.getPublishingLinks(queue)) {
                Map<String, Object> actualArguments;
                Map<String, Object> expectedArguments;
                if (!publishingLink.getBindingKey().equals(binding) || !new HashMap((expectedArguments = bindings.get(binding)) == null ? Map.of() : expectedArguments).equals(new HashMap((actualArguments = publishingLink.getArguments()) == null ? Map.of() : actualArguments))) continue;
                theSameBindingFound = true;
            }
            if (theSameBindingFound) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        this._eventLogger.message(VirtualHostMessages.CREATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }

    @Override
    protected void logRecovered(Outcome outcome) {
        this._eventLogger.message(VirtualHostMessages.OPEN(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        this._eventLogger.message(VirtualHostMessages.DELETE(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logUpdated(Map<String, Object> attributes, Outcome outcome) {
        this._eventLogger.message(VirtualHostMessages.UPDATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }

    private void reportDirectMemoryAboveTargetIfExceeded() {
        if (DIRECT_MEMORY_USAGE_LOGGER.isDebugEnabled()) {
            this.reportDirectMemoryAboveTargetIfExceeded(this.getTargetSize(), this.getInMemoryMessageSize());
        }
    }

    private void reportDirectMemoryBelowTargetIfReached() {
        if (DIRECT_MEMORY_USAGE_LOGGER.isDebugEnabled()) {
            this.reportDirectMemoryBelowTargetIfReached(this.getTargetSize(), this.getInMemoryMessageSize());
        }
    }

    private void reportDirectMemoryBelowTargetIfReached(long currentTargetSize, long inMemoryMessageSize) {
        if (DIRECT_MEMORY_USAGE_LOGGER.isDebugEnabled() && inMemoryMessageSize <= currentTargetSize && QpidByteBuffer.getAllocatedDirectMemorySize() <= this._broker.getFlowToDiskThreshold() && this._directMemoryExceedsTargetReported.compareAndSet(true, false)) {
            DIRECT_MEMORY_USAGE_LOGGER.debug("VirtualHost '{}' direct memory allocation threshold ({}) maintained : {} bytes. Flow to disk stopped.", new Object[]{this.getName(), currentTargetSize, inMemoryMessageSize});
        }
    }

    private void reportDirectMemoryAboveTargetIfExceeded(long currentTargetSize, long inMemoryMessageSize) {
        if (DIRECT_MEMORY_USAGE_LOGGER.isDebugEnabled() && (inMemoryMessageSize > currentTargetSize || QpidByteBuffer.getAllocatedDirectMemorySize() > this._broker.getFlowToDiskThreshold()) && this._directMemoryExceedsTargetReported.compareAndSet(false, true)) {
            DIRECT_MEMORY_USAGE_LOGGER.debug("VirtualHost '{}' direct memory allocation threshold ({}) exceeded : {} bytes. Flow to disk enforced.", new Object[]{this.getName(), currentTargetSize, inMemoryMessageSize});
        }
    }

    @Override
    public long clearMatchingQueues(String queueNamePattern) {
        LOGGER.debug("Clearing the queues with name that matches the pattern: '{}'", (Object)queueNamePattern);
        try {
            Pattern pattern = Pattern.compile(queueNamePattern);
            long count = 0L;
            for (Queue queue : this.getChildren(Queue.class)) {
                if (!pattern.matcher(queue.getName()).matches()) continue;
                LOGGER.debug("Clearing the queue with name '{}' and ID '{}'", (Object)queue.getName(), (Object)queue.getId());
                count += queue.clearQueue();
            }
            return count;
        }
        catch (PatternSyntaxException e) {
            String message = String.format("Failed to compile queue name pattern: '%s'", queueNamePattern);
            LOGGER.debug(message, (Throwable)e);
            throw new IllegalArgumentException(message, e);
        }
    }

    @Override
    public long clearQueues(Collection<String> queues) {
        HashMap<UUID, String> uuid = new HashMap<UUID, String>();
        HashSet<String> names = new HashSet<String>();
        for (String id : queues) {
            try {
                uuid.put(UUID.fromString(id), id);
            }
            catch (IllegalArgumentException e) {
                LOGGER.trace(String.format("'%s' is not a valid queue ID", id), (Throwable)e);
                names.add(id);
            }
        }
        Collection<Queue> queueList = this.getChildren(Queue.class);
        long count = 0L;
        if (!uuid.isEmpty()) {
            LOGGER.debug("Clearing the queues with IDs: {}", uuid.values());
            for (Queue queue : queueList) {
                if (uuid.remove(queue.getId()) == null) continue;
                LOGGER.debug("Clearing the queue with ID '{}'", (Object)queue.getId());
                count += queue.clearQueue();
            }
            names.addAll(uuid.values());
        }
        if (!names.isEmpty()) {
            LOGGER.debug("Clearing the queues with names: {}", names);
            for (Queue queue : queueList) {
                if (!names.contains(queue.getName())) continue;
                LOGGER.debug("Clearing the queue with name '{}'", (Object)queue.getName());
                count += queue.clearQueue();
            }
        }
        return count;
    }

    private class SystemNodeRegistry
    implements SystemNodeCreator.SystemNodeRegistry {
        private SystemNodeRegistry() {
        }

        @Override
        public void registerSystemNode(MessageNode node) {
            if (node instanceof MessageDestination) {
                AbstractVirtualHost.this._systemNodeDestinations.put(node.getName(), (MessageDestination)node);
            }
            if (node instanceof MessageSource) {
                AbstractVirtualHost.this._systemNodeSources.put(node.getName(), (MessageSource)node);
            }
        }

        @Override
        public void removeSystemNode(MessageNode node) {
            if (node instanceof MessageDestination) {
                AbstractVirtualHost.this._systemNodeDestinations.remove(node.getName());
            }
            if (node instanceof MessageSource) {
                this.removeMessageSource(node.getName());
            }
        }

        private void removeMessageSource(String name) {
            MessageSource messageSource = AbstractVirtualHost.this._systemNodeSources.remove(name);
            if (messageSource != null) {
                messageSource.close();
            }
        }

        @Override
        public void removeSystemNode(String name) {
            AbstractVirtualHost.this._systemNodeDestinations.remove(name);
            this.removeMessageSource(name);
        }

        @Override
        public VirtualHostNode<?> getVirtualHostNode() {
            return (VirtualHostNode)AbstractVirtualHost.this.getParent();
        }

        @Override
        public VirtualHost<?> getVirtualHost() {
            return AbstractVirtualHost.this;
        }

        @Override
        public boolean hasSystemNode(String name) {
            return AbstractVirtualHost.this._systemNodeSources.containsKey(name) || AbstractVirtualHost.this._systemNodeDestinations.containsKey(name);
        }

        public void close() {
            AbstractVirtualHost.this._systemNodeSources.values().forEach(MessageSource::close);
        }
    }

    private static enum BlockingType {
        STORE,
        FILESYSTEM;

    }

    private final class AccessControlProviderListener
    extends AbstractConfigurationChangeListener {
        private final Set<ConfiguredObject<?>> _bulkChanges = new HashSet();

        private AccessControlProviderListener() {
        }

        @Override
        public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (object.getCategoryClass() == VirtualHost.class && child.getCategoryClass() == VirtualHostAccessControlProvider.class) {
                child.addChangeListener(this);
                AbstractVirtualHost.this.updateAccessControl();
            }
        }

        @Override
        public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (object.getCategoryClass() == VirtualHost.class && child.getCategoryClass() == VirtualHostAccessControlProvider.class) {
                AbstractVirtualHost.this.updateAccessControl();
            }
        }

        @Override
        public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
            if (object.getCategoryClass() == VirtualHostAccessControlProvider.class && !this._bulkChanges.contains(object)) {
                AbstractVirtualHost.this.updateAccessControl();
            }
        }

        @Override
        public void bulkChangeStart(ConfiguredObject<?> object) {
            if (object.getCategoryClass() == VirtualHostAccessControlProvider.class) {
                this._bulkChanges.add(object);
            }
        }

        @Override
        public void bulkChangeEnd(ConfiguredObject<?> object) {
            if (object.getCategoryClass() == VirtualHostAccessControlProvider.class) {
                this._bulkChanges.remove(object);
                AbstractVirtualHost.this.updateAccessControl();
            }
        }
    }

    private class FileSystemSpaceChecker
    extends HouseKeepingTask {
        private boolean _fileSystemFull;
        private File _fileSystem;

        public FileSystemSpaceChecker() {
            super("FileSystemSpaceChecker[" + AbstractVirtualHost.this.getName() + "]", AbstractVirtualHost.this, AbstractVirtualHost.this._fileSystemSpaceCheckerJobContext);
        }

        @Override
        public void execute() {
            long totalSpace = this._fileSystem.getTotalSpace();
            long freeSpace = this._fileSystem.getFreeSpace();
            if (totalSpace == 0L) {
                LOGGER.warn("Cannot check file system for disk space because store path '{}' is not valid", (Object)this._fileSystem.getPath());
                return;
            }
            long usagePercent = 100L * (totalSpace - freeSpace) / totalSpace;
            if (this._fileSystemFull && usagePercent < (long)AbstractVirtualHost.this._fileSystemMaxUsagePercent) {
                this._fileSystemFull = false;
                AbstractVirtualHost.this.getEventLogger().message(AbstractVirtualHost.this.getMessageStoreLogSubject(), VirtualHostMessages.FILESYSTEM_NOTFULL(AbstractVirtualHost.this._fileSystemMaxUsagePercent));
                AbstractVirtualHost.this.unblock(BlockingType.FILESYSTEM);
            } else if (!this._fileSystemFull && usagePercent > (long)AbstractVirtualHost.this._fileSystemMaxUsagePercent) {
                this._fileSystemFull = true;
                AbstractVirtualHost.this.getEventLogger().message(AbstractVirtualHost.this.getMessageStoreLogSubject(), VirtualHostMessages.FILESYSTEM_FULL(AbstractVirtualHost.this._fileSystemMaxUsagePercent));
                AbstractVirtualHost.this.block(BlockingType.FILESYSTEM);
            }
        }

        public void setFileSystem(File fileSystem) {
            this._fileSystem = fileSystem;
        }
    }

    private static class MessageHeaderImpl
    implements AMQMessageHeader {
        private final String _userName;
        private final long _timestamp;
        private final ManageableMessage _message;

        public MessageHeaderImpl(ManageableMessage message) {
            this._message = message;
            AuthenticatedPrincipal currentUser = AuthenticatedPrincipal.getCurrentUser();
            this._userName = currentUser == null ? null : currentUser.getName();
            this._timestamp = System.currentTimeMillis();
        }

        @Override
        public String getCorrelationId() {
            return this._message.getCorrelationId();
        }

        @Override
        public long getExpiration() {
            Date expiration = this._message.getExpiration();
            return expiration == null ? 0L : expiration.getTime();
        }

        @Override
        public String getUserId() {
            return this._userName;
        }

        @Override
        public String getAppId() {
            return null;
        }

        @Override
        public String getGroupId() {
            Object jmsXGroupId = this.getHeader("JMSXGroupID");
            return jmsXGroupId == null ? null : String.valueOf(jmsXGroupId);
        }

        @Override
        public String getMessageId() {
            return this._message.getMessageId();
        }

        @Override
        public String getMimeType() {
            return this._message.getMimeType();
        }

        @Override
        public String getEncoding() {
            return this._message.getEncoding();
        }

        @Override
        public byte getPriority() {
            return (byte)this._message.getPriority();
        }

        @Override
        public long getTimestamp() {
            return this._timestamp;
        }

        @Override
        public long getNotValidBefore() {
            Date notValidBefore = this._message.getNotValidBefore();
            return notValidBefore == null ? 0L : notValidBefore.getTime();
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public String getReplyTo() {
            return this._message.getReplyTo();
        }

        @Override
        public Object getHeader(String name) {
            return this.getHeaders().get(name);
        }

        @Override
        public boolean containsHeaders(Set<String> names) {
            return this.getHeaders().keySet().containsAll(names);
        }

        @Override
        public boolean containsHeader(String name) {
            return this.getHeaders().keySet().contains(name);
        }

        @Override
        public Collection<String> getHeaderNames() {
            return Collections.unmodifiableCollection(this.getHeaders().keySet());
        }

        private Map<String, Object> getHeaders() {
            return this._message.getHeaders() == null ? Map.of() : this._message.getHeaders();
        }
    }

    private class MessageStoreContent
    implements Content,
    CustomRestHeaders {
        private MessageStoreContent() {
        }

        @Override
        public void write(final OutputStream outputStream) throws IOException {
            AbstractVirtualHost.this.doSync(AbstractVirtualHost.this.doOnConfigThread(new Task<CompletableFuture<Void>, IOException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public CompletableFuture<Void> execute() throws IOException {
                    if (AbstractVirtualHost.this.getState() != State.STOPPED) {
                        throw new IllegalArgumentException("The exportMessageStore operation can only be called when the virtual host is stopped");
                    }
                    AbstractVirtualHost.this._messageStore.openMessageStore(AbstractVirtualHost.this);
                    try {
                        HashMap<UUID, String> queueMap = new HashMap<UUID, String>();
                        AbstractVirtualHost.this.getDurableConfigurationStore().reload(record -> {
                            if (record.getType().equals(Queue.class.getSimpleName())) {
                                queueMap.put(record.getId(), (String)record.getAttributes().get("name"));
                            }
                        });
                        MessageStoreSerializer serializer = new QpidServiceLoader().getInstancesByType(MessageStoreSerializer.class).get("v1.0");
                        MessageStore.MessageStoreReader reader = AbstractVirtualHost.this._messageStore.newMessageStoreReader();
                        serializer.serialize(queueMap, reader, outputStream);
                    }
                    finally {
                        AbstractVirtualHost.this._messageStore.closeMessageStore();
                    }
                    return CompletableFuture.completedFuture(null);
                }

                @Override
                public String getObject() {
                    return AbstractVirtualHost.this.toString();
                }

                @Override
                public String getAction() {
                    return "exportMessageStore";
                }

                @Override
                public String getArguments() {
                    return null;
                }
            }));
        }

        @Override
        public void release() {
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "application/octet-stream";
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            try {
                String vhostName = AbstractVirtualHost.this.getName();
                String asciiName = vhostName.replaceAll("[^\\x20-\\x7E]", "?").replace('\\', '?').replaceAll("%[0-9a-fA-F]{2}", "?");
                String disposition = String.format("attachment; filename=\"%s_messages.bin\"; filename*=\"UTF-8''%s_messages.bin\"", asciiName, URLEncoder.encode(vhostName, StandardCharsets.UTF_8.name()));
                return disposition;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("JVM does not support UTF8", e);
            }
        }
    }

    private static class StoreEmptyCheckingHandler
    implements MessageHandler,
    MessageInstanceHandler,
    DistributedTransactionHandler {
        private boolean _empty = true;

        private StoreEmptyCheckingHandler() {
        }

        @Override
        public boolean handle(StoredMessage<?> storedMessage) {
            this._empty = false;
            return false;
        }

        @Override
        public boolean handle(MessageEnqueueRecord record) {
            this._empty = false;
            return false;
        }

        @Override
        public boolean handle(Transaction.StoredXidRecord storedXid, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) {
            this._empty = false;
            return false;
        }

        public boolean isEmpty() {
            return this._empty;
        }
    }

    private class VirtualHostHouseKeepingTask
    extends HouseKeepingTask {
        public VirtualHostHouseKeepingTask() {
            super("Housekeeping[" + AbstractVirtualHost.this.getName() + "]", AbstractVirtualHost.this, AbstractVirtualHost.this._housekeepingJobContext);
        }

        @Override
        public void execute() {
            for (Queue q : AbstractVirtualHost.this.getChildren(Queue.class)) {
                if (q.getState() != State.ACTIVE) continue;
                LOGGER.debug("Checking message status for queue: {}", (Object)q.getName());
                q.checkMessageStatus();
            }
        }
    }

    class FlowToDiskCheckingTask
    extends HouseKeepingTask {
        public FlowToDiskCheckingTask() {
            super("FlowToDiskChecking[" + AbstractVirtualHost.this.getName() + "]", AbstractVirtualHost.this, AbstractVirtualHost.this._housekeepingJobContext);
        }

        @Override
        public void execute() {
            if (AbstractVirtualHost.this.isOverTargetSize()) {
                long currentTargetSize = AbstractVirtualHost.this._targetSize.get();
                AbstractVirtualHost.this.reportDirectMemoryAboveTargetIfExceeded(currentTargetSize, AbstractVirtualHost.this.getInMemoryMessageSize());
                ArrayList<QueueEntryIterator> queueIterators = new ArrayList<QueueEntryIterator>();
                for (Queue q : AbstractVirtualHost.this.getChildren(Queue.class)) {
                    queueIterators.add(q.queueEntryIterator());
                }
                Collections.shuffle(queueIterators);
                long cumulativeSize = 0L;
                while (!queueIterators.isEmpty()) {
                    Iterator it = queueIterators.iterator();
                    while (it.hasNext()) {
                        QueueEntryIterator queueIterator = (QueueEntryIterator)it.next();
                        if (queueIterator.advance()) {
                            QueueEntry node = queueIterator.getNode();
                            if (node == null || node.isDeleted()) continue;
                            try (MessageReference messageReference = node.getMessage().newReference();){
                                StoredMessage storedMessage = messageReference.getMessage().getStoredMessage();
                                long inMemorySize = storedMessage.getInMemorySize();
                                if (inMemorySize <= 0L) continue;
                                if (cumulativeSize <= currentTargetSize) {
                                    cumulativeSize += inMemorySize;
                                }
                                if (cumulativeSize <= currentTargetSize || !node.getQueue().checkValid(node)) continue;
                                storedMessage.flowToDisk();
                            }
                            catch (MessageDeletedException messageDeletedException) {}
                            continue;
                        }
                        it.remove();
                    }
                }
                AbstractVirtualHost.this.reportDirectMemoryBelowTargetIfReached(cumulativeSize, AbstractVirtualHost.this.getInMemoryMessageSize());
            }
        }
    }
}

