/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.thread;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.rocketmq.common.thread.ThreadPoolStatusMonitor;

public class ThreadPoolWrapper {
    private String name;
    private ThreadPoolExecutor threadPoolExecutor;
    private List<ThreadPoolStatusMonitor> statusPrinters;

    ThreadPoolWrapper(String name, ThreadPoolExecutor threadPoolExecutor, List<ThreadPoolStatusMonitor> statusPrinters) {
        this.name = name;
        this.threadPoolExecutor = threadPoolExecutor;
        this.statusPrinters = statusPrinters;
    }

    public static ThreadPoolWrapperBuilder builder() {
        return new ThreadPoolWrapperBuilder();
    }

    public String getName() {
        return this.name;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public List<ThreadPoolStatusMonitor> getStatusPrinters() {
        return this.statusPrinters;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void setStatusPrinters(List<ThreadPoolStatusMonitor> statusPrinters) {
        this.statusPrinters = statusPrinters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadPoolWrapper wrapper = (ThreadPoolWrapper)o;
        return Objects.equal((Object)this.name, (Object)wrapper.name) && Objects.equal((Object)this.threadPoolExecutor, (Object)wrapper.threadPoolExecutor) && Objects.equal(this.statusPrinters, wrapper.statusPrinters);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.threadPoolExecutor, this.statusPrinters});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("threadPoolExecutor", (Object)this.threadPoolExecutor).add("statusPrinters", this.statusPrinters).toString();
    }

    public static class ThreadPoolWrapperBuilder {
        private String name;
        private ThreadPoolExecutor threadPoolExecutor;
        private List<ThreadPoolStatusMonitor> statusPrinters;

        ThreadPoolWrapperBuilder() {
        }

        public ThreadPoolWrapperBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ThreadPoolWrapperBuilder threadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
            this.threadPoolExecutor = threadPoolExecutor;
            return this;
        }

        public ThreadPoolWrapperBuilder statusPrinters(List<ThreadPoolStatusMonitor> statusPrinters) {
            this.statusPrinters = statusPrinters;
            return this;
        }

        public ThreadPoolWrapper build() {
            return new ThreadPoolWrapper(this.name, this.threadPoolExecutor, this.statusPrinters);
        }

        public String toString() {
            return "ThreadPoolWrapper.ThreadPoolWrapperBuilder(name=" + this.name + ", threadPoolExecutor=" + this.threadPoolExecutor + ", statusPrinters=" + this.statusPrinters + ")";
        }
    }
}

