/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.alibaba.fastjson.JSON;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.util.Map;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.metrics.PopMetricsManager;
import org.apache.rocketmq.broker.processor.PopMessageProcessor;
import org.apache.rocketmq.broker.processor.PopReviveService;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.AckMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.pop.AckMsg;

public class AckMessageProcessor
implements NettyRequestProcessor {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    private final BrokerController brokerController;
    private String reviveTopic;
    private PopReviveService[] popReviveServices;

    public AckMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.reviveTopic = PopAckConstants.buildClusterReviveTopic((String)this.brokerController.getBrokerConfig().getBrokerClusterName());
        this.popReviveServices = new PopReviveService[this.brokerController.getBrokerConfig().getReviveQueueNum()];
        for (int i = 0; i < this.brokerController.getBrokerConfig().getReviveQueueNum(); ++i) {
            this.popReviveServices[i] = new PopReviveService(brokerController, this.reviveTopic, i);
            this.popReviveServices[i].setShouldRunPopRevive(brokerController.getBrokerConfig().getBrokerId() == 0L);
        }
    }

    public PopReviveService[] getPopReviveServices() {
        return this.popReviveServices;
    }

    public void startPopReviveService() {
        for (PopReviveService popReviveService : this.popReviveServices) {
            popReviveService.start();
        }
    }

    public void shutdownPopReviveService() {
        for (PopReviveService popReviveService : this.popReviveServices) {
            popReviveService.shutdown();
        }
    }

    public void setPopReviveServiceStatus(boolean shouldStart) {
        for (PopReviveService popReviveService : this.popReviveServices) {
            popReviveService.setShouldRunPopRevive(shouldStart);
        }
    }

    public boolean isPopReviveServiceRunning() {
        for (PopReviveService popReviveService : this.popReviveServices) {
            if (!popReviveService.isShouldRunPopRevive()) continue;
            return true;
        }
        return false;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        return this.processRequest(ctx.channel(), request, true);
    }

    public boolean rejectRequest() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand processRequest(Channel channel, RemotingCommand request, boolean brokerAllowSuspend) throws RemotingCommandException {
        AckMessageRequestHeader requestHeader = (AckMessageRequestHeader)request.decodeCommandCustomHeader(AckMessageRequestHeader.class);
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        AckMsg ackMsg = new AckMsg();
        RemotingCommand response = RemotingCommand.createResponseCommand((int)0, null);
        response.setOpaque(request.getOpaque());
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (null == topicConfig) {
            POP_LOGGER.error("The topic {} not exist, consumer: {} ", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
            response.setCode(17);
            response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ")));
            return response;
        }
        if (requestHeader.getQueueId() >= topicConfig.getReadQueueNums() || requestHeader.getQueueId() < 0) {
            String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
            POP_LOGGER.warn(errorInfo);
            response.setCode(13);
            response.setRemark(errorInfo);
            return response;
        }
        long minOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
        long maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
        if (requestHeader.getOffset() < minOffset || requestHeader.getOffset() > maxOffset) {
            String errorInfo = String.format("offset is illegal, key:%s@%d, commit:%d, store:%d~%d", requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getOffset(), minOffset, maxOffset);
            POP_LOGGER.warn(errorInfo);
            response.setCode(208);
            response.setRemark(errorInfo);
            return response;
        }
        String[] extraInfo = ExtraInfoUtil.split((String)requestHeader.getExtraInfo());
        ackMsg.setAckOffset(requestHeader.getOffset().longValue());
        ackMsg.setStartOffset(ExtraInfoUtil.getCkQueueOffset((String[])extraInfo).longValue());
        ackMsg.setConsumerGroup(requestHeader.getConsumerGroup());
        ackMsg.setTopic(requestHeader.getTopic());
        ackMsg.setQueueId(requestHeader.getQueueId().intValue());
        ackMsg.setPopTime(ExtraInfoUtil.getPopTime((String[])extraInfo).longValue());
        ackMsg.setBrokerName(ExtraInfoUtil.getBrokerName((String[])extraInfo));
        int rqId = ExtraInfoUtil.getReviveQid((String[])extraInfo);
        long invisibleTime = ExtraInfoUtil.getInvisibleTime((String[])extraInfo);
        this.brokerController.getBrokerStatsManager().incBrokerAckNums(1);
        this.brokerController.getBrokerStatsManager().incGroupAckNums(requestHeader.getConsumerGroup(), requestHeader.getTopic(), 1);
        if (rqId == 999) {
            String lockKey = requestHeader.getTopic() + "@" + requestHeader.getConsumerGroup() + "@" + requestHeader.getQueueId();
            long oldOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
            if (requestHeader.getOffset() < oldOffset) {
                return response;
            }
            while (!this.brokerController.getPopMessageProcessor().getQueueLockManager().tryLock(lockKey)) {
            }
            try {
                oldOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
                if (requestHeader.getOffset() < oldOffset) {
                    RemotingCommand remotingCommand = response;
                    return remotingCommand;
                }
                long nextOffset = this.brokerController.getConsumerOrderInfoManager().commitAndNext(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getQueueId(), requestHeader.getOffset(), ExtraInfoUtil.getPopTime((String[])extraInfo));
                if (nextOffset > -1L) {
                    if (!this.brokerController.getConsumerOffsetManager().hasOffsetReset(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getQueueId())) {
                        this.brokerController.getConsumerOffsetManager().commitOffset(channel.remoteAddress().toString(), requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId(), nextOffset);
                    }
                    if (!this.brokerController.getConsumerOrderInfoManager().checkBlock(null, requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getQueueId(), invisibleTime)) {
                        this.brokerController.getPopMessageProcessor().notifyMessageArriving(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getQueueId());
                    }
                } else if (nextOffset == -1L) {
                    String errorInfo = String.format("offset is illegal, key:%s, old:%d, commit:%d, next:%d, %s", lockKey, oldOffset, requestHeader.getOffset(), nextOffset, channel.remoteAddress());
                    POP_LOGGER.warn(errorInfo);
                    response.setCode(13);
                    response.setRemark(errorInfo);
                    RemotingCommand remotingCommand = response;
                    return remotingCommand;
                }
            }
            finally {
                this.brokerController.getPopMessageProcessor().getQueueLockManager().unLock(lockKey);
            }
            this.decInFlightMessageNum(requestHeader);
            return response;
        }
        if (this.brokerController.getPopMessageProcessor().getPopBufferMergeService().addAk(rqId, ackMsg)) {
            this.decInFlightMessageNum(requestHeader);
            return response;
        }
        msgInner.setTopic(this.reviveTopic);
        msgInner.setBody(JSON.toJSONString((Object)ackMsg).getBytes(DataConverter.charset));
        msgInner.setQueueId(rqId);
        msgInner.setTags("ack");
        msgInner.setBornTimestamp(System.currentTimeMillis());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setDeliverTimeMs(ExtraInfoUtil.getPopTime((String[])extraInfo) + invisibleTime);
        msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genAckUniqueId(ackMsg));
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        PutMessageResult putMessageResult = this.brokerController.getEscapeBridge().putMessageToSpecificQueue(msgInner);
        if (putMessageResult.getPutMessageStatus() != PutMessageStatus.PUT_OK && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_DISK_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_SLAVE_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.SLAVE_NOT_AVAILABLE) {
            POP_LOGGER.error("put ack msg error:" + putMessageResult);
        }
        PopMetricsManager.incPopReviveAckPutCount(ackMsg, putMessageResult.getPutMessageStatus());
        this.decInFlightMessageNum(requestHeader);
        return response;
    }

    private void decInFlightMessageNum(AckMessageRequestHeader requestHeader) {
        this.brokerController.getPopInflightMessageCounter().decrementInFlightMessageNum(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getExtraInfo());
    }
}

