/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authentication.provider;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.auth.authentication.builder.AuthenticationContextBuilder;
import org.apache.rocketmq.auth.authentication.builder.DefaultAuthenticationContextBuilder;
import org.apache.rocketmq.auth.authentication.chain.DefaultAuthenticationHandler;
import org.apache.rocketmq.auth.authentication.context.DefaultAuthenticationContext;
import org.apache.rocketmq.auth.authentication.provider.AuthenticationProvider;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.chain.Handler;
import org.apache.rocketmq.common.chain.HandlerChain;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationProvider
implements AuthenticationProvider<DefaultAuthenticationContext> {
    protected final Logger log = LoggerFactory.getLogger((String)"RocketmqAuthAudit");
    protected AuthConfig authConfig;
    protected Supplier<?> metadataService;
    protected AuthenticationContextBuilder<DefaultAuthenticationContext> authenticationContextBuilder;

    @Override
    public void initialize(AuthConfig config, Supplier<?> metadataService) {
        this.authConfig = config;
        this.metadataService = metadataService;
        this.authenticationContextBuilder = new DefaultAuthenticationContextBuilder();
    }

    @Override
    public CompletableFuture<Void> authenticate(DefaultAuthenticationContext context) {
        return ((CompletableFuture)this.newHandlerChain().handle((Object)context)).whenComplete((nil, ex) -> this.doAuditLog(context, (Throwable)ex));
    }

    @Override
    public DefaultAuthenticationContext newContext(Metadata metadata, GeneratedMessageV3 request) {
        return this.authenticationContextBuilder.build(metadata, request);
    }

    @Override
    public DefaultAuthenticationContext newContext(ChannelHandlerContext context, RemotingCommand command) {
        return this.authenticationContextBuilder.build(context, command);
    }

    protected HandlerChain<DefaultAuthenticationContext, CompletableFuture<Void>> newHandlerChain() {
        return HandlerChain.create().addNext((Handler)new DefaultAuthenticationHandler(this.authConfig, this.metadataService));
    }

    protected void doAuditLog(DefaultAuthenticationContext context, Throwable ex) {
        if (StringUtils.isBlank((CharSequence)context.getUsername())) {
            return;
        }
        if (ex != null) {
            this.log.info("[AUTHENTICATION] User:{} is authenticated failed with Signature = {}.", (Object)context.getUsername(), (Object)context.getSignature());
        } else {
            this.log.debug("[AUTHENTICATION] User:{} is authenticated success with Signature = {}.", (Object)context.getUsername(), (Object)context.getSignature());
        }
    }
}

