/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.impl.consumer.ConsumeService;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

class FifoConsumeService
extends ConsumeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FifoConsumeService.class);

    public FifoConsumeService(String clientId, ConcurrentMap<MessageQueueImpl, ProcessQueue> processQueueTable, MessageListener messageListener, ThreadPoolExecutor consumptionExecutor, MessageInterceptor messageInterceptor, ScheduledExecutorService scheduler) {
        super(clientId, processQueueTable, messageListener, consumptionExecutor, messageInterceptor, scheduler);
    }

    @Override
    public void startUp() {
        LOGGER.info("Begin to start the FIFO consume service, clientId={}", (Object)this.clientId);
        super.startUp();
        LOGGER.info("Begin to shutdown the FIFO consume service, clientId={}", (Object)this.clientId);
    }

    @Override
    public void shutDown() throws InterruptedException {
        LOGGER.info("Begin to shutdown the FIFO consume service, clientId={}", (Object)this.clientId);
        super.shutDown();
        LOGGER.info("Shutdown the FIFO consume service successfully, clientId={}", (Object)this.clientId);
    }

    public void consumeIteratively(ProcessQueue pq, Iterator<MessageViewImpl> iterator) {
        if (!iterator.hasNext()) {
            return;
        }
        MessageViewImpl next = iterator.next();
        ListenableFuture<ConsumeResult> future0 = this.consume(next);
        ListenableFuture future = Futures.transformAsync(future0, result -> pq.eraseFifoMessage(next, (ConsumeResult)((Object)result)), MoreExecutors.directExecutor());
        future.addListener(() -> this.consumeIteratively(pq, iterator), MoreExecutors.directExecutor());
    }

    @Override
    public void dispatch() {
        ArrayList processQueues = new ArrayList(this.processQueueTable.values());
        Collections.shuffle(processQueues);
        for (ProcessQueue pq : processQueues) {
            Iterator<MessageViewImpl> iterator = pq.tryTakeFifoMessages();
            this.consumeIteratively(pq, iterator);
        }
    }
}

