/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.LogLimits;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.LogProcessor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

final class LogEmitterSharedState {
    private final Object lock = new Object();
    private final Resource resource;
    private final Supplier<LogLimits> logLimitsSupplier;
    private final LogProcessor logProcessor;
    private final Clock clock;
    @Nullable
    private volatile CompletableResultCode shutdownResult = null;

    LogEmitterSharedState(Resource resource, Supplier<LogLimits> logLimitsSupplier, List<LogProcessor> logProcessors, Clock clock) {
        this.resource = resource;
        this.logLimitsSupplier = logLimitsSupplier;
        this.logProcessor = LogProcessor.composite(logProcessors);
        this.clock = clock;
    }

    Resource getResource() {
        return this.resource;
    }

    LogLimits getLogLimits() {
        return this.logLimitsSupplier.get();
    }

    LogProcessor getLogProcessor() {
        return this.logProcessor;
    }

    Clock getClock() {
        return this.clock;
    }

    boolean hasBeenShutdown() {
        return this.shutdownResult != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableResultCode shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownResult != null) {
                return this.shutdownResult;
            }
            this.shutdownResult = this.logProcessor.shutdown();
            return this.shutdownResult;
        }
    }
}

