/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.rocketmq.shaded.io.opentelemetry.api.internal.ValidationUtil;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.AbstractInstrument;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.InstrumentValueType;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

abstract class AbstractInstrumentBuilder<BuilderT extends AbstractInstrumentBuilder<?>> {
    static final String DEFAULT_UNIT = "";
    private final MeterProviderSharedState meterProviderSharedState;
    private String description;
    private String unit;
    protected final MeterSharedState meterSharedState;
    protected final String instrumentName;

    AbstractInstrumentBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name, String description, String unit) {
        this.instrumentName = name;
        this.description = description;
        this.unit = unit;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = meterSharedState;
    }

    protected abstract BuilderT getThis();

    public BuilderT setUnit(String unit) {
        this.unit = !ValidationUtil.checkValidInstrumentUnit(unit, " Using \"\" for instrument " + this.instrumentName + " instead.") ? DEFAULT_UNIT : unit;
        return this.getThis();
    }

    public BuilderT setDescription(String description) {
        this.description = description;
        return this.getThis();
    }

    private InstrumentDescriptor makeDescriptor(InstrumentType type, InstrumentValueType valueType) {
        return InstrumentDescriptor.create(this.instrumentName, this.description, this.unit, type, valueType);
    }

    protected <T> T swapBuilder(SwapBuilder<T> swapper) {
        return swapper.newBuilder(this.meterProviderSharedState, this.meterSharedState, this.instrumentName, this.description, this.unit);
    }

    final <I extends AbstractInstrument> I buildSynchronousInstrument(InstrumentType type, InstrumentValueType valueType, BiFunction<InstrumentDescriptor, WriteableMetricStorage, I> instrumentFactory) {
        InstrumentDescriptor descriptor = this.makeDescriptor(type, valueType);
        WriteableMetricStorage storage = this.meterSharedState.registerSynchronousMetricStorage(descriptor, this.meterProviderSharedState);
        return (I)((AbstractInstrument)instrumentFactory.apply(descriptor, storage));
    }

    final CallbackRegistration<ObservableDoubleMeasurement> registerDoubleAsynchronousInstrument(InstrumentType type, Consumer<ObservableDoubleMeasurement> updater) {
        InstrumentDescriptor descriptor = this.makeDescriptor(type, InstrumentValueType.DOUBLE);
        return this.meterSharedState.registerDoubleAsynchronousInstrument(descriptor, this.meterProviderSharedState, updater);
    }

    final CallbackRegistration<ObservableLongMeasurement> registerLongAsynchronousInstrument(InstrumentType type, Consumer<ObservableLongMeasurement> updater) {
        InstrumentDescriptor descriptor = this.makeDescriptor(type, InstrumentValueType.LONG);
        return this.meterSharedState.registerLongAsynchronousInstrument(descriptor, this.meterProviderSharedState, updater);
    }

    @FunctionalInterface
    protected static interface SwapBuilder<T> {
        public T newBuilder(MeterProviderSharedState var1, MeterSharedState var2, String var3, String var4, String var5);
    }
}

