/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.otlp.traces;

import java.io.IOException;
import java.util.List;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.otlp.InstrumentationScopeMarshaller;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.otlp.traces.SpanMarshaler;
import org.apache.rocketmq.shaded.io.opentelemetry.proto.trace.v1.internal.ScopeSpans;

final class InstrumentationScopeSpansMarshaler
extends MarshalerWithSize {
    private final InstrumentationScopeMarshaller instrumentationScope;
    private final List<SpanMarshaler> spanMarshalers;
    private final byte[] schemaUrlUtf8;

    InstrumentationScopeSpansMarshaler(InstrumentationScopeMarshaller instrumentationScope, byte[] schemaUrlUtf8, List<SpanMarshaler> spanMarshalers) {
        super(InstrumentationScopeSpansMarshaler.calculateSize(instrumentationScope, schemaUrlUtf8, spanMarshalers));
        this.instrumentationScope = instrumentationScope;
        this.schemaUrlUtf8 = schemaUrlUtf8;
        this.spanMarshalers = spanMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ScopeSpans.SCOPE, this.instrumentationScope);
        output.serializeRepeatedMessage(ScopeSpans.SPANS, this.spanMarshalers);
        output.serializeString(ScopeSpans.SCHEMA_URL, this.schemaUrlUtf8);
    }

    private static int calculateSize(InstrumentationScopeMarshaller instrumentationScope, byte[] schemaUrlUtf8, List<SpanMarshaler> spanMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage(ScopeSpans.SCOPE, instrumentationScope);
        size += MarshalerUtil.sizeBytes(ScopeSpans.SCHEMA_URL, schemaUrlUtf8);
        return size += MarshalerUtil.sizeRepeatedMessage(ScopeSpans.SPANS, spanMarshalers);
    }
}

