/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.metrics;

import com.google.common.base.Preconditions;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.java.metrics.ClientMeter;
import org.apache.rocketmq.client.java.metrics.GaugeEnum;
import org.apache.rocketmq.client.java.metrics.GaugeObserver;
import org.apache.rocketmq.client.java.metrics.HistogramEnum;
import org.apache.rocketmq.client.java.metrics.Metric;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.rpc.AuthInterceptor;
import org.apache.rocketmq.client.java.rpc.IpNameResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMeterManager {
    private static final Logger log = LoggerFactory.getLogger(ClientMeterManager.class);
    private static final Duration METRIC_EXPORTER_RPC_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration METRIC_READER_INTERVAL = Duration.ofMinutes(1L);
    private static final String METRIC_INSTRUMENTATION_NAME = "org.apache.rocketmq.message";
    private final ClientId clientId;
    private final ClientConfiguration clientConfiguration;
    private volatile ClientMeter clientMeter;
    private volatile GaugeObserver gaugeObserver = GaugeObserver.EMPTY;

    public ClientMeterManager(ClientId clientId, ClientConfiguration clientConfiguration) {
        this.clientId = clientId;
        this.clientConfiguration = clientConfiguration;
        this.clientMeter = ClientMeter.disabledInstance(clientId);
    }

    public void setGaugeObserver(GaugeObserver gaugeObserver) {
        this.gaugeObserver = (GaugeObserver)Preconditions.checkNotNull((Object)gaugeObserver, (Object)"gaugeObserver should not be null");
    }

    public void record(HistogramEnum histogramEnum, Attributes attributes, double value) {
        this.clientMeter.record(histogramEnum, attributes, value);
    }

    public void shutdown() {
        this.clientMeter.shutdown();
    }

    public synchronized void reset(Metric metric) {
        try {
            if (this.clientMeter.satisfy(metric)) {
                log.info("Metric settings is satisfied by the current message meter, metric={}, clientId={}", (Object)metric, (Object)this.clientId);
                return;
            }
            if (!metric.isOn()) {
                log.info("Metric is off, clientId={}", (Object)this.clientId);
                this.clientMeter.shutdown();
                this.clientMeter = ClientMeter.disabledInstance(this.clientId);
                return;
            }
            Endpoints endpoints = metric.getEndpoints();
            NettyChannelBuilder channelBuilder = (NettyChannelBuilder)NettyChannelBuilder.forTarget((String)endpoints.getGrpcTarget()).intercept(new ClientInterceptor[]{new AuthInterceptor(this.clientConfiguration, this.clientId)});
            if (this.clientConfiguration.isSslEnabled()) {
                SslContextBuilder builder = GrpcSslContexts.forClient();
                builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                SslContext sslContext = builder.build();
                channelBuilder.sslContext(sslContext);
            } else {
                channelBuilder.usePlaintext();
            }
            List<InetSocketAddress> socketAddresses = endpoints.toSocketAddresses();
            if (null != socketAddresses) {
                IpNameResolverFactory metricResolverFactory = new IpNameResolverFactory(socketAddresses);
                channelBuilder.nameResolverFactory((NameResolver.Factory)metricResolverFactory);
            }
            ManagedChannel channel = channelBuilder.build();
            OtlpGrpcMetricExporter exporter = OtlpGrpcMetricExporter.builder().setChannel(channel).setTimeout(METRIC_EXPORTER_RPC_TIMEOUT).build();
            InstrumentSelector sendSuccessCostTimeInstrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName(HistogramEnum.SEND_COST_TIME.getName()).build();
            View sendSuccessCostTimeView = View.builder().setAggregation(HistogramEnum.SEND_COST_TIME.getBucket()).build();
            InstrumentSelector deliveryLatencyInstrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName(HistogramEnum.DELIVERY_LATENCY.getName()).build();
            View deliveryLatencyView = View.builder().setAggregation(HistogramEnum.DELIVERY_LATENCY.getBucket()).build();
            InstrumentSelector awaitTimeInstrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName(HistogramEnum.AWAIT_TIME.getName()).build();
            View awaitTimeView = View.builder().setAggregation(HistogramEnum.AWAIT_TIME.getBucket()).build();
            InstrumentSelector processTimeInstrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName(HistogramEnum.PROCESS_TIME.getName()).build();
            View processTimeView = View.builder().setAggregation(HistogramEnum.PROCESS_TIME.getBucket()).build();
            PeriodicMetricReader reader = PeriodicMetricReader.builder((MetricExporter)exporter).setInterval(METRIC_READER_INTERVAL).build();
            SdkMeterProvider provider = SdkMeterProvider.builder().setResource(Resource.empty()).registerMetricReader((MetricReader)reader).registerView(sendSuccessCostTimeInstrumentSelector, sendSuccessCostTimeView).registerView(deliveryLatencyInstrumentSelector, deliveryLatencyView).registerView(awaitTimeInstrumentSelector, awaitTimeView).registerView(processTimeInstrumentSelector, processTimeView).build();
            OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(provider).build();
            Meter meter = openTelemetry.getMeter(METRIC_INSTRUMENTATION_NAME);
            ClientMeter existedClientMeter = this.clientMeter;
            this.clientMeter = new ClientMeter(meter, endpoints, provider, this.clientId);
            existedClientMeter.shutdown();
            log.info("Metrics is on, endpoints={}, clientId={}", (Object)endpoints, (Object)this.clientId);
            List<GaugeEnum> gauges = this.gaugeObserver.getGauges();
            for (GaugeEnum gauge : gauges) {
                String name = gauge.getName();
                try {
                    ObservableDoubleGauge ignored = meter.gaugeBuilder(name).buildWithCallback(measurement -> {
                        Map<Attributes, Double> map = this.gaugeObserver.getValues(gauge);
                        if (map.isEmpty()) {
                            return;
                        }
                        for (Map.Entry<Attributes, Double> entry : map.entrySet()) {
                            Attributes attributes = entry.getKey();
                            Double value = entry.getValue();
                            measurement.record(value.doubleValue(), attributes);
                        }
                    });
                    try {
                        log.debug("Build observable double gauge successfully, gauge={}, clientId={}", (Object)name, (Object)this.clientId);
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
                catch (Exception e) {
                    log.error("Failed to build observable double gauge, gauge={}, clientId={}", new Object[]{name, this.clientId, e});
                }
            }
        }
        catch (Throwable t) {
            log.error("Exception raised when resetting message meter, clientId={}", (Object)this.clientId, (Object)t);
        }
    }

    public boolean isEnabled() {
        return this.clientMeter.isEnabled();
    }
}

